/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-8-6
 * Time: 上午11:22
 * To change this template use File | Settings | File Templates.
 *
 * 注释中标注使用概率为0的地方是指当连接数据库获取全部列表失败时才会用到
 */
define(function (require, exports) {

    require('jquery');
    require('xml2json');
    var path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');
    var BookItem = require('./bookitem').BookItem;
    require('../user');

    /**
     * 书本视图管理类 （均未考虑异常）
     */
    function BookAccessor() {
        var _self = this;
        var user = null;

        _self.allBookList = [];

        /**
         * 更新内存中全部书本列表
         */
        _self.initAllBookList = function (user) {
            var def = $.Deferred();
            var sqlQuery = "select * from Books order by showorder asc";
            _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (res) {
                var bookJson = null;
                try {
                    bookJson = JSON.parse(res);
                    _self.allBookList = _self.turnDBBooksToObjList(res);
                    console.log(_self.allBookList);
                    def.resolve(_self.allBookList);
                } catch (e) {
                    _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (res) {
                        _self.allBookList = _self.turnDBBooksToObjList(res);
                        console.log(_self.allBookList);
                        def.resolve(_self.allBookList);
                    });
                }
            });
            return def.promise();
        }

        /**
         * 获取全部书本列表
         */
        _self.getAllBooks = function (user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                var sqlQuery = "select * from Books order by showorder asc";
                _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (res) {
                    _self.allBookList = _self.turnDBBooksToObjList(res);
                    def.resolve(_self.allBookList);
                });
            }
            else {
                def.resolve(_self.allBookList);
            }
            return def.promise();
        }

        /**
         * 根据所选择的年级和册别进行筛选书本
         * @册别列表 selectedSection
         * @年级列表 selectedGrade
         */
        _self.selectBookByGradeOrSection = function (selectedSection, selectedGrade, user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                //这一块基本上用到的概率是0了
                var sqlQuery = "";
                if (selectedGrade == "" && selectedSection != "") {
                    sqlQuery = "select * from Books where volumn in ('" + selectedSection + "') order by showorder asc";
                }
                else if (selectedGrade != "" && selectedSection == "") {
                    sqlQuery = "select * from Books where grade in ('" + selectedGrade + "') order by showorder asc";
                }
                else if (selectedGrade != "" && selectedSection != "") {
                    sqlQuery = "select * from Books where grade in ('" + selectedGrade + "') and volumn in ('" + selectedSection + "') order by showorder asc";
                }
                else {
                    sqlQuery = "select * from Books order by showorder asc"
                }
                var getBookTask = _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery);
                getBookTask.done(function (res) {
                    def.resolve(_self.turnDBBooksToObjList(res));
                });
            }
            else {
                //遍历allbookList
                var iter = 0, len = _self.allBookList.length;
                var partList = [];
                if (selectedGrade == "" && selectedSection == "") {
                    def.resolve(_self.allBookList);
                }
                else if (selectedGrade == "" && selectedSection != "") {
                    for (; iter < len; iter++) {
                        if (_self.allBookList[iter].volumn == selectedSection) {
                            partList.push(_self.allBookList[iter]);
                        }
                    }
                }
                else if (selectedGrade != "" && selectedSection == "") {
                    for (; iter < len; iter++) {
                        if (_self.allBookList[iter].grade == selectedGrade) {
                            partList.push(_self.allBookList[iter]);
                        }
                    }
                }
                else {
                    for (; iter < len; iter++) {
                        if (_self.allBookList[iter].grade == selectedGrade && _self.allBookList[iter].volumn == selectedSection) {
                            partList.push(_self.allBookList[iter]);
                        }
                    }
                }
                def.resolve(partList);
            }
            return def.promise();
        }

        /**
         * 获取最近使用的书本
         */
        _self.getRecentBooks = function (user) {
            var def = $.Deferred();
            var sqlQuery = "select * from Books where lastUsedTime >'1990-12-30' order by lastUsedTime desc limit 0,10 ";
            var getRecentBookTask = _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery);
            getRecentBookTask.done(function (res) {
                def.resolve(_self.turnDBBooksToObjList(res));
            });
            return def.promise();
        }

        /**
         * 获取新书
         */
        _self.getNewBooks = function (user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                //这一块基本上用到的概率是0了
                var sqlQuery = "select * from Books where isnew = '1' order by showorder asc";
                var getNewBookTask = _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery);
                getNewBookTask.done(function (res) {
                    def.resolve(_self.turnDBBooksToObjList(res));
                });
            }
            else {
                var iter = 0, len = _self.allBookList.length;
                var partList = [];
                for (; iter < len; ++iter) {
                    if (_self.allBookList[iter].isNew == "1") {
                        partList.push(_self.allBookList[iter]);
                    }
                }
                def.resolve(partList);
            }
            return def.promise();
        }

        /**
         * 获取全部书本的年级
         */
        _self.getAllGrades = function (user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                //这一块基本上用到的概率是0了
                var sqlQuery = "select grade from Books group by grade order by grade asc";
                var getTask = _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery);
                getTask.done(function (res) {
                    var gradeJson = {};
                    try {
                        gradeJson = JSON.parse(res);
                    }
                    catch (e) {
                        gradeJson = {};
                        gradeJson.data = [];
                    }
                    def.resolve(gradeJson.data);
                });
            }
            else {
                var iter = 0, len = _self.allBookList.length , list = [], j = 0, flag = 0;
                for (; iter < len; ++iter) {
                    flag = 0;
                    for (j = 0; j < list.length; ++j) {
                        if (_self.allBookList[iter].grade == list[j].grade) {
                            flag = 1;
                            break;
                        }
                    }
                    if (flag == 0) {
                        list.push(_self.allBookList[iter]);
                    }
                }
                //排序
                list.sort(function (a, b) {
                    return parseInt(a.grade) - parseInt(b.grade);
                });
                def.resolve(list);
            }
            return def.promise();
        }

        /**
         * 获取全部书本的册别
         */
        _self.getAllSection = function (user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                //这一块基本上用到的概率是0了
                var sqlQuery = "select volumn from Books group by volumn order by volumn asc";
                var getTask = _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery);
                getTask.done(function (res) {
                    var sectionJson = {};
                    try {
                        sectionJson = JSON.parse(res);
                    }
                    catch (e) {
                        sectionJson = {};
                        sectionJson.data = [];
                    }
                    def.resolve(sectionJson.data);
                });
            }
            else {
                var iter = 0, len = _self.allBookList.length , list = [], j = 0, flag = 0;
                for (; iter < len; ++iter) {
                    flag = 0;
                    for (j = 0; j < list.length; ++j) {
                        if (_self.allBookList[iter].volumn == list[j].volumn) {
                            flag = 1;
                            break;
                        }
                    }
                    /************************************************
                     * Caution :
                     * 对没有填写volum的书作特殊处理。
                     ************************************************/
                    if (flag == 0 && _self.allBookList[iter].volumn) {
                        list.push(_self.allBookList[iter]);
                    }
                }
                list.sort(function (a, b) {
                    return parseInt(a.volumn) - parseInt(b.volumn);
                })
                def.resolve(list);
            }
            return def.promise();
        }

        /**
         * 根据bookId删除数据库记录,异常未处理
         * @书本号 bookId
         */
        _self.deleteBookInshelf = function (bookId, user, i) {
            var def = $.Deferred();
            var sqlQuery = "delete from  Books where bookCode=" + "'" + bookId + "'";
            _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (res) {
                def.resolve({res: res, bookId: bookId, index: i});
            });
            return def.promise();
        }

        /**
         * 根据bookId组成的list删除数据库记录,异常未处理
         * @booklist 纯书本号组成的数组
         */
        _self.deleteBookALot = function (booklist, user) {
            var def = $.Deferred();
            var i = 0, len = booklist.length;
            var sqlQuery = 'delete from  Books where bookCode in (' + '"' + booklist[0];
            for (i = 1; i < len; i++) {
                sqlQuery += '","' + booklist[i];
            }
            sqlQuery += '")';
            _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (res) {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 使所有UsedTime清空
         */
        _self.clearBookUsedTime = function (user) {
            var def = $.Deferred();
            var sqlQuery = "update Books set lastUsedTime = ''";
            var task = _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery);
            task.done(function () {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 更新数据库里最近使用时间,修改“新”标签
         */
        _self.updateBookUseDate = function (bookCode, user) {
            var _nowDate = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
            var sqlQuery = "update Books set isnew= '0', lastUsedTime = '" + _nowDate + "'" + " where bookCode='" + bookCode + "'";
            var def = $.Deferred();
            var updateTask = _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery);
            updateTask.done(function (res) {
                def.resolve(_self.turnDBBooksToObjList(res));
            });
            return def.promise();
        }

        /**
         * 修改书本顺序
         */
        _self.updateBooksOrder = function (bookCode, i, user) {
            var def = $.Deferred();
            var sqlQuery = "update Books set showOrder = '" + i + "' where bookCode = '" + bookCode + "'";
            var task = _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery);
            task.done(function () {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 拼接多条更新时的sql语句（没啥效果，貌似这个函数已经不用了）
         */
        _self.updateShowOrderALot = function (bookCodeList, user) {
            var def = $.Deferred();
            var sqlStr = [];
            for (var j = 0, len = bookCodeList.length; j < len; j++) {
                sqlStr[j] = "update Books set showOrder='" + (j + 2) + "' where bookCode='" + bookCodeList[j] + "'"
            }
            var sqlQuery = sqlStr.join(";");
            console.log(sqlQuery);
            _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function () {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 根据bookcode设置某本书最后使用页码
         */
        _self.updateLastPage = function (bookCode, pageNum, user) {
            var def = $.Deferred();
            var sqlQuery = "update Books set lastPage = '" + pageNum + "' where bookCode = '" + bookCode + "'";
            var task = _shellcmd.executeDbAsyn(user.getUserDbFullPath(), sqlQuery);
            task.done(function () {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 根据资源id获取某本书最后使用页码
         */
        _self.getBookCodeLastPageByID = function (id, user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                //这一块也基本上不会用到了
                var sqlQuery = "select bookCode,lastPage from Books where id='" + id + "'";
                _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (bookStr) {
                    //console.log(bookStr);
                    var bookList = {};
                    try {
                        var bookList = JSON.parse(bookStr);
                    }
                    catch (e) {
                        bookList = {};
                        bookList.data = [];
                    }
                    if (bookList && bookList.data && bookList.data.length > 0) {
                        var obj = {};
                        obj.bookCode = bookList.data[0].bookcode;
                        obj.lastPage = bookList.data[0].lastpage;
                        def.resolve(obj);
                    }
                    else {
                        def.resolve(null);
                    }
                });
            }
            else {
                var iter = 0, len = _self.allBookList.length, obj = {};
                for (; iter < len; ++iter) {
                    if (_self.allBookList[iter].id == id) {
                        obj.bookCode = _self.allBookList[iter].bookCode;
                        obj.lastPage = _self.allBookList[iter].lastPage;
                        break;
                    }
                }
                def.resolve(obj);
            }
            return def.promise();
        }

        _self.getBookInfoById = function(bookid,user){
            var i = 0 , len = _self.allBookList.length;
            for (i = 0; i < len; i++) {
                if (_self.allBookList[i].id == bookid) {
                    return $.extend({}, _self.allBookList[i]);
                }
            }
            return null;
        }

        /**
         * 通过BooCode获取BookID
         */
        _self.getBookId = function (bookCode, user) {
            var def = $.Deferred();
            if (_self.allBookList.length < 1) {
                var sqlQuery = "select id from Books where bookCode='" + bookCode + "'";
                _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (bookStr) {
                    var bookList = JSON.parse(bookStr);
                    if (bookList && bookList.data && bookList.data.length > 0) {
                        def.resolve(bookList.data[0].id);
                    }
                    else {
                        def.resolve("");
                    }
                });
            }
            else {
                var iter = 0 , len = _self.allBookList.length, bookId = "";
                for (; iter < len; ++iter) {
                    if (_self.allBookList[iter].bookCode == bookCode) {
                        bookId = _self.allBookList[iter].id;
                        break;
                    }
                }
                def.resolve(bookId);
            }
            return def.promise();
        }

        /**
         * 通过BookCode获取书本信息
         * 此接口在导出书本时调用
         */
        _self.getBookInfoByCode = function (bookCode) {
            var i = 0 , len = _self.allBookList.length;
            for (i = 0; i < len; i++) {
                if (_self.allBookList[i].bookCode == bookCode) {
                    return $.extend({}, _self.allBookList[i]);
                }
            }
            return null;
        }

        _self.getBInfoByCodeUser = function (bookCode, user) {
            var def = $.Deferred();
            var sqlQuery = "select * from Books where bookCode='" + bookCode + "'";
            console.log(user.getUserDbFullPath());
            console.log(sqlQuery)
            _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (bookStr) {
                console.log(bookStr);
                if (bookStr) {
                    var books = _self.turnDBBooksToObjList(bookStr);
                    def.resolve(books[0]);
                }
                else {
                    def.resolve(null);
                }
            });
            return def.promise();
        }

        /**
         * 把数据库查询结果转为BookItem组成的List
         */
        _self.turnDBBooksToObjList = function (DBBooks) {
            var bookList = [];
            var bookJson = null;
            try {
                bookJson = JSON.parse(DBBooks);
            } catch (e) {
                console.log(DBBooks);
                bookJson = null;
            }
            if (!bookJson) {
                return bookList;
            }
            var data = bookJson.data;
            for (var item in data) {
                var bookItem = new BookItem();
                bookItem.id = data[item].id;
                //sqlite不识别大写，必须是小写
                bookItem.bookCode = data[item].bookcode;
                bookItem.isNew = data[item].isnew;
                //为兼容之前
//                if(data[item].thumbnail.startsWith('users')){
//                    data[item].thumbnail =  data[item].thumbnail; //change it
//                }
                bookItem.thumbnail = path.trimPosix(Config.binPath + data[item].thumbnail);
                //为兼容之前增加一个字段
                bookItem.thumbnail_relative = path.trimPosix('../' + data[item].thumbnail);
                bookItem.title = data[item].title;
                bookItem.subject = data[item].subject;
//                if(data[item].file.startsWith('users')){
//                    data[item].file = + data[item].file; //change it
//                }
                bookItem.file = data[item].file;
                bookItem.fileSize = data[item].filesize;
                bookItem.downloadDate = data[item].downloaddate;
                bookItem.grade = data[item].grade;
                bookItem.volumn = data[item].volumn;
                bookItem.publisher = data[item].publisher;
                bookItem.lastPage = data[item].lastpage;
                bookItem.lastUsedTime = data[item].lastusedtime;
                //license字段记录的是mtbkId，为了兼容1.0的数据库
                bookItem.mtbkId = data[item].license;
                //mtbk字段记录的是U盘标识，为了兼容2.0数据库
                bookItem.isU = data[item].mtbkid;
                bookList.push(bookItem);
            }
            return bookList;
        }

        /**
         * 记录书本位置
         */
        _self.changePosition = function (bookcodelist) {
            var list = [];
            var i = 0, len_i = bookcodelist.length;
            var j = 0, len_j = _self.allBookList.length;
            for (i = 0; i < len_i; i++) {
                for (j = 0; j < len_j; j++) {
                    if (bookcodelist[i] == _self.allBookList[j].bookCode) {
                        list.push(_self.allBookList[j]);
                        break;
                    }
                }
            }
            _self.allBookList = list;
        }

        /**
         * 获取最近使用的三本书的信息
         */
        _self.getLast3BookInfo = function (user) {
            var def = $.Deferred();
            var sqlQuery = "select * from Books where lastUsedTime >'1990-12-30' order by lastUsedTime desc limit 0,3 ";
            _shellcmd.retriveDbAsyn(user.getUserDbFullPath(), sqlQuery).done(function (res) {
                def.resolve(_self.turnDBBooksToObjList(res));
            });
            return def.promise();
        }

        /**
         * 从U盘添加书本
         * 此接口只供导入书本调用
         */
        _self.addBookFromU = function (book, userName) {
            var def = $.Deferred();
            if (book) {
                var sqlQuery = "insert into Books values('" +
                    book.id + "','" + book.bookCode + "','" +
                    book.title + "','" + book.file + "','" +
                    //插入时资源包的id和userid填空
                    book.thumbnail + "','','','" +
                    book.publisher + "','" + book.grade + "','" +
                    book.subject + "','" + book.volumn + "','" +
                    book.fileSize + "','" + book.downloadDate + "','" +
                    book.isNew + "','" + book.lastPage + "','" +
                    //插入时显示顺序和U盘标识填1
                    book.lastUsedTime + "','1','" + book.isU + "')";
                console.log(sqlQuery);
                var dbPath = path.trimPosix(path.join(Config.binPath, 'users/' + userName + '/userdb.db'));
                console.log(dbPath);
                var task = _shellcmd.executeDbAsyn(dbPath, sqlQuery);
                task.done(function () {
                    def.resolve();
                });
            }
            else {
                def.resolve();
            }
            return def.promise();
        }

        _self.changeBookIsU = function(bookCode,isU,userName){
            var def = $.Deferred();
            if(bookCode){
                var sql = "update Books set mtbkId ='" + isU + "' where bookCode = '"+ bookCode + "'";
                console.log(sql);
                var dbPath = path.trimPosix(path.join(Config.binPath, 'users/' + userName + '/userdb.db'));
                _shellcmd.executeDbAsyn(dbPath, sql).done(function () {
                    def.resolve();
                });
            }
            else{
                def.resolve();
            }
            return def.promise();
        }
    }



    exports.Instance = new BookAccessor();
});