define(function (require, exports) {
	var path = nodereq("path");
	var fs = nodereq("fs");
	var commonpath = require("../../../common/path");
	var exec = nodereq("child_process").exec;
	var md5 = require("../../../common/md5helper");
	var ebkCtx = require("../../ebookcontext").Instance;
	var bookaccessor = require("../bookaccessor").Instance;
	var user = require("../../user");
	var loginAssistor = require("../../login/loginAssistor");
	var shellcmd = require("../../../common/shellcmd");
	var eventLogic = require("../eventlogic").Instance;



	var pdf2png = path.resolve(path.dirname(process.execPath),"tools/gswin32c.exe");

	function ImportPDF(){
		var _self = this;
		_self.selectBook = { bookCode: "", user: "", title: "",pdf:""};
		_self.dirPath="";

		_self.show = function(){
			$("#pdfSelector").trigger("click");
            $("#pdfSelector").one("change",function(){
            	var _this = this;

            	showLoading({tips: AppTips.handingImport});

            	getBookCode(_this.files[0]).then(function(md5_pdf){
            		_self.selectBook.bookCode = "pdf_"+md5_pdf;
	            	_self.selectBook.user = ebkCtx.getUser().getName() ;
	                _self.selectBook.title = path.basename(_this.value);
	                _self.selectBook.pdf = _this.value;

	                bookaccessor.getAllBooks(_self.selectBook.user).done(function(booklist){
			            var isBookRepeat = booklist.some(function(book){
			            	return _self.selectBook.bookCode == book.bookCode;
			            });
			            if(isBookRepeat){
			            	hideLoading();
			            	_self.Dom.bookExistPanel.show();
			            }
			            else{
			            	 _self.importBefore(_self.selectBook.bookCode, _self.selectBook.user).done(function(book){
			            	 	var dirStr = "users/" + _self.selectBook.user + "/ebook/" + _self.selectBook.bookCode;
			            	 	var dirPath = path.join(path.dirname(process.execPath), "plugins/62/bin",dirStr);
			            	 	if(!fs.existsSync(dirPath)){
			            	 		fs.mkdirSync(dirPath)
			            	 	}
								 _self.dirPath=dirPath;
			            	 	fs.writeFileSync(dirPath + "/pdf.flag",'{"Title":"'+_self.selectBook.title+'"}');
			            	 	var header = dirPath + "/pdf";
								var cmd='"'+pdf2png +'" -dNOSAFER -r150 -dBATCH -sDEVICE=jpeg -dNOPAUSE -sOutputFile="'+ dirPath+'/pdf-%06d.jpg"  "'+_this.value+'"';
							 	cmd=cmd.replace(/\\/g, '/');
			            	 	exec(cmd,function(){
			            	 		hideLoading();
			            	 		_this.value = "";
			            	 		bookaccessor.addBookFromU(_self.generateBookInfo(), _self.selectBook.user).done(function () {
                                        eventLogic.initAllBookList().done(function () {
						                    //这里更新导入课本的下载时间，是因为导入书本的下载时间不是导入的时间，而是原始的下载时间，TA首页显示有问题
						                    bookaccessor.updateBookUseDate(_self.selectBook.bookCode,ebkCtx.getUser()).done(function(){
						                        eventLogic.initAllBookList().done(function(){
						                            eventLogic.reNewBookSelf().done(function(){
						                                //U盘导入课本，TA实时刷新
						                                var json = {
						                                    type   : "logic",
						                                    action : "refreash_ta_book",
						                                    from   : "ib",
						                                    to : "main"
						                                };
						                                socket.send(json);
						                            });
						                        });
						                    });
					            	 	});
                                    });
			            	 	});
								 if(AppCfg.tuniPdf){//配置项，屏蔽入口
									 // 导入书本过程中请求接口查询相似图片
									 _self.beforeOpenBook(dirPath);
								 }
			            	})
			            }
			        });

            	})
            })
		}

		/**
         * 导入前处理,创建用户目录
         */
        _self.importBefore = function (bookcode, userName) {
            var def = $.Deferred();
            //检查账户是否存在
            //不存在创建账户目录
            var _user = new user.User();
            _user.setBasePath(Config.binPath);
            _user.setName(userName);
            loginAssistor.createUserFolder(_user).done(function (ret) {
                if (!ret) {
                    console.log("创建用户目录失败");
                    shellcmd.deleteDir(path.trimPosix(_user.getUserBasePath()));
                    def.resolve("");
                }
                else {
                    //检查待导入书本是否存在
                    bookaccessor.getBInfoByCodeUser(bookcode, _user).done(function (ret) {
                        def.resolve(ret);
                    });
                }
            });
            return def.promise();
        };


        //读取导入书本图片，直至图片数量大于10张（此方法在导入过程中进行）
        _self.beforeOpenBook = function(dirPath){
        	var dirPath=dirPath;
			fs.readdir(dirPath,function(err,files){
				if(!files||files.length<12){
					//每500毫秒查询一次直至文件数量》=12
					setTimeout(_self.beforeOpenBook(dirPath),500);
				}else{
					_self.isExistSimilarbooks(files,dirPath);
				}
			})
		};

		//请求图麟接口，查询相似结果
		_self.isExistSimilarbooks = function(files,dirPath){
			//pdf转换成图片后，选3张图片发送至图麟接口判断图麟书库中是否有这本书
			var dirPath=dirPath;
			var tuniService=tunicornService.Instance();
			var imgArr=files.filter(function(el) {
				if (el.indexOf(".jpg") != -1) {
					return el;
				}
			});
			//取数组中除去最后一张外的倒数3张（最后一张可能仍然在写文件）
			var imgArrForTuni=imgArr.slice(imgArr.length-4,imgArr.length-1);
			//取得接口数据
			tuniService.getAccessToken().done(function(ret){
				var accesstoken=ret;;
				var requestTuni = function(index){
				    var index=index;
                    tuniService.searchSimilarImg(dirPath+"/"+imgArrForTuni[index],accesstoken).done(function(result){
						console.log("pdf文件预处理第"+ index +"次请求图麟接口成功!");
                        var _result=result.result.results[0];
						if(_result){//如果有结果
							var score=_result.score;
							//相似度低于50并且index<2，再请求一次接口
							if(Number(score)<50&&index<2){
								//如果请求接口得到的结果是不相似，再请求一次
								requestTuni(++index);
							};
							//相似度大于50，处理结果
							if(Number(score)>=50){
								_self.dealBookInfo(_result,imgArrForTuni[index]);
							}
						}else{//遇到一种情况，接口通了但是没数据，再请求一次
							requestTuni(++index);
						}
                    }).fail(function(){
                        console.log("pdf文件预处理第"+ index +"次请求图麟接口失败!");
                        if(index<3){
                            requestTuni(++index);
                        }
                    });
				};
				requestTuni(0);
			});
		}

		//处理图麟接口返回的书本信息
		_self.dealBookInfo=function(bookInfo,imgName){
          	var bookInfo=bookInfo;
			var bookCode=bookInfo.bookInfo.bookCode;
			var param={
				bookCode:bookCode
			}
			//请求接口获得书本信息，subject，grade等
			edcService.Instance().ersp_resource_metadata_book_get(param).done(function(ret){
				if(ret.code=="0"){
					var _bookInfo=ret.data.data;
					var bookName=_bookInfo.name||"";
					var subject=_bookInfo.properties.subject[0]||"";
					var grade=_bookInfo.properties.grade[0]||"";
					var phase=_bookInfo.properties.phase[0]||"";
					var volume=_bookInfo.properties.volume[0]||"";
					var edition=_bookInfo.properties.edition[0]||"";
					var publisher=_bookInfo.properties.publisher[0]||"";
					var stage=_bookInfo.properties.stage[0]||"";
					//如果查询到有相似书本，重写pdf.flag文件
					fs.writeFileSync(_self.dirPath + "/pdf.flag",'{"Title":"'+_self.selectBook.title+'","BookCode":"'+ bookCode +'",'
						+'"Subject":"'+subject +'",'
						+'"Grade":"'+ grade  +'",'
						+'"Phase":"'+phase +'",'
						+'"BookName":"'+ bookName+	'",'
						+'"Volume":"'+ volume +'",'
						+'"Edition":"'+ edition +'",'
						+'"Publisher":"'+ publisher +'",'
						+'"Stage":"'+ stage +'"'
						+'}');
				}
			}).fail(function(){
				console.log("图麟识别成功，但获取书本信息失败");
				fs.writeFileSync(_self.dirPath + "/pdf.flag",'{"Title":"'+_self.selectBook.title+'","BookCode":"'+ bookCode +'",'
					+'}');
			});

		}

         _self.generateBookInfo = function(){
			var book = {};
				book.id = _self.selectBook.bookCode;
				book.title = _self.selectBook.title;
				book.bookCode = _self.selectBook.bookCode;
				book.file = "";
	            book.thumbnail = "webapp/assert/static/common/images/slt_pdf.png";
	            book.publisher = "";
	            book.grade = "";
	            book.subject = "";
	            book.volumn = "";
	            book.fileSize = "";
	            book.downloadDate = "";
	            book.isNew = true;
	            book.lastPage = 0;
	            book.lastUsedTime = "";
	            book.isU = "";

	    	return book;
		}

	function getBookCode(file){
		return new Promise(function(deferred){
			var reader = new FileReader();  
		    //将文件以二进制形式读入页面  
		    reader.readAsBinaryString(file);  
		    reader.onload=function(){  
		         deferred.resolve(md5.hex_md5(this.result))
		    }
		})
	}

}

	exports.Instance = new ImportPDF();
})