/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-8-1
 * Time: 下午4:12
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {

    require('jquery');
    require('zebra_dialog');
    var Messenger=require('../../../thirdparty/messenger');
    var _userinfoAccessor = require('../../login/userinfoAccessor');
    var ebookContext = require('../../ebookcontext').Instance;
    var _shellcmd = require('../../../common/shellcmd');
    var _userData = require('../../../common/userdata').Instance;
    var bookAccessor = require('../bookaccessor').Instance;
    var confirmExit = require('../../../common/confirmExit');
    var _bookLoader = require('../bookloader').Instance;
    var _bookDownloadHelper = require('../bookdownloadhelper');
    var _commonfunc = require('../../../common/commonfunc');
    var remotebookDirAccess = require('../../../common/remotebookdiraccess');

    function PersonalInfoManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};

        _self.user = null;

        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param user 用户对象
         */
        _self.init = function (buttons, controls, user) {
            _self.buttons = buttons;
            _self.controls = controls;
            _self.user = user;

            _self.buttons.btnOpenPersonalInfo.click(function () {
                _self.showPersonalInfoPanel();
                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130602';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);
            });

            // 王哒哒修改
            _self.buttons.btnCloseApp.click(function () {
                confirmExit.LogOffAlert();
                // var obj = {
                //     "type": "logic",
                //     "action": "logout",
                //     "from": "ib",
                //     "to": "all",
                //     "data": ""
                // };
                // socket.send(obj);
            });

            _self.buttons.btnClosePersonalInfoPanel.click(function () {
                _self.hidePersonalInfoPanel();
            });

            _self.buttons.btnPurchasedBooks.click(function () {
                _self.showPurchasedBooks();
                //监管
                var action = LogManager.action.trigger;
                var params = {};
                params.module = '1130603';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                LogManager.statistics(action,params);
            });

            _self.buttons.btnClosePurchasedBooksPanel.click(function () {
                _self.hidePurchasedBooks();
            });

            //图片加载失败时显示默认头像
            _self.controls.ctrHeadPortrait.error(function () {
                $(this).attr('src', 'assert/images/head_default.jpg');
            });

            //接收处理个人中心页面消息
            _self.receivePersonalInfoIFrameMsg();

            //接收处理已购买课本页面消息
            _self.receivePurchasedBooksIFrameMsg();
        };

        /**
         * 接收个人中心页面消息
         */
        _self.receivePersonalInfoIFrameMsg = function () {
            _self.messenger = Messenger.initInParent(_self.controls.personalInfoIfrm[0]);
            _self.messenger.onmessage = function (data) {
                _self._dataReceived = data;
                var cmdJson = JSON.parse(data);
                if (cmdJson == null) return;
                var evt = cmdJson.evt;
                if (evt === "openbookstore") {
                    $("#btnBookStack").trigger("click");
                    _self.hidePersonalInfoPanel();
                }
                else if (evt === "closepersonalpage") {
                    _self.hidePersonalInfoPanel();
                }
            };
        };

        /**
         * 接收已购买课本页面消息
         */
        _self.receivePurchasedBooksIFrameMsg = function () {
            _self.booksMessenger = Messenger.initInParent(_self.controls.purchasedBooksIfrm[0]);
            _self.booksMessenger.onmessage = function (data) {
                _self._dataReceived = data;
                console.log(data);
                var cmdJson = JSON.parse(data);
                if (!cmdJson) return;
                var evt = cmdJson.evt;
                var cmdData = cmdJson.data;
                if (evt == "get_booklist_downloaded") {
                    _bookDownloadHelper.prepareLocalBooksInfoForBookLib(ebookContext.getUser()).done(function (respJsonStr) {
                        dispatchClientMsg(respJsonStr);
                    });
                }
                else if (evt == "downloadbook") {
                    var bookJson = cmdData;
                    var savePath = ebookContext.getUser().getStdBookBasePath() + '/' + bookJson.bookCode;
                    var logObj = {
                        type : "book2",
                        source : "myBook",
                        bookcode : bookJson.bookCode,
                        url: bookJson.file
                    }
                    _userData.start("add",logObj).done(function(){
                        _shellcmd.isDirExist(savePath).done(function (isDirExist) {
                            var remoteAccess = new remotebookDirAccess.RemoteBookDirectoryAccess();
                            if (!isDirExist) {
                                _shellcmd.createDir(savePath).done(function (ret) {
                                    remoteAccess.getBookDirFromWeb("",bookJson.bookCode,ebookContext.getUser()).done(function (content) {
                                        if (content && content.data && content.data.length ) {
                                            _shellcmd.saveFile(JSON.stringify(content),savePath+"/" +  bookJson.bookCode + ".menu");
                                            _bookDownloadHelper.downloadBook(bookJson, ebookContext.getUser());
                                        } else {
                                            var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + bookJson.id + '"}}';
                                            dispatchClientMsg(respJsonStr);
                                            showAlertTips(AppBookShelfTipsList.MenuError);
                                        }
                                    })
                                });
                            } else {
                                remoteAccess.getBookDirFromWeb("",bookJson.bookCode,ebookContext.getUser()).done(function (content) {
                                    if (content && content.data && content.data.length ) {
                                        _shellcmd.saveFile(JSON.stringify(content),savePath+"/" +  bookJson.bookCode + ".menu");
                                        _bookDownloadHelper.downloadBook(bookJson, ebookContext.getUser());
                                    } else {
                                        var respJsonStr = '{"evt":"cancelDownload2","data":{"bookid":"' + bookJson.id + '"}}';
                                        dispatchClientMsg(respJsonStr);
                                        showAlertTips(AppBookShelfTipsList.MenuError);
                                    }
                                })
                            }
                        });
                    });
                }
                else if (evt == "downloadbookres") {
                    var bookResJson = cmdData;
                    var logObj = {
                        type : "mtbk",
                        source : "myBook",
                        bookcode : bookResJson.bookCode,
                        url:bookResJson.file
                    }
                    _userData.start("add",logObj).done(function(){
                        bookResJson["sourcepage"] = "booklibres";
                        bookResJson["moreparam"] = "true";
                        var bookResExtension = ".mtbk";
                        bookResJson["filesavename"] = bookResJson.bookCode + bookResExtension;
                        bookResJson["thumbnailsavename"] = "";
                        bookResJson["savepath"] = ebookContext.getUser().getUserBookRelativeBasePath() + '/' + bookResJson.bookCode;  //文件保存路径
                        bookResJson["dbpath"] = ebookContext.getUser().getUserDbFullPath();
                        var downloadRawData = JSON.stringify(bookResJson);
                        _shellcmd.fileDownload(downloadRawData);
                    });
                }
                else if (evt == "openbook") {
                    var obj = bookAccessor.getBookInfoById(cmdData.resid, ebookContext.getUser());
                    if (obj) {
                            _bookLoader.goToIndex(obj.bookCode,obj.lastPage,obj.isU);
                    }
                }
                else if (evt == "cancelDownload") {//取消下载
                    var resid = cmdData.resid;
                    // _shellcmd.cancleDownload(resid).done(function (ret) {
                    //     var responseJson = cmdJson;
                    //     responseJson.data["status"] = ret ? 'true' : 'false';
                    //     console.log(JSON.stringify(responseJson));
                    //     dispatchClientMsg(JSON.stringify(responseJson));
                    // });
                    var param = {
                        method: "stopEasyCurlDownload",
                        data: {
                            _from: CONST_hproseClientName,
                            action: "stopEasyCurlDownload",
                            raw_data: cmdJson,
                            downloadId: resid
                        }
                    };
                    // 发送取消下载消息
                    hproseClient.hproseNoti(param);
                    app_DownloadQueue.dele(resid);
                }
            };
        };

        /**
         * 打开个人中心页面
         */
        _self.showPersonalInfoPanel = function () {
            _self.hidePurchasedBooks();
            _self.controls.resUpdatePanel.hide();
            var url = AppRemoteSvcCfg.PersonalInfoPageUrl + '&account=' + _self.user.getName();
//            if (!ebookContext.getUser().getIsOnline()) {
//                _self.showTips(AppTips.LocalLoignMsg);
//            } else {
                //显示窗口
                _self.showIFrame(url,_self.controls.personalInfoIfrm,_self.controls.personalInfoPanel,
                    _self.controls.bookpop_tab,_self.controls.personalInfoPanelMask);
//            }
        };

        /**
         * 关闭个人中心页面
         */
        _self.hidePersonalInfoPanel = function () {
            _self.controls.personalInfoIfrm.attr("src", "");
            _self.controls.personalInfoPanel.hide();
        };

        /**
         * 打开已购买课本页面
         */
        _self.showPurchasedBooks = function () {
            _self.hidePersonalInfoPanel();
            _self.controls.resUpdatePanel.hide();
            var url = AppRemoteSvcCfg.PurchasedBooksPageUrl + '&account=' + _self.user.getName();
//            if (!ebookContext.getUser().getIsOnline()) {
//                _self.showTips(AppTips.LocalLoignMsg);
//            } else {
                //显示窗口
                _self.showIFrame(url,_self.controls.purchasedBooksIfrm,_self.controls.purchasedBooksPanel,
                    _self.controls.booklist_tab,_self.controls.purchasedBooksPanelMask);
//            }
        };

        /**
         * 关闭已购买课本页面
         */
        _self.hidePurchasedBooks = function () {
            _self.controls.purchasedBooksIfrm.attr("src", "");
            _self.controls.purchasedBooksPanel.hide();
        };

        /**
         * 显示窗口
         * @param url
         * @param iframe
         * @param panel
         * @param tab
         * @param mask
         */
        _self.showIFrame = function(url,iframe,panel,tab,mask){
            panel.show();

            mask.hide();
            panel.draggable({
                handle: "#" + tab.attr("id"),
                containment: "window",
                scroll : false,
                start: function () {
                    mask.show();
                },
                stop: function () {
                    mask.hide();
                }
            });

            //屏幕分辩率800*600时，才放缩UI面板
            if(panel.outerHeight() > screen.height || panel.outerWidth() > screen.width){
                panel.css('-webkit-transform','scale(0.8)');
            }

            //居中显示
            panel.css({
                position: 'absolute',
                left: ($(window).width() - panel.outerWidth()) / 2,
                top: ($(window).height() - panel.outerHeight()) / 2 + $(document).scrollTop()
            });

            //设置网络连接异常DIV样式
            var marginTop = (panel.height() - tab.height()) / 2;
            var marginLeft = (panel.width() - 300) / 2;
            var tipsStyle = 'position: absolute;margin-top:{0}px;margin-left:{1}px'.format(marginTop,marginLeft);
            _commonfunc.online(url,iframe,tipsStyle,panel,'',ebookContext.getUser());
        };

        /**
         * 显示提示内容
         * @param tips
         */
        _self.showTips = function (tips){
            $.Zebra_Dialog(tips, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips]
            });
        };

        /**
         * 读取用户头像
         * @param userName
         */
        _self.getUserHeadPhoto = function (userName){
            //若头像文件存在，则设置头像src，否则使用默认头像
            _userinfoAccessor.getUserHeadPhoto(userName).done(function (fileName) {
                console.log("用户头像： " + fileName);
                if (fileName) {
                    var filePath = _self.user.getUserBasePath() + '/' + fileName;
                    _self.controls.ctrHeadPortrait.attr("src", filePath);
                }
                else{
                    _self.controls.ctrHeadPortrait.attr("src", "assert/images/head_default.jpg");
                }
                _self.controls.ctrHeadPortrait.show("fast");
            });
        };

    }


    exports.PersonalInfoManager = PersonalInfoManager;
});