/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-5-21
 * Time: 上午8:56
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {

    var ebkContext = require("../../ebookcontext").Instance;
    Recharge.state=0;
    /**
     * 套餐卡充值入口模块
     */
    function Recharge(){
        var _self = this;
        _self.Dom = {};
        _self.shellcmd = require("../../../common/shellcmd.js");
        _self.ready = false;

        _self.show = function(){
            !_self.ready && _self.initDOM();

            var top = ($(window).height() - 200) / 2;
            _self.Dom.rechargePanel.css("top",top).show();
            _self.showTips("&nbsp;");
            _self.Dom.reChargeInput.val("");
        }

        _self.close = function(){
            _self.Dom.rechargePanel.hide();
        }

        _self.initDOM = function(){
            _self.Dom.rechargePanel = $($("#recharge")[0].innerHTML);
            _self.Dom.rechargePanel.appendTo("body");

            _self.Dom.closeReCharge = $("#closeReCharge");
            _self.Dom.reChargeInput = $("#rechargeInput");
            _self.Dom.reChargeBtn = $("#reChargeBtn");
            _self.Dom.reChargeTip = $("#reChargeTips");
            _self.addEvents();
            _self.ready = true;
        }

        _self.addEvents = function(){
            //关闭
            _self.Dom.closeReCharge.click(function(){
                _self.close();
            });

            //充值加载状态
            _self.showLogding =function(){
                var reChargeBtn=document.getElementById("reChargeBtn");
                var html="充值中<img style='margin-left:5px;' height='12' width='12' src='assert/js/app/bookshelf/recharge/loading.gif'>";
                reChargeBtn.innerHTML=html;
                Recharge.state=1;
            }
            //关闭加载状态
            _self.closeLogding=function(){
                var reChargeBtn=document.getElementById("reChargeBtn");
                var html="充值";
                reChargeBtn.innerHTML=html;
                Recharge.state=0;
            }
            // 充值
            _self.Dom.reChargeBtn.click(function(){
                if(Recharge.state==0){
                    _self.showLogding();
                    _self.reCharge(_self.Dom.reChargeInput.val());
                }else{

                }
            });
        }
        _self.reCharge = function(inputstr){
            //16位旧充值码验证
            if( inputstr.length == 16){
                _self.goToPay16(inputstr);
            }
            //14位和18位号码验证
            else if(inputstr.length == 14 || inputstr.length == 18){
                _self.goToPay1814(inputstr);
            }
            else{
                _self.showTips("格式不正确");
                _self.closeLogding();
            }
        }

        _self.goToPay16 = function(inputstr){

            var sendData = {//保存数据到服务器，成功时返回信息
                url: AppRemoteSvcCfg.rePay,
                activeNum : inputstr,
                timeout: 30000, //设置超时
                dataType: "json"
            }

            _self.shellcmd.postHttpRequest(sendData).done(function(ret){
                if(ret){
                    console.log(ret);
                    if (ret.errorCode == 0) {
                        _self.showTips("16位充值码请到商务平台充值");
                        _self.closeLogding();
                    }
                    else{
                        _self.showTips("充值码错误");
                        _self.closeLogding();
                    }
                }
                else{
                    _self.showTips("网络异常");
                    _self.closeLogding();
                }
            });
        }

        _self.goToPay1814 = function(inputstr){
            //充值
            var param = {
                regName : ebkContext.getUser().getName(),
                activeNum : inputstr
            }

            var sendData = {//保存数据到服务器，成功时返回信息
                url: AppRemoteSvcCfg.reCharge,
                regName : ebkContext.getUser().getName(),
                activeNum : inputstr,
                timeout: 30000, //设置超时
                dataType: "json"
            }

            _self.shellcmd.postHttpRequest(sendData).done(function(ret){
                if(ret){
                    if (ret.errorCode == 0) {
                        _self.showTips("充值成功！");
                        _self.closeLogding();
                        //显示加载
                        ebkContext.getUser().getPointsThenSet();
                    }
                    else{
                        _self.showTips(ret.errorInfo);
                        _self.closeLogding();
                    }
                }
                else{
                    _self.showTips("网络异常");
                    _self.closeLogding();
                }
            });
        }

        _self.showTips = function (tips){
            _self.Dom.reChargeTip.empty().html(tips);
        }
    }

    exports.Instance = new Recharge();
});