/**
 * 卡片资源管理类
 * Date: 7/5/13
 * Time: 10:13 AM
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports, module) {
    var shellcmd = require('../../common/shellcmd');
    var md5helper = require('../../common/md5helper');
    var _helper = require("../card/template/choicecardtpl/choicecardtmphelper").Instance;

    var cardReader = require('./cardreader');
    var speechuiModel = require('../../speechui/code/model');

    require('jquery');
    require('xml2json');
    require('browserContext');


    /**
     * 获取英文单词评测卡片参数
     * @param {object} cardInfo
     * @param {string} src
     * @return {{
     *     paperContent:string,
     *     audios: Array.<string>
     * }}
     */
    function getEvalCardOptions(cardInfo,src) {
        var wordsArr=cardInfo.words;
        var constFilePath = src+"/";
        var audioPaths = new Array();
        var words=new Array();

        for (var i = 0; i < wordsArr.length; i++) {
            var audioPath = constFilePath + wordsArr[i].audio;
            audioPaths[i] = audioPath.replace('file:/','');
            words.push(wordsArr[i].word);
        }
        var options = {
            paperContent: '[word]\n' + words.join('\n'),
            audios: audioPaths
        };
        return options;
    }

    /**
     * 获取中文词语评测卡片参数
     * @param {object} cardInfo
     * @param {string} src
     * @return {{
     *     paperContent:string,
     *     audios: Array.<string>
     * }}
     */
    function getCnEvalCardOptions(cardInfo,src) {
        var wordsArr=cardInfo.words;
        var constFilePath = src+"/";
        var audioPaths = new Array();
        var words=new Array();
        var wordsType = 1; // 单字
        var paperContent = "";

        var pyPath = constFilePath + cardInfo.py;
        var pyfile = shellcmd.readFile(pyPath);
        paperContent = pyfile;

        for (var i = 0; i < wordsArr.length; i++) {
            var audioPath = constFilePath.replace("file:/","") + wordsArr[i].audio;
            //var pyfile=callClient("syscmd","readfile",pyPath,0);
            words.push(wordsArr[i].word);
            if (words[i].length > 1) {
                wordsType = 2;  //词
            }
            audioPaths[i] = audioPath;
        }
        paperContent = paperContent.replace(/\0/g, "");

        var options = {
            paperContent: paperContent,
            audios: audioPaths,
            isSyllable: wordsType == 1
        };

        return options;
    }

    /**
     * 获取情景对话卡片参数
     * @param {object} cardInfo
     * @param {string} src
     * @return {object} options
     */
    function getSituCardOptions(cardInfo,src){
        var constFilePath = src+"/";
        for(var i=0; i<cardInfo.sens.length; i++){
            cardInfo.sens[i].audio = constFilePath +cardInfo.sens[i].audio;
        }
        var options=cardInfo;
        return options;
    }

    /**
     * 获取画廊卡片初始化参数
     * @param {string} xmlPath 画廊卡片资源XML路径
     * @return {{
     *     title: string,
     *     imageInfos: Array.<GalleryImageInfo>
     * }}
     */
    function getGalleryCardOptions(xmlPath) {
        //TODO: 检查xml路径有效性
        var def= $.Deferred();
        cardReader.Instance.getContent(xmlPath).done(function(resInfo){
            var imageInfos = [];
            var imageBase = xmlPath;    // 图片根路径
            $.each(resInfo.images, function (index, imageInfo) {
                var imageUri = imageInfo.src;
                var imgUrl = imageBase + '/' + imageUri.substr(imageUri.lastIndexOf('\\') + 1);
                imageInfos.push(new speechuiModel.GalleryImageInfo(parseInt(imageInfo.index), imageInfo.des, imgUrl));
            })
            //判断是否存在GalleryTitle结点
            var heading = (!resInfo.title) ? "" : resInfo.title;

            var cardOptions = {
                title: heading,
                imageInfos: imageInfos
            };

            def.resolve(cardOptions);
        });

        return def.promise();
    }

    function getChoiceCardOptions(xmlPath){
        console.log(xmlPath);
        var jsonFile = xmlPath+"/choiceinfo.json";
        var def= $.Deferred();
        var jsonStr = shellcmd.readFile(jsonFile);
        if(jsonStr){
            jsonStr = jsonStr.replace(/\n/g, "").replace(/\r/g, "").replace(/\0/g, "");
            var metaObj = $.parseJSON(jsonStr);
            //转换json，主要将json中原来的相对路径改为绝对路径
            var title = metaObj.title;
            var totalNum = metaObj.totalNum;

            var questionList = [];
            var questionItem ={};
            var choiceItem1 ={};
            for(var i=0;i<metaObj.questionArr.length;i++){
                questionItem ={};
                questionItem.index = i+1;//为什么index加1，满足杨成的需求
                questionItem.type = metaObj.questionArr[i].type;//题目类型
                if(questionItem.type == _helper.QuestionType.TextChoiceWithImage){
                    questionItem.imgPath = xmlPath+"/"+metaObj.questionArr[i].imgPath;
                }else{
                    questionItem.imgPath = "";
                }
                questionItem.theme =  metaObj.questionArr[i].theme;//题面信息
                questionItem.answer =  parseInt(metaObj.questionArr[i].answer)+1;//正确答案,为什么加1，满足杨成的需求
                questionItem.choiceNum = metaObj.questionArr[i].choiceNum;//选项个数
                questionItem.choiceItem = [];
                for(var j =0;j< metaObj.questionArr[i].choiceItems.length;j++){
                    choiceItem1 ={};

                    if(metaObj.questionArr[i].type == _helper.QuestionType.ImageChoice){
                        //TODO:加上路径
                        choiceItem1.imgPath = xmlPath+"/"+metaObj.questionArr[i].choiceItems[j].imgPath;
                        choiceItem1.label ="";
                        choiceItem1.text = "";
                    }else{
                        choiceItem1.imgPath = "";
                        choiceItem1.label = metaObj.questionArr[i].choiceItems[j].label;
                        choiceItem1.text = metaObj.questionArr[i].choiceItems[j].text;

                    }
                    questionItem.choiceItem.push(choiceItem1);
                }
                questionList.push(questionItem);

            }

            var choiceInfoObj = {};
            choiceInfoObj.title = title;
            choiceInfoObj.totalNum = totalNum;
            choiceInfoObj.questionArr = questionList;

            def.resolve(choiceInfoObj);
        }else{
            console.error("shellcmd读取资源为空： "+xmlPath);
        }

        return def.promise();

    }

    exports.getEvalCardOptions = getEvalCardOptions;
    exports.getCnEvalCardOptions = getCnEvalCardOptions;
    exports.getGalleryCardOptions = getGalleryCardOptions;
    exports.getChoiceCardOptions = getChoiceCardOptions;
    exports.getSituCardOptions = getSituCardOptions;
})
