/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-11-1
 * Time: 下午1:07
 * To change this template use File | Settings | File Templates.
 */

/******************************************************************************
 * 这一模块原本打算用HTML5的视屏流来做拍照功能。
 * 后来因为技术不支持调整摄像头的分辨率而放弃
 * 现在的拍照是调用Delphi编写的videoCap.exe + js 全局回调 实现。
 *
 * 如果当你接手这一模块时，HTML5已经支持自动识别摄像头，
 * 可以设置摄像头分辨率，并且可以很好的区分物理设备和虚拟设备，
 * 恩，你可以考虑用这个新技术重新写这一模块。
 * 而且，我确定不会占用你太多时间，前提是，你对这个项目的所有代码都比较熟悉。
 *
 *              ---------------- by  yczhu  2014-07-26
 ******************************************************************************/
define(function (require, exports) {
    require('jquery');
    var CardWrapper = require('../cardwrapper').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var isSavePress = 0;

    var screenWidth = Config.Width;
    var screenHeight = Config.Height;
    var vedioWidth = 800;
    var vedioHeight = 600;
    var bottomWidth = 800;
    var bottomHeight = 28;
    var btnMarginLeft = 400;

    if(screenWidth==800 || screenHeight == 600) {
        vedioWidth = 640;
        vedioHeight = 480;
        bottomWidth = 640;
        btnMarginLeft = 200;
    }

    var topHeigth = vedioHeight + 5;
    var topWidth  = vedioWidth;

    function Camera() {
        var _self = this;

        _self.init = function () {
            //添加到cardwarp的模块
            var $div = $('<div >' +
                '<div id="topDiv" style="height:'+topHeigth+'px;width:'+topWidth+'px;" ><center>' +
                '<video id="video" width="'+vedioWidth+'" height="'+vedioHeight+'" autoplay=""></video>' +
                '<canvas id="canvas" width="'+vedioWidth+'" height="'+vedioHeight+'"></canvas></center></div>' +
                '<div id="bottomDiv" style="-webkit-border-radius:8px;height:40px;width:'+bottomWidth+'px;border: solid gray 1px;background: url(assert/images/panel_bg.bmp);">' +
                '<div style="margin-top:6px;"><a id="snap" style="margin-left: 10px;"><img src="assert/images/cap_enable.bmp" /></a>' +
                '<a id="unSnap" style="margin-left: 10px;"><img src="assert/images/cap_disable.bmp" /></a>' +
                //'<img src="assert/images/split.bmp" />' +
                '<a id="reSnap" style="margin-left: 40px;"><img src="assert/images/recap_enable.bmp" /></a>' +
                '<a id="unReSnap" style="margin-left: 40px;"><img src="assert/images/recap_disable.bmp" /></a>' +
                //'<img src="assert/images/split.bmp" style="margin-left: 40px;/>' +
                '<a id="save" style="margin-left: '+btnMarginLeft+'px;"><img src="assert/images/save_enable.bmp" /></a>' +
                '<a id="unSave" style="margin-left: '+btnMarginLeft+'px;"><img src="assert/images/save_disable.bmp" /></a></div></div>' +
                '</div>');

            //转换为jQuery对象或Dom对象
            var $topDiv = $div.find("#topDiv");
            var $bottomDiv = $div.find("#bottomDiv");
            var $canvas = $div.find("#canvas");
            var canvas = $canvas[0];
            var context = $canvas[0].getContext("2d");
            var $video = $div.find("#video");
            var video = $video[0];
            var videoObj = { "video": true };
            var errBack = function (error) {
                console.log("Video capture error: ", error.code);
                $.Zebra_Dialog(AppCameraTips.NoCamera, {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [  AppTips.OkTips],
                    'onClose': function (capition) {
                    }
                });
            };

            var $snap = $div.find("#snap");
            var $unSnap = $div.find("#unSnap");
            var $reSnap = $div.find("#reSnap");
            var $unReSnap = $div.find("#unReSnap");
            var $save = $div.find("#save");
            var $unSave = $div.find("#unSave");

            //拍照
            $snap.click(function () {
                context.drawImage(video, 0, 0, vedioWidth, vedioHeight);
                readySave();
            });

            //重拍
            $reSnap.click(function () {
                readySnap();
            });

            //添加到电子书（未完成，交给常维军了）
            $save.click(function () {
                if (isSavePress == 0) {
                    isSavePress = 1;
                    // 1， 获取图片的base64字符串
                    var imagedate = canvas.toDataURL("image/png");
                    // 2, 获取的base64字符串 传递给Delphi的外壳：转换成图片格式经回调添加到课本中
                    shellcmd.saveBase64AsImage(imagedate).done(function () {
                        CardWrapper.minimize();
                        isSavePress = 0;
                    });
                }
            });

            //寻找摄像头（else里面才是的）
            if (navigator.getUserMedia) { // Standard
                navigator.getUserMedia(videoObj, function (stream) {
                    video.src = stream;
                    video.play();
                }, errBack);
            } else if (navigator.webkitGetUserMedia) { // WebKit-prefixed
                navigator.webkitGetUserMedia(videoObj, function (stream) {
                    video.src = window.webkitURL.createObjectURL(stream);
                    video.play();
                    CardWrapper.show($div[0]);
                    locate();
                    readySnap();
                }, errBack);
            }

            function locate() {
                //高度居中
                var windowHeight = $(window).height();

                var topLength = (windowHeight - topHeigth - bottomHeight) / 2;
                $topDiv.css("margin-top", topLength);

                //宽度居中（近似居中）
                var windowWidth = $(window).width();
                var leftLength = (windowWidth - topWidth - 100) / 2;

                $bottomDiv.css("margin-left", leftLength);
                $topDiv.css("margin-left", leftLength);
            }

            //可以拍照时的按钮状态
            function readySnap() {
                $canvas.hide();
                $video.show();
                $snap.show();
                $unSnap.hide();
                $unReSnap.show();
                $reSnap.hide();
                $unSave.show();
                $save.hide();
            }

            //准备重拍时的按钮状态
            function readySave() {
                $canvas.show();
                $video.hide();
                $snap.hide();
                $unSnap.show();
                $unReSnap.hide();
                $reSnap.show();
                $unSave.hide();
                $save.show();
            }
        }
    }

    exports.Instance = new Camera();
});