/**
 * Created by pengfu on 14-7-14.
 */
;
define(function (require, exports) {
    var _helper = require("./choicecardtmphelper").Instance;
    var md5helper = require('../../../../common/md5helper');
    var QuestionItemBase = require("./choicecardbase").QuestionItemBase;
    require('jquery');
    var path = require('../../../../common/path');
    var shellcmd = require('../../../../common/shellcmd');
    var define = require('../../../define');

    /**
     *
     * @constructor
     */
    function TextChoiceQuestion(quesitonObj) {
        this.type = _helper.QuestionType.TextChoice;
        this.choiceItems = [];
        this.correctAnswer = -1;
        var labelList = ['A', 'B', 'C', 'D', 'E', 'F'];
        var input_txt = AppCardTemplateTipsList.clickHereAddAnswer;
        var input_txt_title = AppCardTemplateTipsList.clickHereAddTheme;

//        var domstr = '<div >' +
//            '<div ><input class="showInfo"  type="text"  /> </div>' +
//            '<div><input class="choice_theme" class1="questionText"  type="text" value="{text}"/>' + '</div>' +
//            '</div>';
        var domstr = '<div >' +
            '<div class="shit_input" ><label>第1题</label><input class="choice_theme" class1="questionText"  type="text" value="{text}"/>' + '</div>' +
            '</div>';

        var tmpChoiceItemTpl = '<li index="{index}" class="chioceti">' +
            '<a title="" id="{id}" class1="radioform" class="check_btn "></a>' + '<span class="sub_tit">{lable}.</span>' +
            '<input type="text" class1="choicetext" class="add_answer" value="{addAnswer}"  >' +
            '</li>';
//        var choiceItemTpl = tmpChoiceItemTpl.replace("{addAnswer}", input_txt);
        var choiceItemTpl = tmpChoiceItemTpl;

        var _this = this;

        function init(quesitonObj) {
            if(!quesitonObj){
                _this.questionText = input_txt_title;
                _this.questionId = "TCQ_" + new Date().getTime();
                //TODO: 初始化choiceItems
                for (var i = 0; i < 4; i++) {
                    var item = new _helper.ChoiceItem();
                    item.label = labelList[i];
                    _this.choiceItems.push(item);
                }
            }
            else{
                _this.questionText = quesitonObj.theme;
                _this.questionId = "TCQ_" + new Date().getTime();
                for(var j= 0,len = quesitonObj.choiceItems.length;j < len; j++){
                    var eachItem = new _helper.ChoiceItem();
                    eachItem.label = labelList[j];
                    eachItem.text = quesitonObj.choiceItems[j].text;
                    _this.choiceItems.push(eachItem);
                }
            }

        }

        /**
         *
         * @returns {Array.<ChoiceItem>}
         */
        this.getChoiceItems = function () {
            return this.choiceItems;
        }

        this.buildHTML = function (questionObj) {
//            var domstr = '<div>' +
//                '<div > <input class="questionText"  type="text" value="{text}" style="width: 250px"/>' +'</div>' +
//                '<div><input class="showInfo"  type="text"  style="width: 250px" />'+'</div>'+
//                '</div>';
//
//            var choiceItemTpl = '<div index="{index}" class="chioceti">'+
//                '<input id="{id}" type="radio" name="form1" class="radioform" /><label for="{id}">{lable}</label>'+
//                '<input class="choicetext"  a= "{lable}" name="" lang="x"  type="text" value="{text}"/>'+
//                '</div>';
            var themeContent ;
            if(!questionObj){
                themeContent = input_txt_title;
            }else{
                themeContent = questionObj.theme;
            }
            var dom = $(domstr.replace("{text}", themeContent));

            var choiceItemArr = this.getChoiceItems();
            var choiceItemsHTMLArr = [];
            for (var i = 0, len = choiceItemArr.length; i < len; i++) {
                var choiceItem = choiceItemArr[i];
                var choiceId = "" + i + new Date().getTime();
                var html = choiceItemTpl.replace("{index}", i)
                    .replace(/\{id\}/g, choiceId)
                    .replace("{lable}", choiceItem.label)
                    .replace("{addAnswer}", choiceItem.text);
                choiceItemsHTMLArr.push(html);
            }

//            var choiceItemsDomStr = '<div id="{questionId}"> </div>'.replace("{questionId}",_this.questionText);
            var choiceItemsDomStr = '<div class="sub_type_1" id="{questionId}"> </div>'.replace("{questionId}", _this.questionId);
            var choiceItemsDom = $(choiceItemsDomStr);
            choiceItemsDom.append(choiceItemsHTMLArr.join(''));
            dom.append(choiceItemsDom);

            if(questionObj && questionObj.answer > -1){
                //设置正确答案样式
                dom.find("a[class1=radioform]").eq(questionObj.answer).removeClass().addClass('check_btn checked');
                this.correctAnswer = questionObj.answer;
                var questionDom = dom.find('#'+this.questionId);

                this.changeChoiceItemStyle(questionDom,questionObj.choiceItems.length);

            }

//            dom.append(choiceItemsHTMLArr.join(''));
            var questionTxtDom = dom.find('input[class1=questionText]');

            questionTxtDom.focusout(function () {
                if ($(this).val().trim() === '') {
                    $(this).val(input_txt_title);
                }
                _this.questionText = $(this).val();

            }).focusin(function () {
                    if ($(this).val().trim() === input_txt_title) {
                        $(this).val("");
                    }
                });

            //对题目输入过长的处理
            questionTxtDom.bind('input propertychange',function(){
//                var _that = _this;
                var _self = this;
                if($(_self).val().length>45){
                    $.Zebra_Dialog(AppCardTemplateTipsList.ThemeTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons':  [AppTips.OkTips],
                        'onClose': function(){
                            //题目过长，截断处理
                            $(_self).val($(_self).val().substr(0,45));
                            _this.questionText = $(_self).val();
                        }
                    });
                }
            });

            var choiceTxtDoms =  dom.find('input[class1=choicetext]');

            choiceTxtDoms.focusout(function () {
                if ($(this).val().trim() === '') {
                    $(this).val(input_txt);
                }
                var i = $(this).parent().attr("index");
                // TODO: 同步数据
                _this.getChoiceItems()[i].text = $(this).val();

            }).focusin(function () {
                    if ($(this).val().trim() === input_txt) {
                        $(this).val("");
                    }
                });

            //答案选项不允许输入过长
            choiceTxtDoms.bind('input propertychange',function(){
                var _self = this;
                var i = $(this).parent().attr("index");
                if($(_self).val().length>45){
                    $.Zebra_Dialog(AppCardTemplateTipsList.AnswerTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons':  [AppTips.OkTips],
                        'onClose': function(){
                            //答案过长，截断处理
                            $(_self).val($(_self).val().substr(0,45));
                            _this.getChoiceItems()[i].text = $(_self).val();
                        }
                    });
                }
            });

            // TODO: add event

            dom.find("a[class1=radioform]").click(function () {
                //TODO:改变checked 状态
                var len = $(this).parent().parent().children().length;//选项数
                for (var i = 0; i < len; i++) {
                    var obj = $($($(this).parent().parent().children()[i]).children()[0]).attr("class", "check_btn");
                }

                $(this).attr("class", "check_btn checked");

                var index = $(this).attr("id")[0];
                _this.correctAnswer = index;

            });

            this._dom = dom;
            return this._dom;
        }

        this.travel2Json = function (currentIndex,dir) {
            var questionItem = {};
            var choiceItem = {};
            questionItem.type = this.type;
            questionItem.imgPath = "";
            questionItem.theme = this.questionText;//题面信息,初始化值是单击此处添加测试题目
            if (questionItem.theme == AppCardTemplateTipsList.clickHereAddTheme) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题添加题干信息", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }

            //解决bug，比如现在有4个选项，正确答案原来设置为第4个选项，当减少选项数为3时，这时点击完成，实际上正确答案没有设置，
            var choiceNumber = this.choiceItems.length;
            questionItem.answer = this.correctAnswer;//正确答案
            if ((questionItem.answer == -1) || (questionItem.answer >= choiceNumber)) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题设置正确答案", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }
            questionItem.choiceNum = this.choiceItems.length;//选项个数
            questionItem.choiceItems = [];
            for (var j = 0; j < this.choiceItems.length; j++) {
                choiceItem = {};

                choiceItem.label = this.choiceItems[j].label;
                choiceItem.text = this.choiceItems[j].text;
                if ((!choiceItem.text) || (choiceItem.text == AppCardTemplateTipsList.clickHereAddAnswer)) {
                    $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题的第" + (j + 1) + "选项添加答案信息", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                    return null;
                }
                choiceItem.imgPath = "";
                questionItem.choiceItems.push(choiceItem);
            }
            return questionItem;
        }

        init(quesitonObj);
    }

    TextChoiceQuestion.prototype = new QuestionItemBase();
    TextChoiceQuestion.prototype.constructor = TextChoiceQuestion;

    exports.TextChoiceQuestion = TextChoiceQuestion;
})