/**
 * Created with JetBrains WebStorm.
 * User: Taly
 * Date: 13-6-16
 * Time: 下午1:34
 */
define(function(require, exports) {

    var SearchMode={
        CloudSearch:0,
        LocalSearch:1,
        WebSearch:2
    }
    /**
     * 用户登陆结果类型
     */
    var LoginResultType={

        /**
         * 登陆失败
         */
        Fail:0,

        /**
         * 远程登陆成功
         */
        RemoteSuccess:1,

        /**
         * 本地登陆成功
         */
        LocalSuccess:2,

        /**
         * 环境不允许
         */
         EnvironmentNotAllowed:3,

        /**
         * 用户未激活
         */
        NotActivated: 4,

        /**
         * 无License
         */
        NoLicense:6,

        /**
         * 过期了
         */
        TimeStampOver:7,

        /**
         * 联网登录失败
         */
        RemoteFail:11,
        /**
         * 本地登录失败
         */
        LocalFail:12,

        /**
         * 没有用户目录
         */
        NoAccountFold:14,

        /**
         * 参数不完整
         */
        ArgumentImperfect:15,

        /**
         * 用户名和密码不匹配
         */
        AccountNotMatchPwd:16,

        /**
         * 账号和机器码不匹配
         */
        AccountNotMatchMachineCode:17,

        /**
         * 创建本地用户目录失败
         */
        CannotCreateLocalUserFold:18,

        /**
         *向本地数据库中插入数据失败
         */
        CannotInsertLocalUserinfo:19,

        /**
         * 允许绑定
         */
        AllowBind:20,

        /**
         * 授权绑定已满
         */
        BindOverflow:21,

        /**
         * 已绑定
         */
        AlreadyBind:22,

        /**
         * 获取绑定信息失败
         */
        GetBindMsgError:23,

        /**
         * 用户被禁用
         */
        AccountForbidden:24,

        AccountOutDate:25

    }
    /**
     * 热区类型
     * @enum {define.HotSpotType}
     */
    var HotSpotType = {
        /**
         * 矩形
         */
        Rectangle: 0,

        /**
         * 椭圆
         */
        Ellipse: 1,

        /**
         * 路径(不规则图形)
         */
        Path: 3
    };

    /**
     * 页面视图类别
     * @enum {define.PageViewType}
     */
    var PageViewType = {
        /**
         * TurnJS双页视图
         */
        TurnJsDoublePage: 1,

        /**
         * 简单双页视图
         */
        SimpleDoublePage: 2,

        /**
         * 简单单页视图
         */
        SimpleSinglePage: 3,

        /**
         * 白板视图
         */
        WhiteBoardView : 4
    };

    /**
     * 全部书本或者已选课本
     * @type {{allBooks: number, selectedBooks: number}}
     */
    var FirstButton = {
        allBooks : 1 ,
        selectedBooks :2
    };

    /**
     * 卡片类型,注意这里约定每个字段的值是其属性的第一个字母小写后的值，在加载卡片时会根据这条规则进行判断。
     */
    var WidgetType = {
        /// <summary>
        /// 图片
        /// </summary>
        Img: 'img',
        /// <summary>
        /// 画廊
        /// </summary>
        Gallery: 'gallery',

        /// <summary>
        /// 选择题
        /// </summary>
        Choice:'choice',

        Flash: 'flash',
        Video: 'video',
        Audio: 'audio',

        /// <summary>
        /// 练习题
        /// </summary>
        Exercise: 'exercise',

        /// <summary>
        /// 评测卡片
        /// </summary>
        Evaluate: 'evaluate',

        /**
         * 在线卡片资源
         */
        OnlineRes:'onlineRes',

        /// <summary>
        /// 其他第三方可执行程序
        /// </summary>
        Proc3rd: 'proc3rd',

        /// <summary>
        /// 便签
        /// </summary>
        Note: 'note',

        Icw : 'icw',
        ImgPaint : 'imgPaint',
        FadeCurtain:'fadeCurtain',

        Vote : "vote",
        InteractiveCard : "interactiveCard"
    };
    /**
     * 评测卡片类型
     * @type {{Poem: string, Cn_Word: string, En_Word: string, Immitate: string, Situ: string}}
     */
    var EvalCardType = {
        Poem: 'poem',
        Cn_Word: 'cn_word',
        En_Word: 'en_word',
        Immitate: 'immitate',
        Situ: 'situ'
    };

    /**
     * 在线卡片资源类型
     * @type {{StrokeOrder: string, VirtualExperiment: string, Poem: string}}
     */
    var OnlineResType={
        Dictionary:'dictionary',
        StrokeOrder:'strokeorder',
        VirtualExperiment:'virtualexperiment'
    }

    /**
     * 资源类型
     */
    var extFilter={
        type:['图片','音频','视频','文档','网页文件','可执行文件'],
        array:{
            imgExtArray:['.jpg','.gif','.bmp','.jpeg','.png'],
            audioExtArray:['.mp3','.wav','.wma'],
            videoExtArray:['.rmvb','.mp4','.avi','.wmv','.asf','.mpeg','.3gp','.flv','.mpg','.swf','.f4v','.hlv'],
            officeExtArray:{
               word:  ['.doc','.docx'],
               ppt:['.ppt','.pptx','.pps','.ppsx'],
               excel:['.xls','.xlsx'],
               txt:['.txt'],
               pdf:['.pdf'],
               rtf:['.rtf'],
               chm:['.chm']
            },
            htmlExtArray:['.htm','.html','.mht'] ,
            execExtArray:['.exe']
        }
    };

    //播放器类型
    var PlayerType={
        HotspotPlayer:1,
        AudioPlayer:2,
        VideoPlayer:3
    }

    /**
     * 根据后缀名获取卡片类型
     * @param ext
     * @returns {*}
     */
    function getWidgetTypeByExt(ext) {
        ext = ext.toLowerCase();
        if (ext === '.swf')
            return WidgetType.Flash;
        else if ($.inArray(ext,extFilter.array.videoExtArray)!=-1)
            return WidgetType.Video;
        else if ($.inArray(ext,extFilter.array.imgExtArray)!=-1)
            return WidgetType.Img;
//        else if (ext === '.scard')
//            return WidgetType.Evaluate;
//        else if (ext == '')  //根据cxml文件判断是否为画廊
//            return WidgetType.Gallery;
        else if ($.inArray(ext,extFilter.array.audioExtArray)!=-1)
            return WidgetType.Audio;
        else if(ext==".note")
          return WidgetType.Note;
        else if(ext == ".icw")
            return WidgetType.Icw;
        else if(ext === ".vote")
            return WidgetType.Vote;
        else if(ext ===".sco")
            return WidgetType.InteractiveCard;
        else
            return WidgetType.Proc3rd;
    }
    exports.SearchMode = SearchMode;
    exports.LoginResultType = LoginResultType;
    exports.HotspotType = HotSpotType;
    exports.PageViewType = PageViewType;
    exports.FirstButton = FirstButton;
    exports.WidgetType = WidgetType;
    exports.EvalCardType = EvalCardType;
    exports.OnlineResType=OnlineResType;
    exports.getWidgetTypeByExt = getWidgetTypeByExt;
    exports.extFilter=extFilter;
    exports.PlayerType=PlayerType;
})