define(function (require, exports) {

    function EBookContext() {
        var path = require('../common/path');
        var _user = require('./user');
        var shellcmd = require('../common/shellcmd');
        var _self = this;
        _self._curUser = null;
        _self._binPath = '';
        //以下字段只用在电子书界面
        _self.curBookCode = '';
        _self.WBEB = '';
        _self.ifsBoard=false;//ifs黑板默认未打开
        _self.EndClassStyle=0;//结束上课方式，0表示在上课，1表示点击书架，2表示点击关闭按钮，3表示异常关闭，4表示点击下课按钮
        _self.matchCode = "";
        //画笔是否使用
        _self.isPenUse=false;
        //这个字段正常情况下只用在当前文件中,故写作私有
        var _isU = '';

        _self.setIsU = function(isU){
            _isU = isU;
        }

        _self.setBinPath = function (dir) {
            _self._binPath = dir;
        }

        _self.setUser=function(username,password){
            _self._curUser = new _user.User();
            _self._curUser.setBasePath(_self._binPath);
            _self._curUser.setName(username);
            _self._curUser.setPassword(password);
        }

        _self.setUserRole = function(role){
            _self._curUser.setUserRole(role);
        }

        _self.getUserRole = function(){
            return _self._curUser.getUserRole();
        }

        //记录用的appName
        _self.setUserAppName = function(appName){
            _self._curUser.setUserAppName(appName);
        }

        _self.getUserRole = function(){
            return _self._curUser.getUserAppName();
        }

        _self.setUserBaseInfo = function(uid,email,phone,userName,province){
            uid && _self._curUser.setUid(uid);
            email && _self._curUser.setEmail(email);
            phone && _self._curUser.setPhoneNum(phone);
            userName && _self._curUser.setUserName(userName);
            province && _self._curUser.setProvince(province);
        }

        _self.setUserExtInfo = function(ticket,isOnline,isActive,userloginname,loginFrom,points,SSO,books){
            ticket && _self._curUser.setTicket(ticket);
            isOnline && _self._curUser.setIsOnline(isOnline);
            isActive && _self._curUser.setIsActive(isActive);
            userloginname && _self._curUser.setUserLoginName(userloginname);
            loginFrom && _self._curUser.setLoginFrom(loginFrom);
            points && _self._curUser.setPoints(points);
            books && _self._curUser.setBooks(books);
            SSO && _self._curUser.setSSOTicket(SSO);
        }

        _self.setUserClassId = function(id){
             _self._curUser.setUserClassId(id);
        }

        _self.getUserClassId = function() {
            return _self._curUser.getUserClassId();
        }

        _self.getUser = function () {
            return _self._curUser;
        };

        _self.setBookCode = function (bookcode) {
            _self.curBookCode = bookcode;
        };

        _self.getBookCode = function () {
            return _self.curBookCode;
        };

        _self.getUserBookPath = function () {
            var usrbk = path.join(_self._curUser.getUserBookBasePath(), _self.curBookCode);
            return usrbk;
        };

//        _self.getStdBookPath = function () {
//            var usrbk = (_self.curBookCode == AppCfg.testBook) ? (_self._curUser.getStdTestBookBasePath()): path.join(_self._curUser.getStdBookBasePath(), _self.curBookCode);
//            return usrbk;
//        };

        _self.getStdBookPath = function(){
            var usrbk = '';
            if(_self.curBookCode == AppCfg.testBook){
                usrbk = _self._curUser.getStdTestBookBasePath();
            }else if(_self.curBookCode == AppCfg.testBook2){
                usrbk = _self._curUser.getStdTestBook2BasePath();
            }else{
                usrbk = path.join(_self._curUser.getStdBookBasePath(), _self.curBookCode);
            }
            return usrbk;
        }

        _self.setIsPenUse=function(value){
            // $(document).data("isPenUse",value);
            if(value==_self.isPenUse) return ;
            else
               _self.isPenUse=value;

        }

        //获取当前画笔状态
        _self.getIsPenUse=function(){
            // return _isHavingClass == true ? true : false;
            return _self.isPenUse;
            // $(document).data("isPenUse") ? true : false;
        }


        /**
         * 临时目录地址
         * @returns {*}
         */
        _self.getTmpPath=function(){
            return path.trimPosix(path.join(_self._binPath,'temp'));
        }

        /***
         * 操作系统 %TEMP%/iflybook
         * @returns {*}
         */
       _self.getSysTmpPath=function(){
           return path.trimPosix(Config.tmpPath);
       }

        _self.setWBEB = function(wbeb){
            _self.WBEB = wbeb;
        }

        _self.getWBEB = function(){
            return _self.WBEB;
        }

        _self.getTransformMatrix = function(page){
            var matrixTransform = page ? page.css('-webkit-transform') : $('.pageItem').css('-webkit-transform');
            matrixTransform = matrixTransform && matrixTransform != 'none' ? matrixTransform.substr(7, matrixTransform.length - 8).split(",") : [1, 0, 0, 1, 0, 0];
            return matrixTransform;
        }

        _self.getUnTransForm = function(){
            var matrix = this.getTransformMatrix();
            var wZoom = matrix[0] ? 1 / matrix[0] : 1;
            var hZoom = matrix[3] ? 1 / matrix[3] : 1;
            return {
                wZoom: wZoom,
                hZoom: hZoom
            };
        }
        _self.getUnTransFormBuble = function(){
            var obj = this.getUnTransForm();
            if(obj.wZoom == 1)
            {
                return {
                    wZoom: obj.wZoom / 0.7,
                    hZoom: obj.hZoom /0.7
                };

            }
            else{
                return {
                    wZoom: 1/0.7,
                    hZoom: 1/0.7
                };
            }
        }

        _self.getClientToken = function(){
            var def = $.Deferred();
            shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret){
                if(ret){
                    app_ClientToken = ret.access_token;
                    def.resolve(ret.access_token);
                }
                else{
                    def.resolve("");
                }
            })
            return def.promise();
        }

        _self.getMatchToken = function(){
            var def = $.Deferred();
            if(_self.matchCode){
                def.resolve(_self.matchCode);
            }
            else{
                if(_isU){
                  //返回U盘Token
                  //  var md5helper = require('../common/md5helper');
                  //  _self.matchCode = _curUser.getName() + md5helper.hex_md5(_isU + _curUser.getName());
                    def.resolve(_self._curUser.getName() + _isU);
                }
                else{
                    _self._curUser.getUserToken().done(function(ret){
                        _self.matchCode = ret;
                        def.resolve(ret);
                    })
                }
            }
            return def.promise();
        }

        _self.createUuid=function(){
            var s = [];
            var hexDigits = "0123456789abcdef";
            for (var i = 0; i < 36; i++) {
                s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
            }
            s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
            s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
            s[8] = s[13] = s[18] = s[23] = "";

            var uuid = s.join("");
            return uuid;
        }

    }

    exports.Instance = new EBookContext();
});

