/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-5-13
 * Time: 下午3:59
 * description : 语言切换模块
 */

/**********************************************
 *
 * 这一模块是为了做语言切换，暂时废弃。
 *          ---- by yczhu 2014-07-17
 **********************************************/

define(function(require,exports){
    var path = require('../../common/path.js');

    function ChangeLangModel(){
        var _self = this;
        _self.domObj = {};
        _self.currentLang = "" ;
        _self.newLang = "";
    }

    /**
     * 初始化控件
     */
    ChangeLangModel.prototype.init = function(domObj){
        var _self = this;
        _self.domObj = domObj;
        _self.currentLang = AppCfg.lang ;

        AppCfg.lang == "zhcn" ? (_self.domObj.changeZhcn[0].checked = true):(_self.domObj.changeUyghur[0].checked = true) ;

        _self.domObj.changeZhcn.click(function(){
            _self.getNewLang("zhcn");
            if(_self.newLang != _self.currentLang){
                _self.alertChangeInfo();
            }
        });

        _self.domObj.changeUyghur.click(function(){
            _self.getNewLang("uyghur");
            if(_self.newLang != _self.currentLang){
                _self.alertChangeInfo();
            }
        });

    }

    /**
     * 获取用户输入
     */
    ChangeLangModel.prototype.getNewLang = function(langStr){
        var _self = this;
        _self.newLang = langStr;
    }

    /**
     * 用户确认提示
     */
    ChangeLangModel.prototype.alertChangeInfo = function(){
        var _self = this;
        var _tips = AppTips.changeLang;
        $.Zebra_Dialog(_tips, {
            'type': 'question',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.CancelTips,AppTips.OkTips],
            'onClose' : function(capition){
                if (capition == AppTips.OkTips) {
                    _self.setNewLang();
                }
                else{
                    _self.currentLang == "zhcn" ? (_self.domObj.changeZhcn[0].checked = true):(_self.domObj.changeUyghur[0].checked = true) ;
                }
            }
        });

    }

    /**
     * 设置新语言
     */
    ChangeLangModel.prototype.setNewLang = function(){
        var _self = this;
        var _shellcmd = require("../../common/shellcmd.js");
        var _AppCfgPath =  path.join(path.trimPosix(Config.binPath), 'webapp/assert/js/AppCfg.js');
        //读取AppCfg.js文件
        _shellcmd.readFileAsync(_AppCfgPath).done(function(retString){
            retString = _self.currentLang == "uyghur" ? retString.replace(/lang:"uyghur"/g,'lang:"zhcn"') : retString.replace(/lang:"zhcn"/g,'lang:"uyghur"');
            //写回
            _shellcmd.saveFilAsync(retString,_AppCfgPath).done(function(){
                //刷新页面
                history.go(0);
            });
        });
    }

    exports.Instance = new ChangeLangModel();
});
