/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-21
 * Time: 下午1:56
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var _path = require('../../common/path');
    var result = require("./loginhelper").Result;
    var shellcmd = require("../../common/shellcmd");
    var ebookContext = require('../ebookcontext').Instance;
    var _loginAssistor = require('./loginAssistor');

    function CloudLogin() {

    }

    CloudLogin.prototype.beforeCheckInfo = function (account, pwd) {
        var _self = this;
        var def = $.Deferred();
        // ebookContext.getClientToken().done(function (ret) {
        //     var logfile = _path.trimPosix(_path.join(Config.binPath, "/log/userfold.log"));
        //     var con = "getLoginToken ret :: " + ret + "----" + new Date() + "========";
        //     //添加日志文件
        //     shellcmd.savefileappent(con, logfile).done(function () {
        //         if (ret) {
        //             _self.checkInfo(account, pwd).done(function (ret_1) {
        //                 def.resolve(ret_1);
        //             });
        //         }
        //         else {
        //             console.log('clientToken get failure');
        //             def.resolve(result.CloudResult.webError);
        //         }
        //     });
        // });

        var ret = "notNeedAccessToken";
        var logfile = _path.trimPosix(_path.join(Config.binPath, "/log/userfold.log"));
        var con = "getLoginToken ret :: " + ret + "----" + new Date() + "========";
        //添加日志文件
        shellcmd.savefileappent(con, logfile).done(function () {
            if (ret) {
                _self.checkInfo(account, pwd).done(function (ret_1) {
                    def.resolve(ret_1);
                }).fail(function(errCode){
                    def.reject(errCode);
                });
            }
            else {
                console.log('clientToken get failure');
                def.resolve(result.CloudResult.webError);
            }
        });
        return def.promise();
    }

    CloudLogin.prototype.checkInfo = function (account, pwd) {
        var def = $.Deferred();
        var _self = this;
        _self.ssoCheckCloudInfo(account, pwd).done(function (ret1) {

            var logfile = _path.trimPosix(_path.join(Config.binPath, "/log/userfold.log"));
            var con = "checkCloudInfo :: " + ret1 + "----" + new Date();
            //添加日志文件
            shellcmd.savefileappent(con, logfile).done(function () {
                if (ret1 === result.CloudResult.accountPwdRight) {
                    //账号存在
                    _self.checkEshopInfo(ebookContext.getUser().getName(), pwd).done(function (ret2) {
                        con = "checkEshopInfo :: " + ret2 + "----" + new Date();
                        //添加日志文件
                        shellcmd.savefileappent(con, logfile).done(function () {
                            if (ret2 === result.CloudResult.isNormal) {
                                var curUser = ebookContext.getUser();
                                //可用
                                var userInfo = {
                                    userAccount: curUser.getName(),
                                    userEmail: curUser.getEmail(),
                                    userPhone: curUser.getPhoneNum(),
                                    isActive: curUser.getIsActive(),
                                    userName: curUser.getUserName()
                                }
                                shellcmd.desEncrpty(pwd, curUser.getName()).done(function (passwordData) {
                                    _loginAssistor.addUserToLocalDb(userInfo, passwordData, 1).done(function () {
                                        _self.checkBindInfo(ebookContext.getUser().getName(), pwd).done(function (ret3) {
                                            con = "checkEshopInfo :: " + ret3 + "----" + new Date();
                                            //添加日志文件
                                            shellcmd.savefileappent(con, logfile).done(function () {
                                                def.resolve(ret3);
                                            });
                                        });
                                    });
                                });
                            }else if(ret2 === result.CloudResult.isDele){
                                def.reject(result.CloudResult.isDele);
                            }else if(ret2 === result.CloudResult.isOutDate){
                                def.reject(result.CloudResult.isOutDate);
                            }else if(ret2 === result.CloudResult.autoAccountForbidden){
                                def.reject(result.CloudResult.autoAccountForbidden);
                            }
                            else {
                                def.resolve(ret2);
                            }
                        });
                    });
                }
                else {
                    def.resolve(ret1);
                }
            });

        });
        return def.promise();
    }

    // 该方法废弃（采用sso登录） -xinfang3 201609
    CloudLogin.prototype.checkCloudInfo = function (account, pwd) {
        var def = $.Deferred();
        // 发送至Cloud验证
        var httpurl = AppRemoteSvcCfg.checkAccount + "&access_token=" + app_ClientToken + "&key=loginName&value=" + account + "&password=" + pwd;
        shellcmd.getHttpRequest(httpurl).done(function (ret1) {
            console.log(ret1);
            if (ret1) {
                var ret1Obj = ret1;
                var res = (ret1Obj.statusCode === 1) ? result.CloudResult.accountPwdRight : result.CloudResult.accountOrPwdWrong;
                if (ret1Obj.statusCode === 1) {
                    ebookContext.setBinPath(Config.binPath);
                    ebookContext.setUser(ret1Obj.userInfo.loginName, pwd);
                    ebookContext.setUserRole(ret1Obj.userInfo.enName);
                    //这里要获取用户appname
                    ebookContext.setUserAppName("");
                    ebookContext.setUserBaseInfo(ret1Obj.userInfo.id, ret1Obj.userInfo.email,
                        ret1Obj.userInfo.mobile, ret1Obj.userInfo.userName);
                    ret1Obj.userInfo.userExt && ebookContext.getUser().setProvince(ret1Obj.userInfo.userExt.provinceName);
                }
                if(AppCfg.isBBT || AppCfg.disableStudent){
                    if(ret1Obj.userInfo && ret1Obj.userInfo.enName && ret1Obj.userInfo.enName != "teacher"){
                        def.resolve(result.CloudResult.roleError);
                    }
                }
            }
            def.resolve(ret1 ? res : result.CloudResult.webError);
        });
        return def.promise();
    }

    CloudLogin.prototype.ssoCheckCloudInfo = function (account, pwd) {
        var def = $.Deferred();
        var _self = this;
        // 发送至sso验证
        SSO.appName = Edc_Cfg.EDC_appName;
        SSO.appKey = Edc_Cfg.EDC_appKey;
        SSO.SSOServerUrl = Edc_Cfg.EDC_SSOServerUrl;
        SSO.client = Edc_Cfg.EDC_client;
        SSO.isCenterSSO = Edc_Cfg.EDC_isCenterSSO;
        SSO.loginRedirectUrl = Edc_Cfg.EDC_loginRedirectUrl;
        SSO.needAttribute = Edc_Cfg.EDC_needAttribute;
        var account = account;
        var password = pwd;
        SSO.login(account,password,function(ret) {
            console.log(ret);
            if(ret && ret.result && ret.result.toLowerCase() == 'success' && ret.code == "1001" && ret.data && ret.data.st){
                var ticket = ret.data.st;
                var tgt = ret.data.tgt;
                SSO.validateServiceTicket(ticket,SSO.loginRedirectUrl,function(validateST) {
                    if(validateST && validateST.code == 1){
                        var loginName = validateST.data && validateST.data.attributes && validateST.data.attributes.loginName;
                        var userId = validateST.data && validateST.data.attributes && validateST.data.attributes.userId;
                        var openId = validateST.data && validateST.data.openId;
                        //对用户信息进行加密
                        var encryptedInfo = _self.setEncryptedUserInfo(loginName,password);
                        //加密的用户信息 --edc接口设置用户级别授权
                        encryptedInfo.sso_openId = openId;
                        edcService.Instance().setEncryptedUserInfo(encryptedInfo);

                        if(false){
                            var bindParam = {
                                openId: openId,
                                productId: 'p_ta',
                                userQuery: true
                            };
                            _self.accountExchange(bindParam).done(function(exchangeArr){
                                var exchange = exchangeArr[0] || {};
                                var exchangeOpenId = exchange.id || '';
                                var rs = {
                                    loginName: loginName || '',
                                    userId: userId || '',
                                    openId: openId || '',
                                    exchangeOpenId: exchangeOpenId || '',
                                    tgt: tgt || '',
                                    st: ticket || '',
                                    des_encrypted_userInfo: encryptedInfo.des_encrypted_userInfo || '',
                                    rsa_encrypted_password: encryptedInfo.rsa_encrypted_password || ''
                                };
                                var sso_userInfo = {
                                    "sso_loginName": loginName,
                                    "sso_userId": userId,
                                    "sso_openId": openId,
                                    "exchange_openId": exchangeOpenId,
                                    "sso_tgt": tgt,
                                    "des_encrypted_userInfo": encryptedInfo.des_encrypted_userInfo,
                                    "rsa_encrypted_password": encryptedInfo.rsa_encrypted_password
                                };
                                _self.ssoDataTranslate(sso_userInfo).done(function (ret) {
                                    var ret1Obj = ret;
                                    ebookContext.setBinPath(Config.binPath);
                                    ebookContext.setUser(ret1Obj.userInfo.loginName, pwd);
                                    ebookContext.setUserRole(ret1Obj.userInfo.enName);
                                    ebookContext.setUserAppName(ret1Obj.userInfo._user_userAppName);
                                    ebookContext.setUserBaseInfo(ret1Obj.userInfo.id, ret1Obj.userInfo.email, ret1Obj.userInfo.mobile, ret1Obj.userInfo.userName);
                                    ret1Obj.userInfo.userExt && ebookContext.getUser().setProvince(ret1Obj.userInfo.userExt.provinceName);
                                    if(AppCfg.isBBT || AppCfg.disableStudent){
                                        if(ret1Obj.userInfo && ret1Obj.userInfo.enName != "teacher"){
                                            def.resolve(result.CloudResult.roleError);
                                        }
                                    }
                                    def.resolve(result.CloudResult.accountPwdRight);
                                }).fail(function (e) {
                                    console.error(e);
                                    def.resolve(result.CloudResult.webError);
                                });
                            }).fail(function(e){
                                console.log(e);
                                // 畅言通行证获取失败，则按sso返回信息来进行登录
                                var sso_userInfo = {
                                    "sso_loginName": loginName,
                                    "sso_userId": userId,
                                    "sso_openId": openId,
                                    "exchange_openId": '',
                                    "sso_tgt": tgt,
                                    "des_encrypted_userInfo": encryptedInfo.des_encrypted_userInfo,
                                    "rsa_encrypted_password": encryptedInfo.rsa_encrypted_password
                                };
                                _self.ssoDataTranslate(sso_userInfo).done(function(ret){
                                    var ret1Obj = ret;
                                    ebookContext.setBinPath(Config.binPath);
                                    ebookContext.setUser(ret1Obj.userInfo.loginName, pwd);
                                    ebookContext.setUserRole(ret1Obj.userInfo.enName);
                                    ebookContext.setUserAppName(ret1Obj.userInfo._user_userAppName);
                                    ebookContext.setUserBaseInfo(ret1Obj.userInfo.id, ret1Obj.userInfo.email,ret1Obj.userInfo.mobile, ret1Obj.userInfo.userName);
                                    ret1Obj.userInfo.userExt && ebookContext.getUser().setProvince(ret1Obj.userInfo.userExt.provinceName);
                                    if(AppCfg.isBBT || AppCfg.disableStudent){
                                        if(ret1Obj.userInfo && ret1Obj.userInfo.enName != "teacher"){
                                            def.resolve(result.CloudResult.roleError);
                                        }
                                    }
                                    def.resolve(result.CloudResult.accountPwdRight);
                                }).fail(function(e){
                                    console.error(e);
                                    def.resolve(result.CloudResult.webError);
                                });
                            });
                        }else{
                            var sso_userInfo = {
                                "sso_loginName": loginName,
                                "sso_userId": userId,
                                "sso_openId": openId,
                                "exchange_openId": '',
                                "sso_tgt": tgt,
                                "des_encrypted_userInfo": encryptedInfo.des_encrypted_userInfo,
                                "rsa_encrypted_password": encryptedInfo.rsa_encrypted_password
                            };
                            _self.ssoDataTranslate(sso_userInfo).done(function(ret){
                                var ret1Obj = ret;
                                ebookContext.setBinPath(Config.binPath);
                                ebookContext.setUser(ret1Obj.userInfo.loginName, pwd);
                                ebookContext.setUserRole(ret1Obj.userInfo.enName);
                                ebookContext.setUserAppName(ret1Obj.userInfo._user_userAppName);
                                ebookContext.setUserBaseInfo(ret1Obj.userInfo.id, ret1Obj.userInfo.email,ret1Obj.userInfo.mobile, ret1Obj.userInfo.userName);
                                ret1Obj.userInfo.userExt && ebookContext.getUser().setProvince(ret1Obj.userInfo.userExt.provinceName);
                                if(AppCfg.isBBT || AppCfg.disableStudent){
                                    if(ret1Obj.userInfo && ret1Obj.userInfo.enName != "teacher"){
                                        def.resolve(result.CloudResult.roleError);
                                    }
                                }
                                def.resolve(result.CloudResult.accountPwdRight);
                            }).fail(function(e){
                                console.error(e);
                                def.resolve(result.CloudResult.webError);
                            });
                        }
                    }else{
                        def.resolve(result.CloudResult.autoSSOValidateError);
                    }
                });
            }else{
                /**
                 * 1000 success <1001>
                 * 1002 您提供的凭证有误。
                 * 2002 您登陆尝试次数过多，请{0}分钟后再试
                 * 2003 账号被冻结
                 * 2007 登录超时
                 * 2008 TGT已经过期或者不存在
                 * 2009 用户不存在<同1002>
                 */
                if (ret && ret.result == "fail" && ret.code) {
                    var errCode = ret.code + '';
                    switch(errCode){
                        case '1002':
                        case '2009':
                            def.resolve(result.CloudResult.accountOrPwdWrong);
                            break;
                        case '2002':
                        case '2007':
                            def.resolve(result.CloudResult.autoSSOValidateError);
                            break;
                        case '2003':
                            def.resolve(result.CloudResult.autoAccountForbidden);
                            break;
                        case '2008':
                            def.resolve(result.CloudResult.autoSSOValidateError);
                            break;
                        default:
                            // 对于异常信息，目前sso暂未提供完善、完整的状态码说明，这里暂根据返回的result.data做一些优化处理。
                            var fail_tips = result.data;
                            // 处理 '未能够识别出目标','???','登录失败，出现异常！'异常
                            if(-1 == fail_tips.indexOf("未能够识别出目标") && -1 == fail_tips.indexOf("???") && -1 == fail_tips.indexOf("异常")) {
                                // 使用默认提示语
                                def.resolve(result.CloudResult.autoSSOValidateError);
                            }else{
                                def.resolve(result.CloudResult.autoSSOValidateError);
                            }
                    }
                }else{
                    def.resolve(result.CloudResult.autoSSOValidateError);
                }
            }
        });
        return def.promise();
    }

    /**
     * 畅言通信证2.0校验
     */
    CloudLogin.prototype.accountExchange = function(param){
        var _self = this;
        var def = $.Deferred();
        if(-1 == Easy_Cfg.EASYSVC.indexOf('test')){
            // 生产
            console.warn('生产环境下，请将畅言通行证接口开放，目前原路返回用户openId：%s',param.openId);
            def.resolve({
                code: 0,
                data: [{id:param.openid}]
            });
        }else{
            // 测试
            edcService.Instance().core_usercenter_account_get_by_product(param).done(function(ret){
                if(ret && ret.code == 0 && ret.data && $.isArray(ret.data)){
                    var accountList = ret.data || [];
                    if(accountList.length > 0){
                        def.resolve(accountList);
                    }else{
                        def.reject([]);
                    }
                }else{
                    def.reject(ret);
                }
            }).fail(function(e){
                console.log(e);
                def.reject(e);
            });
        }
        return def.promise();
    }

    /**
     * 设置用户加密信息（包括des加密和rsa密码加密）
     * @param loginName,password
     * @returns {*}
     */
    CloudLogin.prototype.setEncryptedUserInfo = function(loginName,password){
        var _self = this;
        //将用户信息DES(key,loginName=password)加密存储到全局des_encrypted_userInfo --用于单点登录
        var plain_userInfo = loginName + '=' + password;
        var des_key = '';
        if(typeof TA != 'undefined' && $.isPlainObject(TA) && TA.UserService && TA.UserService.key){
            des_key = TA.UserService.key;
        }else{
            des_key = 'wyc4yrmK';
        }
        DES.init(des_key, plain_userInfo);
        var des_encrypted_userInfo = DES.Encrypt();

        //将用户明文密码RSA(key,password)加密存储到rsa_encrypted_password -- 用于用户级别授权接口
        //这里的RSA算法和sso登录的RSA算法一致，（n,e）
        var exponent = Edc_Cfg.EDC_SSORSAExponent;
        var modulus = Edc_Cfg.EDC_SSORSAModulus;
        var key = RSAUtils.getKeyPair(exponent, "", modulus);
        var rsa_encrypted_password = RSAUtils.encryptedString(key, password);
        return {loginName:loginName,des_encrypted_userInfo:des_encrypted_userInfo,rsa_encrypted_password:rsa_encrypted_password};
    }

    CloudLogin.prototype.ssoDataTranslate = function(sso_userInfo){
        var _self = this;
        var def = jQuery.Deferred();
        var result = {};
        var sso_userInfo = sso_userInfo;
        var sso_loginName = sso_userInfo.sso_loginName;
        var sso_userId = sso_userInfo.sso_userId;
        var sso_openId = sso_userInfo.sso_openId;
        // sso_userInfo.exchange_openId 是查询用户绑定接口得到的绑定用户openId
        var exchange_openId = sso_userInfo.exchange_openId;
        var sso_tgt = sso_userInfo.sso_tgt;
        var _openId = (exchange_openId != '') ? exchange_openId : sso_openId,
            _user_info = "",
            _user_type = "",
            _user_school = "",
            _user_freeClass = "",
            _user_orgClass = "",
            _user_org_detail = "";
        var param_user_type_get = {
            userId:_openId
        };
        edcService.Instance().core_user_type_get(param_user_type_get).done(function(ret){
            if(ret.code == 0){
                _user_type = ret.data;
                var param_core_user_org_detail = {
                    openId: sso_openId,
                    userId: _openId
                };
                edcService.Instance().core_user_org_detail(param_core_user_org_detail).done(function(ret){
                    if(ret.code == 0){
                        _user_org_detail = ret.data;
                        _user_school = _user_org_detail.extInfo.school;
                        _user_freeClass = _user_org_detail.extInfo.freeClass;
                        _user_orgClass = _user_org_detail.extInfo.orgClass;
                        var userData = {
                            sso_userInfo:sso_userInfo,
                            user_info:_user_org_detail,
                            user_type:_user_type,
                            user_school:_user_school,
                            user_freeClass:_user_freeClass,
                            user_orgClass:_user_orgClass
                        };
                        result = _self.format_core_user_data(userData);
                        def.resolve(result);
                    }else{
                        def.reject(e);
                    }
                }).fail(function(e){
                    def.reject(e);
                });
            }else{
                console.log(ret);
                def.reject(e);
            }
        }).fail(function(e){
            def.reject(e);
        });
        return def.promise();
    }

    CloudLogin.prototype.format_core_user_data = function(userData) {
        var _self = this;
        var sso_userInfo = userData.sso_userInfo || {};
        var user_info = userData.user_info || {};
        var user_type_arr = userData.user_type || [];
        var _user_school_list_arr = userData.user_school || [];
        var _user_freeClass_list_arr = userData.user_freeClass || [];
        var _user_orgClass_list_arr = userData.user_orgClass || [];
        //示例结构
        var result = {
            statusCode:1,
            userInfo:{
                userExt:{},
                userPhotoSize:{},
                classInfo:[],
                freeClass:[]
            }
        };
        var enName = "";
        //用户身份类型，001机构用户，002行政教师用户，003行政学生用户，004家长用户，005自由老师，006自由学生
        if (Object.prototype.toString.apply(user_type_arr) === '[object Array]') {
            //用户身份为空，默认允许登录
            if(user_type_arr.length == 0){
                enName = "teacher";
            }else{
                var _teacher_type_arr = user_type_arr.filter(function(el){
                    return el.code == '005' || el.code == '002';
                });
                if(_teacher_type_arr.length > 0){
                    enName = "teacher";
                }
            }
        }
        result.userInfo = {
            "id": sso_userInfo.sso_userId,
            "_sso_loginName": sso_userInfo.sso_loginName,
            "_sso_openId": sso_userInfo.sso_openId,
            "_sso_userId": sso_userInfo.sso_userId,
            "_sso_tgt": sso_userInfo.sso_tgt,
            "des_encrypted_userInfo": sso_userInfo.des_encrypted_userInfo,
            "rsa_encrypted_password": sso_userInfo.rsa_encrypted_password,
            "_user_openId": user_info.id,
            "_user_userType": user_type_arr,
            "_user_userAppName": user_info.appName,
            "_user_exchange_openId": sso_userInfo.exchange_openId,
            "delFlag": "", //--
            "loginName": user_info.loginName,
            "email": user_info.loginEmail,
            "mobile": user_info.loginMobile,
            "userCode": null, //--
            "userName": user_info.userName,
            "gender": user_info.gender,
            "phone": user_info.displayMobile, //--
            "pinyinName": user_info.pinyinName,
            "birthDate": user_info.birthDate,
            "im": user_info.im,
            "homeAddress": user_info.homeAddr,
            "idCardNo": user_info.idCardNo,
            "remark": "", //--
            "appName": "", //--
            "creator": "", //--
            "createTime": "", //--
            "modificator": "", //--
            "updateTime": "", //--
            "grade": "",//--
            "subject": "",//--
            "enName": enName,
            "userPhoto": user_info.userPhoto,
            "avatar": user_info.userPhoto,
            "loginCount": user_info.loginCount,
            "userExt":{},
            "userPhotoSize":{},
            //老的userInfo里只存储了行政班级的班级列表，不存储自由班级列表，这里沿用以前数据结构
            "classInfo":[],
            "freeClass":[] //自由班级
        };
        result.userInfo.userPhotoSize = user_info.userPhotoSize || {};
        //判断用户是否有学校
        if(_user_school_list_arr.length > 0) {
            var userExt = _user_school_list_arr[0];
            result.userInfo.userExt = {
                "schoolName": userExt.schoolName,
                "schooldCode": userExt.id,
                "province": "",//--
                "city": "",//--
                "district": "",//--
                "provinceName": userExt.provinceName,
                "cityName": userExt.cityName,
                "districtName": userExt.districtName,
                "provinceId": userExt.provinceId,
                "cityId": userExt.cityId,
                "districtId": userExt.districtId
            };
        }else{
            result.userInfo.userExt = {};
        }
        for(i = 0,count = _user_orgClass_list_arr.length;i < count;i++){
            var item = _user_orgClass_list_arr[i];
            var rs = {
                "classCode" : item.classShortId || "",
                "classShortId" :item && item.classShortId  || "",
                "classId" : item.id || "",
                "className" : item.className || "",
                "shortName" : item.shortName || "",
                "eduSystem" : item.eduSystem || "",
                "classLabel" : item.classLabel || "",
                "classOrder" : item.classOrder || "",
                "passed" : item.passed || "",
                "createTime" : "undefined",
                "phase" : item.phase || "",
                "schoolId" : item.schoolId || "",
                "schoolName" : "undefined",
                "studentCount" : "undefined",
                "subject" : "undefined",
                "subjectName" : "undefined",
                "year" : item.year || "",
                "extInfo" : item.extInfo || ""
            };
            result.userInfo.classInfo.push(rs);
        }
        //这里对自由班级做格式化处理，是为了在后期班级合并展示时避免兼容性问题
        for(i = 0,count = _user_freeClass_list_arr.length;i < count;i++){
            var item = _user_freeClass_list_arr[i];
            var rs = {
                "classCode" : item.classShortId || "undefined",
                "classShortId" :item.classShortId || "",
                "classId" : item.id || "",
                "className" : item.className || "",
                "shortName" : "undefined",
                "eduSystem" : "undefined",
                "classLabel" : "undefined",
                "classOrder" : "undefined",
                "passed" : "undefined",
                "createTime" : "undefined",
                "grade" : item.grade || "",
                "phase" : item.phase || "",
                "schoolId" : item.schoolId || "",
                "schoolName" : "undefined",
                "studentCount" : "undefined",
                "subject" : "undefined",
                "subjectName" : "undefined",
                "year" :item.year || "",
                "extInfo" :item.extInfo || ""
            };
            result.userInfo.freeClass.push(rs);
        }
        return result;
    }

    CloudLogin.prototype.checkEshopInfo = function (account, pwd) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.isActive;
        var msgJson = {
            url: httpurl,
            loginName: account
        };
        shellcmd.postHttpRequest(msgJson).done(function (ret) {
            var retObj , _res;
            ret && (retObj = JSON.parse(ret));
            console.log(retObj ? retObj : ret);
            //返回[],新账号
            if (retObj instanceof Array && retObj.length == 0) {
                if (ebookContext.getUser().getPhoneNum()) {
                    ebookContext.getUser().setIsActive(true);
                }
                def.resolve(result.CloudResult.isNormal);
            }
            else if(retObj) {
                //返回对象，有值
                _res = retObj.isDelete === 1 ? result.CloudResult.isDele : result.CloudResult.isNormal;
                var nowDate = new Date();
                var retDate = Date.parse(retObj.outDate);
                _res = (nowDate < retDate ) ? _res : result.CloudResult.isOutDate;
                ebookContext.getUser().setIsActive(!!(retObj.isActive == 1));
//                if (ebookContext.getUser().getPhoneNum()) {
//                    ebookContext.getUser().setIsActive(true);
//                }
            }
            //返回 "" 字符串
            def.resolve(ret ? _res : result.CloudResult.webError);
        });
        return def.promise();
    }

    CloudLogin.prototype.checkBindInfo = function (account, pwd) {
        var def = $.Deferred();
        var getHdTypeTask = shellcmd.getHardwareType();
        var getHdInfoTask = shellcmd.getHardwareInfo(account);
        var hdNameTask = shellcmd.getHardwareName();
        $.when(getHdTypeTask, getHdInfoTask, hdNameTask).done(function (hdType, hdInfo, hdName) {
            var httpurl = AppRemoteSvcCfg.checkBindandBind;
            var msgJson = {
                url: httpurl,
                account: account,
                hardware: hdInfo,
                machinename: hdName,
                hdtype: hdType,
                password: pwd
            };
            shellcmd.postHttpRequest(msgJson).done(function (ret) {
                var retResult = null;
                console.log(ret);
                var retObj = JSON.parse(ret);
                switch (parseInt(retObj.statuscode)) {
                    case 0:
                        retObj.userLoginName && (ebookContext.getUser().setUserLoginName(retObj.userLoginName));
                        retObj.userFrom && (ebookContext.getUser().setLoginFrom(retObj.userFrom));
                        retObj.ticket && (ebookContext.getUser().setSSOTicket(retObj.ticket));
                        retObj.provinceName && (ebookContext.getUser().setProvince(retObj.provinceName));
                        if (retObj.bindcode == 0) retResult = result.CloudResult.bindSuccess;
                        if (retObj.bindcode == 1) retResult = result.CloudResult.bindFail;
                        break;
                    case 1:
                        retResult = result.CloudResult.canNotBind;
                        break;
                    case 2:
                        retResult = result.CloudResult.alreadyBind;
                        retObj.userLoginName && (ebookContext.getUser().setUserLoginName(retObj.userLoginName));
                        retObj.userFrom && (ebookContext.getUser().setLoginFrom(retObj.userFrom));
                        retObj.ticket && (ebookContext.getUser().setSSOTicket(retObj.ticket));
                        retObj.provinceName && (ebookContext.getUser().setProvince(retObj.provinceName));
                        break;
                    case 3:
                        retResult = result.CloudResult.getBindMsgError;
                        break;
                }
                def.resolve(ret ? retResult : result.CloudResult.webError);
            });
        });
        return def.promise();
    }

    exports.CloudLogin = CloudLogin;
});
