/**
 * Created with JetBrains WebStorm.
 * User: CHANG Weijun
 * Date: 13-7-31
 * Time: 下午4:41
 * To change this template use File | Settings | File Templates.
 *
 * 用于用户信息本地数据库访问。封装了对iflybook.db的 users 表的操作
 */

/**
 * Caution :
 * 这里大约有一半的代码是废代码。
 * 您可以看到许多 if(AppCfg.useWebDB){....}else{....}的代码
 * 愿因是 : 在最初写下这些代码的时候，Html5的本地数据库技术相当火热。
 * 可惜，那个时候，它还不成熟，相当不稳定。
 * else{...}模块里面的代码用的是sqlite数据库，就是user目录下的.db文件
 * 如果您接手时，Html5技术已经相当成熟，可以考虑修改一下。
 *
 *              ------------  by yczhu
 */

define(function (require, exports) {
    var path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');

    var dbPath = path.trimPosix(Config.binPath) + "iflybook.db";

    var dataBase = {};

    function init() {
        creatTable();
    }

    function creatTable() {
        if (AppCfg.useWebDB) {
            dataBase = openDatabase("iflybook", "1.0", "user", 1024 * 1024, function () {
            });
            if (!dataBase) {
            } else {
                dataBase.transaction(function (tx) {
                    tx.executeSql(
                        "create table if not exists users " +
                            "(account VARCHAR(20), email VARCHAR(50),phone VARCHAR(20),password VARCHAR(50),IsRememberPasswordOrNot BOOL,lastLoginTime DATETIME,headImg VARCHAR(100))",
                        [],
                        function (tx, result) {
                        },
                        function (tx, error) {
                        })
                });
            }
        }
    }

    function loadAccountList() {
        if (AppCfg.useWebDB) {
            var def = $.Deferred();
            init();
            dataBase.transaction(function (tx) {
                tx.executeSql(
                    "select account from users order by lastLoginTime desc ", [],
                    function (tx, result) {  //执行成功的回调函数
                        var dataJson = '{ "data" :[ ';
                        for (var i = 0; i < result.rows.length; i++) {
                            dataJson += '{"account":"' + result.rows.item(i)['account'] + '"}';
                            if (i != result.rows.length - 1) {
                                dataJson += ',';
                            }
                        }
                        dataJson += ']}';
                        console.log(dataJson);
                        def.resolve(dataJson);
                    },
                    function (tx, error) {
                    });
            });
            return def.promise();
        }
        else {
            var sqlStr = 'select account from users order by lastLoginTime desc limit 10';
            return _shellcmd.retriveDbAsyn(dbPath, sqlStr);
        }
    }

    /**
     * 删除超过10个的用户
     */
    function deleteMoreAccount() {
        var sqlStr = 'delete from users where account not in (select account from users order by lastLoginTime desc limit 10)';
        _shellcmd.retriveDbAsyn(dbPath, sqlStr);
    }

    function getAccount(inputinfo) {
        var def = $.Deferred();
        if (AppCfg.useWebDB) {
            dataBase.transaction(function (tx) {
                tx.executeSql(
                    "select account from users where account= ? or email= ? or phone= ? ", [inputinfo, inputinfo, inputinfo],
                    function (tx, result) {  //执行成功的回调函数
                        var dataJson = '{ "data" :[ ';
                        for (var i = 0; i < result.rows.length; i++) {
                            dataJson += '{"account":"' + result.rows.item(i)['account'] + '"}';
                            if (i != result.rows.length - 1) {
                                dataJson += ',';
                            }
                        }
                        dataJson += ']}';
                        var dataObj = JSON.parse(dataJson);
                        console.log(dataObj.data);
                        def.resolve(dataObj.data);
                    },
                    function (tx, error) {
                    });
            });
        }
        else {
            var sqlStr = 'select account from users where account="' + inputinfo +
                '" or email="' + inputinfo + '" or phone="' + inputinfo + '"';
            _shellcmd.getFirstItemAsyn(dbPath, sqlStr).done(function (account) {
                def.resolve(account);
            });
        }

        return def.promise();
    }

    function addAccount(account, email, phone, password, rememberPasswordFlag,isActive,userName) {
        var def = $.Deferred();
        var _nowDate = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
        if (AppCfg.useWebDB) {
            //TODO：嘿！这里没有维护！
            dataBase.transaction(function (tx) {
                tx.executeSql(
                    'insert into users(account,email,phone,password,IsRememberPasswordOrNot,lastLoginTime) values(?,?,?,?,?,?)',
                    [account, email, phone, password, rememberPasswordFlag, _nowDate],
                    function () {
                        def.resolve();
                    },
                    function (tx, error) {
                    });
            });
        }
        else {//isActiveDelete
            var sqlStr = 'insert into users(account,email,phone,password,IsRememberPasswordOrNot,isActive,lastLoginTime,reserve1) values("'
                + account + '","' + email + '","' + phone + '","' + password + '","' + rememberPasswordFlag +
                '","' + isActive + '","' + _nowDate + '","' + userName + '")';
            _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                def.resolve(ret);
            })
        }
        return def.promise();
    }

    function updateAccount(account, email, phone, password, rememberPasswordFlag,isActive,userName) {
        var def = $.Deferred();
        var _nowDate = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
        if (AppCfg.useWebDB) {
            //TODO : 嘿！这里没有维护！
            dataBase.transaction(function (tx) {
                tx.executeSql(
                    "update  users  set  email=  ? , phone= ? , password= ? ,IsRememberPasswordOrNOt= ? , lastLoginTime= ?  where account= ?",
                    [ email, phone, password, rememberPasswordFlag, _nowDate, account],
                    function (tx) {
                        def.resolve(tx);
                    },
                    function (tx, error) {
                    });
            });
        }
        else {
            var sqlStr = 'update users set ';
            email && (sqlStr += 'email="' + email + '",');
            phone && (sqlStr += 'phone="' + phone + '",');
            password && (sqlStr += 'password="' + password + '", ');
            isActive && (sqlStr += 'isActive="' + isActive + '", ');
            userName && (sqlStr += 'reserve1="' + userName + '", ');

            sqlStr += 'IsRememberPasswordOrNOt="' + rememberPasswordFlag + '", ' +
                'lastLoginTime="' + _nowDate + '"  ' +
                'where account="' + account + '"';

            _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                def.resolve(ret);
            })
        }

        return def.promise();
    }

    function deleteAccount(account) {
        var def = $.Deferred();
        var sqlStr = "delete from users where account = '" + account + "'or email= '" + account + "' or phone='" + account + "'";
        _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    function getPhoneNum(account) {
        var def = $.Deferred();
        var sqlStr = "select phone from users where account= '" + account + "'";
        console.log(sqlStr);
        _shellcmd.retriveDbAsyn(dbPath, sqlStr).done(function (ret) {
            def.resolve(ret);
        })
        return def.promise();
    }

    function getUserInfo(account){
        var def = $.Deferred();
        var sqlStr = "select * from users where account= '" + account + "'";
        console.log(sqlStr);
        _shellcmd.retriveDbAsyn(dbPath, sqlStr).done(function (ret) {
            def.resolve(ret);
        })
        return def.promise();
    }

    /**
     * 获取最后一次登录的用户信息
     */
    function getLastLoginUser() {
        var defer = $.Deferred();
        if (AppCfg.useWebDB) {
            var sqlStr = 'select * from users where lastLoginTime = (select Max(lastLoginTime) from users)';
            dataBase.transaction(function (tx) {
                tx.executeSql(
                    "select * from users where lastLoginTime = (select Max(lastLoginTime) from users) ", [],
                    function (tx, result) {  //执行成功的回调函数
                        var lastLoginUser = {};
                        if (result.rows.length > 0) {
                            lastLoginUser.password = result.rows.item(0)['password'];
                            lastLoginUser.account = result.rows.item(0)['account'];
                            lastLoginUser.IsRememberPasswordOrNOt = result.rows.item(0)['IsRememberPasswordOrNot'];
                            lastLoginUser.lastLoginTime = result.rows.item(0)['lastLoginTime'];
                            console.log(lastLoginUser);
                        }
                        defer.resolve(lastLoginUser);
                    },
                    function (tx, error) {
                    });
            });
        }
        else {
		
            var sqlStr = 'select * from users where lastLoginTime = (select Max(lastLoginTime) from users)';
			
			console.log(dbPath, sqlStr);
            var accountListTask = _shellcmd.retriveDbAsyn(dbPath, sqlStr);
            accountListTask.done(function (res) {
				
				console.log(res);
				
                var lastLoginUserJson = JSON.parse(res);
                var lastLoginUser = {};
                var data = lastLoginUserJson.data;
                for (var item in data) {
                    lastLoginUser.password = data[item].password;
                    lastLoginUser.account = data[item].account;
                    lastLoginUser.IsRememberPasswordOrNOt = data[item].isrememberpasswordornot;
                    lastLoginUser.lastLoginTime = data[item].lastlogintime;
                }
				
				console.log(lastLoginUser);
				
                defer.resolve(lastLoginUser);
            });
        }
        return defer.promise();
    }

    /**
     * 是否记住密码
     * Caution ：
     * 现在 IsRememberPasswordOrNOt 这个字段用来区别是否自动登录
     */
    function rememberPwd(userName){
        var defer = $.Deferred();
        var sqlStr = 'update  users  set IsRememberPasswordOrNOt="0" where account="' + userName + '"';
        _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (res) {
            var lastLoginUserJson = JSON.parse(res);
            var lastLoginUser = {};
            var data = lastLoginUserJson.data;
            for (var item in data) {
                lastLoginUser.password = data[item].password;
                lastLoginUser.account = data[item].account;
                lastLoginUser.IsRememberPasswordOrNOt = data[item].isrememberpasswordornot;
                lastLoginUser.lastLoginTime = data[item].lastlogintime;
            }
            defer.resolve(lastLoginUser);
        });
        return defer.promise();
    }

    /**
     * 下载用户头像
     * @param user
     * @returns {*}
     */
    function downloadUserProfile(user) {
        var def = $.Deferred();
        var url = user.getPhoto();
        console.log("个人头像url:" + url);

        var fileName = 'head' + path.extname(url);
        var savePath = path.trimPosix(user.getUserBasePath()) + '/' + fileName;
        _shellcmd.getImageFromUrl(url, savePath).done(function (headImgPath) {
            console.log(headImgPath);
            if (headImgPath == null || headImgPath == '') {
                def.resolve(false);
            } else {
                if (AppCfg.useWebDB) {
                    init();
                    dataBase.transaction(function (tx) {
                        tx.executeSql(
                            "update users set headImg = ?  where account= ?",
                            [ fileName, user.getName()],
                            function (tx) {
                                def.resolve(tx);
                            },
                            function (tx, error) {
                            });
                    });
                }
                else {
                    var sqlStr = 'update users set headImg = "' + fileName + '" where account = "' + user.getName() + '"';
                    _shellcmd.executeDbAsyn(dbPath, sqlStr).done(function (ret) {
                        def.resolve(ret);
                    });
                }
            }
        });
        return def.promise();
    }

    /**
     * 读取用户头像
     * @param username 用户名
     * @returns {*}
     */
    function getUserHeadPhoto(username) {
        var defer = $.Deferred();
        if (AppCfg.useWebDB) {
            init();
            dataBase.transaction(function (tx) {
                tx.executeSql(
                    "select headImg from users where account= ?",
                    [username],
                    function (tx, result) {
                        if (result.rows.length != 0) {

                            if (result.rows.item(0)['headImg'] == null) {
                                defer.resolve(null);
                            }
                            defer.resolve(result.rows.item(0)['headImg']);
                        }
                        else {
                            defer.resolve(null);
                        }
                    },
                    function (tx, error) {
                    });
            });
        }
        else {
            var sqlStr = "select headImg from users where account='" + username + "'";
            var retriveTask = _shellcmd.retriveDbAsyn(dbPath, sqlStr);
            retriveTask.done(function (url) {
                if (url) {
                    console.log("头像： " + url);
                    var urlJson = JSON.parse(url); //urlJson --> Object
                    if (urlJson == null)
                        defer.resolve(null);
                    var data = urlJson.data;//data --> Array
                    if (data.length == 0)
                        defer.resolve("");
                    defer.resolve(data[0].headimg);
                }
                else {
                    defer.resolve(null);
                }
            });
        }

        return defer.promise();
    }

    function getPass(username){
        var defer = $.Deferred();
        var sqlStr = 'select password from users where account= "'+username+'" ';
        var accountListTask = _shellcmd.retriveDbAsyn(dbPath, sqlStr);
        accountListTask.done(function (res) {
                var str = JSON.parse(res);
               _shellcmd.desDecrpty(str.data[0].password,username).done(function(pass){
                   defer.resolve(pass);
               });
            });
       return  defer.promise();
    }

    function getP(username){
        var defer = $.Deferred();
        var sqlStr = 'select password from users where account= "'+username+'" ';
        var accountListTask = _shellcmd.retriveDbAsyn(dbPath, sqlStr);
        accountListTask.done(function (res) {
            var str = JSON.parse(res);
            defer.resolve(str.data[0].password);
        });
        return defer.promise();
    }

    exports.deleteMoreAccount = deleteMoreAccount;
    exports.getLastLoginUser = getLastLoginUser;
    exports.creatTable = creatTable;
    exports.loadAccountList = loadAccountList;
    exports.getAccount = getAccount;
    exports.addAccount = addAccount;
    exports.updateAccount = updateAccount;
    exports.getUserHeadPhoto = getUserHeadPhoto;
    exports.downloadUserProfile = downloadUserProfile;
    exports.deleteAccount = deleteAccount;
    exports.getPhoneNum = getPhoneNum;
    exports.rememberPwd = rememberPwd;
    exports.getUserInfo = getUserInfo;
    exports.getPass = getPass;
    exports.getP = getP;
});

