/**日志，数据监控模块
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-9-9
 * Time: 上午11:56
 * 不知为何，调用之前必须初始化，instance 貌似不起作用
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {

    function Log() {
        var path = require('../common/path');
        var ebookContext = require('./ebookcontext').Instance;
        var _shellcmd = require('../common/shellcmd');
        var _self = this;

        var _logPath = path.join(path.trimPosix(Config.binPath), 'share/iflybooklog.data');

        /**
         * 初始化，主要是log保存地址
         */
        _self.init = function () {
            _self._logPath = path.join(path.trimPosix(Config.binPath), 'share/iflybooklog.data');
        }

        _self.setLogPath = function (dir) {
            _self._logPath = dir;
        }

        _self.getLogPath = function () {
            return _self._logPath;
        }

        _self.creatLogIfNotExist = function () {
            var def = $.Deferred();
            _shellcmd.isFileExist(_self._logPath).done(function (ret) {
                if (!ret) {
                    //创建
                    _self.clearLog().done(function () {
                        def.resolve();
                    });
                }
                else {
                    def.resolve();
                }
            });
            return def.promise();
        }

        /**
         * log文件中插入新纪录
         */
        _self.insertNewLog = function () {
            _self.creatLogIfNotExist().done(function () {
                var readTask = _self.readLogObj();
                var getHardwareTypeTask = _shellcmd.getHardwareType();
                $.when(readTask, getHardwareTypeTask).done(function (obj, num) {
                    var _newUser = {};
                    _newUser.userAccount = ebookContext.getUser().getName();
                    _newUser.loginTime = _self.getTime();
                    _newUser.books = [];
                    _newUser.quitTime = "";
                    _newUser.isOnline = ebookContext.getUser().getIsOnline() ? "1" : "0";
                    _newUser.hdtype = num;
                    obj.users.push(_newUser);
                    _self.writeLogObj(obj);
                });
            });
        }

        /**
         * 读取日志，并转为Json对象
         * @returns {*}
         */
        _self.readLogObj = function () {
            var des = $.Deferred();
            var readTask = _shellcmd.readFileAsync(_self._logPath);
            readTask.done(function (res) {
                if (isString(res)) {
                    if (res.length > 0) {
                        var obj = {};
                        try {
                            obj = JSON.parse(res);
                        } catch (e) {
                            //如果数据没被清空，出了问题，转为空数组
                            obj.users = [];
                        }
                        des.resolve(obj);
                    }
                }
                else {
                    //如果被清空，创建"users"数组
                    var obj = {};
                    obj.users = [];
                    des.resolve(obj);
                }
            });
            return des.promise();
        }

        /**
         * 直接写对象
         * @param obj
         */
        _self.writeLogObj = function (obj) {
            var def = $.Deferred()
            var logXml = JSON.stringify(obj);
            var task = _shellcmd.saveFilAsync(logXml, _self._logPath);
            task.done(function (ret) {
                def.resolve(ret);
            });
            return def.promise();
        }

        /**
         * 纪录log中最后一位user所使用的书本编号
         * @param bookCode
         * @returns {*}
         */
        _self.addUsedBook = function (bookCode) {
            var def = $.Deferred();
            var readTask = _self.readLogObj();
            readTask.done(function (obj) {
                var i = obj.users.length;
                if (i > 0) {
                    try {
                        obj.users[i - 1].books.push(bookCode);
                    } catch (e) {
                        //若book字段丢失
                        obj.users[i - 1].books = [];
                        obj.users[i - 1].books.push(bookCode);
                    }
                }
                _self.writeLogObj(obj);
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 清空log，还原为空数组
         */
        _self.clearLog = function () {
            var def = $.Deferred();
            var task = _shellcmd.saveFilAsync('{"users":[]}', _self._logPath);
            task.done(function () {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 设置当前用户的退出时间并准备发送
         */
        _self.getSendMsg = function () {
            var des = $.Deferred();
            var readTask = _self.readLogObj();
            readTask.done(function (obj) {
                var i = obj.users.length;
                if (i > 0) {
                    obj.users[i - 1].quitTime = _self.getTime();
                }
                des.resolve(obj);
            });
            return des.promise();
        }

        /**
         * 若联网，则发送log，然后清空Log；反之，保存
         */
        _self.sendLog = function () {
            var des = $.Deferred();
            var getSendMsgTask = _self.getSendMsg();
            getSendMsgTask.done(function (sendObj) {
                if (ebookContext.getUser().getIsOnline()) {
                    var str = JSON.stringify(sendObj);
                    var httpurl = AppRemoteSvcCfg.PostUserDataUrl;
                    var msgJson = {
                        url: httpurl,
                        loginlog: str
                    };
                    _shellcmd.postHttpRequest(msgJson).done(function (ret) {
                        //清空log
                        _self.clearLog().done(function () {
                            des.resolve(ret);
                        });
                    });
                }
                else {
                    _self.writeLogObj(sendObj).done(function () {
                        des.resolve(sendObj);
                    });
                }
            });
            return des.promise();
        }

        /**
         * 时间格式化
         * @returns {*}
         */
        _self.getTime = function () {
            return (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
        }

        Date.prototype.Format = function (fmt) { //author: meizz
            var o = {
                "M+": this.getMonth() + 1,                 //月份
                "d+": this.getDate(),                    //日
                "h+": this.getHours(),                   //小时
                "m+": this.getMinutes(),                 //分
                "s+": this.getSeconds(),                 //秒
                "q+": Math.floor((this.getMonth() + 3) / 3), //季度
                "S": this.getMilliseconds()             //毫秒
            };
            if (/(y+)/.test(fmt))
                fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
            for (var k in o)
                if (new RegExp("(" + k + ")").test(fmt))
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            return fmt;
        }
    }

    exports.Instance = new Log();
})
;