/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-12
 * Time: 上午10:21
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    var blackboardHelper = require("../blackboard/blackboardhelper").instance;
    var pyUtil = require('pyutil').Instance;
    var CardWrapper = require('../card/cardwrapper').Instance;
    var ebkcontext = require('../ebookcontext').Instance;
    var ibWSLogic = require("../../ibWSLogic");

    /**
     * 这个类主要用来处理显示白板上笔迹识别的结果
     */
    function StrokeResult() {
        var _self = this;
        _self.Ready = false;
        _self.conInfo = null;
        _self.Dom = null;
        _self.CnWords = null;
        _self.imgPrePageSrc = "";
        _self.imgNextPageSrc = "";
        _self.imgZoomInSrc = "";
        _self.imgZoomOutSrc = "";

        _self.showZnDic = false;
        _self.showEnDic = false;
        _self.showEval = false;
    }

    //初始化DOM结构
    StrokeResult.prototype.init = function () {
        var _self = this;
        if (_self.Ready)return;
        //这一块纯粹为了复用代码
        _self.DOM = blackboardHelper.getDOM();
        _self.getDOM();

        //初始化显示大小
        var _container = $("#bookContainer");
        var _w = parseInt(_container.css("width"));
        var _h = parseInt(_container.css("height"));
        var cssStyle = {
            width: _w + 20,
            height: _h,
            left: $("#leftToolbar").css("width"),
            top: app_global_isMainToolBarUp ? $('#mainToolBar').height() + $('#header').height() : 26
        }
        _self.DOM.blackboardContainer.css(cssStyle);
        $('#board_top').css("width", _w - 20);
        $('#board_bot').css("width", _w - 20);
        _self.DOM.canvasContainer.css("height", _h - 14).css("width", _w - 20);
        _self.DOM.tempCanvas && _self.DOM.tempCanvas.hide();
        _self.createTextToScreenDiv();
        _self.bindCommandsToCNUI(), _self.bindCommandsToENUI();
        _self.Ready = true;
    }

    //获取页面DOM元素
    StrokeResult.prototype.getDOM = function () {
        var _self = this;
        _self.DOM.btnBBoardEvaluate = $("#btnBBoardEvaluate");
        _self.DOM.bBoardCNToolBar = $("#bBoardCNToolBar");
        _self.DOM.bBoardENToolBar = $("#bBoardENToolBar");
        _self.DOM.eBookToolBar = $("#eBookToolBar");
        _self.DOM.btnBBoardCNExit = $("#btnBBoardCNExit");
        _self.DOM.btnBBoardXiaoyan = $("#btnBBoardXiaoyan");
        _self.DOM.btnBBoardXiaoyu = $("#btnBBoardXiaoyu");
        _self.DOM.btnBlackBoardSingleEval = $("#btnBlackBoardSingleEval");
        _self.DOM.btnBlackBoardWordsEval = $("#btnBlackBoardWordsEval");
        _self.DOM.btnBBoardPinYin = $("#btnBBoardPinYin");
        _self.DOM.btnBBoardStrokeOrder = $("#btnBBoardStrokeOrder");
        _self.DOM.btnBBoardMarry = $("#btnBBoardMarry");
        _self.DOM.btnBBoardHenrey = $("#btnBBoardHenrey");
        _self.DOM.btnBBoardEnEval = $("#btnBBoardEnEval");
        _self.DOM.btnBBoardDictionary = $("#btnBBoardDictionary");
        _self.DOM.btnBBoardENExit = $("#btnBBoardENExit");
        _self.DOM.imgEB = $.merge($("#EBL").find("img"),$("#EBR").find("img"));
        _self.DOM.imgPrePage = $.merge($("#btnLeftPrePage").find("img"),$("#btnRightPrePage").find("img"));
        _self.DOM.imgNextPage = $.merge($("#btnLeftNextPage").find("img"),$("#btnRightNextPage").find("img"));
        _self.DOM.imgSnapShot = $("#snapShot").find("img");
        _self.DOM.imgZoomIn = $("#btnZoomIn").find("img");
        _self.DOM.imgZoomOut = $("#btnZoomOut").find("img");
        _self.DOM.imgPenR = $("#btnRightPen").find("img");
        _self.DOM.imgEraserR = $("#btnRightEraser").find("img");
    }

    //生成文字显示区
    StrokeResult.prototype.createTextToScreenDiv = function () {
        var _self = this;
        if (!_self.DOM.textToScreenDiv) {
            _self.DOM.textToScreenDiv = $("<div class='text_box'>").attr("id", 'textToScreenDiv')
                .css({
                    "position": "absolute",
                    "left": "11px",
                    "top": "11px",
                    "display": "none"
                });
            _self.DOM.textToScreenDiv.css("width", _self.DOM.canvasContainer.width() + 8)
                .css("height", _self.DOM.canvasContainer.height() + 8);
            _self.DOM.textToScreenArea = $("<div>");
            _self.DOM.textToScreenDiv.append(_self.DOM.textToScreenArea);
            _self.DOM.canvasContainer.append(_self.DOM.textToScreenDiv);
        }
    }

    /**
     * 显示手势识别结果
     * 这里的language只有两种 中文 英文
     */
    StrokeResult.prototype.showResult = function (language, strokes) {
        var _self = this;
        if(strokes.length == 0){
            blackboardHelper.showTips(AppBlackBoardTipsList.NoStrokeNew);
            return ;
        }
        //这里为了和侧边工具栏isEditing状态不发生冲突
        //只是在切换到此状态的时候把侧边工具栏按钮样式禁灰，
        // 然后罩上一层遮罩，使之不能点击，造成禁用的假象。
        $("#blackBoardOverlay").show();
        _self.changeSideBarCss(false);
        _self.conInfo = blackboardHelper.initConInfo();
        _self.conInfo.strokes = strokes;
        _self.DOM.textToScreenArea.empty();
        _self.DOM.canvasContainer.css({backgroundColor:AppCfg.wbcolor});
        _self.DOM.blackboardContainer.show();
        (language === blackboardHelper.LanguageType.Chinese) ?
            (_self.insertContentToTextArea(blackboardHelper.LanguageType.Chinese, blackboardHelper.TextType.Chinese),
                _self.DOM.bBoardCNToolBar.show()) :
            (_self.insertContentToTextArea(blackboardHelper.LanguageType.English, blackboardHelper.TextType.English),
                _self.DOM.bBoardENToolBar.show());
        _self.DOM.eBookToolBar.hide();
        _self.showZnDic = false;
        _self.showEnDic = false;
        _self.showEval = false;
    }

    /**
     * 在文字显示区生成文字 单词 拼音
     */
    StrokeResult.prototype.insertContentToTextArea = function (language, textType) {
        var _self = this;
        var def = $.Deferred();
        var innerHeight = _self.DOM.canvasContainer.height() + 8;
        var innerWidth = _self.DOM.canvasContainer.width() + 8;
        var lineNum = 0;
        var speecher = "wangru";
        var pySize = 30;
        if (textType === blackboardHelper.TextType.English) {
            _self.strokesToWords(language).done(function (wordStr) {
                if (!wordStr) {
                    def.resolve(false);
                    return def.promise();
                }
                lineNum = parseInt(_self.conInfo.toStrokeResultWords.length / (parseInt(innerWidth / 200))) + 1;
                _self.DOM.textToScreenArea.attr("class", "wzsp9")
                    .css('font-family', 'Arial,serif')
                    .css("paddingLeft", 0)
                    .append(_self.conInfo.toStrokeResultWordStr)
                    .css("paddingTop", (innerHeight - 100 * lineNum) / 2 > 0 ? (innerHeight - 100 * lineNum) / 2 : 10);
                _self.DOM.textToScreenDiv.show();
                def.resolve(true);
                return def.promise();
            });
        }
        else if (textType === blackboardHelper.TextType.Chinese) {
            _self.strokesToWords(language).done(function (wordStr) {
                if (!wordStr) {
                    def.resolve(false);
                    return def.promise();
                }
                lineNum = parseInt(_self.conInfo.toStrokeResultWords.length / (parseInt(innerWidth / 100))) + 1;
                _self.DOM.textToScreenArea.empty().attr("class", "wz_box9").css('font-family', '"楷体","华文楷体"');
                var innerUl = $("<ul></ul>");
                for (var j = 0; j < _self.conInfo.toStrokeResultWords.length; j++) {
                    var py = "py";
                    var word = _self.conInfo.toStrokeResultWords[j];
                    var innerLi = $("<li></li>");
                    var pyStrPra = $("<p class='py' style='color: rgba(0,0,0,0);font-family:Arial;font-size:" + pySize + "px'>" + py + "</p>");
                    var wordStrPra = $("<p>" + word + "</p>");

                    innerLi.append(pyStrPra).append(wordStrPra);
                    innerUl.append(innerLi);
                }
                var paddingLeft = (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 > 0 ? (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 : 10;
                var paddingTop = (innerHeight - (80 + pySize) * lineNum) / 2 - 20 > 0 ? (innerHeight - (80 + pySize) * lineNum) / 2 - 20 : 10;
                _self.DOM.textToScreenArea.append(innerUl).css("paddingLeft", paddingLeft).css("paddingTop", paddingTop);
                _self.DOM.textToScreenDiv.show();
                def.resolve(true);
            });
        }
        else if (textType === blackboardHelper.TextType.PinYin) {
            lineNum = parseInt(_self.conInfo.toStrokeResultWords.length / (parseInt(innerWidth / 100))) + 1;
            blackboardHelper.initShellTTs().done(function (initResult) {
                if (!initResult) {
                    blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                //先整个句子都合成，得到每个字的拼音
                blackboardHelper.textToSpeech([_self.conInfo.toStrokeResultWordStr], speecher).done(function (result) {
                    if (result) {
                        var everyPyArr = result.everyPyArr;
                        var lis = _self.DOM.textToScreenArea.children().children();
                        for (var j = 0; j < _self.conInfo.toStrokeResultWords.length; j++) {
                            var py = pyUtil.convertToPy(everyPyArr[j]);
                            var innerLi = lis[j];
                            var pyStrPra = $(innerLi).children(".py");
                            pyStrPra.empty().append(py).css("color", "rgba(0,0,0,1)");
                        }
                        var paddingLeft = (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 > 0 ? (innerWidth - 80 * _self.conInfo.toStrokeResultWords.length) / 2 : 10;
                        var paddingTop = (innerHeight - (80 + pySize) * lineNum) / 2 - 20 > 0 ? (innerHeight - (80 + pySize) * lineNum) / 2 - 20 : 10;

                        _self.DOM.textToScreenArea.css("paddingLeft", paddingLeft).css("paddingTop", paddingTop);
                    }
                    hideLoading();
                });
                _self.DOM.textToScreenDiv.show();
                def.resolve(true);
            });
        }
        return def.promise();
    }

    //手势识别成文字
    StrokeResult.prototype.strokesToWords = function (lan) {
        var _self = this;
        var def = $.Deferred();
        blackboardHelper.strokes2Words(lan, _self.conInfo.strokes).done(function (wordStr) {
            if (wordStr) {
                //拆成单个字放在数组里,后面可以给笔顺库使用
                _self.conInfo.toStrokeResultWords = [];
                if (lan === blackboardHelper.LanguageType.Chinese) {
                    for (var i = 0; i < wordStr.length; i++) {
                        _self.conInfo.toStrokeResultWords.push(wordStr[i]);
                    }
                }
                else if (lan === blackboardHelper.LanguageType.English) {
                    wordStr = wordStr.replace(/\//g, "").replace(/\n/g, " ");
                    wordStr = wordStr.replace(/  /g, " ");
                    var tempStr = wordStr.replace(/\,/g, "")
                        .replace(/\./g, "")
                        .replace(/\?/g, "")
                        .replace(/\!/g, "")
                        .replace(/\:/g, "")
                        .replace(/\;/g, "")
                        .replace(/\-/g, "");
                    _self.conInfo.toStrokeResultWords = tempStr.split(" ");
                }
                //把识别出来的字符串保存下来，后面合成前不用再识别了
                _self.conInfo.toStrokeResultWordStr = wordStr;
            }
            else {
                blackboardHelper.showTips(AppBlackBoardTipsList.StrokeToWordsFailed);
            }
            def.resolve(wordStr);
        });
        return def.promise();
    }

    StrokeResult.prototype.bindCommandsToCNUI = function () {
        var _self = this;
        _self.DOM.btnBBoardCNExit.unbind().click(function () {
            _self.exitblackboard();
        });

        _self.DOM.btnBBoardXiaoyan.unbind().click(function () {
            _self.playSoundHelper(blackboardHelper.LanguageType.Chinese, "wangru");
        });
        _self.DOM.btnBBoardXiaoyu.unbind().click(function () {
            _self.playSoundHelper(blackboardHelper.LanguageType.Chinese, "xiaoyu");
        });

        _self.DOM.btnBBoardEvaluate.unbind().click(function () {
            if(!_self.showEval){
                _self.DOM.strokeAndDic.hide();
                var botArrow = _self.DOM.evalControl.find(".bot_arrow");
                var topArrow = _self.DOM.evalControl.find(".top_arrow");
                app_global_isMainToolBarUp ? (botArrow.hide(), topArrow.show()) : (botArrow.show(), topArrow.hide());
                //修正位置
                _self.DOM.evalControl.show().css("marginLeft", $(this).offset().left - 81);
                _self.DOM.evalControl.css("marginTop",   app_global_isMainToolBarUp ? ( parseInt(_self.DOM.blackboardContainer.css("height")) * (-1) - 15) : -68 );
            }
            else{
                _self.DOM.evalControl.hide();
            }
            _self.showEval = !_self.showEval;
        });

        //中文单字评测
        _self.DOM.btnBlackBoardSingleEval.click(function () {
            _self.evalHelper(blackboardHelper.LanguageType.Chinese, "cn_word", "wangru");
        });

        //中文词语评测
        _self.DOM.btnBlackBoardWordsEval.click(function () {
            _self.evalHelper(blackboardHelper.LanguageType.Chinese, "cn_word", "wangru");
        });

        _self.DOM.btnBBoardPinYin.unbind().click(function () {
            _self.insertContentToTextArea(blackboardHelper.LanguageType.Chinese, blackboardHelper.TextType.PinYin).done(function () {
                //处理显示逻辑
            });
        });

        //笔顺库
        _self.DOM.btnBBoardStrokeOrder.unbind().click(function () {
            _self.DOM.evalControl.hide();
            if(!_self.showZnDic){
                var botArrow = _self.DOM.strokeAndDic.find(".bot_arrow");
                var topArrow = _self.DOM.strokeAndDic.find(".top_arrow");
                app_global_isMainToolBarUp ? (botArrow.hide(), topArrow.show()) : (botArrow.show(), topArrow.hide());
                _self.showStrokeOrDic(blackboardHelper.TextType.Chinese);
            }
            else{
                _self.DOM.strokeAndDic.hide();
            }
            _self.showZnDic = !_self.showZnDic;
        });
    }

    StrokeResult.prototype.bindCommandsToENUI = function () {
        var _self = this;
        _self.DOM.btnBBoardMarry.unbind().click(function () {
            _self.playSoundHelper(blackboardHelper.LanguageType.English, "mary");
        });

        _self.DOM.btnBBoardHenrey.unbind().click(function () {
            _self.playSoundHelper(blackboardHelper.LanguageType.English, "henry");
        });

        _self.DOM.btnBBoardEnEval.unbind().click(function () {
            _self.evalHelper(blackboardHelper.LanguageType.English, "en_word", "mary");
        });

        _self.DOM.btnBBoardDictionary.unbind().click(function () {
            _self.DOM.evalControl.hide();
            if(!_self.showEnDic){
                var botArrow = _self.DOM.strokeAndDic.find(".bot_arrow");
                var topArrow = _self.DOM.strokeAndDic.find(".top_arrow");
                app_global_isMainToolBarUp ? (botArrow.hide(), topArrow.show()) : (botArrow.show(), topArrow.hide());
                _self.showStrokeOrDic(blackboardHelper.TextType.English);
            }
            else{
                _self.DOM.strokeAndDic.hide();
            }
            _self.showEnDic = !_self.showEnDic;
        });

        _self.DOM.btnBBoardENExit.unbind().click(function () {
            _self.exitblackboard();
        });
    };

    //退出显示处理
    StrokeResult.prototype.exitblackboard = function () {
        var _self = this;
        $("#blackBoardOverlay").hide();
        _self.DOM.eBookToolBar.show();
        _self.DOM.evalControl.hide();
        _self.DOM.strokeAndDic.hide();
        _self.DOM.bBoardCNToolBar.hide();
        _self.DOM.bBoardENToolBar.hide();
        _self.DOM.blackboardContainer.hide();
        _self.changeSideBarCss(true);
        $("#btnMouse").click();
        $("#btnPen").click();
    }

    // 音频合成处理
    StrokeResult.prototype.playSoundHelper = function (language, speecher) {
        var _self = this;
        showLoading({tips: AppBlackBoardTipsList.ConvertingTextToSpeech});

        if(AppCfg.isBBT){
            ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.TTS);
            ibWSLogic.setTTSObj(_self,language,speecher);

            var json = {
                to     : "tray",
                action : "watchdog_exist"
            };
            socket.send(json);
        }else{
            _self.realPlaySoundHelper(language,speecher);
        }
    };

    StrokeResult.prototype.realPlaySoundHelper = function (language, speecher) {
        var _self = this;

        blackboardHelper.initShellTTs().done(function (initResult) {
            if (!initResult) {
                hideLoading();
                blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                return;
            }
            if (language === blackboardHelper.LanguageType.English) {
                _self.conInfo.toStrokeResultWordStr = _self.conInfo.toStrokeResultWordStr.replace(/\,/g, "").replace(/\./g, "").replace(/\?/g, "")
                    .replace(/\!/g, "").replace(/\:/g, "").replace(/\;/g, "").replace(/\-/g, "");
            }
            blackboardHelper.textToSpeech([_self.conInfo.toStrokeResultWordStr], speecher, false).done(function (result) {
                hideLoading();
                result && blackboardHelper.audioPlay(result.audioPaths[0], _self.DOM.player);
            });
        });
    };


    /**
     * 评测处理
     * speecher  wangru 中文单字  xiaoyan 中文词语 mary 英文评测
     */
    StrokeResult.prototype.evalHelper = function (language, cardType, speecher) {
        var _self = this;
        showLoading({tips: AppBlackBoardTipsList.CreatingCards});

        if(AppCfg.isBBT){
            ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.TTSEVALCARD);
            ibWSLogic.setTTSEvalCard(_self,language,cardType,speecher);

            var json = {
                to     : "tray",
                action : "watchdog_exist"
            };
            socket.send(json);
        }else{
            _self.realEvalHelper(language,cardType,speecher);
        }
    };

    StrokeResult.prototype.realEvalHelper = function (language, cardType, speecher) {
        var _self = this;

        blackboardHelper.initShellTTs().done(function (initResult) {
            if (!initResult) {
                hideLoading();
                blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed);
                return;
            }
            if (language === blackboardHelper.LanguageType.Chinese) {
                if (speecher === "wangru") {
                    _self.CNwordsEvaHelper(speecher, cardType);
                }
                else if (speecher === "xiaoyan") {
                    _self.CNchEvaHelper("wangru", cardType);
                }
            }
            else if (language === blackboardHelper.LanguageType.English) {
                _self.ENEvaHelper(speecher, cardType);
            }
        });
    };

    StrokeResult.prototype.CNwordsEvaHelper = function (speecher, cardType) {
        var _self = this;
        //先整个句子都合成，得到每个字的拼音
        blackboardHelper.textToSpeech(_self.conInfo.toStrokeResultWords, speecher).done(function (result) {
            if (result) {
                console.log(result);
                var cssmlWords = [];
                var everyPyArr = result.everyPyArr;
                //需要把识别出来的字符串拆成单个字
                for (var i = 0; i < _self.conInfo.toStrokeResultWords.length; i++) {
                    var wordCSSML = '<?xml version="1.0" encoding="gb2312"?><speak><phoneme py=' + everyPyArr[i] + '>' +
                        _self.conInfo.toStrokeResultWords[i] + '</phoneme>';
                    cssmlWords.push(wordCSSML);
                }
                hideLoading();
                var card = blackboardHelper.createMeta(cardType, result);
                _showCard(card);
//                var useCSSML = true;
//                blackboardHelper.textToSpeech(_self.conInfo.toStrokeResultWords, speecher, useCSSML, cssmlWords).done(function (newResult) {
//                    hideLoading();
//                    if (newResult) {
//                        console.log(newResult);
//                        var card = blackboardHelper.createMeta(cardType, newResult);
//                        _showCard(card);
//                    }
//                });
            }
        });
    }

    StrokeResult.prototype.CNchEvaHelper = function (speecher, cardType) {
        var _self = this;
        blackboardHelper.textToSpeech([_self.conInfo.toStrokeResultWordStr], speecher).done(function (result) {
            if (result) {
                var resultWords = result.resultWords;
                blackboardHelper.textToSpeech(resultWords, speecher).done(function (newResult) {
                    if (newResult) {
                        (newResult.resultWords.length == 0) ? (blackboardHelper.showTips(AppBlackBoardTipsList.InitTTSFailed)) :
                            (_showCard(blackboardHelper.createMeta(cardType, newResult)));
                    }
                    hideLoading();
                });
            }
        });
    }

    StrokeResult.prototype.ENEvaHelper = function (speecher, cardType) {
        var _self = this;
        blackboardHelper.textToSpeech(_self.conInfo.toStrokeResultWords, speecher).done(function (result) {
            hideLoading();
            (result) && (_showCard(blackboardHelper.createMeta(cardType, result)));
        });
    }

    StrokeResult.prototype.showStrokeOrDic = function (_curTextType) {
        var _self = this;
        _self.conInfo.strokeOrderResultWordArr = [];
        var len = _self.conInfo.toStrokeResultWords.length;
        //第一页的页码从1开始
        for (var i = 0; i < len; i += 10) {
            _self.conInfo.strokeOrderResultWordArr.push({index: (i / 10 + 1), words: _self.conInfo.toStrokeResultWords.slice(i, i + 10)});
        }
        //设定翻页按钮初始状态
        _self.strokeOrderPageNum = Math.floor(_self.conInfo.toStrokeResultWords.length / 10);
        (_self.conInfo.toStrokeResultWords.length % 10 == 0) && ( _self.strokeOrderPageNum -= 1);
        //每次打开笔顺库，都显示第一页
        _self.strokeOrderPageIndex = 0;
        _self.DOM.nextPageBtn.children().attr("class", (_self.strokeOrderPageNum == 0) ? "nextpage_disable" : "nextpage");
        _self.DOM.prePageBtn.children().attr("class", "prepage_disable");
        // 给笔顺库翻页按钮绑定点击事件
        _self.DOM.nextPageBtn.unbind().click(function(){
            (_self.strokeOrderPageIndex < _self.strokeOrderPageNum) && (_self.strokeOrderPageIndex++ , _self.createStrokeOrder(_curTextType));
            _self.turnPageHelper();
        });
        _self.DOM.prePageBtn.unbind().click(function(){
            (_self.strokeOrderPageIndex > 0 ) && ( _self.strokeOrderPageIndex-- , _self.createStrokeOrder(_curTextType));
            _self.turnPageHelper();
        });
        _self.createStrokeOrder(_curTextType);
    }

    StrokeResult.prototype.createStrokeOrder = function (_curTextType) {
        var _self = this;
        var wordsArr = _self.conInfo.strokeOrderResultWordArr[_self.strokeOrderPageIndex].words;
        var controlWidth = 0;

        var lis = $("#strokeOrderContainer").children("li");
        $(lis).remove();
        for (var i = 0; i < wordsArr.length; i++) {
            (function (i) {
                var li = $("<li/>").click(function () {
                    var strokeUrl = "";
                    var source = "";
                    if (_curTextType === blackboardHelper.TextType.Chinese) {
                        strokeUrl = AppRemoteSvcCfg.BlackBoardStrokeOrderPageUrl;
                        source = "&type=0604&keyword=" + wordsArr[i];
                    }
                    if (_curTextType === blackboardHelper.TextType.English) {
                        strokeUrl = AppRemoteSvcCfg.BlackBoardDictionaryPageUrl;
                        source = wordsArr[i];
                    }
                    var src = strokeUrl + source;
                    var strokeIframe = $('<iframe id="dictionary_'+ source +'" frameborder="0" allowtransparency="true" scrolling="no" src="' + src + '"></iframe>').load(function () {
                    });
                    blackboardHelper.checkShellOnline().done(function (isNetWorking) {
                        if (!isNetWorking) {
                            blackboardHelper.showTips( (!ebkcontext.getUser().getIsOnline())? AppTips.LocalLoignMsg : AppTips.NetWorkConnectFailed);
                        } else {
                            registerIframe( 'dictionary_'+ source, '*');
                            CardWrapper.show(strokeIframe[0]);
                        }
                    });
                })
                li.html(wordsArr[i]);
                $("#divBlackBoardClear").before(li);
            })(i);
        }

        if (_curTextType === blackboardHelper.TextType.Chinese) {
            (wordsArr.length <= 5) ? (controlWidth = wordsArr.length * 62 + 100, _self.DOM.strokeAndDic.css("marginTop", -95)) :
                (controlWidth = 410, _self.DOM.strokeAndDic.css("marginTop", -158));
            var marginLeft =  _self.DOM.btnBBoardStrokeOrder.offset().left - controlWidth / 2 + 20;
        }
        else if (_curTextType === blackboardHelper.TextType.English) {
            var firstLineWidth = 0, secondLineWidth = 0, wordWidth = 65;
            if (wordsArr.length <= 5) {
                for (var i = 0; i < wordsArr.length; i++) {
                    wordWidth = (wordsArr[i].length > 5) ? (wordsArr[i].length * 10 + 15) : 65;
                    controlWidth += wordWidth;
                }
                controlWidth += 100;
                _self.DOM.strokeAndDic.css("marginTop", -95);
            } else {
                for (var i = 0; i < 5; i++) {
                    wordWidth = (wordsArr[i].length > 5) ? (wordsArr[i].length * 10) : 65;
                    firstLineWidth += wordWidth;
                }
                for (var j = 5; j < wordsArr.length; j++) {
                    wordWidth = (wordsArr[j].length > 5) ? ( wordsArr[j].length * 10) : 65;
                    secondLineWidth += wordWidth;
                }
                controlWidth = ( (firstLineWidth > secondLineWidth) ? firstLineWidth : secondLineWidth ) + 100;
                _self.DOM.strokeAndDic.css("marginTop", -158);
            }
            var marginLeft =  _self.DOM.btnBBoardDictionary.offset().left - controlWidth / 2 + 20;
        }
        _self.DOM.strokeAndDic.css("width", controlWidth).css("marginLeft", marginLeft - 60).show();

        app_global_isMainToolBarUp && _self.DOM.strokeAndDic.css("marginTop", parseInt(_self.DOM.blackboardContainer.css("height")) * (-1) - 15 );
        !app_global_isMainToolBarUp && (parseInt(_self.DOM.strokeAndDic.css("height")) > 80) && _self.DOM.strokeAndDic.css("marginTop", -148) ;

    }

    StrokeResult.prototype.turnPageHelper = function () {
        var _self = this;
        _self.DOM.prePageBtn.children().attr("class",(_self.strokeOrderPageIndex == 0)  ? "prepage_disable" : "prepage");
        _self.DOM.nextPageBtn.children().attr("class",(_self.strokeOrderPageIndex == _self.strokeOrderPageNum) ?  "nextpage_disable" : "nextpage");
    }

    /**
     * 传入卡片信息，展示卡片
     * @param {{cardInfo: Object, cardPath: String}}  card
     */
    function _showCard(card) {
        blackboardHelper.showCard(card,CardWrapper);
    }

    //切换到笔记识别状态时记录侧边工具栏状态
    //切换回去的时候再切回去
    StrokeResult.prototype.changeSideBarCss = function(isbool){
        var _self = this;

        _self.DOM.imgPenR.attr('src', 'assert/images/tool_brush' + (isbool ? '' : '_disable') + '.png');
        _self.DOM.imgEraserR.attr('src', 'assert/images/tool_ostrich' + (isbool ? '' : '_disable') + '.png');
        _self.DOM.imgSnapShot.attr('src', 'assert/images/tool_pz' + (isbool ? '' : '_disable') + '.png');
        _self.DOM.imgEB.attr('src', 'assert/images/tool_kb' + (isbool ? (ebkcontext.getBookCode() ? '': '_disable'): '_disable')+ '.png');

        !isbool && (_self.imgPrePageSrc = _self.DOM.imgPrePage.attr('src'),
            _self.imgNextPageSrc = _self.DOM.imgNextPage.attr('src'),
            _self.imgZoomInSrc = _self.DOM.imgZoomIn.attr('src'),
            _self.imgZoomOutSrc = _self.DOM.imgZoomOut.attr('src'),
            _self.DOM.imgPrePage.attr('src', 'assert/images/tool_prepage_disabled.png'),
            _self.DOM.imgNextPage.attr('src', 'assert/images/tool_nextpage_disabled.png'),
            _self.DOM.imgZoomIn.attr('src', 'assert/images/tool_zoomin_disabled.png'),
            _self.DOM.imgZoomOut.attr('src', 'assert/images/tool_zoomout_disabled.png'));

        isbool && ( _self.DOM.imgPrePage.attr('src', _self.imgPrePageSrc),
            _self.DOM.imgNextPage.attr('src',_self.imgNextPageSrc),
            _self.DOM.imgZoomIn.attr('src',  _self.imgZoomInSrc),
            _self.DOM.imgZoomOut.attr('src', _self.imgZoomOutSrc));

    }

    exports.Instance = new StrokeResult();
});
