/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 15-5-12
 * Time: 上午9:11
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    var shellcmd = require("../../common/shellcmd");
    var ebookContext = require("../../app/ebookcontext").Instance;

    function LocalPlugins() {

        var PluginsProvider = require("./localpluginsprovider").LocalPluginsProvider;

        var _pluginsProvider = new PluginsProvider();

        var _pluginItemTpl =
            '<li class="plug_tool_normal" onMouseDown="'+"this.className='plug_tool_current'"+'" onmouseUp="'+"this.className='plug_tool_normal'"+'" onmouseout="'+"this.className='plug_tool_normal'"+'">'+
                '<a nann ="{{AppName}}" href="javasrcipt:void(0);" class="btn_remove"></a>'+
                '<table border="0" cellpadding="0" cellspacing="0">'+
                    '<tr>'+
                        '<td><p><img src="assert/images/{{thumbnail}}"></p><p names="{{AppName}}">{{name}}</p></td>'+
                    '</tr>'+
                '</table>'+
            '</li>';


        var _addItemTpl =
            '<li class="plug_tool_normal add" >'+
                '<table border="0" cellpadding="0" cellspacing="0">'+
                    '<tr>'+
                        '<td><p id="addlocalexebtn"><img src="assert/images/tool_add.png"></p><p>添加</p></td>'+
                    '</tr>'+
                '</table>'+
            '</li>';


        var _list = [];
        var _self = this;
        var _DOM = {};
        var _pluginMgr = null;
        var maxLocalpluginCount = 35;
        var currentPageIndex = 1;

        //初始化
        _self.init = function (domparam,pluginMgr) {
            var def = $.Deferred();
            _pluginMgr = pluginMgr;
            _DOM.localpluginlist = domparam.find("#localpluginlist");
            //获取item信息,将item存在_list里面
            _self.getInfo().done(function(){
                def.resolve();
            });
            _self.addEvents();
            return def.promise();
        }

        _self.getInfo = function () {
            var def = $.Deferred();
            _pluginsProvider.getLocalInfo().done(function (retlist) {
                //Caution 手动为每一项添加plugintype;
                for(var i =0 ,len = retlist.length;i<len;i++ ){
                    retlist[i].plugintype = "exe";
                }
                _list = retlist;
                def.resolve();
            });
            return def.promise();
        }

        _self.addEvents = function(){
            _DOM.localpluginlist.click(_self.clickHander);
        }

        _self.clickHander = function(e){
            var $target = $(e.target);
            _self.deleExe($target.attr("nann"));

            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130680';
            var user_id = ebookContext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
            if(typeof($target.attr("nann")) != "undefined"){
                return false;
            }
        }

        _self.show = function () {
            if($('#localpluginlist').hasClass('tool_editing')){
                $('#localpluginlist').removeClass('tool_editing');
                $('#editPlug_btn').html('编辑');
            }
            //根据_list显示界面
            var i ,len ;
            var htmlStr = "";
            for(i=0,len=_list.length;i<len;i++){
                var appName = _list[i].name;
                var name = _list[i].name;
                if(appName.length >6){
                    name = appName.substring(0,4)+'...';
                }
                htmlStr += _pluginItemTpl.replace(/\{\{AppName\}\}/g,appName)
                    .replace("{{thumbnail}}",_list[i].thumbnail)
                    .replace("{{path}}",_list[i].path)
                    .replace(/\{\{name\}\}/g,name);
            }
            htmlStr += _addItemTpl;
            var htmlObj = $(htmlStr);
            _DOM.localpluginlist.empty().append(htmlObj);
            $('#addlocalexebtn').click(_self.addExe);
        }


        _self.showEdit = function () {
            //根据_list显示界面
            var i ,len ;
            var htmlStr = "";
            for(i=0,len=_list.length;i<len;i++){
                var appName = _list[i].name;
                var name = _list[i].name;
                if(appName.length >6){
                    name = appName.substring(0,4)+'...';
                }
                htmlStr += _pluginItemTpl.replace(/\{\{AppName\}\}/g,appName)
                    .replace("{{thumbnail}}",_list[i].thumbnail)
                    .replace("{{path}}",_list[i].path)
                    .replace(/\{\{name\}\}/g,name);
            }
            htmlStr += _addItemTpl;
            var htmlObj = $(htmlStr);
            _DOM.localpluginlist.empty().append(htmlObj);
            $('#addlocalexebtn').click(_self.addExe);    

            $('#localpluginlist').addClass('tool_editing');
            $('#editPlug_btn').html('完成');
        }


        _self.addExe = function () {
            if(_list.length == maxLocalpluginCount){
                showAlertTips("数量已达上限，请删除部分程序后再添加");
                return;
            }
            var ret = { "multi": false, "ext": [".exe"]};
            shellcmd.openFileDialog(ret).done(function (result) {
                if (result.length > 0) {
                    for (var i in result) {
                        var icoSavePath = "webapp\\assert\\images\\icons\\";
                        //TODO : 这里没做重复检测，先不管
                        shellcmd.getExeInfo(result[i], icoSavePath).done(function (ret) {
                            if (!ret) {
                                ret = " | ";
                            }
                            var obj = _pluginsProvider.doExeInfo(ret);
                            obj.plugintype = "exe";
                            if (_self.checkExe(obj.title)){
                                showAlertTips("此软件已添加至列表");
                            }
                            else{
                                _list.push(obj);
                                _self.showLastPagePlagins();
                                _pluginsProvider.addOneInfo(obj).done(function(){
                                    _pluginMgr.add(obj);
                                });
                            }

                            //监管
                            var action = LogManager.action.trigger;
                            var params = {};
                            params.module = '1130606';
                            var user_id = ebookContext.getUser().getUid();
                            if(user_id != '0' && user_id){
                                params.user_id =user_id;
                            }
                            LogManager.statistics(action,params);
                        });
                    }
                }
            });
        }

        _self.showCurrentPagePlagins = function(){
            if(currentPageIndex < (Math.floor((_list.length + 4)/8) +1)){
                _self.showPagePlagins(currentPageIndex);
            }
            else{
                _self.showLastPagePlagins();
            }
        }

        _self.showLastPagePlagins = function(){
            _self.showPagePlagins(Math.floor((_list.length + 4)/8) +1);
        }

        _self.showPagePlagins = function (pageIndex){
            _self.cleanShow();
            var startIndex=0; endIndex = 0,showAddBtn = false;
            if(pageIndex == 1){
                _self.showCloudPlagins(true);
                endIndex = 3,showAddBtn = false;
            }
            else{
                _self.showCloudPlagins(false);
                startIndex = 4 +(pageIndex-2)*8;
                endIndex = 4 +(pageIndex-1)*8 -1;
            }
            if(_list.length <= endIndex){
                endIndex = (_list.length-1) >= 0 ?(_list.length-1):0;
                showAddBtn = true;
            }
            _self.showLocalPlagins(startIndex,endIndex,showAddBtn);

            _self.showPages(pageIndex);
            currentPageIndex = pageIndex;
        }

        _self.cleanShow = function(){
            $('#cloudpluginlist').hide();
            $('#localpluginlist').empty();
            $('#pageList').empty();
        }

        _self.showPages = function(currentPage){
            var btnTpl = '<input type="button" value="{{value}}" class="pageBtn {{class}}"/>'
            var totalPageCount = Math.floor((_list.length + 4)/8) +1;
            var htmlStr = "";
            for (var i = 0; i < totalPageCount; i++) {
                if(i == currentPage-1){
                    htmlStr += btnTpl.replace("{{value}}",i+1)
                        .replace("{{class}}",'btn_flip2');
                }
                else{
                    htmlStr += btnTpl.replace("{{value}}",i+1)
                        .replace("{{class}}",'btn_flip');
                }
            };

            var htmlObj = $(htmlStr);
            $('#pageList').empty().append(htmlObj);
            $('.pageBtn').click(function(){
                var pageIndex = parseInt($(this).val());
                _self.showPagePlagins(pageIndex);
            })
        }

        _self.showCloudPlagins = function(isShow){
            isShow ? $('#cloudpluginlist').show():$('#cloudpluginlist').hide();
        }

        _self.showLocalPlagins = function(startIndex,endIndex,withAddBtn){            
                //根据_list显示界面
                var i ;
                var htmlStr = "";
                if(startIndex == 0 && endIndex == 0 && _list.length <= 0){
                        htmlStr += _addItemTpl;
                        var htmlObj = $(htmlStr);
                        _DOM.localpluginlist.empty().append(htmlObj);
                        $('#addlocalexebtn').click(_self.addExe);
                }
                else{
                    for(i= startIndex;i<=endIndex;i++){
                        var appName = _list[i].name;
                        var name = _list[i].name;
                        if(appName.length >6){
                            name = appName.substring(0,4)+'...';
                        }
                        htmlStr += _pluginItemTpl.replace(/\{\{AppName\}\}/g,appName)
                            .replace("{{thumbnail}}",_list[i].thumbnail)
                            .replace("{{path}}",_list[i].path)
                            .replace(/\{\{name\}\}/g,name);
                    }
                    if(withAddBtn){
                        htmlStr += _addItemTpl;
                        var htmlObj = $(htmlStr);
                        _DOM.localpluginlist.empty().append(htmlObj);
                        $('#addlocalexebtn').click(_self.addExe);
                    }
                    else{
                        var htmlObj = $(htmlStr);
                        _DOM.localpluginlist.empty().append(htmlObj);
                    }                    
                }

                if($('#editPlug_btn').html() == '完成'){                    
                    $('#localpluginlist').addClass('tool_editing');
                }
        }


        //检查是否重复
        _self.checkExe = function(title){
            var i,len,flag=0;
            for(i=0,len=_list.length;i<len;i++){
                if(_list[i].title == title){
                    flag = 1;
                    break;
                }
            }
            return (flag == 1);
        }

        _self.deleExe = function(name){
            if(typeof(name) == 'undefined' || name.length < 0){
                return;
            }
            _pluginsProvider.deleOneInfo(name).done(function(){
                for(var i = 0,len = _list.length;i<len;i++){
                    if(_list[i].name == name){
                        break;
                    }
                }
                _list.splice(i,1);
                _pluginMgr.dele(name);
                _self.showCurrentPagePlagins();
            });
        }

        _self.returnLocalPlugin = function(){
            //Caution : 返回一个复制后的对象
            var def = $.Deferred();
            def.resolve(_list.concat());
            return def.promise();
        }
    }

    exports.LocalPlugins = LocalPlugins;
});

