/**
 * Created by Administrator on 15-5-15.
 */

define(function (require, exports) {

    var PLUGIN_CONFIG ={
        'EachLineNumber' : 4 ,
        'ItemHight' : 60,
        'Offset' : 50
    };

    function plugin_window() {

        /**
         *  插件化默认展示DOM
         * @type {string}
         */
        var DomTemplate_show = '<li class="plug_tool_normal"  >'+
            '<table border="0" cellpadding="0" cellspacing="0">'+
            '<tr>'+
            '<td><p><img width="25px" height="25px" src={iconPath}></p><p names="{name}">{AppName}</p></td>'+
            '</tr>'+
            '</table>'+
            '</li>';

        /**
         *  插件化弹出展示DOM
         * @type {string}
         */
        var headLi = '<li class="plug_tool_normal " data-order = {order}  onMouseDown="this.className='+ "'"+ 'plug_tool_current'+ "'" + '" onmouseout="this.className=' + "'"+ 'plug_tool_normal'+"'" + '">';

        var DomTemplate_panel = headLi +
            '<table border="0" cellpadding="0" cellspacing="0">' +
                '<tr>' +
                    '<td><p><img width="25px" height="25px" src={iconPath} ></p><p names="{name}">{AppName}</p></td>'+
                    '</tr>' +
                '</table>'+
            '</li>';

        /**
         * 排序按钮DOM
         * @type {string}
         */
        var btnSort = ' <div style="padding-left: 10px;padding-top: 5px; float:left"><a class="btn-sort" href="javascript:void(0);">排序</a></div>';


        /**
         *  默认展示数量
         * @type {number}
         */
        var SHOWNUMBER = 4;

        var _self = this;
        var _pluginMgr ;
        var window_Dom = {
            "alertBtn" : $(".btn-sub") , // 弹出按钮
            "sortWindow" : $(".plug-box-con-se")  //   排序/完成按钮
        };

        _self.init = function(pluginMgr) {
            // 传入插件管理类
            _pluginMgr = pluginMgr;
            bindEvent();
        };

        /**
         * 鼠标事件绑定
         */
        function bindEvent() {
            $(document).on('click' , '.btn-sort' ,dragSort);
            $(document).on("click",".plug_tool_normal , .tool_current", openApp);
            $(document).on("click","#editPlug_btn" ,function(){
                if($('#localpluginlist').hasClass('tool_editing')){
                    $('#localpluginlist').removeClass('tool_editing');
                    $('#editPlug_btn').html('编辑');
                }
                else{
                    $('#localpluginlist').addClass('tool_editing');
                    $('#editPlug_btn').html('完成');
                }
            });
            document.addEventListener("click",GlobalListen,true);            
        }

        /**
         *  拖拽排序事件绑定
         */
        var dragSort = function(){

            if (  $(".btn-sort").html() == '排序'){
                $(".plug-box-con-se").dragsort({ dragSelector: "table", dragBetween: true, dragEnd: saveOrder, placeHolderTemplate: "" });
                $(".btn-sort").html("完成");
            }else {
                $(".plug-box-con-se").dragsort("destroy");
                $(".btn-sort").html("排序");
            }
        };
        /**
         *  打开应用
         */
        var openApp = function(){
                var tmp = $($(this).find('p')[1]).attr("names");
            if ($("#editPlug_btn").html() != '完成'){
                _pluginMgr.openPlugin(tmp);
            }
            else{
                if(tmp == 'videoclass' || tmp == 'snapshot' || tmp == 'chinesetest' || tmp == 'englishtest'){
                    _pluginMgr.openPlugin(tmp);
                }
            }
        };
        /**
         *  全局事件处理
         * @constructor
         */
        var GlobalListen = function() {
            var $TargetDom = $(event.target);
            if ($TargetDom.parents('.plug-box-con-se').length == 0){
                window_Dom.sortWindow.hide();
            }
        };

        /**
         *  排序后更新list列表顺序
         */
        function saveOrder() {
            var newlist = _pluginMgr.list;

            var Domlist = $(".plug-box-con-se").find('li');
            var dataOrderArr = [];
            for (var i = 0 ; i< Domlist.length ; ++i){
                var data_order = parseInt($(Domlist[i]).attr('data-order'));
                $(Domlist[i]).attr('data-order' , i);
                dataOrderArr.push(data_order);
            }
            var copyList = newlist.concat();
            for (var k = 0 ; k < newlist.length ; ++k ){
                newlist[k] = copyList[dataOrderArr[k]];
            }
            _pluginMgr.list = newlist;
            _pluginMgr.drawPlugin();
        }

        /**
         *  加载默认插件图标并展示
         * @param list
         */
        _self.loadPluginInfo = function(list){
            var pluginInfo = list;
            $("#plugin_useful").find("li").remove();
            var showNumber = pluginInfo.length < 4 ? pluginInfo.length : SHOWNUMBER;
            for (var i = 0; i < showNumber ; ++i){
                var appDom = DomTemplate_show;
                var appName = cutString(pluginInfo[i].title , 6);
                appDom = appDom.replace("{iconPath}" , formatThumbnail(pluginInfo[i].thumbnail))
                    .replace("{AppName}" , appName)
                .replace("{name}" , pluginInfo[i].name);
                $("#plugin_useful").append(appDom);
            }
        };
        /**
         *  加载所用插件图标，并展示
         * @param list
         */
        _self.loadPluginAll = function(list){
            var pluginInfo = list;
            $(".plug-box-con-se").dragsort("destroy");
            if (app_global_isMainToolBarUp == false){
                var listNum = parseInt(list.length);
                var lineNum = Math.ceil((listNum + 1) / PLUGIN_CONFIG.EachLineNumber) ;
                var WindowHeight = PLUGIN_CONFIG.ItemHight  * lineNum;
                var offset = - (WindowHeight - PLUGIN_CONFIG.Offset) ;
                window_Dom.sortWindow.css('top' , offset);
            }
            else {
                window_Dom.sortWindow.css('top' , 0);
            }
            window_Dom.sortWindow.show();
            $(".plug-box-con-se").find("li").remove();
            $(".plug-box-con-se").find("div").remove();
            for (var i = 0; i < pluginInfo.length ; ++i){
                var appDom = DomTemplate_panel;
                var appName = cutString(pluginInfo[i].title , 6);
                appDom = appDom.replace("{iconPath}" , formatThumbnail(pluginInfo[i].thumbnail))
                    .replace("{AppName}" , appName)
                    .replace("{name}" , pluginInfo[i].name)
                    .replace("{order}" , i);
                $(".plug-box-con-se").append(appDom);
            }
            $(".plug-box-con-se").append(btnSort);
        };

        /**
         *  格式化缩略图路径
         * @param thumbnail
         * @returns {string}
         */
        function formatThumbnail(thumbnail){
            var relaBase = "assert/images/" ;
            return relaBase + thumbnail;
        }

        function cutString(str , cut_len) {
            if (str.length <= cut_len) return str;
            var newStr='' ;
            for(i = 0 ;i < cut_len ; ++i){
                newStr += str[i];
            }
            newStr += "...";
            return newStr;
        }

    }
    exports.plugin_window = plugin_window;
});