/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 15-5-12
 * Time: 下午8:17
 * To change this template use File | Settings | File Templates.
 */
;
define(function(require,exports){

    var shellcmd = require("../../../../common/shellcmd");
    var bbhelper = require("../../../blackboard/blackboardhelper").instance;
    var CardWrapper = require('../../../card/cardwrapper').Instance;
    var ebkcontext = require('../../../ebookcontext').Instance;

    function PluginEnglishTest(){

        var _self = this;
        var _tplpath = Config.binPathNoFile + "webapp/assert/js/app/plugins/pluginitem/englishtest/tpl.html" ;
        var _ready = false;
        var _Dom = null;
        var btns = {};
        var controls = {};
        var _toStrokeResultWordStr = "";
        var _toStrokeResultWords = [];
        var _strokeOrderResultWordArr = [];

        //识别板的宽和高
        var _canvasWidth = 674,_canvasHeight = 430;
        //默认画笔颜色
        var _color = "#000";
        //默认画笔粗细
        var _size = 4;
        //点迹数组
        var strokes = [];
        // TODO : 这里是个坑，调用的是别的地方的player，没细看
        var _player = $("#blackBoardPlayer");

        var _curIndex = 0;

        _self.init = function(){
            var _tpl = shellcmd.readFile(_tplpath);
            _ready = false;
            _Dom = $(_tpl);
            btns.closebtn = _Dom.find("#entestclose");
            controls.enresult = _Dom.find("#enresult");
            controls.enwrite = _Dom.find("#enwrite");

            btns.retoenwrite = _Dom.find("#retoenwrite");
            btns.enrecognize = _Dom.find("#enrecognize");
            btns.enEraser = _Dom.find("#enEraser");

            btns.engirl = _Dom.find("#engirl");
            btns.enboy = _Dom.find("#enboy");
            btns.enEval = _Dom.find("#enEval");
            btns.enDic = _Dom.find("#enDic");

            controls.enreContent = _Dom.find("#enreContent");
            controls.enDicCh = _Dom.find("#enDicCh");
            controls.enDicPanel = _Dom.find("#enDicPanel");
            btns.enPrePage = _Dom.find("#enPrePage");
            btns.enNextPage = _Dom.find("#enNextPage");

            controls.entestcanvas = _Dom.find("#entestcanvas");
            controls.entestcanvas.attr("width", _canvasWidth).attr("height",_canvasHeight);
            controls.entestcanvasCtx = controls.entestcanvas[0].getContext("2d");

            controls.entestcanvas.css("cursor", bbhelper.cursor.penCursor);
            controls.entestcanvasCtx.strokeStyle = _color;
            controls.entestcanvasCtx.fillStyle = _color;
            controls.entestcanvasCtx.lineWidth = _size;
            controls.entestcanvasCtx.lineJoin = "round";
            controls.entestcanvasCtx.lineCap = "round";

            _self.addEvents();
        }

        _self.addEvents = function(){

            btns.closebtn.click(_self.close);

            btns.retoenwrite.click(_self.show);

            btns.enrecognize.click(_self.showResult);

            btns.engirl.click(function(){
                _self.playSoundHelper(bbhelper.LanguageType.English, "mary");
            });

            btns.enboy.click(function(){
                _self.playSoundHelper(bbhelper.LanguageType.English, "henry");
            });

            btns.enEraser.click(_self.clearStrokePoints);

            btns.enEval.click(function(){
                _self.evalHelper(bbhelper.LanguageType.English, "en_word", "mary");
            });

            btns.enDic.click(_self.enDicToggle);

            controls.enDicCh.click(function(){
                var s = $(this).attr("word");
                _self.createDic(s);
            });

            btns.enPrePage.click(function(){
                if(_curIndex > 0){
                    _self.showDic(--_curIndex);
                }
            });

            btns.enNextPage.click(function(){
                if(_curIndex < _toStrokeResultWords.length ){
                    _self.showDic(++_curIndex);
                }
            });

            var sx,sy,ex,ey;
            var   _isPainting = false;
            controls.entestcanvas.mousedown(function(e){
                controls.entestcanvasCtx.beginPath();
                var startX = e.offsetX, startY = e.offsetY;
                //在仅仅点击鼠标时，需要画出一个点，如果不加上这0.01个像素，则画不出来
                sx = startX + 4,sy = startY + 4;
                ex = startX + 4 + 0.01, ey = startY + 4 + 0.01;
                strokes.push([sx,sy]);
                controls.entestcanvasCtx.moveTo(sx, sy);
                controls.entestcanvasCtx.lineTo(ex, ey);
                controls.entestcanvasCtx.stroke();
                _isPainting = true;
            }).mousemove(function(e){
                    if(_isPainting){
                        ex = e.offsetX + 4, ey = e.offsetY + 4;
                        strokes.push([ex, ey]);
                        controls.entestcanvasCtx.lineTo(ex, ey);
                        controls.entestcanvasCtx.stroke();
                    }
                }).mouseup(function(){
                    strokes.push([-1, -1]);
                    _isPainting = false;
                    strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                }).mouseout(function(){
                    strokes.push([-1, -1]);
                    _isPainting = false;
                    strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                });
        }

        _self.close = function(){
            _Dom.hide();
        }

        _self.startOpen = function(){
            if(!_ready){
                _Dom.appendTo("body");
                _ready = true;
                _self.show("",1);
            }
            else{
                _self.show("",1);
            }
            //监管
            var action = LogManager.action.trigger;
            var params = {};
            params.module = '1130414';
            var user_id = ebkcontext.getUser().getUid();
            if(user_id != '0' && user_id){
                params.user_id =user_id;
            }
            LogManager.statistics(action,params);
        }

        _self.show = function(e,flag){
            _Dom.show();
            controls.enresult.hide();
            controls.enwrite.show();
            if(flag){
                _self.clearStrokePoints();
            }
        }

        _self.clearStrokePoints = function(){
            strokes = [];
            _toStrokeResultWordStr = "";
            _toStrokeResultWords = [];
            _strokeOrderResultWordArr = [];
            controls.entestcanvasCtx.clearRect(0,0,_canvasWidth,_canvasHeight);
            _curIndex = 0;
        }

        _self.enDicToggle = function(){
            controls.enDicPanel.toggle();
            _self.showDic(0);
        }

        _self.showResult = function(){
            if(strokes.length>0){
                //TODO : 后续可以考虑缓存优化，在“返回”之后不需要再进行“识别”
                bbhelper.initShellTTs().done(function (initResult) {
                    if (!initResult) {
                        _self.showTips(AppBlackBoardTipsList.InitTTSFailed);
                        return;
                    }
                    bbhelper.strokes2Words(bbhelper.LanguageType.English, strokes).done(function (wordStr) {
                        wordStr = wordStr.replace(/\//g, "").replace(/\n/g, " ");
                        wordStr = wordStr.replace(/  /g, " ");
                        var tempStr = wordStr.replace(/\,/g, "")
                            .replace(/\./g, "")
                            .replace(/\?/g, "")
                            .replace(/\!/g, "")
                            .replace(/\:/g, "")
                            .replace(/\;/g, "")
                            .replace(/\-/g, "");
                        _toStrokeResultWords = tempStr.split(" ");
                        //把识别出来的字符串保存下来，后面合成前不用再识别了
                        _toStrokeResultWordStr = wordStr;
                        controls.enreContent.text(wordStr);
                        controls.enwrite.hide();
                        controls.enresult.show();
                        controls.enDicPanel.hide();
                    });
                });
            }
            else{
                _self.showTips("请先书写单词");
            }
        }

        _self.playSoundHelper = function(language, speecher){
            showLoading({tips: AppBlackBoardTipsList.ConvertingTextToSpeech});
            if(AppCfg.isBBT){
                ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.TTS);
                ibWSLogic.setTTSObj(_self,language,speecher);
                var json = {
                    to     : "tray",
                    action : "watchdog_exist"
                };
                socket.send(json);
            }else{
                _self.realPlaySoundHelper(language,speecher);
            }
        }

        _self.realPlaySoundHelper = function (language, speecher) {
            bbhelper.initShellTTs().done(function (initResult) {
                if (!initResult) {
                    hideLoading();
                    _self.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                if (language === bbhelper.LanguageType.English) {
                    _toStrokeResultWordStr = _toStrokeResultWordStr.replace(/\,/g, "").replace(/\./g, "").replace(/\?/g, "")
                        .replace(/\!/g, "").replace(/\:/g, "").replace(/\;/g, "").replace(/\-/g, "");
                }
                bbhelper.textToSpeech([_toStrokeResultWordStr], speecher, false).done(function (result) {
                    hideLoading();
                    result && bbhelper.audioPlay(result.audioPaths[0], _player);
                });
            });
        };

        /**
         * 评测处理
         * speecher  wangru 中文单字  xiaoyan 中文词语 mary 英文评测
         */
        _self.evalHelper = function (language, cardType, speecher) {
            showLoading({tips: AppBlackBoardTipsList.CreatingCards});

            if(AppCfg.isBBT){
                ibWSLogic.setDongleAction(ibWSLogic.DONGLE_ACTION.TTSEVALCARD);
                ibWSLogic.setTTSEvalCard(_self,language,cardType,speecher);

                var json = {
                    to     : "tray",
                    action : "watchdog_exist"
                };
                socket.send(json);
            }else{
                _self.realEvalHelper(language,cardType,speecher);
            }
        };

        _self.realEvalHelper = function (language, cardType, speecher) {
            bbhelper.initShellTTs().done(function (initResult) {
                if (!initResult) {
                    hideLoading();
                    _self.showTips(AppBlackBoardTipsList.InitTTSFailed);
                    return;
                }
                    _self.ENEvaHelper(speecher, cardType);
            });
        };


        _self.ENEvaHelper = function (speecher, cardType) {
            bbhelper.textToSpeech(_toStrokeResultWords, speecher).done(function (result) {
                hideLoading();
                (result) && (_showCard(bbhelper.createMeta(cardType, result)));
            });
        }

        function _showCard(card) {
            bbhelper.showCard(card,CardWrapper);
        }

        _self.showTips = function(tips){
            showAlertTips(tips);
        }

        _self.showDic = function(index){
            index && (_curIndex = index);
            controls.enDicCh.attr("word",_toStrokeResultWords[_curIndex]).text(_toStrokeResultWords[_curIndex]);
        }

        _self.createDic = function(word){
            var strokeUrl = AppRemoteSvcCfg.BlackBoardDictionaryPageUrl;
            var source =  "&type=0604&w=" + word;
            var src = strokeUrl + source;
            var strokeIframe = $('<iframe id="dictionary_'+ source +'" frameborder="0" allowtransparency="true" scrolling="no" src="' + src + '"></iframe>').load(function () {
            });

            bbhelper.checkShellOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    _self.showTips( (!ebkcontext.getUser().getIsOnline())? AppTips.LocalLoignMsg : AppTips.NetWorkConnectFailed);
                } else {
                    registerIframe( 'dictionary_'+ source, '*');
                    CardWrapper.show(strokeIframe[0]);
                }
            });
        };
    }

    exports.PluginEnglishTest = PluginEnglishTest;
});
