/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 15-5-12
 * Time: 上午9:10
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    var shellcmd = require("../../common/shellcmd");
    var _path = require("../../common/path");
    var _child_process = nodereq('child_process');
    var ebkContext = require("../ebookcontext").Instance;
    var guid = require("../../common/guid").Instance;
    var plugin_window = require("./plugin_window").plugin_window;
    var ibWSLogic = require("../../ibWSLogic");
    var _ktsl_book = require("../book/toolbar/ktsl");

    function PluginsMgr() {

        var CloudPlugin = require("./cloudplugins").CloudPlugins;
        var _cloudPlugin = new CloudPlugin();
        var LocalPlugin = require("./localplugins").LocalPlugins;
        var _localPlugin = new LocalPlugin();

        var _drawPluginInstance = new plugin_window();
        _drawPluginInstance.init(this);

        var Plugin3rdLocal = require("./pluginitem/plugin3rdlocal").Plugin3rdLocal;

        var _tplPath = Config.binPathNoFile + "webapp/assert/template/pluginpanel.html";
        var _Dom = null;
        var btns = {};
        var controls = {};
        var _self = this;

        var _ready = false;
        //TA主目录
        _self.basePath = process.execPath.substring(0, process.execPath.lastIndexOf('\\')).replace(/\\/g, '/');
        //NW目录
        _self.nwPath = _self.basePath + '/nw.exe';
        //缓存list
        _self.list = [];
        //TA是否打开的标志
        _self.taOpen = false;
        //要发给TA的信息
        /**
         * toTAMSG应是一个对象数组
         * 要包含的字段 action :有以下几种：delete setup-此处的实际上是打开百宝箱有安装\卸载的界面，剩下的还是用户要操作
         *             id   :   某个应该的ID
         * @type {Array}
         */
        _self.toTAMSG = [];
        var _plugins = [];
        //排序文件地址
        var _sortFilePath = "";

        //初始化
        _self.init = function () {
            var tplstr = shellcmd.readFile(_tplPath);
            _Dom = $(tplstr);
            btns.closebtn = _Dom.find("#pluginpanelclose");
            btns.localpluginbtn = _Dom.find("#localpluginbtn");
            btns.cloudpluginbtn = _Dom.find("#cloudpluginbtn");

            controls.cloudplugintab = _Dom.find("#cloudplugintab");
            controls.localplugintab = _Dom.find("#localplugintab");
            _ready = false;

            btns.showPluginBtn = $("#showPluginBtn");

            var task1 = _cloudPlugin.init(_Dom, _self);
            var task2 = _localPlugin.init(_Dom, _self);
            $.when(task1,task2).done(function(){
                //读取排序文件,存在_self.list里面
                //顺便刷新界面
                _self.refrash();
            });

            _sortFilePath = ebkContext.getUser().getUserSortFileFullPath();

            _self.addEvent();

            var PluginChineseTest = require("./pluginitem/chinesetest/chinesetest.js").PluginChineseTest;
            _plugins["chinesetest"] = new PluginChineseTest;
            _plugins["chinesetest"].init();

            var PluginEnglishTest = require("./pluginitem/englishtest/englishtest.js").PluginEnglishTest;
            _plugins["englishtest"] = new PluginEnglishTest;
            _plugins["englishtest"].init();
        }

        _self.addEvent = function () {
            btns.closebtn.click(_self.close);
            //本地插件显示
            btns.localpluginbtn.click(_self.showLocalPlugin);
            //云端插件显示
            btns.cloudpluginbtn.click(_self.showCloudPlugin);

            //显示插件面板
//            btns.showPluginBtn.click(_self.show);
            //简化，直接弹出添加程序对话框
//            btns.showPluginBtn.click(_localPlugin.addExe);
            btns.showPluginBtn.click(_self.show);


            $(".btn-sub").click(_self.showPluginPanel);


        };

        _self.show = function () {
            if (!_ready) {
                _Dom.appendTo("body");
                _ready = true;
                _self.showLocalPlugin();
            }
            else {
                if(_Dom.is(':visible')){
                    _Dom.hide();
                }
                else{
                    _Dom.show();
                    _self.showLocalPlugin();                    
                }
            }
            _Dom.find("[names=videoclass]").parents("li").hide();
            _Dom.find("[names=snapshot]").parents("li").hide();
        }

        _self.showCloudPlugin = function () {
            controls.cloudplugintab.show();
            controls.localplugintab.hide();
            btns.localpluginbtn.removeClass("current");
            btns.cloudpluginbtn.addClass("current");
            _cloudPlugin.show();
        }

        _self.showLocalPlugin = function () {
            controls.cloudplugintab.hide();
            controls.localplugintab.show();
            btns.localpluginbtn.addClass("current");
            btns.cloudpluginbtn.removeClass("current");
            _localPlugin.showPagePlagins(1);
            
            if(app_global_isMainToolBarUp){
                $('#pluginpanel').css('z-index','1');

                // $('#pluginpanel').css('bottom','58px');
                // $('#pluginpanel').css('top','77px');
                //底部工具条58px,边框5px,工具栏下三角5px共68
                $('#pluginpanel').addClass("user-popover")
                var topVal = $('#showPluginBtn').offset().top - 240;
                $('#pluginpanel').css('top',topVal + 'px');
                var left_p = $('#showPluginBtn').offset().left;
                left_p = left_p - 120;
                $('#pluginpanel').css('left',left_p+'px');
            }
            else{
                //底部工具条58px,边框5px,工具栏下三角5px共68
               // $('#pluginpanel').css('bottom','58px');
                $('#pluginpanel').addClass("user-popover");
                 var topVal = $('#showPluginBtn').offset().top - 240;
                 $('#pluginpanel').css('top',topVal + 'px');
                var left_p = $('#showPluginBtn').offset().left;
                left_p = left_p - 120;
                $('#pluginpanel').css('left',left_p+'px');
            }
        }

        _self.showPluginPanel = function(){
            _drawPluginInstance.loadPluginAll(_self.list);
        }

        _self.close = function () {
            _Dom.hide();
        }

        //排序
        _self.sort = function () {
            //操作dom
            //根据dom操作_self.list
        }

        //将排序结果写进排序文件
        _self.saveSort = function () {
            var jsonStr = JSON.stringify(_self.list);
            shellcmd.saveFile(jsonStr, _sortFilePath);
        }

        //添加一项 操作_self.list
        _self.add = function (dataitem) {
            _self.list.push(dataitem);

            _self.drawPlugin();
        }

        //删除一项 操作_self.list
        _self.dele = function (name) {
            var i, len;
            var pos = [];
            for (i = 0, len = _self.list.length; i < len; i++) {
                if (_self.list[i].name == name) {
                    pos.push(i);
                }
            }
            for (i = 0, len = pos.length; i < len; i++) {
                _self.list.splice(pos[i], 1);
            }
            _self.drawPlugin();
        }

        _self.drawPlugin = function () {
            //绘制按钮时保存数据
            _self.saveSort();
            //根据_self.list,生成主工具栏可操作按钮
            _drawPluginInstance.loadPluginInfo(_self.list);
        }

        //刷新页面
        _self.refrash = function () {
            shellcmd.isFileExist(_sortFilePath).done(function (ret) {
                var jsonlist = [];
                var locallist = [];
                if (ret) {
                    var jsonStr = shellcmd.readFile(_sortFilePath);
                    jsonlist = JSON.parse(jsonStr);
                }
                //可能数据库TA更新了，但是iFB没有更新
                _cloudPlugin.returnDownloadPlugin().done(function(listCloudlocal){

                    _localPlugin.returnLocalPlugin().done(function(listHere){
                        locallist = listCloudlocal.concat(listHere);
                        //先删除别的账号已经移除的数据项
                        jsonlist = _self.deleBeforeMergeTitle(jsonlist,locallist);
                        //再添加别的账号添加的数据项
                        jsonlist = _self.mergeList(jsonlist, listCloudlocal);
                        //再添加别的账号添加的数据项
                        _self.list = _self.mergeList(jsonlist, listHere);
                        _self.drawPlugin();
                    });
                });
            });
        }

        _self.deleBeforeMergeTitle = function(list1,list2){
            var i,leni, j,lenj,flag;
            var pos = [],posx;
            for(i=0,leni=list1.length;i<leni;i++){
                flag = 0 ;
                for(j=0,lenj=list2.length;j<lenj;j++){
                    if( list1[i].title && list1[i].title == list2[j].title){
                        flag = 1;
                        break;
                    }
                }
                if(!flag){
                    pos.push(i);
                }
            }
            //从后往前删
            while(pos.length>0){
                posx = pos.pop();
                list1.splice(posx,1);
            }
            return list1;
        }

        _self.mergeList = function (list1, list2) {
            var i , leni;
            var j, lenj;
            for (i = 0, leni = list1.length; i < leni; i++) {
                for (j = 0, lenj = list2.length; j < lenj; j++) {
                    if (list1[i].name == list2[j].name) {
                        list2.splice(j, 1);
                        break;
                    }
                }
            }
            //添加没有信息
            if (list2.length > 0) {
                list1 = list1.concat(list2);
            }
            return list1;
        }

        _self.searchInfoByName = function(name){
            var i ,len;
            for(i=0,len = _self.list.length;i<len;i++){
                if(_self.list[i].name == name){
                    return _self.list[i];
                }
            }
        }

        //根据不同的标签，启动相应的调用
        _self.openPlugin = function (pluginname) {
            if(pluginname=='videoclass'){
               //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebkContext._curUser._uid,
                    module:'03014',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
            }else if(pluginname=='snapshot'){
                _ktsl_book.toggleSnapshot(true);
               //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebkContext._curUser._uid,
                    module:'03019',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
            }else if(pluginname=='chinesetest'){
                //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebkContext._curUser._uid,
                    module:'03015',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
            }else if(pluginname=='englishtest'){
               //temp eshop监管 linwang5@iflytek.com
                var staticParams = {
                    uid:ebkContext._curUser._uid,
                    module:'03016',
                    type:'trigger',
                    havingClass:_isHavingClass?1:0
                };
                edcService.Instance().api_eshop_baseStatics(staticParams);
            }
            if('snapshot' == pluginname){
                if(app_global_isMainToolBarUp)
                {
                    $('#pluginpanel').slideUp();
                }
                else{
                    var topV = parseInt($("#pluginpanel").css('top'));
                        topV += 230;
                    $("#pluginpanel").animate({top:(topV+"px")});
                    // $('#pluginpanel').slideUp();
                }
            }
            setTimeout(function(){
                _self.getPluginInstance(pluginname).done(function (obj) {
                    var dstPath = "";
                    if (obj.startOpen) {
                        //耦合较紧直接调用
                        obj.startOpen();
                    }
                    else if (obj.openCall) {
                        obj.openCall();
                    }
                });
               // _self.openSnapshot();

            },400);
        }


//快照打开程序单独调用
        _self.openSnapshot= function(){
//         function openSnapshot(){
            var param = null;
            var newSnapshot = null;
            $LAB.script("assert/js/app/plugins/pluginitem/" + "snapshot" + "/" + "snapshot.js").wait(function () {
                newSnapshot = new BBTPLUGINS["snapshot"];
                // _plugins[pluginname] = newInstance;
                //一些组件在init的时候传出去
                if (newSnapshot.init) {
                    param = {
                        path: _path,
                        shellcmd: shellcmd,
                        guid : guid ,
                        ebookContext : ebkContext,
                        ibWSLogic:ibWSLogic
                    }
                    newSnapshot.init(param);
                }
                newSnapshot.openCallBehind(true);
            });
        }

        $(document).on("callSnapshot",function(){
            _self.openSnapshot();
        })

        _self.getPluginInstance = function (pluginname) {
            var def = $.Deferred();
            var param = null;
            var newInstance = null;
            if(typeof(pluginname) != "undefined"){
                if (_plugins[pluginname]) {
                    def.resolve(_plugins[pluginname]);
                }
                else {
                    //先看类型
                    var pInfo = _self.searchInfoByName(pluginname);
                    if(pInfo.plugintype == "exe"){
                        _plugins[pluginname] = new Plugin3rdLocal(pInfo.path);
                        def.resolve(_plugins[pluginname]);
                    }
                    else if(pInfo.plugintype == "nw"){
                    }
                    else if(pInfo.plugintype == "js"){
                        $LAB.script("assert/js/app/plugins/pluginitem/" + pluginname + "/" + pluginname + ".js").wait(function () {
                            newInstance = new BBTPLUGINS[pluginname];
                            _plugins[pluginname] = newInstance;
                            //一些组件在init的时候传出去
                            if (_plugins[pluginname].init) {
                                param = {
                                    path: _path,
                                    shellcmd: shellcmd,
                                    guid : guid ,
                                    ebookContext : ebkContext,
                                    ibWSLogic:ibWSLogic
                                }
                                _plugins[pluginname].init(param);
                            }
                            def.resolve(_plugins[pluginname]);
                        });
                    }
                    else{
                        //TODO : 这种情况我也不知道要干啥
                    }
                }
            }
            return def.promise();
        }

        /**
         * 启动教师助手主程序，监听其离开时，记录_self.taOpen=false
         */
        _self.openTeacherAssistant = function () {
            var main = 'main';
            _child_process.spawn(_self.nwPath, [main]).on("error",function (err) {
                console.log('TA::启动失败' + err);
            }).on("exit", function () {
                    _self.taOpen = false;
                });
        };
        /**
         * 发送已有队列中的消息给TA
         */
        _self.sendPluginMsgToTA = function () {
            for (var i = 0; i < _self.toTAMSG.length; i++) {
                //TODO:发送消息给TA
                var tempObj = _self.toTAMSG.pop();
                socket && socket.send({type: 'logic', action: 'ifbPlugins', to: 'main', data: {action: tempObj.action, id: tempObj.id}});
            }
        }

        /**
         * 接收给TA的消息
         * @param action
         * @param id
         */
        _self.receiveMsgTOTA = function (action, id) {

            if (action && id != 'undefined' && id != null && action != '' && id != '') {
                var msgObj = {
                    action: action || '',
                    id: id || ''
                }
                _self.toTAMSG.push(msgObj);
                _self.sendPluginMsgToTA();
//                if(_self.taOpen){
//                    _self.sendPluginMsgToTA();
//                }else{
//                    _self.openTeacherAssistant();
//                }

            }
        }
        /**
         * 根据websocket返回的应用列表，同步TA的打开状态，并判断是否发送队列的消息
         * @param list 链接websocket的客户端列表
         * @constructor
         */
        _self.SynStateAndSocket = function (list) {
            if (list.indexOf('main') == -1 && _self.taOpen) {
                _self.taOpen = false;
            } else if (list.indexOf('main') != -1 && _self.taOpen == false) {
                _self.taOpen = true;
                _self.sendPluginMsgToTA();
            }
        }

    }


    exports.Instance = new PluginsMgr();
});
