/**
 * Created with JetBrains WebStorm.
 * User: jhwang
 * Date: 13-8-28
 * Time: 下午4:56
 * 用户行为记录
 */

define(function (require, exports) {

    var ctx = require('./ebookcontext').Instance;

    /***
     * 用户行为类型
     * @type {{SetPage: string, OpenWidget: string, CloseWidget: string, StartImportTeb: string, EndImportTeb: string}}
     */
    var ActionType = {
        /***
         * 页面跳转
         */
        SetPage: 'setpageindex',
        /***
         * 打开某个卡片
         */
        OpenWidget: 'openwidget',
        /***
         * 关闭某个卡片
         */
        CloseWidget: 'closewidget',
        /***
         * 开始导入资源
         */
        StartImportTeb: 'startimportteb',
        /***
         * 导入某个资源完成
         */
        EndImportTeb: 'endimportteb',
        /**
         * 切换一本书
         */
        SetBook:'setbook',
        /**
         * 单双页切换
         */
        SwitchPageView:'switchPageView',
        /**
         * 放大缩小
         */
        ZoomInOrOut:'zoomInOrOut'
    }

    function Trace() {
        var _self = this;

        /**
         * 保存当前打开的卡片ID
         * @type {string}
         * @private
         */
        var _curCardId = "";
        /**
         * 保存当前页码
         * @type {string}
         * @private
         */
        var _curPageIndex = 1;
        var _curBookCode="";

        /**
         * 获取当前打开的卡片ID
         * @returns {string}
         */
        this.getCurCardId = function () {
            return _curCardId;
        }

        var _curPageIndex = 1;

        _self.log = function (module, action, data) {
            if (action === ActionType.SetBook) {
                _curBookCode = data.bookCode;
            }
            if (action === ActionType.SetPage) {
                var params = {'bookCode':_curBookCode};
                params.pageIndex = data.pageIndex;
                callClient('ebagcmd', 'teachersyncturnpage', JSON.stringify(params), 2);
            }
            else if (action === ActionType.OpenWidget) {
                _curCardId = data.cardId;
            }
            else if (action === ActionType.CloseWidget) {
                _curCardId = "";
            }
            else if (action === ActionType.StartImportTeb) {
                var user = ctx.getUser().getName();
                console.log(user,data.bookCode,data.filePath);
                var params = {};
                params['user'] = user;
                params['bookCode'] = data.bookCode;
                params['filePath'] = data.filePath;
                callClient('ebagcmd', 'handleimportstartmsg', JSON.stringify(params), 2);
            }
            else if (action === ActionType.EndImportTeb) {
                var bookCode = data.bookCode;
                console.log(bookCode);
                callClient('ebagcmd', 'handleimportendmsg', "", 0);
            }else if(action===ActionType.SetBook){
                _curBookCode = data.bookCode;

            }
            else if(action===ActionType.SwitchPageView){
                console.log(data);
            }
            else if(action===ActionType.ZoomInOrOut){
                console.log(data);
            }

        };
    }

    exports.Instance = new Trace();
    exports.ActionType = ActionType;
});