﻿/**
 * 画廊卡片
 * @module speechui/cards
 * @author yuwang@iflytek.com
 * @date 2013/06/09
 */
define(function (require, exports, module) {

    require('jquery');
    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplparse = require('../thirdparty/template');

    require('../../view/css/gallerycard.css');

    var speechuiCommon = require('../common/common');
    var speechUIDir = speechuiCommon.getSpeechUIBase();

    /**
     * 响应鼠标滑动翻的鼠标最小滑动距离
     * @type {number}
     */
    var SLIDINGDISTANCE_MIN = 8;

    /**
     * 画廊卡片类构造函数
     * @constructor
     * @param {{
     *     title: string,
     *     imageInfos: Array.<GalleryImageInfo>
     * }}   option 卡片ID
     *
     * @extends {speechui.cards.cardbase.CardBase}
     */
    function GalleryCard(option) {
        if (!('imageInfos' in option)) {
            throw new Error('option Parameters!');
        }

        var _galleryObj = option;                               //图片信息集合
        var _dom;                                               //dom
        var _self = this;                                       //画廊卡片对象
        var _currIndex = 0;                                     //当前图片的索引
        var _imageEles;                                         //图片列表集合
        var _imageDes;                                          //图片描述信息的集合
        var _imageCount;                                        //图片的个数
        var _imagePageNums;                                     //图片索引的集合

        var prePostionX = 0;
        var curPostionX = 0;
        var isDown =false;

        /**
         *初始化画廊卡片
         */
        function init() {
            var tpl = _self.getTemplate();                      //取原始模版

            for (var i = 0; i < _galleryObj.imageInfos.length; i++) {
                var obj = _galleryObj.imageInfos[i];
                obj.index++;
            }

            //对option对象的infoList排序
            _self._sortImgByIndex(_galleryObj.imageInfos);

            option.speechUIDir = speechUIDir;
            var html = tplparse.render(tpl, option);          //模版解析
            _dom = $(html);                                   //为防止卡片间相互影响，使用dom
//            $('body').append(_dom);
            _self.dom = _dom;

            _galleryImgdiv = _dom.find('.gallery_img');
            _eleImgs = _dom.find('.gallery_img ul li img');
            _imageEles = _dom.find('.gallery_img li');
            _imageDes = _dom.find('.gallery_ms span');
            _imagePages = _dom.find('.img_ctrl input');
            _imageUl = _dom.find('.gallery_img ul');
            _imageCount = _galleryObj.imageInfos.length;
            //初始化样式
            _self._showImages(0);
            _self._displayDes(0);

            //设置图片居中样式(图片按照默认尺寸显示)
            _galleryImgdiv.attr("style", "text-align: center;line-height: 450px;");
            $.each(_eleImgs, function (eleIdx, img) {
                $(img).attr("style", "max-height: 450px; max-width: 600px;vertical-align: middle;");
            });

            //默认显示第一个按钮的样式
            _imagePages.eq(0).addClass("btn_flip2");

            _bindEvents();
            //鼠标事件绑定
            _MouseEvent();
        }

        /**
         * 鼠标事件绑定
         * @private
         */
        function _MouseEvent(){
            $(_imageEles).mousedown(_self.onMouseDown);
            $(_imageEles).mousemove(_self.onMouseMove);
            $(_imageEles).mouseup(_self.onMouseUp);
        }
        /**
         * 事件绑定
         * @private
         */
        function _bindEvents() {
            // 上一张图片
            _dom.find('.img_pre').click(function () {
             _self.onPreImg();
            });

            // 下一张图片
            _dom.find('.img_nex').click(function () {
              _self.onNexImg();
            });

            // 按钮
            _dom.find(".img_ctrl input").click(function () {
                var button = $(this);
                var imageIndex = button.index();
                var pageNum = _self._getimagePages();
                _currIndex = imageIndex;
                $(pageNum).removeClass("btn_flip2");
                button.addClass("btn_flip2");
                _self._showImages(_currIndex);
                _self._displayDes(_currIndex);
            });
        }

        /**
         * mouseDown
         * @param e
         */
        this.onMouseDown = function(e){
            if(1 == e.which){                       //这边 3代表的是右键， 2表示中间键 ，1表示左键
                isDown = true;
                var coordinateX = e.originalEvent.x || e.originalEvent.layerX || 0;
                prePostionX = coordinateX;
            }
        }

        /**
         * mouseUp
         * @param e
         */
        this.onMouseUp = function(e){
            if(isDown)
            {
                curPostionX = e.originalEvent.x || e.originalEvent.layerX || 0;
                var offset = curPostionX - prePostionX;
                console.log(offset);
                if(offset > SLIDINGDISTANCE_MIN){                           //上一张
                    _self.onPreImg();
                }
                else if(offset < -SLIDINGDISTANCE_MIN){                    //下一张
                    _self.onNexImg();
                }

                prePostionX = curPostionX;
                isDown = false;
            }
        }

        /**
         * mouseMove
         * @param e
         */
        this.onMouseMove = function(e){
            event.returnValue=false;                 //阻止用户选择页面上的内容
            if(isDown)
            {
                curPostionX = e.pageX;
            }
        }

        /**
         * 上一张
         * @private
         */
        this.onPreImg = function(){
            var pageNum = _self._getimagePages();
            if (_currIndex == 0) {
                _currIndex = _imageCount - 1;
            } else {
                _currIndex = _currIndex - 1;
            }
            pageNum.removeClass("btn_flip2");
            pageNum.eq(_currIndex).addClass("btn_flip2");

            _self._showImages(_currIndex);
            _self._displayDes(_currIndex);
        }

        /**
         * 下一张
         * @private
         */
        this.onNexImg = function(){
            var pageNum = _self._getimagePages();

            if (_currIndex == _imageCount - 1) {
                _currIndex = 0;
            } else {
                _currIndex = _currIndex + 1;
            }
            pageNum.removeClass("btn_flip2");
            pageNum.eq(_currIndex).addClass("btn_flip2");

            _self._showImages(_currIndex);
            _self._displayDes(_currIndex);
        }

        /**
         * 执行动画(从右向左)
         * @private
         */
        this._animationLeft = function () {
            _imageUl.css({"left": "0px"});
            _self._getImageEles().css({"left": "0px"});

            _self._getImageEles().eq(_currIndex).css({"z-index": zIndex});

            _self._getImageEles().eq(_currIndex).css({"left": "800px"});
            _imageUl.animate({left: "-800px"}, "normal");
            zIndex++;
        }

        /**
         * 执行动画(从左向右)
         * @private
         */
        this._animationRight = function () {
            var zIndex = 0;
            _imageUl.css({"left": "0px"});
            _self._getImageEles().css({"left": "0px"});

            _self._getImageEles().eq(_currIndex).css({"z-index": zIndex});

            _self._getImageEles().eq(_currIndex).css({"left": "-800px"});
            _imageUl.animate({left: "800px"}, "normal");
            zIndex++;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageEles = function () {
            return  _imageEles;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageDes = function () {
            return  _imageDes;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getimagePages = function () {
            return  _imagePages;
        }

        /**
         *
         * @returns {jQuery}
         */
        this.getContent = function () {
            return  _dom;
        }

        init();
    }

    GalleryCard.prototype = new _cardbase.CardBase();
    GalleryCard.prototype.constructor = GalleryCard;

    /**
     * 根据图片的index，用冒泡排序法进行排序
     * @param { Array.<GalleryImageInfo> } imgInfoArr 图片信息列表
     * @private
     */
    GalleryCard.prototype._sortImgByIndex = function (imgInfoArr) {
        //外层循环，共要进行arr.length次求最大值操作
        for (var i = 0; i < imgInfoArr.length; i++) {

            //内层循环，找到第i大的元素，并将其和第i个元素交换
            for (var j = i; j < imgInfoArr.length; j++) {

                if (imgInfoArr[i].index > imgInfoArr[j].index) {
                    //交换两个对象的位置
                    var temp = imgInfoArr[i];
                    imgInfoArr[i] = imgInfoArr[j];
                    imgInfoArr[j] = temp;
                }
            }
        }
    }

    /**
     * 图片切换
     * @param {number} index
     */
    GalleryCard.prototype._showImages = function (index) {

        var imageEles = this._getImageEles();

        $.each(imageEles, function (eleIdx, imageEle) {
            if (index == eleIdx) {
                $(imageEle).fadeIn(800);
            } else if(index == 0){
                $(imageEle).hide();
            }else{
                $(imageEle).fadeOut(800);
            }
        });
    }

    /**
     * 显示匹配元素的描述信息
     * @param {number} index
     */
    GalleryCard.prototype._displayDes = function (index) {

        var imageDes = this._getImageDes();

        $.each(imageDes, function (eleIdx, imageDes) {
            if (index == eleIdx) {
                $(imageDes).slideDown();
            } else {
                $(imageDes).hide();
            }
        });
    }

    /**
     * 上一张图片
     * @protected
     */
    GalleryCard.prototype.onPreImg = function () {
        var self = this;
    }

    /**
     * 下一张图片
     * @protected
     */
    GalleryCard.prototype.onNexImg = function () {
        var self = this;
    }

    /**
     * @inheritDoc
     */
    GalleryCard.prototype.getCardName = function () {
        return _define.CardName.Gallery;
    };

    /**
     * @export
     */
    exports.Constructor = GalleryCard;

});