﻿/**
 * SpeechUI 模板处理模块
 * @module speechui/common/resource
 * @date 2013/06/09
 */
define(function (require, exports) {

    var define = require('../define');
    var $ = require('jquery');


    /**
     * 读取文件类容(同步方法!!)
     * @param {string} filePath  文件路径
     * @return {string}
     */
    function readFile(filePath) {
        //filePath = path.trimPosix(filePath);
        var retval;
        var file = cef.fs;
        try {
            retval = file.readAll(filePath);
        } catch (e) {
            console.error(e);
            retval = null;
        }
        return retval;
    }

    /**
    * 初始化SpeechUI
    * @param {speechui.define.CardName} cardName 卡片名称
    * @return {string} 卡片模板
    */
    exports.getTemplate = function (cardName) {

        // TODO：处理本地运行时卡片模板的获取

        var tmpUrl;
        switch (cardName) {
            case define.CardName.EnWordEval:
                tmpUrl = require.resolve('../../view/templates/enwordeval.html#');
                //tmpUrl = require('../../view/templates/enwordeval.js');
                break;
            case define.CardName.CnWordEval:
                tmpUrl = require.resolve('../../view/templates/cnwordeval.html#');
                break;
            case define.CardName.Poetry:
                tmpUrl = require.resolve('../../view/templates/poetry.html#');
                break;
            case define.CardName.Gallery:
                tmpUrl =  require.resolve('../../view/templates/gallerycard.html#');
                break;
            case define.CardName.Situ:
                tmpUrl =  require.resolve('../../view/templates/dialogue.html#');
                break;
            default:
                throw new Error('Unknown cardName:' + cardName);
        }
         tmpUrl=decodeURI(tmpUrl);
        var tpl = '';
        // 本地路径
        /*if(!tmpUrl) return eval('window.'+cardName+'Str');
        else */
        if(tmpUrl.indexOf('file:///') > -1){
            tpl = readFile(tmpUrl.substr('file:///'.length))
        } else{
            $.ajax(tmpUrl, {
                async: false,
                success: function (result) {
                    tpl = result;
                },
                error: function () {
                    throw new Error("get " + cardName + " template error");
                }
            });
        }

        return tpl;
    };
});