/**
 * 定义公用函数库
 * Created with JetBrains WebStorm.
 * User: qmjie
 * Date: 13-9-5
 * Time: 下午3:44
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {

    var path = require('./path');
    var shellcmd = require('./shellcmd');

    /**
     *  禁用拖放打开本地文件操作
     */
    function disabledDragLocalFiles() {
        $(document).bind({
            dragenter: function (e) {
                e.stopPropagation();
                e.preventDefault();
                var dt = e.originalEvent.dataTransfer;
                dt.effectAllowed = dt.dropEffect = 'none';
            },
            dragover: function (e) {
                e.stopPropagation();
                e.preventDefault();
                var dt = e.originalEvent.dataTransfer;
                dt.effectAllowed = dt.dropEffect = 'none';
            }
        });
    }

    function disabledDropLocalFiles() {
        $(document).bind({
            dragover: function (e) {
                e.stopPropagation();
                e.preventDefault();
                var dt = e.originalEvent.dataTransfer;
        //        console.log("common dragover:" + dt.effectAllowed + " | " + dt.dropEffect);
                dt.effectAllowed = dt.dropEffect = 'move';
            },
            dragStart: function (e) {
                return false;
            },
            drop: function (e) {
                return false;
            }
        });
    }

    function newGuid() {
        var guid = "";
        for (var i = 1; i <= 32; i++) {
            var n = Math.floor(Math.random() * 16.0).toString(16);
            guid += n;
            if ((i == 8) || (i == 12) || (i == 16) || (i == 20))
                guid += "-";
        }
        return guid;
    }

    /**
     * 检测网络连接异常接口
     * @param url
     * @param iframe
     * @param tipsStyle
     * @param panel
     * @param handle
     */
    function online(url, iframe, tipsStyle, panel, handle,user) {
        iframe.hide();
        panel.find(".tips_box").remove();
        //显示网络连接提示语
        var tipsBox = $('<div class="tips_box"> ' +
            '<img src="assert/images/waiting.gif"/>' +
            '</div>  ');
        tipsBox.attr("style", tipsStyle);
        panel.append(tipsBox);
        var param ={
            type: "GET",
            url: AppRemoteSvcCfg.OnlineCheckUrl,
            version : AppCfg.version,
            product : AppCfg.product
        };
        if (AppCfg.ajaxTimeOut && AppCfg.ajaxTimeOut > 0) {
            param.timeout = AppCfg.ajaxTimeOut
        }
        $.ajax(param)
            .done(function (data) {
                user.showIsOnline(true);
                panel.find(".tips_box").remove();
                console.log(url);
                iframe.attr("src", url);
                iframe.show();
            })
            .error(function (XMLHttpRequest, textStatus, errorThrown) {
                user.showIsOnline(false);
                panel.find(".tips_box").remove();
                //显示网络连接提示语
                tipsBox = $('<div class="tips_box"> ' +
                    '<img src="assert/images/loader.gif"/>' +
                    '</div>  ');
                tipsBox.attr("style", tipsStyle);
                panel.append(tipsBox);
                tipsBox.html(AppResTipList.badWeb);
                if (handle != undefined)
                    handle();
            });
    }

    /**
     *  清理内存，不建议使用该方法进行内存释放
     */
    function clearMemory(){
        //var emptyPath = path.trimPosix(Config.binPath) + 'empty.exe';
        var tmpPath = path.trimPosix(Config.tmpPath);
        var emptyPath = tmpPath + "/empty.exe";
        var imageName = 'nw.exe';
        shellcmd.shellexecutewithargs(emptyPath,imageName);
    }

    /**
     * 打开外部网页(实现单点登录)
     * @param url
     * @param options {"type":"sso/des","tgt":"",["platform":"changyan[default]/false"]}
     * @param callback function(err,url)
     */
    function openWebPage(url,options,callback){
        var def = jQuery.Deferred();
        var gui = nodereq('nw.gui');
        var fs = nodereq("fs");
        var uli_dat_path = process.execPath.replace('nw.exe', 'uli.dat');
        var security_cr_path = process.env.APPDATA + '\\iflytek\\security.cr';
        var yun_cloud = Base_Cfg.YUN_CLOUD;
        var param_separator = '?';
        var desAttribute = {
            key: 'wyc4yrmK'
        }
        if(!jQuery.isPlainObject(options)){
            callback = options;
            options = undefined;
        }
        if(!jQuery.type(callback) === "function"){
            callback = undefined;
        }

        /**
         * 解析security.cr
         */
        var _list = function (val) {
            if (!val)return false;
            if (val.indexOf('=') == -1) {
                return false
            }
            var userInfo = val.split('=');
            if (userInfo.length != 2) {
                userInfo[1] = val.substr(val.indexOf('=') + 1);
            }
            return {username: userInfo[0], password: userInfo[1]};
        };

        /**
         * 获取用户基本信息
         */
        var getUserInfo = function(){
            var def = jQuery.Deferred();
            try{
                //如果全局缓存了userInfo,则直接返回
                def.resolve(userInfo);
            }catch(e){
                fs.readFile(uli_dat_path, function (error, loginInfo) {
                    if (error) {
                        def.reject(null);
                        return;
                    }
                    try {
                        var userInfo = JSON.parse(loginInfo);
                        if(userInfo){
                            def.resolve(userInfo);
                        }else{
                            def.reject(null);
                        }
                    } catch (e) {
                        console.log(e.message);
                        def.reject(null);
                    }
                });
            }
            return def.promise();
        };

        /**
         * 获取用户登录信息
         */
        var getUserLoginInfo = function(){
            var def = jQuery.Deferred();
            fs.readFile(security_cr_path, function (error, loginInfo) {
                if (error) {
                    def.reject(null);
                    return;
                }
                try {
                    loginInfo = loginInfo.toString();
                    DES.init(desAttribute.key, loginInfo);
                    loginInfo = decodeURIComponent(DES.Encrypt("Decrypt"));
                    loginInfo = _list(loginInfo);

                    //自动登录读取cr文件，password结尾有空字符
                    loginInfo.password = loginInfo.password.replace(/\0/g,"");
                    if(loginInfo.username){
                        def.resolve(loginInfo);
                    }else{
                        def.reject(null);
                    }
                } catch (e) {
                    console.log(e.message);
                    def.reject(null);
                }
            });
            return def.promise();
        };

        /**
         * 获取tgt
         */
        var getTgt = function(options){
            var def = jQuery.Deferred();
            // 读取参数 tgt
            if(jQuery.isPlainObject(options) && options.hasOwnProperty('tgt')){
                def.resolve(options.tgt);
            }else{
                try{
                    // 尝试读取全局userInfo的_sso_tgt属性
                    def.resolve(userInfo && userInfo._sso_tgt || '');
                }catch(e){
                    getUserInfo().done(function(userInfo){
                        if(jQuery.isPlainObject(userInfo) && userInfo.hasOwnProperty('_sso_tgt') && userInfo._sso_tgt){
                            def.resolve(userInfo._sso_tgt || '');
                        }else{
                            def.reject(userInfo);
                        }
                    }).fail(function(e){
                        def.reject(e);
                    });
                }
            }
            return def.promise();
        };

        /**
         * 获取用户ticket(sso登录模式)
         * @param account
         * @param password
         * @returns {*}
         */
        var getSSOTicket = function(account,password){
            var def = jQuery.Deferred();
            SSO.appName = Edc_Cfg.EDC_appName;
            SSO.appKey = Edc_Cfg.EDC_appKey;
            SSO.SSOServerUrl = Edc_Cfg.EDC_SSOServerUrl;
            SSO.client = Edc_Cfg.EDC_client;
            SSO.isCenterSSO = Edc_Cfg.EDC_isCenterSSO;
            SSO.loginRedirectUrl = Edc_Cfg.EDC_loginRedirectUrl;
            SSO.needAttribute = Edc_Cfg.EDC_needAttribute;
            SSO.login(account, password, function (result) {
                if (result != undefined && result.code == "1001" && result.data != undefined && result.data.st != undefined) {
                    var ticket = result.data.st;
                    var tgt = result.data.tgt;
                    try{
                        //重置userInfo里的tgt
                        userInfo._sso_tgt = tgt;
                    }catch(e){
                        console.log(e);
                    }
                    var ticketParam = {
                        data: {
                            service: encodeURI(url)
                        },
                        tgt: tgt,
                        type: 'post'
                    };
                    edcService.Instance().api_sso_v1_ticket_get(ticketParam).done(function (ret) {
                        ret = ret + '';
                        if (ret && ret.indexOf('ST') == 0) {
                            var ticket = ret;
                            def.resolve(ticket);
                        } else {
                            def.reject(false);
                        }
                    }).fail(function (e) {
                        def.reject(e);
                    });
                } else {
                    def.reject(result);
                }
            });
            return def.promise();
        };

        /**
         * 请求ticket
         */
        var requestTicket = function(param){
            var def = jQuery.Deferred();
            edcService.Instance().api_sso_v1_ticket_get(param).done(function (ret) {
                ret = ret + '';
                if (ret && ret.indexOf('ST') == 0) {
                    var ticket = ret;
                    def.resolve(ticket);
                } else {
                    getUserLoginInfo().done(function(loginInfo){
                        var account = loginInfo.loginName;
                        var password = loginInfo.password;
                        getSSOTicket(account,password).done(function(ret){
                            def.resolve(ret);
                        }).fail(function(e){
                            def.reject(e);
                        });
                    }).fail(function(e){
                        def.reject(e);
                    });
                }
            }).fail(function (e) {
                def.reject(e);
            });
            return def.promise();
        };

        var type = options && options.type.toLocaleLowerCase() || 'sso';
        shellcmd.checkOnline().done(function(online){
            // TODO(xinfang3): 2017-01-9 10:35:53,网络状态离线时，仍然请求ticket,网络判断函数需改善.
            if(!online){
                online = true;
            }
            if(online){
                switch(type){
                    case 'sso':
                        // 获取tgt
                        getTgt(options).done(function(tgt){
                            if(tgt){
                                var ticketParam = {
                                    data: {
                                        service: encodeURI(url)
                                    },
                                    tgt: tgt,
                                    type: 'post'
                                };
                                requestTicket(ticketParam).done(function(ret){
                                    var ticket = ret;
                                    var authorizedUrl = url + '&ticket=' + ticket;
                                    callback ? callback(false,authorizedUrl) : gui.Shell.openExternal(authorizedUrl);
                                    def.resolve(authorizedUrl);
                                }).fail(function(e){
                                    callback ? callback(e) : gui.Shell.openExternal(url);
                                    def.reject();
                                });
                            }else{
                                callback ? callback(e) : gui.Shell.openExternal(url);
                                def.reject();
                            }
                        }).fail(function(e){
                            // tgt 不存在，重新请求
                            getUserLoginInfo().done(function(loginInfo){
                                var account = loginInfo.username;
                                var password = loginInfo.password;
                                getSSOTicket(account,password).done(function(ret){
                                    var ticket = ret;
                                    if(url.substr(url.length - param_separator.length) == param_separator || url.substr(url.length - encodeURIComponent(param_separator).length) == encodeURIComponent(param_separator)){
                                        var authorizedUrl = url + 'ticket=' + ticket;
                                    }else{
                                        var authorizedUrl = url + '&ticket=' + ticket;
                                    }
                                    callback ? callback(false,authorizedUrl) : gui.Shell.openExternal(authorizedUrl);
                                    def.resolve(authorizedUrl);
                                }).fail(function(e){
                                    callback ? callback(e) : gui.Shell.openExternal(url);
                                    def.reject();
                                });
                            }).fail(function(e){
                                callback ? callback('获取用户信息失败') : gui.Shell.openExternal(url);
                            });
                        });
                        break;
                    case 'des':
                        if(options && (options.platform + '').toLocaleLowerCase() == 'off') {
                            var loginToUrl = url;
                        }else{
                            var loginToUrl = yun_cloud + "index.php?app=public&mod=PluginLogin&act=index&to=" + encodeURIComponent(url);
                        }
                        getUserInfo().done(function(userInfo){
                            if(jQuery.isPlainObject(userInfo)){
                                var token = userInfo.des_encrypted_userInfo;
                                if(url.substr(url.length - param_separator.length) == param_separator || url.substr(url.length - encodeURIComponent(param_separator).length) == encodeURIComponent(param_separator)){
                                    var authorizedUrl = loginToUrl + "token=" + token;
                                }else{
                                    var authorizedUrl = loginToUrl + "&token=" + token;
                                }
                                callback ? callback(true,authorizedUrl) : gui.Shell.openExternal(authorizedUrl);
                                def.resolve(authorizedUrl);
                            }else{
                                callback ? callback('获取用户信息失败') : gui.Shell.openExternal(url);
                                def.reject();
                            }
                        }).fail(function(e){
                            callback ? callback('获取用户信息失败') : gui.Shell.openExternal(url);
                            def.reject();
                        });
                        break;
                    default:
                        callback ? callback('未集成sso或des模式单点跳转') : gui.Shell.openExternal(url);
                        def.reject();
                        break;
                }
            }else{
                // 离线时跳转原始网页
                callback ? callback('网络异常') : gui.Shell.openExternal(url);
                def.reject();
            }
        });
        return def.promise();
    }

    exports.disabledDragLocalFiles = disabledDragLocalFiles;
    exports.disabledDropLocalFiles = disabledDropLocalFiles;
    exports.newGuid = newGuid;
    exports.online = online;
    exports.clearMemory = clearMemory;
    exports.openWebPage = openWebPage;

})