/**
 * Created with JetBrains WebStorm.
 * User: feiqian
 * Date: 13-12-12
 * Time: 上午10:34
 * To change this template use File | Settings | File Templates.
 */

define(function(require,exports,module){
    /**
     * 事件帮助类
     * @constructor
     */

    function EventUtil()
    {

    }

    (function (methods) {
        for(var  i= 0,len=methods.length;i<len;++i){
            var method=methods[i];
            /**
             *绑定事件
             * @param {object<jQuery>=} element 可以传入事件观察者,这样便于自动释放绑定的事件和相关内存 。
             * @param name 事件名称
             * @param fun  处理函数
             * @returns {*}
             */
            EventUtil.prototype[method]=(function(method){
                return  function (element, name, fun) {
                    this._initEventUtil();
                    var eventName;
                    if (typeof element != 'object') {
                        fun = name;
                        name = element;
                        element = null;
                        eventName = name;
                    }
                    else  eventName = this._getEventName(element, name);
                    //包装原有的回调函数
                    var eventFun = this._getEventFun(element, fun);
                    this._eventObj[method](eventName, eventFun);
                    ++this._bindEventCount;
                    return this;
                }
            })(method)
        }
    })(['on','one']);


    EventUtil.prototype._initEventUtil = function () {
        if (!this._eventObj) {
            this._eventObj = $({});
            this._uuid = 0;
            this._bindEventCount = 0;
        }
    }

    EventUtil.prototype._getEventName=function(element,name){
        var data=element.data('eventUtil');
        if(data===undefined) {
            data=[];
            var _self=this;

            //自动析构
            element.unbind('remove.eventUtil').on('remove.eventUtil',function(){
                _self._unbind(element);
            });
            //每个元素分配一个UUID
            element.data('eventUtilUUID',this._uuid++);
        }

        //不允许重复绑定
        this._unbind(element,name);

        var eventName=name+"."+element.data('eventUtilUUID');
        data.push(eventName);
        element.data('eventUtil',data);
        return eventName;
    }

    EventUtil.prototype._getEventFun=function(element,fun){
       var _self=this;
       return function(event,args){
           if(!args||!element||args[0]===element[0])  {
               //console.dir(fun);
               return fun.apply(
                   _self,[event].concat(Array.prototype.slice.call(arguments,2)));
           }
       };
    }

    /**
     *
     * @param {!jQuery} element
     * @param {string=} name
     */
    EventUtil.prototype._unbind=function(element,name){
        if(element instanceof jQuery)
        {
            var data=element.data('eventUtil');
            if(data)
            {
                var eventName,value;
                if(name) eventName=name+"."+element.data('eventUtilUUID');

                for(var i= 0,len=data.length;i<len;++i)
                {
                    value=data[i];
                    if(eventName)
                    {
                        if(value===eventName) {
                            this._eventObj.unbind(value);
                            data.splice(i,1);
                            --this._bindEventCount;
                            break;
                        }
                    }
                    else {
                        this._eventObj.unbind(value);
                        this._bindEventCount-=1;
                    }
                }
                if(!data.length||!name) element.removeData('eventUtil eventUtilUUID');
                if(!this._bindEventCount) this.eventUtilDestroy();
            }
        }
    }

    EventUtil.prototype.unbind=function(name){
        this._eventObj&&this._eventObj.unbind(name);
    }

    EventUtil.prototype.bind=EventUtil.prototype.on;

    /**
     *
     * @param {object=} element 要想应事件的观察者，如果不设置，则所有绑定该事件的观察者都会触发该事件
     * @param {string} name
     * @param {Array} args
     * @returns {*}
     */

    EventUtil.prototype.trigger=function(element,name,args)
    {
        if(!this._eventObj) return;
        if(typeof element !=='object')
           args=name,name=element,element=null;

        this._eventObj.trigger(name,[element].concat(args));
        return this;
    }

    /**
     *
     * @param {object=} element
     * @param {string} name
     * @param {Array} args
     * @returns {*}
     */
    EventUtil.prototype.triggerHandler=function(element,name,args)
    {
        if(!this._eventObj) return;
        if(typeof element !=='object')
            args=name,name=element,element=null;

        return this._eventObj.triggerHandler(name,[element].concat(args));
    }

    /**
     * 释放内存
     */
    EventUtil.prototype.eventUtilDestroy=function(){
        if(this._eventObj)
        {
            this._eventObj.unbind();
            this._eventObj=null;
        }
    }

    module.exports=EventUtil;
})
