/**
 * 页面跳转类
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-9-5
 * Time: 下午3:36
 * To change this template use File | Settings | File Templates.
 */

/**
 * nw架构下页面跳转后前个页面占用的内存未释放，这里用empty.exe来清内存
 */
define(function (require, exports) {
    var userLog = require('../app/logmgr').Instance;
    var bookAccessor = require('../app/bookshelf/bookaccessor').Instance;
    var shellcmd = require('./shellcmd');
    var commFunc = require('./commonfunc');


    function clearMemory(){
//        var count = sessionStorage.getItem("memoryCount");
//        if(count){
//            count = parseInt(count);
//            if(count > 9){
//                sessionStorage.setItem("memoryCount",1);
//                commFunc.clearMemory();
//            }else{
//                sessionStorage.setItem("memoryCount",count + 1);
//            }
//        }else{
//            sessionStorage.setItem("memoryCount",1);
//        }
        commFunc.clearMemory();
    }

    /**
     * 跳转到bookshelf页面
     * @param user
     */
    function goToBookShelf(user) {
        clearMemory();
        //发送ifb状态给ifs(授课精灵) by njfu
        socket.send({
            action:"cur_ibstatus",
            data:{
                status:2 // (ifb置前 且 上课状态) 1：是，2：否
            },      
            from:"ib",
            id:"",
            to:"iflyslide",
            type:"logic"
        });
        /**
         * 在这里清除订阅主要是为了，在同一个窗口下重复会重复订阅topic，
         * 导致同一个订阅的topic不能正确的接收消息，
         * 且咨询了作者 hproseRclient关闭经常无效 
         * 如果不再使用hprose推送功能后，可去除
         */
        hproseRClient&&hproseRClient.unsubscribe('topic', hproseClientName);
        window.location.href = "bookshelf.html?user=" + user.getName() +
            "&ticket=" + user.getTicket() + "&uid=" + user.getUid()+
            "&userloginname=" + encodeURIComponent(user.getUserLoginName()) +
            "&userName=" + encodeURIComponent (user.getUserName()) + "&p=" + user.getProvince()+
            "&isonline=" + user.getIsOnline() + "&LoginFrom=" + user.getLoginForm()+
            "&isactive=" + user.getIsActive()+
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints()+
            "&books=" + user.getBooks()+
			"&SSOTicket="  + user.getSSOTicket()+
            "&classId=" + user.getUserClassId()+
            "&role=" + user.getUserRole()+
            "&userAppName=" + user.getUserAppName();

    }

    /**
     * 跳转到书架页面并且打开书库--与icw的交互
     */
    function goToBookShelfAndOpenBookLib(){
        clearMemory();
        /**
         * 在这里清除订阅主要是为了，在同一个窗口下重复会重复订阅topic，
         * 导致同一个订阅的topic不能正确的接收消息，
         * 且咨询了作者 hproseRclient关闭经常无效
         * 如果不再使用hprose推送功能后，可去除
         */
        hproseRClient&&hproseRClient.unsubscribe('topic', hproseClientName);
        window.location.href = "bookshelf.html?openlib=1";

    }

    /**
     * 跳转到书架页面并且打开书库--与icw的交互
     */
    function goToBookShelfAndOpenBookLib2(user){
        clearMemory();
        user.getPassword().done(function (pwd) {
            clearMemory();
            /**
             * 在这里清除订阅主要是为了，在同一个窗口下重复会重复订阅topic，
             * 导致同一个订阅的topic不能正确的接收消息，
             * 且咨询了作者 hproseRclient关闭经常无效
             * 如果不再使用hprose推送功能后，可去除
             */
            hproseRClient&&hproseRClient.unsubscribe('topic', hproseClientName);
            window.location.href = "bookshelf.html?user=" +  user.getName() +
                "&ticket=" + user.getTicket() + "&uid=" + user.getUid()+
                "&userloginname=" + encodeURIComponent(user.getUserLoginName())+
                "&userName=" + encodeURIComponent (user.getUserName()) + "&firstload=0&openlib=1"+
                "&photo=" + user.getPhoto()+ "&isactive=" + user.getIsActive()+
                "&pwd=" + encodeURIComponent (pwd)+ "&p=" + user.getProvince()+
                "&phone=" + user.getPhoneNum() + "&LoginFrom=" + user.getLoginForm()+
                "&isonline=" + user.getIsOnline()+
                "&SSOTicket="  + user.getSSOTicket() +
                "&role=" + user.getUserRole()+
                "&userAppName=" + user.getUserAppName();

        });


    }

    /**
     * 从登录界面跳转至书架
     * @param user
     * @param password
     */
    function goToShelfFromLogin(user) {
        user.getPassword().done(function (pwd) {
            clearMemory();
            window.location.href = "bookshelf.html?user=" +  user.getName() +
                "&ticket=" + user.getTicket() + "&uid=" + user.getUid()+
                "&userloginname=" + encodeURIComponent(user.getUserLoginName())+
                "&userName=" + encodeURIComponent (user.getUserName()) + "&firstload=1"+
                "&photo=" + user.getPhoto()+ "&isactive=" + user.getIsActive()+
                "&pwd=" + encodeURIComponent (pwd)+ "&p=" + user.getProvince()+
                "&phone=" + user.getPhoneNum() + "&LoginFrom=" + user.getLoginForm()+
                "&isonline=" + user.getIsOnline()+
                "&SSOTicket="  + user.getSSOTicket() +
                "&role=" + user.getUserRole()+
                "&userAppName=" + user.getUserAppName();

        });
    }

    function goToShelfFromLoginNoAuto(user) {
        user.getPassword().done(function (pwd) {
            clearMemory();
            window.location.href = "bookshelf.html?user=" +  user.getName() +
                "&ticket=" + user.getTicket() + "&uid=" + user.getUid()+
                "&userloginname=" + encodeURIComponent(user.getUserLoginName())+
                "&userName=" + encodeURIComponent (user.getUserName()) + "&firstload=1&noauto=1"+
                "&photo=" + user.getPhoto()+ "&isactive=" + user.getIsActive()+
                "&pwd=" + encodeURIComponent (pwd)+ "&p=" + user.getProvince()+
                "&phone=" + user.getPhoneNum() + "&LoginFrom=" + user.getLoginForm()+
                "&isonline=" + user.getIsOnline()+
                "&SSOTicket="  + user.getSSOTicket() +
                "&role=" + user.getUserRole()+
                "&userAppName=" + user.getUserAppName();

        });
    }

    /**
     * 跳转到login页面
     * @private
     */
    function goToLogin() {
        var EduSSO = require('./sso');
        var edusso = new EduSSO(AppRemoteSvcCfg.SSOUrl, AppRemoteSvcCfg.CycoreSSOUrl);
        edusso.logout(function (result) {
            if (result && result.result) {
                if (result.result == "success") {
                    console.log("SSO logout success");
                    //登出成功处理代码;
                } else {
                    console.log("SSO logout fail");
                    //登出失败处理代码;
                }
            } else {
                console.log("SSO数据：" + result);
            }
        });

        //将单点登录上次的请求时间设为undefined
        sessionStorage["lastCheckSingleLogin"] = undefined;
        userLog.init();
        userLog.sendLog();
        clearMemory();
        window.location.href = "bookshelf.html?logout=1";

    }

    function goToErrorLogin() {
        var EduSSO = require('./sso');
        var edusso = new EduSSO(AppRemoteSvcCfg.SSOUrl, AppRemoteSvcCfg.CycoreSSOUrl);
        edusso.logout(function (result) {
            if (result && result.result) {
                if (result.result == "success") {
                    console.log("SSO logout success");
                    //登出成功处理代码;
                } else {
                    console.log("SSO logout fail");
                    //登出失败处理代码;
                }
            } else {
                console.log("SSO数据：" + result);
            }
        });

        //将单点登录上次的请求时间设为undefined
        sessionStorage["lastCheckSingleLogin"] = undefined;
        userLog.init();
        userLog.sendLog();
        clearMemory();
        window.location.href = "bookshelf.html?logout=1&error=1001";

    }

    /**
     * 跳转到index页面
     * @param bookCode
     * @param user
     */
    function goToIndex(bookCode, user, pageIndex,isU,isOpenTeachingPackage) {
        if (pageIndex == "" || pageIndex == null) {
            pageIndex = 1;
        }
        var url = "index.html?bookCode=" + bookCode +
            "&user=" + user.getName() +  "&ticket=" + user.getTicket() +
            "&userName=" + encodeURIComponent(user.getUserName())  + "&p=" + user.getProvince() +
            "&userloginname=" + encodeURIComponent(user.getUserLoginName())  +
            "&isonline=" + user.getIsOnline() + "&isactive=" + user.getIsActive() +
            "&pageIndex=" + pageIndex + "&uid=" + user.getUid() +
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints() +
            "&books=" + user.getBooks()+
            "&isU=" + isU + "&SSOTicket=" + user.getSSOTicket() +
            "&LoginFrom=" + user.getLoginForm() +
            "&classId=" + user.getUserClassId() +
            "&role=" + user.getUserRole() +
            "&isOpenTeachingPackage=" + isOpenTeachingPackage+
            "&userAppName=" + user.getUserAppName();
        clearMemory();
        /**
         * 在这里清除订阅主要是为了，在同一个窗口下重复会重复订阅topic，
         * 导致同一个订阅的topic不能正确的接收消息，
         * 且咨询了作者 hproseRclient关闭经常无效
         * 如果不再使用hprose推送功能后，可去除
         */
        hproseRClient&&hproseRClient.unsubscribe('topic', hproseClientName);
        window.location.href = url;

    }

    function goToIndex2(bookCode ,user ,menuObj,isU){
        menuObj = menuObj || {};
        var pageIndex = -1,unit1,unit2;
        unit1 = menuObj.unit1,unit2 = menuObj.unit2,unit3 = menuObj.unit3,unit4 = menuObj.unit4;
        if(!unit1){
            pageIndex = 1;
        }
        unit1 = menuObj.unit1 || '';
        unit2 = menuObj.unit2 || '';
        unit3 = menuObj.unit3 || '';
        unit4 = menuObj.unit4 || '';
        var url = "index.html?bookCode=" + bookCode +
            "&user=" + user.getName() +  "&ticket=" + user.getTicket() +
            "&userName=" + encodeURIComponent(user.getUserName())  + "&p=" + user.getProvince() +
            "&userloginname=" + encodeURIComponent(user.getUserLoginName())  +
            "&isonline=" + user.getIsOnline() + "&isactive=" + user.getIsActive() +
            "&pageIndex=" + pageIndex + "&uid=" + user.getUid() +
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints() +
            "&books=" + user.getBooks()+
            "&isU=" + isU + "&SSOTicket=" + user.getSSOTicket() +
            "&LoginFrom=" + user.getLoginForm() +
            "&classId=" + user.getUserClassId() +
            "&role=" + user.getUserRole() +
            "&userAppName=" + user.getUserAppName() +
            "&unit1=" + unit1 +
            "&unit2=" + unit2 +
            "&unit3=" + unit3 +
            "&unit4=" + unit4;
        clearMemory();
        /**
         * 在这里清除订阅主要是为了，在同一个窗口下重复会重复订阅topic，
         * 导致同一个订阅的topic不能正确的接收消息，
         * 且咨询了作者 hproseRclient关闭经常无效
         * 如果不再使用hprose推送功能后，可去除
         */
        hproseRClient&&hproseRClient.unsubscribe('topic', hproseClientName);
        window.location.href = url;
    }


    function defaultUserGoToIndex(bookCode,pageIndex){
        if (pageIndex == "" || pageIndex == null) {
            pageIndex = 1;
        }
        var url = "index.html?bookCode=" + bookCode +
            "&user=defaultuser&ticket=&userName=&p=&userloginname=&isonline=true&isactive=false&pageIndex="
            + pageIndex + "&uid=0&phone=&points=0&books=0&isU=&SSOTicket=undefined&LoginFrom=&classId=&role=undefined&userAppName=undefined";

        clearMemory();
        window.location.href = url;


    }


    function goToWhiteBoard(user) {
        var url = "";
        clearMemory();
        bookAccessor.getLast3BookInfo(user).done(function (booklist) {
            if (booklist.length != 0 ) {
                if(booklist[0].isU){
                    shellcmd.checkU(booklist[0].isU,user.getName()).done(function(ret){
                        if(ret){
                            url = goWBhelper1(user,booklist[0].bookCode,booklist[0].lastPage,booklist[0].isU);
                            window.location.href = url;
                        }
                        else{
                            //url = goWBhelper2(user);
                            url = goWBhelper1(user,AppCfg.testBook,booklist[0].lastPage,"");
                            window.location.href = url;
                        }
                    });
                }
                else{
                    url = goWBhelper1(user,booklist[0].bookCode,"1","");
                    window.location.href = url;
                }
            }
            else {
                //url = goWBhelper2(user);
                url = goWBhelper1(user,AppCfg.testBook,"1","");
                window.location.href = url;
            }


        });
    }

    function goWBhelper1 (user,bookCode,lastPage,isU){
       var  url = "index.html?bookCode=" + bookCode+
            "&user=" + user.getName() + "&isWB=1"+
            "&userName=" + encodeURIComponent(user.getUserName()) +
            "&ticket=" + user.getTicket() + "&SSOTicket=" + user.getSSOTicket()+
            "&isonline=" + user.getIsOnline() + "&isactive=" + user.getIsActive()+
            "&pageIndex=" + lastPage +
            "&p=" + user.getProvince() + "&uid=" + user.getUid()+
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints()+
            "&books=" + user.getBooks()+
            "&userloginname=" + encodeURIComponent( user.getUserLoginName()) +
            "&isU=" + isU +
            "&LoginFrom=" + user.getLoginForm() +
            "&classId=" + user.getUserClassId()+
            "&role=" + user.getUserRole()+
            "&userAppName=" + user.getUserAppName();
        return url ;
    }

    function goWBhelper2(user){
        var url = "singleWB.html?" + "&user="  + user.getName()  +
            "&ticket=" + user.getTicket() + "&isonline=" + user.getIsOnline() +
            "&isactive=" + user.getIsActive() + "&points=" + user.getPoints() +
            "&books=" + user.getBooks()+
            "&phone=" + user.getPhoneNum() + "&userName=" + encodeURIComponent( user.getUserName()) +
            "&p=" + user.getProvince() +
            "&uid=" + user.getUid() + "&userloginname=" +  encodeURIComponent( user.getUserLoginName()) +
            "&SSOTicket="  + user.getSSOTicket() +
            "&isU=&LoginFrom=" + user.getLoginForm() +
            "&classId=" + user.getUserClassId()+
            "&role=" + user.getUserRole()+
            "&userAppName=" + user.getUserAppName();
        return url ;
    }

    exports.goToShelfFromLogin = goToShelfFromLogin;
    exports.goToShelfFromLoginNoAuto = goToShelfFromLoginNoAuto;
    exports.goToBookShelf = goToBookShelf;
    exports.goToLogin = goToLogin;
    exports.goToErrorLogin = goToErrorLogin;
    exports.goToIndex = goToIndex;
    exports.goToIndex2 = goToIndex2;
    exports.goToBookShelfAndOpenBookLib = goToBookShelfAndOpenBookLib;
    exports.goToBookShelfAndOpenBookLib2 = goToBookShelfAndOpenBookLib2;
    exports.goToWhiteBoard = goToWhiteBoard;
    exports.defaultUserGoToIndex = defaultUserGoToIndex;
});