/**
 * Created with JetBrains WebStorm.
 * User: feiqian
 * Date: 13-12-9
 * Time: 下午2:03
 * To change this template use File | Settings | File Templates.
 */

//滑动插件
define(function(require,exports,module){
    var defaults={
       distance:200,//鼠标水平滑动的距离为distance时产生滑动
       element:null,//滑动要绑定在哪个元素上面,
       disabled:false, //是否禁用滑动
       deltaTime:200 //鼠标按下到释放的时间不能超过这个值
    }

    var EventUtil=require('./eventUtil');
    function Slide(obj){
       this.setOption(obj);
    }

    Slide.prototype=new EventUtil();
    Slide.prototype.constructor=Slide;


    Slide.prototype.setOption=function(obj){
       if(obj) {
           var isOldDraggable;
           if(!this._options) {
               isOldDraggable=!defaults.disabled;
               this._options=$.extend({},defaults,obj);
           }
           else  {
               isOldDraggable=this._options.disabled;
               $.extend(this._options,obj);
           }

           if(this._options.disabled!=isOldDraggable||(obj.element&&obj.element!==this._options.element))
           {
               this._options.disabled?this._setUnSlideAble():this._setSlideAble();
           }
       }
    }

    Slide.prototype._setSlideAble=function(){

        if(!this._options.element)  return;

        this._setUnSlideAble();
        var _self=this;
        var isMouseDown=false,startX,startTime;
        var element=this._options.element;
        element.on('mousedown.slide',function(e){
            isMouseDown = true;
            startX = e.clientX;
            startTime=new Date().getTime();
        }).on('mouseup.slide mouseout.slide',function(e){
            if(isMouseDown){
                var horizonOffset = e.clientX - startX;
                var deltaTime=new Date().getTime()-startTime;
                //console.log(deltaTime,horizonOffset);
                if(deltaTime<=_self._options.deltaTime)
                {
                    if(horizonOffset>_self._options.distance){
                        _self.trigger(element,'slideRight');
                    }
                    else if(horizonOffset<-_self._options.distance){
                        _self.trigger(element,'slideLeft');
                    }
                    isMouseDown=false;
                }

            }
        });
    }

    Slide.prototype._setUnSlideAble=function(){
       this._options.element.unbind('.slide');
    }

    Slide.prototype.getContent=function(){
        return this._options.element;
    }

    module.exports=Slide;
});
