/**
 * Created with JetBrains WebStorm.
 * function：任务队列管理类，主要用于处理上传文件的上传状态消息
 * User: qmjie
 * Date: 13-10-29
 * Time: 上午11:56
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {

    function TaskQueue() {
        var taskList = [];

        //判断任务列表是否为空
        this.isEmpty = function(){
            return taskList.length <= 0;
        };
        //清除任务列表
        this.clearTask = function(){
            taskList = [];
        };

        //添加任务
        this.addTask = function (task) {
            taskList.push(task);
        };

        //执行任务
        this.doTask = function (task) {
            if( this.isEmpty() ){
               //气泡已由delphi来直接完成，通知功能将更加丰富。
               // showUploadTips(task.time,task.status,task.msg);
            }
            this.addTask(task);
        };

        /**
         * 显示上传提示信息
         * @param time
         * @param resultOptions
         * @param unitName 可选
         */
         function showUploadTips(time, resultOptions, msg) {
            if (!time || !resultOptions) return;

            //生成提示信息DIV
            var panel = $('<div class="wy_tippop" id="uploadTips"> ' +
                '<div class="wytp_left"></div>' +
                '<div class="wytp_cen"><img id="upLogoImg"/><div id="uploadTipsContent" style="width: 182px"></div><div id="closeBtnDiv"></div></div>' +
                '<div class="wytp_right"></div>');
            $('body').append(panel);
            //根据上传提示类型确定panel UI，正在上传，上传成功，上传失败
            var _upLogoImg = panel.find("#upLogoImg");
            var _uploadTipsContent = panel.find("#uploadTipsContent");
            var imgUrl = "";
            var uploadTipsContent = '<span style="white-space:nowrap; text-overflow:ellipsis; -o-text-overflow:ellipsis; overflow:hidden;">{0}</span>' + '<p>{1}</p>';
            if (resultOptions == "start") {
                imgUrl = "assert/images/wy_uplo.png";
                uploadTipsContent = uploadTipsContent.format(AppUploadTips.BeginUploadMsg, msg);
                _uploadTipsContent.attr("class", "wytpc_p green");
            }
            else if (resultOptions == "success") {
                imgUrl = "assert/images/wy_upsuc.png";
                uploadTipsContent = uploadTipsContent.format(msg, AppUploadTips.UploadSuccessMsg);
                _uploadTipsContent.attr("class", "wytpc_p green");
            }
            else if (resultOptions == "fail") {
                //关闭按钮
                var _closeBtnDiv = panel.find("#closeBtnDiv");
                _closeBtnDiv.attr("class", "wy_clo");
                _closeBtnDiv.append($('<a id="closeBtn"></a>'));

                imgUrl = "assert/images/wy_upwro.png";
                uploadTipsContent = uploadTipsContent.format(msg, AppUploadTips.UploadFailMsg);
                _uploadTipsContent.attr("class", "wytpc_p red");
            }
            _upLogoImg.attr("src", imgUrl);
            _uploadTipsContent.html(uploadTipsContent);

            panel.css({
                position: 'absolute',
                zIndex: 1000,
                left: $(window).width(),
                bottom: 10
            });
            panel.animate({ 'opacity': '1', 'left': $(window).width() - panel.width()}, 'slow');

            if (resultOptions == "fail") {//上传失败
                var _closeBtn = panel.find("#closeBtn");
                _closeBtn.click(function () {
                    panel.animate({'opacity': '0', 'left': $(window).width()}, 'slow', function () {
                        $(this).remove();
                    });
                });
                setTimeout(function(){
                    //触发执行下一任务
                    nextTask();
                },time);

            }
            else {
                //定时关闭
                setTimeout(function () {
                    panel.animate({'opacity': '0', 'left': $(window).width()}, 'slow', function () {
                        $(this).remove();
                        //触发执行下一任务
                        nextTask();
                    });
                }, time);
            }
        }

        /**
         * 显示下一条上传提示信息
         */
        function nextTask(){
            taskList.shift();
            if(taskList[0])
                showUploadTips(taskList[0].time,taskList[0].status,taskList[0].msg);
        }
    }

    exports.Instance = new TaskQueue();

});
