/**
 * Created by zzsun on 15-2-6.
 */
    ;
define(function(require,exports){

    var homework = require('./app/book/homework/homework').Instance;
    var _path = require('./common/path');
    var shellcmd = require("./common/shellcmd");
    var commonfunc = require("./common/commonfunc");
    var childProcess = nodereq('child_process');
    var ebookContext = require('./app/ebookcontext').Instance;
    var pageNavigatorHelper = require('./common/pagenavigatorhelper');
    var bookAccessor = require('./app/bookshelf/bookaccessor').Instance;
    var classSelector = require('./classSelector');
    var wbKtsl = require('./app/book/toolbar/ktsl');
    var syncRecommend = require('./app/book/smartbar/SyncRecommend');
    var confirmExit = require("./common/confirmExit");

    var TA_APP = {
        //空
        "TA_APP_NONE": 'none',
        //TA主程序
        "TA_APP_MAIN": 'main',
        //iFlyBook
        "TA_APP_IB": 'ib',
        //托盘
        "TA_APP_TRAY": 'tray',
        //课件制作工具
        "TA_APP_ICW": 'icw',
        // 上传下载
        "TA_APP_DUM": 'ta_dum',
        //作业
        "TA_APP_HOMEWORK":"homework",
        //所有
        "TA_APP_ALL": 'all',
        //答题器
//        "TA_APP_VOTE":"vote-control"
        "TA_APP_VOTE":"vote-main"//答题器架构调整
    };

    var TAMSG = {
        "TAMSG_TYPEKEY": "type",
        "TAMSG_ACTIONKEY": "action",
        "TAMSG_FROMKEY": "from",
        "TAMSG_TOKEY": "to",
        "TAMSG_IDKEY": 'id',
        "TAMSG_DATAKEY": "data",
        "TAMSG_RETURNKEY": "return"
    }

    var TYPE = {
        'CONN': 'conn',
        'LOGIC': 'logic'
    };

    var CMD = {

        "IFB_INNER_KTSL":'ifb_inner_ktsl',
        //register
        "TAMSG_REGISTER": 'register',
        //quit
        "TAMSG_QUIT": 'quit',
        //login
        "TAMSG_LOGIN": 'login',
        "TA_IFSLESSON":'lesson',
        //logout
        "TAMSG_LOGOUT": 'logout',
        //list
        "TAMSG_LIST":"list",
        //畅言云有消息
        "TAMSG_HASMSG": 'msg',
        //打开面板
        'TAMSG_OPENPANEL': 'main',
        //打开反馈和客服
        "TAMSG_OPENFEEDBACK": 'feedback',
        //打开消息中心
        "TAMSG_OPENMSGCENTER": 'msgcenter',
        //通知退出
        "TAMSG_NOTIFYEXIT": 'exit',
        //下载回调
        "TAMSG_DOWNLOAD_GETRES": 'download_getres',
        // 下载回调
        "TAMSG_TADUM_DOWNLOAD": 'ta_download_process',
        "TAMSG_TADUM_DOWNLOAD_CANCEL" : 'ta_download_cancel',
        //高拍仪回调
        "TAMSG_CameraInfo" : 'cameraInfo',
        // 截图回调
        "TAMSG_SCREENSHOT" : 'screenshotInfo',
        //快照回调
        "TAMSG_SNAPSHOT" : 'snapshotInfo',
        "TAMSG_AUDIOTOOL" : 'audioInfo',
        //浮动工具栏消息
        "TAMSG_FLOATTOOLBAR_IB_MIN":'floattoolbar_ib_min',
        "TAMSG_FLOATTOOLBAR_IB_MAX":'floattoolbar_ib_max',
        "DISPLAYCHANGE" : 'displaychange',
        "UPLOADCALLBACK" : 'upload',

        "TA_UPLOAD":"ta_upload",
        "TA_UPLOAD_PROGRESS":'ta_upload_process',
        //分享为动态
        "T_SHARE":'T_share',
        //发布为作业
        "T_HOMEWORK":'T_public',
        //打开作业
        "T_HOMEWORK_OPEN":"homework_open",
        "T_HOMEWORK_BACK":"homework_ib_back",

        //加密狗
        "WATCHDOG_EXIST_RESULT":"watchdog_exist_result",

        //打开书本
        "OPEN_BOOK":"openbook",
        "OPEN_BOOKSHELF":"openbookshelf",
        "IFS_OPEN_BOOK":"goto_book",

        //刷新TA书本
        "REFRESH_TA_BOOK":"refreash_ta_book",

        "ICW_REFER_IFB":"icw_open_ib",

        "CAPTURE_OK":'capture_ok',
        //授课精灵_ifs_ifb
        "MOVE_IBPAGE":"move_ibpage", //翻页
        "ZOOM_IBPAGE":"zoom_ibpage"  //缩放
    };

    var UP_LOAD_TYPE = {                       //区分动态和作业
        HOMEWORK: 'upload_file',
        MESSAGE : 'attachments',
        IbResource: 'multiFile',
        Prepare: 'file' ,//iflybook备课上传
        KTSL_IB_UPLOAD:'ifb_ktsl_upload',
        SYNC_Recommend:'syncRecommend_upload',
        MTBK_IB_UPLOAD:'ifb_mtbk_upload', //mtbk文件上传
        WIDGET_IB_UPLOAD:'ifb_widget_upload' //widget文件上传
    };

    //加密狗限制
    var dongleAction = null;
    var DONGLE_ACTION = {
        HOTSPOT    :"hotspot",
        MAINTOOLBAR:"maintoolbar",
        EVALCARD:"evalcard",
        TTS:"tts",
        TTSEVALCARD:"ttsevalcard",
        RECOGNISE:"recognise"
    };
    function setDongleAction(type){
        dongleAction = type
    }


    //评测卡片
    var evalCard = null;
    var evalCardClickEvent = null;
    function setEvalCard(obj,event){
        evalCard = obj;
        evalCardClickEvent = event;
    }

    //TTS合成
    var ttsObj = null;
    var language,speecher;
    function setTTSObj(obj,lan,speech){
        ttsObj = obj;
        language = lan;
        speecher = speech;
    }

    //TTS评测卡片
    var ttsEvalCardObj = null;
    var cardLanguage,cardType,cardSpeecher;
    function setTTSEvalCard(obj,lan,type,speech){
        ttsEvalCardObj = obj;
        cardLanguage = lan;
        cardType = type;
        cardSpeecher = speech;
    }

    //黑板识别
    var recogniseObj = null;
    var recogniseType;
    function setRecogniseObj(obj,type){
        recogniseObj = obj;
        recogniseType = type;
    }

    //答题器
    var voteOpen = false;
    function getVoteStatus(){
        return voteOpen;
    }

    //TA main程序
    var tamain = true;//iflybook是从ta打开，所以默认iflybook打开的时候TA总是开的
    function getTamainStatus(){
        return tamain;
    }


    //TA首页打开书本
    var currentBookCode = -1;
    function setCurrentBookCode(bookcode){
        currentBookCode = bookcode;
    }

    var isBlackboard = false;
    function setCurrentState(state){
        isBlackboard = state;
    }

    /**
     * 处理因socket未连接上导致的监管数据不能发送的问题
     */
    function handPreStatics(){
        if(!app_global_statics) return;
        var obj = {
            type:'logic',
            action:'statistics',
            to:'tray',
            data:{
                userId:ebookContext._curUser._uid,
                event:app_global_statics.statics?'16011005':'16011004',
                objectId:'',
                objectType:'',
                moduleId:'16011002',
                extensions:'',
                inputData:''
            }
        };
        app_global_statics = null;
        socket&&socket.send(obj);
        /**
         * 修改一下，作为备课的次数再次发送
         * @type {string}
         */
        obj.data.event = '16011011';
        socket&&socket.send(obj);
    }

    function ibWSLogic(receive){
        console.log("收到的信息内容::"+ receive);
        if(receive){
            handPreStatics();
            var _type = receive.type,
                _action = receive.action,
                _from = receive.from,
                _to = receive.to,
                _data = receive.data,
                _return = receive.return;
            if(_to == TA_APP.TA_APP_IB || _to == TA_APP.TA_APP_ALL){
                console.log("收到新消息");
                console.log(receive);
                console.log(JSON.stringify(receive));
                //连接相关
                if(_type=='conn'){
                    switch (_action){
                        case CMD.TAMSG_REGISTER:
                            //客户端注册收到的消息
                            if(_return.code ==0 ){
                                console.log("注册成功");
                            }
                            break;
                        case CMD.TAMSG_QUIT:
                            //客户端断开连接收到的消息
                            if(_return.code ==0 ){
                                console.log("socket客户端退出");
                            }
                            break;
                        case CMD.TAMSG_LIST:
                            var sendFlag = receive.return;
                            if(!sendFlag){
                                var list = _data.list;
                                //对插件化的处理
                                app_PluginMgr && app_PluginMgr.SynStateAndSocket(list);
                                homework.isOpen = false;
                                voteOpen = false;
                                tamain = true;
                                for(var i=0,length=list.length; i<length; i++){
                                    if(list[i] === TA_APP.TA_APP_HOMEWORK){
                                        homework.isOpen = true;
                                    }
                                    if(list[i] === TA_APP.TA_APP_VOTE){
                                        voteOpen = true;
                                    }
                                }
                                for(var i=0,length=list.length; i<length; i++){
                                    if(list[i] === TA_APP.TA_APP_MAIN ){
                                        tamain = true;
                                        global_tamain && handleOpenDTBDetail();
                                        global_tamain = false;
                                        global_tamain_record && handleOpenRecordDetail();
                                        global_tamain_record = false;
                                        global_tamain_icw && handleOpenICWDetail();
                                        global_tamain_icw = false;
                                        break;
                                    }
                                    tamain = false;

                                }
                            }
                            break;
                    }
                }
                //业务相关
                if(_type=='logic'){
                    switch (_action){
                        case CMD.IFB_INNER_KTSL:
                           !_return && wbKtsl.createElementFile(_data);
                            break;
                        case CMD.TAMSG_LOGIN:
                            // 这里接收由托盘注册发出的login消息不再处理，会引起书库二次登录问题
                            // handleLogin(_from);
                            break;
                       /* case CMD.TA_IFSLESSON:
                            if(_from=="iflyslide") {
                                if (_data.motion == "start") {
                                    app_global_MainToolbar.changeClassStatus(true);
                                } else if (_data.motion == "stop") {
                                    app_global_MainToolbar.changeClassStatus(false);
                                }
                            }
                            break;*/
                        case CMD.TAMSG_LOGOUT:
                            gui.App.argv[0] = ""; 
                            // handleLogOut(_from);
                            //需求变更，TA端退出登录后iflybook关闭进程 by njfu
                            confirmExit.saveBookData().done(function(){
                                confirmExit.ForceExit();
                            });
                            break;
                        case CMD.TAMSG_DOWNLOAD_GETRES:
                            handleDownload(_data);
                            break;
                        case CMD.TAMSG_TADUM_DOWNLOAD:
                            if(_data.key  && _data.key == UP_LOAD_TYPE.Prepare) {
                                //备课模块文件上传
                                app_global_prepareSource.onMessageReceived(_data);
                            } else {
                                handleTadumDownload(_data);
                            }
                            break;
                        case CMD.TAMSG_TADUM_DOWNLOAD_CANCEL:
                            handleTadumDownloadCancel(_data);
                            break;
                        case CMD.TAMSG_CameraInfo:
                            handleCamera(_data);
                            break;
                        case CMD.TAMSG_SCREENSHOT :
                            handleScreenShot(_data);
                            break;
                        case CMD.TAMSG_SNAPSHOT:
                            handleSnapShot(_data);
                            break;
                        case CMD.TAMSG_AUDIOTOOL :
                            handleAudioTool(_data);
                            break;
                        case CMD.TAMSG_FLOATTOOLBAR_IB_MIN:
                            handleMinimiseWin();
                            break;
                        case CMD.TAMSG_FLOATTOOLBAR_IB_MAX:
                            handleMaxmiseWin();
                            break;
                        case CMD.TAMSG_NOTIFYEXIT:
                            handleIFBExit();
                            break;
                        case CMD.DISPLAYCHANGE:
                            handleDisplayChange();
                            break;
                        case CMD.UPLOADCALLBACK:
                            handleUploadCallback(_data);
                            break;
                        //T型需求新增
                        case CMD.TA_UPLOAD_PROGRESS:
                            handleTupload(_data);
                            break;
                        case CMD.TA_UPLOAD:
                            handleTupload(_data);
                            break;
                        case CMD.T_SHARE:
                            // handleTshare(_data);
                            break;
                        case CMD.T_HOMEWORK:
                            homework.isSending = true;
                            handleThomework(_data);
                            break;
                        case CMD.T_HOMEWORK_OPEN:
                            handleThomeworkOpen();
                            break;
                        case CMD.WATCHDOG_EXIST_RESULT:
                            handleWatchDog(_data);
                            break;
                        case CMD.OPEN_BOOK:
                            shellcmd.appSetAlwaysTop(null,null,'课本教学');
                            handleOpenBook(_data);
                            break;
                        case CMD.IFS_OPEN_BOOK:
                            shellcmd.appSetAlwaysTop(null,null,'课本教学');
                            handleGotoBook(_data);
                            break;
                        case CMD.OPEN_BOOKSHELF:
                            shellcmd.appSetAlwaysTop(null,null,'课本教学');
                            handleOpenBookshelf();
                            break;
                        case CMD.ICW_REFER_IFB:
                            handleReferIFB(_data);
                            break;
                        case CMD.CAPTURE_OK:
                            handleCaptureOK(_data);
                            break;
                        case CMD.MOVE_IBPAGE:
                            if(_from == "iflyslide"){
                                if(_data && _data.action === 1){
                                    console.log("上一页");
                                    $("#btnRightPrePage").trigger("click");
                                }else if(_data && _data.action === 2){
                                    console.log("下一页");
                                    $("#btnRightNextPage").trigger("click");
                                }
                            }
                            break;
                        case CMD.ZOOM_IBPAGE:
                            if(_from == "iflyslide"){
                                if(_data && _data.action === 1){
                                    console.log("放大");
                                    $("#btnZoomIn").trigger("click");
                                }else if(_data && _data.action === 2){
                                    console.log("缩小");
                                    $("#btnZoomOut").trigger("click");
                                }
                            }
                            break;
                        // 王哒哒修改
                        //通过托盘打开书架
                        case CMD.TAMSG_OPENPANEL:
                            shellcmd.showApp();    
                            break;
                        default :
                            break;
                    }
                }
            }
        }
    }

    function handleOpenDTBDetail(){
        var json = {
            to : "main",
            action : "ifbPlugins",
            data : {
                id:15

            }
        };
        socket.send(json);
    }

    function handleOpenRecordDetail(){
        var json = {
            to : "main",
            action : "ifbPlugins",
            data : {
                id:64

            }
        };
        socket.send(json);
    }


    function handleCamera(data){
        var dataArr = data.split('|');
        var obj = {'evt':'','data':''};
        obj.evt =dataArr[0];
        obj.data = dataArr[1].replace(/\\/g,'/');
        onClientInvoked2(JSON.stringify(obj));
    }

    function handleScreenShot(data){
        var dataArr = data.split('|');
        var obj = {'evt':'','data':''};
        obj.evt =dataArr[0];
        obj.action = CMD.TAMSG_SCREENSHOT;
        obj.data = dataArr[1].replace(/\\/g,'/');
        onClientInvoked2(JSON.stringify(obj));
    }

    function handleSnapShot(data){
        var dataArr = data.split('|');
        var obj = {'evt':'','data':''};
        obj.evt =dataArr[0];
        obj.action = CMD.TAMSG_SNAPSHOT;
        obj.data = dataArr[1].replace(/\\/g,'/');
        onClientInvoked2(JSON.stringify(obj));
    }

    function handleAudioTool(data) {
        var dataArr = data.split('|');
        var obj = {'evt':'','data':''};
        obj.evt =dataArr[0];
        obj.data = dataArr[1].replace(/\\/g,'/');
        onClientInvoked2(JSON.stringify(obj));
    }

    function handleDownload(data){
        console.error('isWSlogic'+data);
        var dataArr = data.split('|');
        var obj = {evt:'',data:{id:'',progress:'',sourcepage:''}};
        obj.evt = 'file_download';
        obj.data.id = dataArr[1];
        obj.data.progress = parseInt(dataArr[2])/100 ;

        callClient('syscmd' , 'downloadcallback' , data , 0 , 0);
    }

    function handleTadumDownload(data){
//        console.error('TAdum download callback: ' + data);请问这里是谁加的？我给你改了-- by linwang5 --2015-12-18
        console.log('%c TAdum download callback: ' + data,'color:red');
        console.log(data);
        var obj = {evt:'file_download',data:{
            id:data.id,
            progress:'',
            sourcepage:data.sourcepage
        }}
        if (data.process < 100) {
            obj.data.progress = (data.process/100).toString();
            onClientInvoked2(JSON.stringify(obj));
			
			if(data.process == -1){
                app_DownloadQueue.dele(data.id);
                $(document).dequeue("selectedIds");
            }
			
        } else if (data.process == 100) {
            var basePath = _path.trimPosix(Config.binPath).replace(/\\/g,'/');
            if (basePath[basePath.length-1] != '/') basePath += '/';
            obj.data.progress = '2';
            obj.data.file = data.file.replace(/\\/g,'/');
            obj.data.rawData = JSON.parse(data.raw_data);
            if (obj.data.file.substr(0, basePath.length) == basePath)
                obj.data.file = obj.data.file.substring(basePath.length, obj.data.file.length);
            var idx = 0;
            if (typeof obj.data.rawData.thumbnail == 'string' && obj.data.rawData.thumbnail.substr(0, 4) == 'http') {
                obj.data.thumbnail = data.extra_download[idx++].file[0].replace(/\\/g,'/');
                if (obj.data.thumbnail.substr(0, basePath.length) == basePath)
                    obj.data.thumbnail = obj.data.thumbnail.substring(basePath.length, obj.data.thumbnail.length);
            } else {
                obj.data.thumbnail = '';
            }
            if (typeof obj.data.rawData.photo == 'string' && obj.data.rawData.photo.substr(0, 4) == 'http') {
                obj.data.photo = data.extra_download[idx++].file[0].replace(/\\/g, '/');
                if (obj.data.photo.substr(0, basePath.length) == basePath)
                    obj.data.photo = obj.data.photo.substring(basePath.length, obj.data.photo.length);
            } else {
                obj.data.photo = '';
            }

            app_DownloadQueue.dele(data.id);
            //暂时不知道callClient downloadcallback2 是为了做什么的 但是会导致程序崩溃 所以注解掉了  by linwang5
            if(data.sourcepage == 'webMtbkImport'){
                onClientInvoked2(JSON.stringify(obj));
            }else if(data.sourcepage == "booklibres"){
                onClientInvoked2(JSON.stringify(obj));
            }else{
                callClient('syscmd', 'downloadcallback2', JSON.stringify(obj.data), 0, 0);
                onClientInvoked2(JSON.stringify(obj));
            }


            //监管
            if(data.sourcepage != 'booklib' && data.sourcepage != 'booklibres'){
                var action = LogManager.action.download;
                var params = {};
                params.module = '1130108';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                params.resource_id = obj.data.id;
                LogManager.statistics(action,params);
            }else if(data.sourcepage == 'booklib'){
                var action = LogManager.action.download;
                var params = {};
                params.module = '1130107';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                params.resource_id = obj.data.id;
                LogManager.statistics(action,params);
            }else if(data.sourcepage == 'booklibres'){
                var action = LogManager.action.download;
                var params = {};
                params.module = '1130109';
                var user_id = ebookContext.getUser().getUid();
                if(user_id != '0' && user_id){
                    params.user_id =user_id;
                }
                params.resource_id = obj.data.id;
                LogManager.statistics(action,params);
            }
            $(document).dequeue("selectedIds");
        }
    }

    function handleTadumDownloadCancel(data) {
//         console.log(data);
        if (typeof data.id == 'string') {
            shellcmd.confirmCancel(data.id);
        }
        app_DownloadQueue.dele(data.id);
        $(document).dequeue("selectedIds");
    }

    function handleMinimiseWin(){
//    console.error('handle minimise')
        WIN.minimize();
    }

    function handleMaxmiseWin(){
//    console.error('handle maxmise')
        WIN.restore();
    }

    function handleIFBExit(){
        //退出前保存数据
        confirmExit.saveBookData().done(function() {
            $(window).trigger('realexit');
        });
    }

    function handleLogOut(_from){
        if(_from != TA_APP.TA_APP_IB){
            if(_from == TA_APP.TA_APP_MAIN && (ebookContext.getUser().getName() == AppCfg.defaultuser)){
                return;
            }
            //退出前保存数据
            confirmExit.saveBookData().done(function(){
                window.location.href = "bookshelf.html?logout=1&noauto=1";
//            $.Zebra_Dialog("当前账号已注销", {
//                'type': 'information',
//                'title': AppTips.WarmTips,
//                'zIndex': 1000,
//                'buttons': [AppTips.OkTips],
//                'onClose': function () {
//
//                }
//            });
            });
        }
    }

    function handleLogin(_from){
        var user = ebookContext.getUser();
        if(_from != TA_APP.TA_APP_IB){
            // if(_from == TA_APP.TA_APP_MAIN && (ebookContext.getUser().getName() != AppCfg.defaultuser)){
            //     return;
            // }
            if(_from == TA_APP.TA_APP_MAIN && user && user.getName() != AppCfg.defaultuser){
                return ;
            }
            shellcmd.getUserFromFile().done(function(ret){
                var userEntryInfo = ret.split("=");
                console.log(userEntryInfo[0]+'-------'+userEntryInfo[1]);
                app_global_loginMgr && app_global_loginMgr.loginFunction(userEntryInfo[0],userEntryInfo[1],"",true);
            });
        }
    }

    function handleDisplayChange(){
        var msgObj = {
            evt : "displaychange"
        }
        onClientInvoked(JSON.stringify(msgObj));
    }


    function handleUploadCallback(data){
        var dataArr = data.split('|');
        var obj =  {evt:'',type:'',data : ''};
        obj.evt = dataArr[0];
        obj.type = dataArr[1];
        obj.data = JSON.parse(dataArr[2]);
        var objStr = JSON.stringify(obj);
        onClientInvoked(objStr);
    }

    function handleTupload(data){
        var type = data.key;
        if(type == UP_LOAD_TYPE.MESSAGE){
            if(data.process == 0){
                tipsDialog({
                    "id":"sharestart" + new Date().getTime(),
                    "content":"文件发送开始"
                });
            }
            if(data.process > 0 && data.process < 100){
                tipsDialog({
                    "id":"shareing" + new Date().getTime(),
                    "content":"文件发送中..."
                });
            }
            if(data.process == 100 && data.response_message && JSON.parse(data.response_message).statusCode ==0){
                //成功
                var tips =  tipsDialog({
                    "id":"sharesucess" + new Date().getTime(),
                    "content":"<span class='success_box_right'></span>文件发送成功"
                });

            }
            if(data.process == -1 ){
                //失败
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"文件发送失败"
                });
            }
        }

        if(type == UP_LOAD_TYPE.IbResource){
            if(data.process == 0){
                tipsDialog({
                    "id":"sharestart" + new Date().getTime(),
                    "content":"文件上传开始"
                });
            }
            if(data.process > 0 && data.process < 100){
                tipsDialog({
                    "id":"shareing" + new Date().getTime(),
                    "content":"文件上传中..."
                });
            }
            //&& data.response_message && JSON.parse(data.response_message).statusCode ==0
            if(data.process == 100){
                //成功
                var tips =  tipsDialog({
                    "id":"sharesucess" + new Date().getTime(),
                    "content":"<span class='success_box_right'></span>文件上传成功"
                });

            }
            if(data.process == -1 ){
                //失败
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"文件上传失败"
                });
            }
        }

        if(type == UP_LOAD_TYPE.HOMEWORK){
            if(data.process == 100){
                var response = JSON.parse(data.response_message);
                homework.attach = response;
                if(homework.isOpen){
                    handleThomeworkOpen();
                }else{
                    homework.openHomework();
                }
            }
            if(data.process == -1){
                //失败
                var tips =  tipsDialog({
                    "id":"sharefail" + new Date().getTime(),
                    "content":"作业创建失败"
                });
            }
        }

        if(type == UP_LOAD_TYPE.Prepare) {
            //备课模块文件上传
            if(data.source == UP_LOAD_TYPE.KTSL_IB_UPLOAD){
                wbKtsl.onReceiveMessage(data);
            }else if(data.source == UP_LOAD_TYPE.SYNC_Recommend){
                syncRecommend.onReceiveMessage(data);
            }else if(data.source == UP_LOAD_TYPE.MTBK_IB_UPLOAD){
                app_global_mtbkExport.onMessageReceived(data);
            }else if(data.source == UP_LOAD_TYPE.WIDGET_IB_UPLOAD){
                app_global_curWidget.onMessageReceived(data);
            }else{
                app_global_prepareSource.onMessageReceived(data);
            }

        }
    }    
    
    function handleTshare(data){
        shellcmd.checkOnline().done(function(ret){
            if(!ret){
                $.Zebra_Dialog("您当前处于离线状态，请检查网络连接", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [ AppTips.OkTips],
                    'zIndex': 1000
                });
                return;
            }else{
                _handleTshare(data);
            }
        })
    }

    /**
     * warn：classSelector.show已废弃使用，应当使用classSelector.render方法（和show方法的参数和逻辑都不一样），这里因为handleTshare方法被注释了，这里的逻辑暂不做调整
     */
    function _handleTshare (data){
        if (ebookContext.getUser().getName() != AppCfg.defaultuser) {
            //TODO:分享
            var ownerId = ebookContext.getUser().getUid();
            var classIds = ebookContext.getUserClassId();
            if(!classIds || classIds == 'null'){
                //showAlertTips('您还没有班级，请去云平台创建班级');
                $.Zebra_Dialog('您还没有班级，请去云平台创建班级',{
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'zIndex': 1000,
                    'buttons': ["去创建"],
                    'onClose': function (caption) {
                        if(caption=="去创建"){
                            // var url = Base_Cfg.YUN_CREATE_CLASS;
                            // ebookContext.getUser().getPassword().done(function(pwd){
                            //     DES.init("wyc4yrmK",ebookContext.getUser().getName() + "=" + pwd);
                            //     var token = DES.Encrypt();
                            //     url = url + "&token=" + token;
                            //     shellcmd.openPageOutside(url);
                            // })

                            var url = Base_Cfg.YUN_CREATE_CLASS_BASE + '&' + 'from=ew&appId=web';
                            commonfunc.openWebPage(url);
                        }
                    }
                })
                return;
            }
//            var classIds = '';
            var url = '';
            var file = _path.trimPosix(data.picpath);
//            var content = '分享资料，同学们点击查看吧！';
            classSelector.show(file,function(isconfirm,classIds){
                if(isconfirm){
                    var obj = app_global_bookContainer && app_global_bookContainer.getCurrPageMetadata() || {};
                    var content = obj.unit4Name || obj.unit3Name || obj.unit2Name || obj.unit1Name || '' ;
                    content = encodeURI(content);
                    var attachInfo = '[{"attachType":0,"duration":0}]';
                    var labelIdUrl = AppCenterSvcHelper.CYSVC +"&method=jx.label.extend.list&labelType=3";
                    var labelId = '';
                    ebookContext.getUser().getDataByUserToken(labelIdUrl).done(function(labelRet){
                        $.each(labelRet,function(){
                            if(this.labelName == '课堂记录'){
                                labelId = this.labelId;
                            }
                        })

                        shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret){
                            if(ret){
                                app_ClientToken = ret.access_token;
                                url = AppCenterSvcHelper.CYSVC +"&method=jx.feed.add&ownerId=" + ownerId +'&classIds='+classIds+ '&access_token='+app_ClientToken+'&content='+content+'&attachInfo='+attachInfo+'&labelIds='+labelId+'&fromApp=3';
                                var obj = {"type":"logic",
                                    "action":"ta_upload",
                                    "from":"ib",
                                    "to":"ta_dum",
                                    "id":0,
                                    "data":{"id":"abc","key":"attachments","url":url,"file":file}
                                };
                                socket.send(obj);
                            }else{
                                console.error('access_token get error')
                            }

                        })
                    })
                }
            });
        }
        else {
            app_global_loginMgr.show();
        }
    }

    function handleThomework (data){
        if (ebookContext.getUser().getName() != AppCfg.defaultuser) {
            var picPath = _path.trimPosix(data.picpath);
            var json = {
                type   : "logic",
                action : CMD.TA_UPLOAD,
                from   : TA_APP.TA_APP_IB,
                to : TA_APP.TA_APP_DUM,
                "data":{
                    id:"test",
                    url:encodeURI(AppRemoteSvcCfg.homeworkUrl),
                    key:'upload_file',
                    extra:{
                        ext_args:"attachment_upload"
                    },
                    file:picPath
                }
            };
            socket.send(json);
        }else{
            app_global_loginMgr.show();
        }

    }

    function handleThomeworkOpen(){
        if(homework.isSending){
            var json = {
                type   : "logic",
                action : CMD.T_HOMEWORK_BACK,
                from   : TA_APP.TA_APP_IB,
                to : TA_APP.TA_APP_HOMEWORK,
                "data":{
                    attach:homework.attach
                }
            };
            socket.send(json);
            homework.isSending = false;
        }

        if(homework.isOpen)   {
            //TODO:置顶
            var pid = 0;
            homework.homeworkProcess && homework.homeworkProcess.pid && (pid = homework.homeworkProcess.pid);
            var reiv = Config.nwexePath+'/reiv.exe ';
            var cmdLine = 'topmost|' + null + '|'+ pid + '|' + "作业-教师助手";
            console.log(reiv+cmdLine);
            childProcess.spawn(reiv, [cmdLine], {detached: true}).on('exit',function(){
                console.log(reiv+' exit');
            }).on('error',function(err){
                console.log(reiv+' '+err);
            });
        }
    }

    function handleWatchDog(data){
        if(AppCfg.isBBT){
            if(data.ret != 0){
                $.Zebra_Dialog(AppTips.docWatchFail, {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                (dongleAction == DONGLE_ACTION.TTS || dongleAction == DONGLE_ACTION.TTSEVALCARD) && hideLoading();
            }
            else
            {
                switch (dongleAction){
                    case DONGLE_ACTION.HOTSPOT:     //热区点读
                        app_global_playerMgr.realPlay && app_global_playerMgr.realPlay();
                        break;
                    case DONGLE_ACTION.MAINTOOLBAR:   //工具栏暂停、播放
                        app_global_playerMgr.resume && app_global_playerMgr.resume();
                        break;
                    case DONGLE_ACTION.EVALCARD:       //评测卡片
                        evalCard.realOpen && evalCard.realOpen(evalCardClickEvent);
                        break;
                    case DONGLE_ACTION.TTS:           //黑板合成
                        ttsObj.realPlaySoundHelper && ttsObj.realPlaySoundHelper(language,speecher);
                        break;
                    case DONGLE_ACTION.TTSEVALCARD:           //黑板卡片
                        ttsEvalCardObj.realEvalHelper && ttsEvalCardObj.realEvalHelper(cardLanguage,cardType,cardSpeecher);
                        break;
                    case DONGLE_ACTION.RECOGNISE:           //黑板识别
                        recogniseObj.recognitionEvent && recogniseObj.recognitionEvent(recogniseType);
                        break;
                }
            }
        }
    }

//从TA打开课本
    function handleOpenBook(data){
        var bookCode = data.bookCode;
        if(currentBookCode != bookCode || isBlackboard){
            var pageIndex = data.pageIndex;
            var isU = data.isU;
            var isOpenTeachingPackage = data.isOpenTeachingPackage;
            pageNavigatorHelper.goToIndex(bookCode,ebookContext.getUser(),pageIndex,isU,isOpenTeachingPackage);
        }
        else{
            if(currentBookCode == bookCode){
                app_global_bookContainer.setPageIndex(data.pageIndex);
            }
        }
    }

    //IFB已启动情况下IFS跳转到书本
    function handleGotoBook(receiveData){
        var bookStatus=receiveData.state;
        var curBookCode=receiveData.code||"";//书本号可以为空
        var unitCode=receiveData.unit_code||"";//单元号
        if (bookStatus == 0) {
            //备课状态
            ifsOpenBook(bookStatus,curBookCode,unitCode);
        } else if (bookStatus == 1) {//获取用户信息和书本信息
            //上课状态
            ifsOpenBook(bookStatus,curBookCode,unitCode);
        }
    }

    //获取当前需要打开的书本信息并打开
    function findAndOpenBook(bookCode){
        var userName=ebookContext.getUser().getName();
        var sql = "select * from books where bookCode = '"+ bookCode +"'";
        var dbPath = _path.trimPosix(_path.join(Config.binPath, 'users/' + userName + '/userdb.db'));
        shellcmd.retriveDbAsyn(dbPath, sql).done(function (ret) {
           var curBook=JSON.parse(ret).data[0];
                    // handleOpenBook(curBook);
            var bookId = curBook.id;
            var bookCode = curBook.bookcode;
            var pageIndex = curBook.lastPage || 1;
            var isU =  curBook.mtbkId || "";
            var json = {
                type:"logic",
                action:"openbook",
                to:"ib",
                data:{
                    bookCode:bookCode,
                    pageIndex:pageIndex,
                    isU:isU,
                    // unitCode:unitCode,
                    // bookStatus:bookStatus
                }
            };
            socket.send(json);
        });
    }

    function ifsOpenBook(bookStatus,curBookCode,unitCode){
        if(curBookCode==""){
            //打开书架
            pageNavigatorHelper.goToBookShelf(ebookContext.getUser());
        }else {
            //如果本地有这本书则打开
            bookAccessor.getAllBooks(ebookContext.getUser()).done(function (res) {
                for(var i =0 ,len = res.length; i < len; i++){
                    if(res[i].bookCode == curBookCode){
                        //打开课本
                        findAndOpenBook(curBookCode);
                        var lessonFlag=process.execPath.substring(0,process.execPath.lastIndexOf('\\')).replace(/\\/g,"/")+'/lesson.flag';
                        if(fs.existsSync(lessonFlag)){
                            app_global_MainToolbar.changeClassStatus(true);
                        }else{
                            app_global_MainToolbar.changeClassStatus(false);
                        }

                        break;
                    }else if(i==res.length-1){
                        //打开书库
                        pageNavigatorHelper.goToBookShelfAndOpenBookLib2(ebookContext.getUser());
                    }
                }

            });
        }



    }

    function handleOpenBookshelf(){
        if(currentBookCode != -1){
            pageNavigatorHelper.goToBookShelf(ebookContext.getUser());
        }
    }

    function handleReferIFB(data){
        var hasBook = false;
        var isU = '';
        var bookCode = data.bookCode,title = decodeURIComponent(data.title) || '该本书';
        var unit1 = data.unit1|| '',unit2 = data.unit2 || '',unit3 = data.unit3 || '',unit4 = data.unit4 || '';
        (unit1 == 'null') && (unit1 = ''),(unit2 == 'null') && (unit2 = ''),(unit3 == 'null') && (unit3 = ''),(unit4 == 'null') && (unit4 = '');

        var menuObj = {unit1:unit1,unit2:unit2,unit3:unit3,unit4:unit4};
        var from = data.from;
        if(from == 'refer'){
            //写下个标志，后面用于判断截取图标是否显示
            localStorage.setItem('btn_cut_pf','true');
            localStorage.setItem('btn_cut_pf_icon','true');
        }else if(from == 'open'){
            localStorage.setItem('btn_cut_pf','false');
            localStorage.setItem('btn_cut_pf_icon','false');
        }else{
            localStorage.setItem('btn_cut_pf','false');
            localStorage.setItem('btn_cut_pf_icon','false');
        }

//        localStorage.setItem('btn_cut_pf','true');

        //窗口最大化
//        WIN.setAlwaysOnTop(true);
        shellcmd.appSetAlwaysTop(null,null,'iFlyBook');
        if(!global_jump){
            return;
        }
        if(!bookCode) return;
        //在这个地方处理判断书本是否下载
        bookAccessor.getAllBooks(ebookContext.getUser()).done(function (res) {
            for(var i =0 ,len = res.length; i < len; i++){
                if(res[i].bookCode == bookCode){

                    hasBook = true;
                    isU = res[i].isU;
                    break;
                }
            }
            if(isU ){
                //isU有值时，hasBook肯定为true
                shellcmd.GetUpanList().done(function(ret){
                    if(ret[0][0]){
                        pageNavigatorHelper.goToIndex2(bookCode,ebookContext.getUser(),menuObj,isU);
                    }else {
//                        showAlertTips('请插入授权U盘');
                        shellcmd.checkOnline().done(function(result){
                            if(result){
                                pageNavigatorHelper.goToIndex2(bookCode,ebookContext.getUser(),menuObj,isU);
                            }else{
                                showAlertTips('请插入授权U盘');
                            }
                        })
                    }
                })

            }else {
                if(hasBook){
                    pageNavigatorHelper.goToIndex2(bookCode,ebookContext.getUser(),menuObj,isU);
                }else{
                    localStorage.setItem('bookTitle_pf',title);
                    pageNavigatorHelper.goToBookShelfAndOpenBookLib();
                }
            }


//            else if(hasBook){
//                pageNavigatorHelper.goToIndex2(bookCode,ebookContext.getUser(),menuObj,isU);
//            }
//            else{
//                localStorage.setItem('bookTitle_pf',title);
//                pageNavigatorHelper.goToBookShelfAndOpenBookLib();
//            }
        });

    }

    function handleCaptureOK(data){
        $(window).trigger('capture_ok');
    }



    exports.ibWSLogic = ibWSLogic;

    exports.DONGLE_ACTION = DONGLE_ACTION;
    exports.setDongleAction = setDongleAction;


    exports.setEvalCard = setEvalCard;
    exports.setTTSObj = setTTSObj;
    exports.setTTSEvalCard = setTTSEvalCard;
    exports.setRecogniseObj = setRecogniseObj;
    exports.getVoteStatus = getVoteStatus;
    exports.getTamainStatus = getTamainStatus;
    exports.setCurrentBookCode = setCurrentBookCode;

    exports.setCurrentState =  setCurrentState;
});



