﻿/**
 * 卡片基类
 * @module speechui/cards
 * @author yuwang@iflytek.com
 * @date 2013/06/09
 */
define(function (require, exports, module) {

    var _tplmgr = require('../common/tplmgr');

    /**
    * 卡片基类
    * @constructor
    * @param {String} id 卡片ID
    */
    function CardBase() {

        /**
        * 卡片名称访问器
        * @return {define.CardName} 卡片名称
        */
        this.getCardName = function() {
            throw new Error('accessor "getCardName" not implement');
        };

        /**
        * 获取模板
        * @protected
        * @return {String} 卡片模板
        */
        this.getTemplate = function () {
            return _tplmgr.getTemplate(this.getCardName());
        };

        /**
         * 获取卡片
         * @return {Element} 卡片DOM
         */
        this.getContent = function(){
            throw new Error('accessor "getContent" not implement');
        };

        /**
        * 释放资源
        */
        this.dispose = function () {
            throw new Error('method "dispose" not implement');
        };
    }

    /**
    * @export {speechui.code.cards.CardBase.Constructor}
    */
    exports.CardBase = CardBase;
});