/**
 *
 * User: chengyang@iflytek.com
 * Date: 14-7-7 上午8:50
 * Version: 1.0
 */

define(function(require, exports){
    var _cardbase  = require('./cardbase'),
        _define    = require('../define'),
        _tplParse  = require('../thirdparty/template');

    require('jquery');
    require('../../view/css/choicecard.css');

    /**
     * 单选题卡片类
     * @constructor
     * @param {{
     *     questionArr:   Array.<json>
     * }} options  卡片加载参数
     * @extends {speechui.code.cards.CardBase.Constructor}
     */
    function ChoiceCard(options){
        this.choiceType = {
            Text : 1,
            Img  : 2,
            ImgText : 3
        };
        this.options = options;
        this.actualWidth  = Math.min($(document).width(),Config["Width"]);
        this.actualHeight = Math.min($(document).height(),Config["Height"]);

        this.index  = 1; //当前是第几题
        this.answer = -1; //选择的是哪个答案

//        this.options = {
//            title:"选择题测试",
//            totalNum:13,
//            questionArr:
//                [
//                    {
//                        index:1,
//                        theme:"下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案" +
//                            "下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案",
//                        answer:3,
//                        choiceNum:6,
//                        type:2,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\5.jpg"
//                                },
//                                {
//                                    label:'B',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\15.png"
//                                },
//                                {
//                                    label:'C',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\16.png"
//                                },
//                                {
//                                    label:'D',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\1.png"
//                                },
//                                {
//                                    label:'E',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\10.png"
//                                },
//                                {
//                                    label:'F',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\11.png"
//                                }
//                            ]
//                    },
//                    {
//                        index:2,
//                        theme:"下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案下面哪一张图片是答案",
//                        answer:3,
//                        choiceNum:6,
//                        type:3,
//                        imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\11.png",
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'4'
//                                },
//                                {
//                                    label:'B',
//                                    text:'6'
//                                },
//                                {
//                                    label:'C',
//                                    text:'8'
//                                },
//                                {
//                                    label:'D',
//                                    text:'10'
//                                },
//                                {
//                                    label:'E',
//                                    text:'12'
//                                },
//                                {
//                                    label:'F',
//                                    text:'14'
//                                }
//                            ]
//                    },
//                    {
//                        index:3,
//                        theme:"图片中的 答案C",
//                        answer:3,
//                        choiceNum:4,
//                        type:3,
//                        imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\15.png",
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'4'
//                                },
//                                {
//                                    label:'B',
//                                    text:'6'
//                                },
//                                {
//                                    label:'C',
//                                    text:'8'
//                                },
//                                {
//                                    label:'D',
//                                    text:'10'
//                                }
//                            ]
//                    },
//                    {
//                        index:4,
//                        theme:"2+2=？",
//                        answer:2,
//                        choiceNum:2,
//                        type:1,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'2'
//                                },
//                                {
//                                    label:'B',
//                                    text:'4'
//                                }
//                            ]
//                    },
//                    {
//                        index:5,
//                        theme:"图片中的 答案C",
//                        answer:3,
//                        choiceNum:5,
//                        type:3,
//                        imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\16.png",
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'4'
//                                },
//                                {
//                                    label:'B',
//                                    text:'6'
//                                },
//                                {
//                                    label:'C',
//                                    text:'8'
//                                },
//                                {
//                                    label:'D',
//                                    text:'10'
//                                },
//                                {
//                                    label:'E',
//                                    text:'12'
//                                }
//                            ]
//                    },
//                    {
//                        index:6,
//                        theme:"下面哪一张图片是 答案A",
//                        answer:1,
//                        choiceNum:5,
//                        type:2,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\10.png"
//                                },
//                                {
//                                    label:'B',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\11.png"
//                                },
//                                {
//                                    label:'C',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\5.jpg"
//                                },
//                                {
//                                    label:'D',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\6.jpg"
//                                },
//                                {
//                                    label:'E',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\3.png"
//                                }
//                            ]
//                    },
//                    {
//                        index:7,
//                        theme:"3+3=？",
//                        answer:2,
//                        choiceNum:3,
//                        type:1,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'3'
//                                },
//                                {
//                                    label:'B',
//                                    text:'6'
//                                },
//                                {
//                                    label:'C',
//                                    text:'9'
//                                }
//                            ]
//                    },
//                    {
//                        index:8,
//                        theme:"下面哪一张图片是 答案D",
//                        answer:4,
//                        choiceNum:4,
//                        type:2,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\10.png"
//                                },
//                                {
//                                    label:'B',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\1.png"
//                                },
//                                {
//                                    label:'C',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\5.jpg"
//                                },
//                                {
//                                    label:'D',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\6.jpg"
//                                }
//                            ]
//                    },
//                    {
//                        index:9,
//                        theme:"4+4=？",
//                        answer:4,
//                        choiceNum:4,
//                        type:1,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'2'
//                                },
//                                {
//                                    label:'B',
//                                    text:'4'
//                                },
//                                {
//                                    label:'C',
//                                    text:'6'
//                                },
//                                {
//                                    label:'D',
//                                    text:'8'
//                                }
//                            ]
//                    },
//                    {
//                        index:10,
//                        theme:"下面哪一张图片是 答案B",
//                        answer:2,
//                        choiceNum:3,
//                        type:2,
//                        choiceItem:
//                            [
//                                {
//                                    label:'B',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\1.png"
//                                },
//                                {
//                                    label:'C',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\5.jpg"
//                                },
//                                {
//                                    label:'D',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\6.jpg"
//                                }
//                            ]
//                    },
//                    {
//                        index:11,
//                        theme:"5+5=？",
//                        answer:4,
//                        choiceNum:5,
//                        type:1,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'4'
//                                },
//                                {
//                                    label:'B',
//                                    text:'6'
//                                },
//                                {
//                                    label:'C',
//                                    text:'8'
//                                },
//                                {
//                                    label:'D',
//                                    text:'10'
//                                },
//                                {
//                                    label:'E',
//                                    text:'12'
//                                }
//                            ]
//                    },
//                    {
//                        index:12,
//                        theme:"下面哪一张图片是 答案A",
//                        answer:1,
//                        choiceNum:2,
//                        type:2,
//                        choiceItem:
//                            [
//                                {
//                                    label:'B',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\1.png"
//                                },
//                                {
//                                    label:'C',
//                                    text:'',
//                                    imgPath:"E:\\Project\\EPD_CYCloud1.0\\Development\\Source\\iflyBook2.1\\image\\5.jpg"
//                                }
//                            ]
//                    },
//                    {
//                        index:13,
//                        theme:"6+6=？",
//                        answer:5,
//                        choiceNum:6,
//                        type:1,
//                        choiceItem:
//                            [
//                                {
//                                    label:'A',
//                                    text:'4'
//                                },
//                                {
//                                    label:'B',
//                                    text:'6'
//                                },
//                                {
//                                    label:'C',
//                                    text:'8'
//                                },
//                                {
//                                    label:'D',
//                                    text:'10'
//                                },
//                                {
//                                    label:'E',
//                                    text:'12'
//                                },
//                                {
//                                    label:'F',
//                                    text:'14'
//                                }
//                            ]
//                    }
//                ]
//        };
        this.revertParam();
        this.totalNum = this.options.questionArr.length;

        this.tpl = this.getTemplate();
        this.html = this.render();
        this.registerClickEvent();

        //设置第一题的样式，主要是为了设置图片的样式
        this.init();
    }

    ChoiceCard.prototype = new _cardbase.CardBase();
    ChoiceCard.prototype.constructor = ChoiceCard;

    /**
     * 获取卡片名称
     * @return String
     * @protected
     */
    ChoiceCard.prototype.getCardName = function () {
        return _define.CardName.Choice;
    };

    /**
     * 处理传入的参数
     * @protected
     */
    ChoiceCard.prototype.revertParam = function(){
        var options = this.options,
            questionArr = options.questionArr,
            totalNum = options.totalNum,
            title = options.title,
            answerIndex = 0;

        for(var i= 0,length = questionArr.length; i < length; i++){
            questionArr[i].title = title;
            questionArr[i].totalNum = totalNum;
            questionArr[i].answer += answerIndex;
            answerIndex += questionArr[i].choiceNum;

            questionArr[i].setStyle = false;
        }
    };

    /**
     * 获取html
     * @return String
     * @protected
     */
    ChoiceCard.prototype.getContent = function(){
        return this.dom;
    };

    /**
     * 渲染html
     * @protected
     */
    ChoiceCard.prototype.render = function(){
        var body = $('body'),
            questionArr = this.options.questionArr,
            question,
            html,
            _this = this;

        body.append(this.tpl);
        var title = $("#choice_card_full").text();
        this.dom = $(title);

        for(var i = 0,length = questionArr.length;i < length; i++){
            question = questionArr[i];
            switch(question.type){
                case this.choiceType.Text:
                    html = $("#choice_type_text").text();
                    break;
                case this.choiceType.Img:
                    html = $("#choice_type_img").text();
                    break;
                case this.choiceType.ImgText:
                    html = $("#choice_type_img_text").text();
                    break;
            }
            var text = _tplParse.render(html,question);
            this.dom.append(text);
        }
        var foot = $("#choice_card_foot").text();
        this.dom.append(foot);

        this.dom.find(".type_img").each(function(){
            var list = $(this).find("li");
            if( list.length < 5){
                list.each(function(index){
                    var style = index % 2 == 0 ? "15px 10% 0 18%" : "15px 18% 0 10%";
                    $(this).css("margin",style);
                })
            }else{
                list.each(function(index){
                    var style = index % 3 == 0 ? "15px 10% 0 7%":
                                    index % 3 == 1 ? "15px 0 0" : "15px 7% 0 10%";
                    $(this).css("margin",style);
                })
            }
        });
        this.dom.find(".choice_full_tit").each(function(){
            var h2 = $(this).find("h2"),
                h3 = $(this).find("h3"),
                actualRate = (_this.actualWidth/_this.actualHeight).toFixed(3),
                titleLen = h2.text().length,
                questionLen = h3.text().length,
                titleSize,
                questionSize;

            titleSize = _this.setTitleSize(actualRate, titleLen);
            questionSize = _this.setTitleSize(actualRate, questionLen);

            h2.css({"font-size":titleSize,"line-height":titleSize+"px"});
            h3.css({"font-size":questionSize,"line-height":questionSize+"px"});

            if ( _this.actualWidth == 800 ) {
                var pSize = questionSize < 18 ? 18 : 20,
                    pPadding = questionSize < 18 ? "5px 20px" : "10px 20px";

                $(this).find("p").css({
                    padding : pPadding,
                    "font-size" : pSize,
                    "line-height" : pSize + "px"
                });

                if(questionLen >= 33) {
                    h2.css({margin:"10px 0"})
                }
            }
        });

        if ( _this.actualWidth == 800 ) {
            this.dom.find(".choice_full_list").each(function(){
                $(this)
                    .find(".type_img_text")
                        .css({"padding":"50px 0"})
                    .end()
                    .find(".type_img_text_item")
                        .css({"top":"50px"})
                    .end();
            });

            this.dom.find(".choice_page_box").find("a").css({
                "-webkit-transform":"scale(0.65)"
            });
        }

        $("#choice_card_full, #choice_type_img, #choice_type_text, #choice_type_img_text, #choice_card_foot").remove();
        this.dom
            .find(".choice_full_tit")
            .first()
                .css("display","block")
            .end()
            .end()
            .find(".choice_full_list")
            .first()
                .css("display","block");
    };

    /**
     * 绑定事件
     * @protected
     */
    ChoiceCard.prototype.registerClickEvent = function(){
        var _this = this,
            dom   = this.dom,
            list  = dom.find(".choice_full_list"),
            title = dom.find(".choice_full_tit"),
            selectBtn = dom.find("li a"),
            questionArr = this.options.questionArr;

        selectBtn.bind("click",function(){
            selectBtn.removeClass("choice_checked choice_true_btn choice_error_btn");
            $(this).addClass("choice_checked");
            _this.answer = $(this).index(".choice_full_list li a") + 1;
        });

        dom.find(".choice_btn_hedui").bind("click",function(){
            if(_this.answer == -1) return;
            var result =  _this.answer == questionArr[_this.index - 1].answer ? "choice_true_btn" : "choice_error_btn";
            selectBtn.eq(_this.answer - 1).removeClass("choice_checked").addClass(result);
        });

        dom.find(".choice_page_next").bind("click",function(){
            if(_this.index == _this.totalNum) return;
            selectBtn.removeClass("choice_checked choice_true_btn choice_error_btn");

            title.eq(_this.index - 1).css("display","none");
            list.eq(_this.index - 1).css("display","none");
            title.eq(_this.index).fadeIn("200");
            list.eq(_this.index).fadeIn("200");

            _this.index++;
            _this.answer = -1;

            if(!_this.options.questionArr[_this.index-1].setStyle){
                _this.options.questionArr[_this.index-1].setStyle = true;
                dom.find('.choice_full_list').each(function(){
                    if($(this).css("display")!= 'none'){
                        $(this).find(".type_img li").each(_this.setStyle);
                        $(this).find(".type_img_text_item").each(_this.setStyle);
                    }
                });
            }
        });

        dom.find(".choice_page_pre").bind("click",function(){
            if(_this.index == 1) return;
            selectBtn.removeClass("choice_checked choice_true_btn choice_error_btn");

            title.eq( _this.index-1).css("display","none");
            list.eq(_this.index-1).css("display","none");
            title.eq( _this.index-2).fadeIn("200");
            list.eq(_this.index-2).fadeIn("200");

            _this.index--;
            _this.answer = -1;
        });
    };

    ChoiceCard.prototype.init = function(){
        var domList = this.dom.find('.choice_full_list').eq(0),
            list = domList.find("li"),
            _this = this,
            question = _this.options.questionArr[0],
            choiceType = _this.choiceType,
            img;

        var time = setInterval(function(){
            if(question.type == choiceType.Img){
                img = list.last().find("img");
                if(img.width() != 0){
                    list.each(_this.setStyle);
                    _this.options.questionArr[0].setStyle = true;
                    clearInterval(time);
                }
            }
            else if(question.type == choiceType.ImgText){
                img = domList.find("img");
                if(img.width() != 0){
                    domList.find(".type_img_text_item").each(_this.setStyle);
                    _this.options.questionArr[0].setStyle = true;
                    clearInterval(time);
                }
            }else{
                _this.options.questionArr[0].setStyle = true;
                clearInterval(time);
            }
        },100);

        //适应屏幕分辨率
        var dom = this.dom,
            mainWidth  = this.actualWidth - 100,
            mainHeight = this.actualHeight,
            actualRate = (this.actualWidth/this.actualHeight).toFixed(3);

        console.log("actualWidth:" + this.actualWidth + "actualHeight:" + this.actualHeight);
        dom.find(".choice_full_tit").each(function(){
            $(this).css({
                width  : mainWidth,
                height : 0.21 * mainHeight
            });

            var padding = actualRate < 1.4 ? "30px 0" : actualRate < 1.67 ? "10px 0" : "20px 0";
            padding = _this.actualWidth == 800 ? "5px 0" : padding;
            $(this).find(".choice_full_tit_co").css({
                padding : padding
            })
        });

        dom.find(".choice_full_list").each(function(){
            $(this).css({
                width  : mainWidth,
                height : 0.68 * mainHeight
            });

            $(this).find(".type_img li").each(function(){
                $(this).parent().parent().css({
                    padding : 0
                });
                $(this).css({
                    width  : 0.21 * mainWidth,
                    height : 0.3  * mainHeight
                });

                $(this).find("img").each(function(){
                    $(this).css({
                        "max-Width"  : 0.21 * mainWidth,
                        "max-Height" : 0.3  * mainHeight
                    })
                });
            });

            $(this).find(".type_img_text").each(function(){
                $(this).parent().css({
                    "padding-left" : 0.04 * mainWidth
                });
                $(this).css({
                    width: 0.5 * mainWidth
                })
            });

            $(this).find(".type_img_text_item").each(function(){
                $(this).css({
                    width  : 0.4 * mainWidth,
                    height : 0.45 * mainHeight,
                    left  : 0.58 * mainWidth,
                    right : 0
                });
                $(this).find("img").css({
                    "max-width" : 0.4 * mainWidth,
                    "max-height": 0.45 * mainHeight
                });
            });
        });

        dom.find(".choice_page_box").css({
            width  : mainWidth,
            height : 0.08 * mainHeight
        })
    };

    ChoiceCard.prototype.setStyle = function(){
        var maxWidth  = $(this).width();
        var maxHeight = $(this).height();
        var left = (maxWidth  - $(this).find("img").width())/2;
        var top  = (maxHeight - $(this).find("img").height())/2;
        $(this).find("img").css({
            top:top,
            left:left
        })
    };

    ChoiceCard.prototype.setTitleSize = function(rate, length){
        var size;
        if ( this.actualWidth == 800 ) {
            if( length < 33 ){
                size = 20;
            } else if ( length < 41 ) {
                size = 16
            } else {
                size = 13;
            }
        } else if ( rate < 1.4 ) {
            if ( length < 38 ) {
                size = 30;
            } else if ( length < 50 ) {
                size = 22;
            } else {
                size = 18;
            }
        } else if ( rate < 1.67 ) {
            if ( length < 29 ) {
                size = 30;
            } else if ( length < 44 ) {
                size = 20;
            } else {
                size = 16;
            }
        } else {
            if ( length < 43 ) {
                size = 30;
            } else if ( length < 54 ) {
                size = 20;
            } else {
                size = 20;
            }
        }
        return size;
    };


    /**
     * @export {speechui.code.cards.ChoiceCard.Constructor}
     */
    exports.Constructor = ChoiceCard;
})