﻿/**
 * 画廊卡片
 * @module speechui/cards
 * @date 2013/06/09
 */
define(function (require, exports, module) {
    require('jquery');
    require('../../view/css/gallerycard.css');

    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplparse = require('../thirdparty/template');
    var speechuiCommon = require('speechui/code/common/common');
    var speechUIDir = speechuiCommon.getSpeechUIBase();

    /**
     * 响应鼠标滑动翻的鼠标最小滑动距离
     * @type {number}
     */
    var SLIDINGDISTANCE_MIN = 8;

    /**
     * 画廊卡片类构造函数
     * @constructor
     * @param {{
     *     title: string,
     *     imageInfos: Array.<GalleryImageInfo>
     * }}   option 卡片ID
     *
     * @extends {speechui.cards.cardbase.CardBase}
     */
    function GalleryCard(option) {

        if (!('imageInfos' in option)) {
            throw new Error('option Parameters!');
        }

        var _galleryObj = option;                               //图片信息集合
        var _dom;                                               //dom
        var _self = this;                                       //画廊卡片对象
        var _currIndex = 0;                                     //当前图片的索引
        var _imageEles;                                         //图片列表集合
        var _imageDes;                                          //图片描述信息的集合
        var _imageCount;                                        //图片的个数
        var _imagePageNums;                                     //图片索引的集合

        var _galleryImgdiv,
            _eleImgs,
            _imagePages,
            _imageUl,
            _galleryTabDiv,
            _galleryMsDiv,
            _galleryPageDiv;

        var prePostionX = 0;
        var curPostionX = 0;
        var isDown = false;

        this.enableMove = false;
        this.hasMove = false;
        this.point = {
            beginX : 0,
            beginY : 0,
            offsetX : 0,
            offsetY : 0
        }
        //数组记录每张图片的basePoint和rate
        this.basePoint = [];
        this.rate = [];

        //每张图片的边界信息，用于判断是否可以拖动
//        this.bound = {
//            //图片宽高
//            height:0,
//            width: 0,
//            //容器div宽高
//            maxHeight: 0,
//            maxWidth:  0,
//            //图片中心点
//            centerPointX: 0,
//            centerPointY:0
//        }

        //存放多张图片的信息
        this.bounds = [];

        /**
         *初始化画廊卡片
         */
        function init() {
            //拖拽标记，杨成写的，先不管
            _self.enableMove = false;
            //滑动标记
            _self.enableSlide = true;

            for(var pointObj in _self.point){
                if(_self.point.hasOwnProperty(pointObj)){
                    _self.point[pointObj] = 0;
                }
            }

            var tpl = _self.getTemplate();                      //取原始模版
            for (var i = 0; i < _galleryObj.imageInfos.length; i++) {
                var obj = _galleryObj.imageInfos[i];
                obj.index++;

                _self.basePoint[2 * i] = 0;
                _self.basePoint[2 * i+1] = 0;
                _self.rate[i] = 1;
            }

            //对option对象的infoList排序
            _self._sortImgByIndex(_galleryObj.imageInfos);

            option.speechUIDir = speechUIDir;
            var html = tplparse.render(tpl, option);          //模版解析
            _dom = $(html);                                   //为防止卡片间相互影响，使用dom
            _self.dom = _dom;

            _galleryImgdiv = _dom.find('.gallery_img');
            _imageEles = _dom.find('.gallery_img ul li');
            _eleImgs = _dom.find('.gallery_img ul li img');
            _imageDes = _dom.find('.gallery_ms span');
            _imagePages = _dom.find('.img_ctrl input');
            _imageUl = _dom.find('.gallery_img ul');
            _imageCount = _galleryObj.imageInfos.length;//图片数

            //在这给bounds赋值
            setTimeout(function(){
                for(var i = 0;i < _imageCount ;i++){
                    var b = {};
                    b.height = _self._getImageEles().eq(i).height();
                    b.width = _self._getImageEles().eq(i).width();
                    b.maxHeight = $("#cardWrapper").height();
                    b.maxWidth = $("#cardWrapper").width();
                    b.centerPointX = b.maxWidth / 2;
                    b.centerPointY = b.maxHeight/2;
                    _self.bounds.push(b);
                }

            },1000);


            //支持各种屏幕分辩率（最低800*600）
            var actuallWidth= Config["Width"],actuallHeight= Config["Height"];
            _dom.css({
                height:actuallHeight,
                width:actuallWidth
            });
            _galleryTabDiv = _dom.find('.gallery_tab');
            _galleryMsDiv = _dom.find('.gallery_ms');
            _galleryPageDiv = _dom.find('.full_bot');

            /*这一串是展现后的样式宽度大小*/
            var siderBarDivWidth = 50;
            var galleryTabHeight = 51;
            var galleryMsHeight = 24;
            var galleryPageHeight = 42;
            var maxHeight = actuallHeight - galleryTabHeight - galleryMsHeight - actuallHeight*0.08;
            var maxWidth = actuallWidth - siderBarDivWidth*2 - 4;
            var galleryImgDivStyle = "text-align: center;line-height: {0}px;width: {1}px;height: {2}px".format(maxHeight,maxWidth,maxHeight);
            var imgStyle = "max-height: {0}px; max-width: {1}px;vertical-align: middle;".format(maxHeight,maxWidth);
            //设置图片居中显示(图片按照默认尺寸显示)
            _galleryImgdiv.attr("style", galleryImgDivStyle);
            $.each(_eleImgs, function (eleIdx, img) {
                $(img).attr("style", imgStyle);
            });

            var liStyle = "height:{0}px;width:{1}px;line-height:{2}px;".format(maxHeight,maxWidth,maxHeight);
            $.each(_imageEles,function(eleIdx, img){
                $(img).attr("style",liStyle);
            });

            //初始化样式
            _self._showImages(0);
            _self._displayDes(0);

            //默认显示第一个按钮的样式
            _imagePages.eq(0).addClass("btn_flip2");

            _bindEvents();
            //鼠标事件绑定
            _MouseEvent();
        }

        function getTotalWidthOfObject(object) {

            if(object == null || object.length == 0) {
                return 0;
            }

            var value       = object.width();
            value           += parseInt(object.css("padding-left"), 10) + parseInt(object.css("padding-right"), 10); //Total Padding Width
            value           += parseInt(object.css("margin-left"), 10) + parseInt(object.css("margin-right"), 10); //Total Margin Width
            value           += parseInt(object.css("borderLeftWidth"), 10) + parseInt(object.css("borderRightWidth"), 10); //Total Border Width
            return value;
        }

        function  getTotalHeightOfObject(object) {

            if(object == null || object.length == 0) {
                return 0;
            }

            var value       = object.height();
            value           += parseInt(object.css("padding-top"), 10) + parseInt(object.css("padding-bottom"), 10); //Total Padding Width
            value           += parseInt(object.css("margin-top"), 10) + parseInt(object.css("margin-bottom"), 10); //Total Margin Width
            value           += parseInt(object.css("borderTopWidth"), 10) + parseInt(object.css("borderBottomWidth"), 10); //Total Border Width
            return value;
        }

        /**
         * 鼠标事件绑定
         * @private
         */
        function _MouseEvent() {
            $(_imageEles).mousedown(_self.onMouseDown);
            $(_imageEles).mousemove(_self.onMouseMove);
            $(_imageEles).mouseup(_self.onMouseUp);
        }

        /**
         * 事件绑定
         * @private
         */
        function _bindEvents() {
            // 上一张图片
            _dom.find('.img_pre').click(function (e) {
                _self.onPreImg();
            });

            // 下一张图片
            _dom.find('.img_nex').click(function (e) {
                _self.onNexImg();
            });

            // 按钮
            _dom.find(".img_ctrl input").click(function () {
                var button = $(this);
                var imageIndex = button.index();
                var pageNum = _self._getimagePages();
                _currIndex = imageIndex;

                $(pageNum).removeClass("btn_flip2");
                button.addClass("btn_flip2");
                _self._showImages(_currIndex);
                _self._displayDes(_currIndex);

                var src;
                if(_self.rate[_currIndex] == 1){
                    src = speechUIDir + "/view/images/zoomout_disabled.png";
                    _self.enableSlide = true;
                }else{
                    src = speechUIDir + "/view/images/zoomout.png";
                    _self.enableSlide = false;
                }
                _self.dom.find(".img_zoom_out").find("img").attr("src",src);
            });

            _dom.find(".zoom_in_btn").click(function(){
                _self.rate[_currIndex] += 0.1;
                var imgEles = _self._getImageEles();
                imgEles.eq(_currIndex).css({
                    '-webkit-transform' : 'translate('+  _self.basePoint[_currIndex * 2] + "px," + _self.basePoint[_currIndex * 2 + 1] + "px" + ') scale(' + _self.rate[_currIndex] +  ')'
                })
                var src = speechUIDir + "/view/images/zoomout.png";
                _self.dom.find(".zoom_out_btn").find("img").attr("src",src);
                //放大后不允许滑动
                _self.enableSlide = false;
            });

            _dom.find(".zoom_out_btn").click(function(){
                if(_self.rate[_currIndex] >= 1.1){
                    _self.rate[_currIndex] -= 0.1;
                    if(_self.rate[_currIndex] == 1){
                        _self.basePoint[_currIndex * 2] = 0;
                        _self.basePoint[_currIndex * 2 + 1] = 0;
                        var src = speechUIDir + "/view/images/zoomout_disabled.png";
                        _self.dom.find(".zoom_out_btn").find("img").attr("src",src);
                        //原大小允许滑动
                        _self.enableSlide = true;
                    }
                    var imgEles = _self._getImageEles();
                    imgEles.eq(_currIndex).css({
                        '-webkit-transform' : 'translate('+  _self.basePoint[_currIndex * 2] + "px," + _self.basePoint[_currIndex * 2 + 1] + "px" + ') scale(' + _self.rate[_currIndex] +  ')'
                    })
                }
            });

            _dom.find(".gallery_img").find('img').bind({
                mousedown : function(e){
                    if( _self.enableSlide) return ;
                    _self.enableMove = true;
                    _self.point.beginX = e.originalEvent.pageX;
                    _self.point.beginY = e.originalEvent.pageY;
                },
                mousemove : function(e){
                    if( _self.enableSlide) return ;

                    event.returnValue = false;
                    if(_self.enableMove){
                        _self.hasMove = true;
                        _self.point.offsetX = e.originalEvent.pageX - _self.point.beginX;
                        _self.point.offsetY = e.originalEvent.pageY - _self.point.beginY;

                        var offsetX =  _self.point.offsetX + _self.basePoint[_currIndex * 2];
                        var offsetY =  _self.point.offsetY + _self.basePoint[_currIndex * 2 + 1];

                        var imgEles = _self._getImageEles();
//                        var height = imgEles.eq(_currIndex).height();
//                        console.log(height);
                        //--------以下限制拖动范围代码由pengfu添加-------------
                        //算法是：保证图片的中心点不在边界之外
//                        var centerPointXPosition = _self.bounds[_currIndex].centerPointX +  _self.point.offsetX;
//                        var centerPointYPosition = _self.bounds[_currIndex].centerPointY +  _self.point.offsetY;
//                        if(centerPointXPosition > _self.bounds[_currIndex].maxWidth){
//                            _self.point.offsetX =  _self.bounds[_currIndex].maxWidth - _self.bounds[_currIndex].centerPointX;
//                            offsetX = _self.point.offsetX + _self.basePoint[_currIndex * 2];
//                        }else if(centerPointXPosition < 0){
//                            _self.point.offsetX =  0 -  _self.bounds[_currIndex].centerPointX;
//                            offsetX = _self.point.offsetX + _self.basePoint[_currIndex * 2 ];
//                        }
//
//                        if(centerPointYPosition > _self.bounds[_currIndex].maxHeight){
//                            _self.point.offsetY = _self.bounds[_currIndex].maxHeight - _self.bounds[_currIndex].centerPointY;
//                            offsetY = _self.point.offsetY + _self.basePoint[_currIndex * 2+1 ];
//                        }else if(centerPointYPosition < 0){
//                            _self.point.offsetY = 0 - _self.bounds[_currIndex].centerPointY;
//                            offsetY = _self.point.offsetY + _self.basePoint[_currIndex * 2+1 ];
//                        }
                        //--------以上限制拖动范围代码由pengfu添加-------------

                        imgEles.eq(_currIndex).css({
                            '-webkit-transform' : 'translate('+  offsetX + "px," + offsetY + "px" + ') scale(' + _self.rate[_currIndex] +  ')'
                        })
                     }
                },
                //added by fupeng
                mouseup: function(e){
                    _self.enableMove = false;
                    if (_self.hasMove) {
//                        _self.offset.baseX += _self.offset.x;
//                        _self.offset.baseY += _self.offset.y;
//                        _self.bound.centerPointX += _self.offset.x;
//                        _self.bound.centerPointY += _self.offset.y;
//                        _self.hasMove = false;
                        _self.basePoint[_currIndex * 2] += _self.point.offsetX;
                        _self.basePoint[_currIndex * 2 + 1] += _self.point.offsetY;
                        _self.bounds[_currIndex].centerPointX += _self.point.offsetX;
                        _self.bounds[_currIndex].centerPointY += _self.point.offsetY;
                        _self.hasMove = false;
                    }
                }
            })
            _dom.bind({
                dragstart : function(){
                    return false;
                },
                mouseup : function(){
                    if( _self.enableSlide) return ;

                    _self.enableMove = false;
                    if(_self.hasMove){
                        _self.basePoint[_currIndex * 2] += _self.point.offsetX;
                        _self.basePoint[_currIndex * 2 + 1] += _self.point.offsetY;
                        _self.bounds[_currIndex].centerPointX += _self.point.offsetX;
                        _self.bounds[_currIndex].centerPointY += _self.point.offsetY;
                        _self.hasMove = false;
                    }
                }
            })

            $("#cardWrapper").mouseup(function(){
                _self.enableMove = false;
                if(_self.hasMove){
                    _self.basePoint[_currIndex * 2] += _self.point.offsetX;
                    _self.basePoint[_currIndex * 2 + 1] += _self.point.offsetY;
                    _self.bounds[_currIndex].centerPointX += _self.point.offsetX;
                    _self.bounds[_currIndex].centerPointY += _self.point.offsetY;
                    _self.hasMove = false;
                }
            })

            $(window).mouseup(function(){
                _self.enableMove = false;
                if(_self.hasMove){
                    _self.basePoint[_currIndex * 2] += _self.point.offsetX;
                    _self.basePoint[_currIndex * 2 + 1] += _self.point.offsetY;
                    _self.bounds[_currIndex].centerPointX += _self.point.offsetX;
                    _self.bounds[_currIndex].centerPointY += _self.point.offsetY;
                    _self.hasMove = false;
                }
            })
        }

        /**
         * mouseDown
         * @param e
         */
        this.onMouseDown = function(e){
            if( _self.enableSlide){
                if(1 == e.which){                       //这边 3代表的是右键， 2表示中间键 ，1表示左键
                    isDown = true;
                    var coordinateX = e.originalEvent.x || e.originalEvent.layerX || 0;
                    prePostionX = coordinateX;
                }
            }
        }

        /**
         * mouseUp
         * @param e
         */
        this.onMouseUp = function(e){
            if( _self.enableSlide){
                if(isDown)
                {
                    curPostionX = e.originalEvent.x || e.originalEvent.layerX || 0;
                    var offset = curPostionX - prePostionX;
                    console.log(offset);
                    if(offset > SLIDINGDISTANCE_MIN){                           //上一张
                        _self.onPreImg();
                    }
                    else if(offset < -SLIDINGDISTANCE_MIN){                    //下一张
                        _self.onNexImg();
                    }

                    prePostionX = curPostionX;
                    isDown = false;
                }
            }
        }

        /**
         * mouseMove
         * @param e
         */
        this.onMouseMove = function(e){
            if( _self.enableSlide){
                event.returnValue=false;                 //阻止用户选择页面上的内容
                if(isDown)
                {
                    curPostionX = e.pageX;
                }
            }
        }

        /**
         * 上一张
         * @private
         */
        this.onPreImg = function () {
            var pageNum = _self._getimagePages();
            if (_currIndex == 0) {
                _currIndex = _imageCount - 1;
            } else {
                _currIndex = _currIndex - 1;
            }
            pageNum.removeClass("btn_flip2");
            pageNum.eq(_currIndex).addClass("btn_flip2");

            _self._showImages(_currIndex);
            _self._displayDes(_currIndex);

            var src;
            if(_self.rate[_currIndex] == 1){
                src = speechUIDir + "/view/images/zoomout_disabled.png";
                _self.enableSlide = true;
                _self.enableMove = false;
            }else{
                src = speechUIDir + "/view/images/zoomout.png";
                _self.enableSlide = false;
//                _self.enableMove = true;
            }
//            _self.dom.find(".img_zoom_out").find("img").attr("src",src);
            _self.dom.find(".zoom_out_btn").find("img").attr("src",src);
        }

        /**
         * 下一张
         * @private
         */
        this.onNexImg = function () {
            var pageNum = _self._getimagePages();

            if (_currIndex == _imageCount - 1) {
                _currIndex = 0;
            } else {
                _currIndex = _currIndex + 1;
            }
            pageNum.removeClass("btn_flip2");
            pageNum.eq(_currIndex).addClass("btn_flip2");

            _self._showImages(_currIndex);
            _self._displayDes(_currIndex);

            var src;
            if(_self.rate[_currIndex] == 1){
                src = speechUIDir + "/view/images/zoomout_disabled.png";
                _self.enableSlide = true;
                _self.enableMove = false;
            }else{
                src = speechUIDir + "/view/images/zoomout.png";
                _self.enableSlide = false;
//                _self.enableMove = true;
            }
//            _self.dom.find(".img_zoom_out").find("img").attr("src",src);
            _self.dom.find(".zoom_out_btn").find("img").attr("src",src);
        }

        /**
         * 执行动画(从右向左)
         * @private
         */
        this._animationLeft = function () {
            _imageUl.css({"left": "0px"});
            _self._getImageEles().css({"left": "0px"});

            _self._getImageEles().eq(_currIndex).css({"z-index": zIndex});

            _self._getImageEles().eq(_currIndex).css({"left": "800px"});
            _imageUl.animate({left: "-800px"}, "normal");
            zIndex++;
        }

        /**
         * 执行动画(从左向右)
         * @private
         */
        this._animationRight = function () {
            var zIndex = 0;
            _imageUl.css({"left": "0px"});
            _self._getImageEles().css({"left": "0px"});

            _self._getImageEles().eq(_currIndex).css({"z-index": zIndex});

            _self._getImageEles().eq(_currIndex).css({"left": "-800px"});
            _imageUl.animate({left: "800px"}, "normal");
            zIndex++;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageEles = function () {
            return  _imageEles;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageDes = function () {
            return  _imageDes;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getimagePages = function () {
            return  _imagePages;
        }

        /**
         *
         * @returns {jQuery}
         */
        this.getContent = function () {
            return  _dom;
        }

        this.getCurIndex = function () {
            return _currIndex;
        }

        this.getImgCount = function () {
            return _imageCount;
        }

        init();
    }

    GalleryCard.prototype = new _cardbase.CardBase();
    GalleryCard.prototype.constructor = GalleryCard;

    /**
     * 根据图片的index，用冒泡排序法进行排序
     * @param { Array.<GalleryImageInfo> } imgInfoArr 图片信息列表
     * @private
     */
    GalleryCard.prototype._sortImgByIndex = function (imgInfoArr) {
        //外层循环，共要进行arr.length次求最大值操作
        for (var i = 0; i < imgInfoArr.length; i++) {

            //内层循环，找到第i大的元素，并将其和第i个元素交换
            for (var j = i; j < imgInfoArr.length; j++) {

                if (imgInfoArr[i].index > imgInfoArr[j].index) {
                    //交换两个对象的位置
                    var temp = imgInfoArr[i];
                    imgInfoArr[i] = imgInfoArr[j];
                    imgInfoArr[j] = temp;
                }
            }
        }
    }

    /**
     * 图片切换
     * @param {number} index
     */
    GalleryCard.prototype._showImages = function (index) {

        var imageEles = this._getImageEles();

        $.each(imageEles, function (eleIdx, imageEle) {
            if (index == eleIdx) {
                $(imageEle).fadeIn(800);
            } else if (index == 0) {
                $(imageEle).hide();
            } else {
                $(imageEle).fadeOut(800);
            }
        });
    }

    /**
     * 显示匹配元素的描述信息
     * @param {number} index
     */
    GalleryCard.prototype._displayDes = function (index) {

        var imageDes = this._getImageDes();

        $.each(imageDes, function (eleIdx, imageDes) {
            if (index == eleIdx) {
                $(imageDes).slideDown();
            } else {
                $(imageDes).hide();
            }
        });
    }

    /**
     * @inheritDoc
     */
    GalleryCard.prototype.getCardName = function () {
        return _define.CardName.Gallery;
    };

    /**
     * @export
     */
    exports.Constructor = GalleryCard;

});