﻿/**
 * SpeechUI 入口模块
 * @module speechui
 * @author yuwang@iflytek.com
 * @date 2013/06/09
 */
define(function (require, exports, module) {

    var _define  = require('./code/define');

    // 卡片元数据定义
    var _cardMeta = {};

    // 卡片列表
    var _cards = [];

    /**
    * 初始化SpeechUI
    * @export
    * @param {Array.<speechui.define.CardName>} 卡片列表
    */
    exports.init = function (cards) {
        if (cards instanceof Array) {
            for (var i = 0; i < cards.length; i++) {
                var cardName = cards[i];
                switch (cardName) {
                    case _define.CardName.Gallery:
                        _cardMeta[cardName] = require('./code/cards/gallery');
                        break;
                    case _define.CardName.Choice:
                        _cardMeta[cardName] = require('./code/cards/choice');
                        break;
//                    case _define.CardName.CnWordEval:
//                        _cardMeta[cardName] = require('./code/cards/cnwordeval');
//                        break;
//                    case _define.CardName.EnWordEval:
//                        _cardMeta[cardName] = require('./code/cards/enwordeval');
//                        break;
//                    case _define.CardName.Poetry:
//                        _cardMeta[cardName] = require('./code/cards/poetry');
//                        break;
                    default:
                        throw new Error('unknown card name:' + cardName);
                }
            }
        }
        else {
            throw new Error('cards is not instance of Array');
        }
    };

    /**
    * 加载卡片
    * @param {speechui.define.CardName}   卡片名称
    * @param {Object} options 初始化参数
    * @return {CardBase}
    */
    exports.loadCard = function (cardName, options) {

        // TODO: 卡片加载时做一些逻辑判断和缓处理
        if(!_cardMeta[cardName])    {
            throw new Error(cardName + ' card  is not initialized');
        }
        var card;
        if(cardName === _define.CardName.EnWordEval){
            card = new _cardMeta[cardName].Constructor();
            card.init(options);
        }else{
            card = new _cardMeta[cardName].Constructor(options);
        }
        _cards.push(card);

        return card;
    };
});