(function($){
	
	$.confirm = function(params){
		
		if($('#confirmOverlay').length){
			// A confirm is already shown on the page:
			return false;
		}
		
		var buttonHTML = '';
		$.each(params.buttons,function(name,obj){
			
			// Generating the markup for the buttons:
			buttonHTML+='<a href="#" class="button">'+name+'</a>';
            if(!obj.action){
				obj.action = function(){};
			}
		});
		
		var markup = [
			'<div id="confirmOverlay">',
			'<div id="confirmBox">',
            '<a  href="#" class="out_pop_clo" title="关闭"></a>',
            '<div class="out_pop_con">',
            '<p class="out_pop_text"><span class="out_pop_ic"><img src="./assert/images/ic_out.png"/></span><em>',params.message,'</em></p>',
            '</div>',
//            '<div id="confirmMessage">',params.message,'</div>',
			//'<div id="confirmButtons">',
            '<p class="out_pop_btn">',
			buttonHTML,
            '</p>',
			'</div></div></div>'
		].join('');
        var _$markup = $(markup);
        (AppCfg.lang == "uyghur")&&_$markup.find(".out_pop_text").css("padding","20px").css("font-family","ALKATIP Basma");
        _$markup.hide().appendTo('body').fadeIn();

		var buttons = $('#confirmBox .button'),
			i = 0;
        var closeButton=$('.out_pop_clo');
        closeButton.click(function(){
            $.confirm.hide();
            return false;
        });
		$.each(params.buttons,function(name,obj){
			buttons.eq(i++).click(function(){
				
				// Calling the action attribute when a
				// click occurs, and hiding the confirm.
				
				obj.action();
				$.confirm.hide();
				return false;
			});
		});
	}

	$.confirm.hide = function(){
		$('#confirmOverlay').fadeOut(function(){
			$(this).remove();
		});
	}
	
})(jQuery);