define(function(require,exports,module){

    /**
     *
     * @param {!object} content
     * @param {!object} container
     * @param {double=} initCurrentTime
     */

    function showVideoControl(content,container){
        //INITIALIZE

        var  matrix=getTransformMatrix(container);

        var video = content.find('video:first');
        var currentBar=content.find('.current'),durationBar=content.find('.duration'),bufferBar=content.find('.bufferBar'),
            timeBar=content.find('.timeBar'),controlBar=content.find('.control'),
            btnPlay=content.find('.btnPlay'),btnStop=content.find('.btnStop'),progressBar = content.find('.progress'),
            volumeBar=content.find('.volumeBar'),soundBar=content.find('.sound'),volume=content.find('.volume');

        if(!video.length) return;

        //remove default control when JS loaded
        video[0].removeAttribute("controls");
        controlBar.show();
        progressBar.css({width:video.outerWidth()-330});

        //before everything get started
        video.on('loadedmetadata',function(e){
            currentBar.text(timeFormat(0));
            updateVolume(0, 0.7);

            //start to get video buffering data

            startBuffer();

            //bind video events
            content.find('.videoContainer')
                .hover(function() {
                    controlBar.stop().animate({'bottom':0}, 500);
                }, function() {
                    if(!volumeDrag && !timeDrag){
                        controlBar.stop().animate({'bottom':-30}, 500);
                    }
                });
            e.stopPropagation();
        });

        //video canplay event
        video.on('canplay', function(e) {
            playpause();
            e.stopPropagation();
        });

        video.on('remove',function(e){
            video=null;
            e.stopPropagation();
        });

        //display video buffering bar
        var startBuffer = function() {
            if(video)
            {
                var currentBuffer = video[0].currentTime;
                var maxduration = video[0].duration;
                var perc = 100 * currentBuffer / maxduration;
                bufferBar.css('width',perc+'%');
                durationBar.text(timeFormat(maxduration));
                if(currentBuffer < maxduration) {
                    setTimeout(startBuffer, 500);
                }
            }
        };

        //display current video play time
        video.on('timeupdate', function(e) {
            var currentPos = video[0].currentTime;
            var maxduration = video[0].duration;
            var perc = 100 * currentPos / maxduration;
            currentBar.text(timeFormat(currentPos));
            timeBar.css('width',perc+'%');
            e.stopPropagation();
        });

        //CONTROLS EVENTS
        //video screen and play button clicked
        video.on('click', function(e) { playpause();e.stopPropagation()} );

        btnPlay.on('click', function(e) { playpause();e.stopPropagation()} );

        var playpause = function() {
            if(video[0].paused || video[0].ended) {
                btnPlay.addClass('paused');
                video.triggerHandler('video_play');
            }
            else video[0].pause();
        };

        //stop button clicked
        btnStop.on('click', function(e) {
            updatebar(progressBar.offset().left);
            video[0].pause();
            e.stopPropagation();
        });

        //sound button clicked
        content.find('.sound').click(function(e) {
            video[0].muted = !video[0].muted;
            $(this).toggleClass('muted');
            if(video[0].muted) {
                volumeBar.css('width',0);
            }
            else{
                volumeBar.css('width', video[0].volume*100+'%');
            }
            e.stopPropagation();
        });

        //video ended event
        video.on('pause ended', function(e) {
            btnPlay.removeClass('paused');
            e.stopPropagation();
        });

        //VIDEO PROGRESS BAR
        //when video timebar clicked
        var timeDrag = false;	/* check for drag event */
        progressBar.on('mousedown', function(e) {
            timeDrag = true;
            updatebar(e.pageX);
            e.stopPropagation();
        });

        var updatebar = function(x) {


            //calculate drag position
            //and update video currenttime
            //as well as progress bar
            var maxduration = video[0].duration;
            var position = (x - progressBar.offset().left)/matrix[0];
            var percentage = 100 * position / progressBar.width();
            if(percentage > 100) {
                percentage = 100;
            }
            if(percentage < 0) {
                percentage = 0;
            }
            timeBar.css('width',percentage+'%');
            video[0].currentTime = maxduration * percentage / 100;
        };

        //VOLUME BAR
        //volume bar event
        var volumeDrag = false;
        volume.on('mousedown', function(e) {
            volumeDrag = true;
            video[0].muted = false;
            content.find('.sound').removeClass('muted');
            updateVolume(e.pageX);
            e.stopPropagation();
        });

        var updateVolume = function(x, vol) {
            var volume = volumeBar;
            var percentage;
            //if only volume have specificed
            //then direct update volume
            if(vol) {
                percentage = vol * 100;
            }
            else {
                var position = (x - volume.offset().left)/matrix[0];
                percentage = 100 * position / volume.width();
            }

            if(percentage > 100) {
                percentage = 100;
            }
            if(percentage < 0) {
                percentage = 0;
            }

            //update volume bar and video volume
            volume.css('width',percentage+'%');
            video[0].volume = percentage / 100;

            //change sound icon based on volume
            if(video[0].volume == 0){
                soundBar.removeClass('sound2').addClass('muted');
            }
            else if(video[0].volume > 0.5){
                soundBar.removeClass('muted').addClass('sound2');
            }
            else{
                soundBar.removeClass('muted').removeClass('sound2');
            }

        };

        //Time format converter - 00:00
        var timeFormat = function(seconds){
            var m = Math.floor(seconds/60)<10 ? "0"+Math.floor(seconds/60) : Math.floor(seconds/60);
            var s = Math.floor(seconds-(m*60))<10 ? "0"+Math.floor(seconds-(m*60)) : Math.floor(seconds-(m*60));
            return m+":"+s;
        };
    }

    function getTransformMatrix(ele){
        var matrix=[1, 0, 0, 1, 0, 0];
        if(ele){
            var matrixTransform = ele.css('-webkit-transform');
            if( matrixTransform && matrixTransform != 'none')  matrix =  matrixTransform.substr(7, matrixTransform.length - 8).split(",");
        }
        return matrix;
    };

    module.exports=showVideoControl;
})
