


(function (win) {
    // var _fs = require('fs');
    // var _crypto = require('crypto');
    // var _path = require('path');
    win.COMMON_ = {};


    //在目标地址查询有无重名文件，若有重名文件，返回一个不重名的文件夹
    /*@param title 没有后缀的文件名
     * @param extra 后缀
     * @param fileName 有后缀的文件名
     * @param path 目标地址
     * @param callback 回调
     * */
    COMMON_.getNotSameFileName =function (title, extra, fileName, path, callback) {
        var existFile=function (files, name) {
            return (JSON.stringify(files).indexOf(name) != -1);
        }
        var fs = require('fs');
        var files = fs.readdirSync(path);
        if (!existFile(files, fileName)) {
            callback && callback(fileName);
        } else {
            var i = 2;
            if(extra){//文件有后缀
                for (; existFile(files, title + '(' + i + ')' + extra); i++) {

                }
                callback && callback(title + '(' + i + ')' + extra);
            }else{//文件夹没有后缀
                for (; existFile(files, title + '(' + i + ')' ); i++) {

                }
                callback && callback(title + '(' + i + ')' );
            }
        }
    }


    //全局queue方法
    /*
     * param:{
     *       arr:参数数组
     *       fun:return deffer对象的方法
     *   }
     * */
    COMMON_.global_queue = function(arr, fun) {
        var def = $.Deferred();
        var qName = COMMON_.golbalGetGuid(10);
        var len = arr.length, curIndex = 0;

        for (var i = 0; i < len; i++) {
            $.queue(document, qName, single)
        }
        function single(next, hooks) {
            fun(arr[curIndex]).done(function () {
                if (curIndex == len - 1) {
                    def.resolve();
                } else {
                    curIndex++;
                    next && next();
                }
            }).fail(function (e) {
                def.reject(e);
            });
        }

        if (len>0) $.dequeue(document, qName);
        else setTimeout(function () {
            def.resolve();
        }, 0);
        return def.promise();

    };


    /**
     * 获取guid
     * @param len 长度
     * @returns {string} 小写的字符串
     */
    COMMON_.golbalGetGuid = function (len) {
        var len = len||32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    };

    /*
     * 获取md5值
     * */
    COMMON_.getMd5 = function (path) {
        var crypto = require('crypto');
        var def = $.Deferred();
        //读取一个Buffer
        fs.readFile(path,function (err,buf) {
            if(err){
                def.reject(err);
            }else {
                var hash = crypto.createHash('md5');
                hash.update(buf);
                var md5 = hash.digest('hex');
                def.resolve(md5);
            }
        });
        return def.promise();
    };

    /*
    * 获取uuid
    * */
    COMMON_.crateUuid = function (){
        var s = [];
        var hexDigits = "0123456789abcdef";
        for (var i = 0; i < 36; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
        s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
        s[8] = s[13] = s[18] = s[23] = "-";

        return s.join("");
    };

    COMMON_._getRandomString = function(len){
        var len = len||32;
        var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'; // 默认去掉了容易混淆的字符oOLl,9gq,Vv,Uu,I1
        var maxPos = $chars.length;
        var pwd = '';
        for (var i = 0; i < len; i++) {
            pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
        }
        return pwd.toLowerCase();
    }

    /*
    * Date format方法
    * */
    Date.prototype.Format = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1,                 //月份
            "d+": this.getDate(),                    //日
            "h+": this.getHours(),                   //小时
            "m+": this.getMinutes(),                 //分
            "s+": this.getSeconds(),                 //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds()             //毫秒
        };
        if (/(y+)/.test(fmt))
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt))
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    };




})(window)












