-- WinBase.lua
-- From WinBase.h
local ffi = require "ffi"
local bit = require "bit"
local bor = bit.bor
local lshift = bit.lshift
local rshift = bit.rshift

require "WTypes"


INVALID_HANDLE_VALUE = ffi.cast("intptr_t", -1)
INVALID_FILE_SIZE         = (0xFFFFFFFF);
INVALID_SET_FILE_POINTER  = (-1);
INVALID_FILE_ATTRIBUTES   = (-1);

WAIT_TIMEOUT = 0X102;
WAIT_OBJECT_0 = 0;


function MAKEWORD(low,high)
	return bor(low , lshift(high , 8))
end

function LOWBYTE(word)
	return band(word, 0xff)
end

function HIGHBYTE(word)
	return band(rshift(word,8), 0xff)
end




OPEN_ALWAYS = 4;
OPEN_EXISTING = 3;

GENERIC_READ    = 0x80000000;
GENERIC_WRITE   = 0x40000000;
GENERIC_EXECUTE = 0x20000000;
GENERIC_ALL     = 0x10000000;

PURGE_TXABORT = 0x01;
PURGE_RXABORT = 0x02;
PURGE_TXCLEAR = 0x04;
PURGE_RXCLEAR = 0x08;


ERROR_IO_PENDING = 0x03E5; -- 997

INFINITE = 0xFFFFFFFF;


-- Access Rights
DELETE 			= 0x00010000
READ_CONTROL	= 0x00020000
WRITE_DAC		= 0x00040000
WRITE_OWNER		= 0x00080000
SYNCHRONIZE		= 0x00100000

STANDARD_RIGHTS_REQUIRED        = 0x000F0000

STANDARD_RIGHTS_READ            = READ_CONTROL
STANDARD_RIGHTS_WRITE           = READ_CONTROL
STANDARD_RIGHTS_EXECUTE         = READ_CONTROL

STANDARD_RIGHTS_ALL             = 0x001F0000
SPECIFIC_RIGHTS_ALL             = 0x0000FFFF


-- File access rights
FILE_FLAG_OVERLAPPED 		= 0X40000000;

FILE_READ_DATA              = 0x0001;    -- file & pipe
FILE_WRITE_DATA             = 0x0002;    -- file & pipe
FILE_APPEND_DATA            = 0x0004;    -- file
FILE_READ_EA                = 0x0008;    -- file & directory
FILE_WRITE_EA               = 0x0010;    -- file & directory
FILE_EXECUTE                = 0x0020;    -- file
FILE_READ_ATTRIBUTES		= 0x0080;    -- all
FILE_WRITE_ATTRIBUTES		= 0x0100;    -- all


FILE_ALL_ACCESS			= bor(STANDARD_RIGHTS_REQUIRED, SYNCHRONIZE, 0x1FF);
FILE_GENERIC_READ		= bor(STANDARD_RIGHTS_READ,FILE_READ_DATA,FILE_READ_ATTRIBUTES,FILE_READ_EA,SYNCHRONIZE);
FILE_GENERIC_WRITE		= bor(STANDARD_RIGHTS_WRITE ,FILE_WRITE_DATA,FILE_WRITE_ATTRIBUTES,FILE_WRITE_EA,FILE_APPEND_DATA,SYNCHRONIZE);
FILE_GENERIC_EXECUTE	= bor(STANDARD_RIGHTS_EXECUTE, FILE_READ_ATTRIBUTES, FILE_EXECUTE, SYNCHRONIZE);

-- CreateFile()
-- dwDesiredAccess

-- dwShareMode
FILE_SHARE_READ				= 0x00000001;
FILE_SHARE_WRITE			= 0x00000002;
FILE_SHARE_DELETE			= 0x00000004;

-- dwCreationDisposition
CREATE_NEW			= 1;
CREATE_ALWAYS		= 2;
OPEN_EXISTING		= 3;
OPEN_ALWAYS			= 4;
TRUNCATE_EXISTING	= 5;



--THREAD_ALL_ACCESS
THREAD_TERMINATE					= 0x0001
THREAD_SUSPEND_RESUME				= 0x0002
THREAD_GET_CONTEXT					= 0x0008
THREAD_SET_CONTEXT					= 0x0010
THREAD_SET_INFORMATION				= 0x0020
THREAD_QUERY_INFORMATION			= 0x0040
THREAD_SET_THREAD_TOKEN				= 0x0080
THREAD_IMPERSONATE					= 0x0100
THREAD_DIRECT_IMPERSONATION			= 0x0200
THREAD_SET_LIMITED_INFORMATION		= 0x0400
THREAD_QUERY_LIMITED_INFORMATION	= 0x0800

-- Process dwCreationFlag values

 DEBUG_PROCESS				= 0x00000001
 DEBUG_ONLY_THIS_PROCESS	= 0x00000002
 CREATE_SUSPENDED			= 0x00000004
 DETACHED_PROCESS			= 0x00000008

 CREATE_NEW_CONSOLE			= 0x00000010
 NORMAL_PRIORITY_CLASS		= 0x00000020
 IDLE_PRIORITY_CLASS		= 0x00000040
 HIGH_PRIORITY_CLASS		= 0x00000080

 REALTIME_PRIORITY_CLASS	= 0x00000100
 CREATE_NEW_PROCESS_GROUP	= 0x00000200
 CREATE_UNICODE_ENVIRONMENT	= 0x00000400
 CREATE_SEPARATE_WOW_VDM	= 0x00000800

 CREATE_SHARED_WOW_VDM      = 0x00001000
 CREATE_FORCEDOS			= 0x00002000
 BELOW_NORMAL_PRIORITY_CLASS= 0x00004000
 ABOVE_NORMAL_PRIORITY_CLASS      = 0x00008000

 INHERIT_PARENT_AFFINITY          = 0x00010000
 CREATE_PROTECTED_PROCESS         = 0x00040000
 EXTENDED_STARTUPINFO_PRESENT     = 0x00080000

 PROCESS_MODE_BACKGROUND_BEGIN    = 0x00100000
 PROCESS_MODE_BACKGROUND_END      = 0x00200000

 CREATE_BREAKAWAY_FROM_JOB        = 0x01000000
 CREATE_PRESERVE_CODE_AUTHZ_LEVEL = 0x02000000
 CREATE_DEFAULT_ERROR_MODE        = 0x04000000
 CREATE_NO_WINDOW                 = 0x08000000

 PROFILE_USER                     = 0x10000000
 PROFILE_KERNEL                   = 0x20000000
 PROFILE_SERVER                   = 0x40000000
 CREATE_IGNORE_SYSTEM_DEFAULT     = 0x80000000


 STACK_SIZE_PARAM_IS_A_RESERVATION   = 0x00010000    -- Threads only

--
-- Priority flags
--
--[[
 THREAD_PRIORITY_LOWEST          THREAD_BASE_PRIORITY_MIN
 THREAD_PRIORITY_BELOW_NORMAL    (THREAD_PRIORITY_LOWEST+1)
 THREAD_PRIORITY_NORMAL          0
 THREAD_PRIORITY_HIGHEST         THREAD_BASE_PRIORITY_MAX
 THREAD_PRIORITY_ABOVE_NORMAL    (THREAD_PRIORITY_HIGHEST-1)
 THREAD_PRIORITY_ERROR_RETURN    (MAXLONG)

 THREAD_PRIORITY_TIME_CRITICAL   THREAD_BASE_PRIORITY_LOWRT
 THREAD_PRIORITY_IDLE            THREAD_BASE_PRIORITY_IDLE

 THREAD_MODE_BACKGROUND_BEGIN    0x00010000
 THREAD_MODE_BACKGROUND_END      0x00020000
--]]












ffi.cdef[[



typedef struct _BY_HANDLE_FILE_INFORMATION {
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD dwVolumeSerialNumber;
    DWORD nFileSizeHigh;
    DWORD nFileSizeLow;
    DWORD nNumberOfLinks;
    DWORD nFileIndexHigh;
    DWORD nFileIndexLow;
} BY_HANDLE_FILE_INFORMATION, *PBY_HANDLE_FILE_INFORMATION, *LPBY_HANDLE_FILE_INFORMATION;
]]

ffi.cdef[[
typedef struct _STARTUPINFO {
  DWORD  cb;
  LPTSTR lpReserved;
  LPTSTR lpDesktop;
  LPTSTR lpTitle;
  DWORD  dwX;
  DWORD  dwY;
  DWORD  dwXSize;
  DWORD  dwYSize;
  DWORD  dwXCountChars;
  DWORD  dwYCountChars;
  DWORD  dwFillAttribute;
  DWORD  dwFlags;
  WORD   wShowWindow;
  WORD   cbReserved2;
  PUCHAR lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFO, *LPSTARTUPINFO;
]]
--
-- GetOverlappedResult()
--
function HasOverlappedIoCompleted(lpOverlapped)
	return (lpOverlapped.Internal ~= STATUS_PENDING)
end
