local ffi = require("ffi")
require("WTypes")
local USER32 = require("user32_ffi")
local SHELL32 = require("Shell32")
local KERNEL32 = require("Kernel32")

function shellExecuteEx( exe,params )

    local pStartInfo = ffi.new("SHELLEXECUTEINFO[1]")

    pStartInfo[0].cbSize = ffi.sizeof("SHELLEXECUTEINFO")
    pStartInfo[0].fMask = SHELL32.SEE_MASK_NOCLOSEPROCESS
    pStartInfo[0].lpVerb = nil
    pStartInfo[0].lpFile = KERNEL32.utf8ToGBK(exe,nil)
    pStartInfo[0].lpParameters = KERNEL32.utf8ToGBK(params,nil)
    pStartInfo[0].nShow = USER32.SW_SHOW
    pStartInfo[0].hInstApp = nil

    SHELL32.ShellExecuteEx(pStartInfo)
end