(function () {
    /*
    var gui = require("nw.gui");
    gui.Window.open("http://127.0.0.1:15050/server/route/send/classes.html", {
        //width:480,
        width: 290,
        //height:320,
        height: 350,
        toolbar: true,
        frame: false
    })
*/
    var http = require("http");
    var url = require("url");
    var path = require("path");
    var fs = require("fs");


    var basePath = path.dirname(process.execPath);
    var service = require(path.join(basePath, "server/route/api/service"));
    var mime = require(path.join(basePath, "server/mime")).mime;
    var proxy = require(path.join(basePath,"server/route/proxy/cyservice")).proxy;
    var port = 15050;

    var server = http.createServer(function (request, response) {
        var pathname = decodeURIComponent(url.parse(request.url).pathname);
        var realPath = path.join(basePath, pathname);
        var ext = path.extname(realPath);
        ext = ext ? ext.slice(1) : null;
        if (ext) {
            console.log(pathname);
            fs.exists(realPath, function (exists) {
                if (!exists) {
                    response.writeHead(404, {
                        'Content-Type': 'text/plain'
                    });
                    response.write("This request URL " + realPath + " was not found on this server.");
                    response.end();
                }
                else {
                    fs.readFile(realPath, "binary", function (err, file) {
                        if (err) {
                            response.writeHead(500, {
                                'Content-Type': 'text/plain'
                            });
                            response.end(err);
                        } else {
                            var contentType = mime[ext] || "text/plain";
                            response.writeHead(200, {
                                'Content-Type': contentType
                            });
                            response.write(file, "binary");
                            response.end();
                        }
                    });
                }
            })
        }
        else {
            var apiMatch = /\/api\/(.*)/.exec(pathname);
            var proxyMatch = /\/proxy\/(.*)/.exec(pathname);
            var isSupport = false;
            if(apiMatch){
                var apiFunc = apiMatch[1];
                if(service[apiFunc]){
                    isSupport = true;
                    service[apiFunc].call(this,request,response);
                }
            }
            else if(proxyMatch){
                isSupport = true;
                proxy(request,response);
            }
            if(!isSupport){
                response.writeHead(404, {
                    'Content-Type': 'text/plain'
                });
                response.write("This request api " + pathname + " was not found on this server.");
                response.end();
            }
        }
    });
    server.listen(port);
})();