/**
 * Created with JetBrains WebStorm.
 * User: qxb-810
 * Date: 2016/11/23
 * Time: 15:18
 * Description:
 */

(function () {
    var phaseToGrade = [
        {
            "phase": "01",
            "grade": [
                {
                    "code": "14",
                    "name": "幼儿园小班"
                },
                {
                    "code": "15",
                    "name": "幼儿园中班"
                },
                {
                    "code": "16",
                    "name": "幼儿园大班"
                },
            ]
        },
        {
            "phase": "02",
            "grade": [
                {
                    "code": "17",
                    "name": "学前班"
                }
            ]
        },
        {
            "phase": "03",
            "grade": [
                {
                    "code": "01",
                    "name": "一年级"
                },
                {
                    "code": "02",
                    "name": "二年级"
                },
                {
                    "code": "03",
                    "name": "三年级"
                },
                {
                    "code": "04",
                    "name": "四年级"
                },
                {
                    "code": "05",
                    "name": "五年级"
                },
                {
                    "code": "06",
                    "name": "六年级"
                },
            ]
        },
        {
            "phase": "04",
            "grade": [
                {
                    "code": "07",
                    "name": "七年级"
                },
                {
                    "code": "08",
                    "name": "八年级"
                },
                {
                    "code": "09",
                    "name": "九年级"
                },
            ]
        },
        {
            "phase": "05",
            "grade": [
                {
                    "code": "10",
                    "name": "高一"
                },
                {
                    "code": "11",
                    "name": "高二"
                },
                {
                    "code": "12",
                    "name": "高三"
                },
            ]
        },
    ];

    //有班级显示
    var template = '<div class="jxpop-box" style="height:100%;width:100%">'+
        '<div class="jxpop-tab"><p>发送</p><p><a class="close" href="javascript:void(0)"><i class="icon iconfont">&#xe60a;</i></a></p></div>'+
        '<div class="jxpop-main">'+
        '<div class="jxpop-infolist">'+
        '<dl class="clearfix">'+
        '<dt class="w110">请选择要发送的班级</dt>'+
        '<dd class="clearfix">'+
        '<select class="select-list fl select-list7 classList" name="" style="width:auto">'+
        '<option classid=0>全部</option>'+
        '</select>'+
        '</dd>'+
        '</dl>'+
        '</div>'+
        '<div class="mb-10 ml4">#课堂实录#</div>'+
        '<div class="jxpop-poety"><img src=""></div>'+
        '</div>'+
        '<div class="jxpop-btnbar jxpop-notline">'+
        '<button type="button" class="btn-blue btnconfirm">确定</button>'+
        '<button type="button" class="btn-gray btncancel">取消</button>'+
        '</div>'+
        '</div>';

    //没有班级显示 style="background:url(common/images/bg-createClass.jpg) no-repeat 0px 0px;margin:0 0 10px 0"
    var templateNoClasses = '<div class="jxpop-box" style="height:100%;width:100%">'+
        '<div class="jxpop-tab"><p>温馨提示</p><p><a class="close" href="javascript:void(0)"><i class="icon iconfont">&#xe60a;</i></a></p></div>'+
        '<div class="jxpop-main" style="display:position">'+
        '<div class="clearfix" style="padding: 30px 13px 20px;"><div class="fl"><img src="./common/images/createClass_banner.png" style="width:240px"/></div>'+
        '<div class="fl" style="width:240px;margin-top:50px;padding-left:20px"><p style="font-size:20px;font-weight: 550;margin:30px 0 0 0;text-align:center">您还没有任何班级信息</p><div style="font-size:14px;font-weight: 100;margin:30px 0 0 0;text-align:center">赶快前往<span style="font-size:18px;font-weight: 700;">云平台</span>创建或者加入班级！</div></div>'+
        '</div></div>'+
        '<div class="jxpop-btnbar jxpop-notline">'+
        '<button type="button" class="btn-blue btncreate">去创建</button>'+
        '<button type="button" class="btn-gray btncancel">取消</button>'+
        '</div>'+
        '</div>';

    var userInfo = "";


    var getQueryString = function(name)
    {
         var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
         var r = window.location.search.substr(1).match(reg);
         if(r!=null)return  decodeURIComponent(r[2]); return null;
    }

    var picPath = getQueryString("picpath");

    var getUserInfo = function () {
        var defer = $.Deferred();
        $.ajax({
            url: "http://127.0.0.1:15050/api/getUserCache",
            dataType: "json",
            success: function (data) {
                defer.resolve(data);
            }
        })
        return defer.promise();
    };

    var getInterfaceUrl = function () {
        var defer = $.Deferred();
        $.ajax({
            url: "http://127.0.0.1:15050/api/getInterfaceUrl",
            dataType: "json",
            success: function (result) {
                defer.resolve(result.interfaceUrl);
            },
            error: function(err){

            }
        })
        return defer.promise();
    }

    var getLabelId = function(labelName){
        var defer = $.Deferred();
        getInterfaceUrl().done(function (interfaceUrl) {
            var labelUrl = interfaceUrl + "method=jx.label.extend.list&version=1.0&format=json&labelType=3";
            labelUrl = labelUrl.replace("cyservice.edcc.xinjiangtest.changyan.cn","127.0.0.1:15050/proxy");
            labelUrl = labelUrl.replace("cyservice.edcc.edu.xjcxedu.com","127.0.0.1:15050/proxy");
            $.ajax({
                url:labelUrl,
                dataType:"jsonp",
                success:function(labelRet){
                    $.each(labelRet,function(){
                        if(this.labelName == '课堂记录'){
                            var labelId = this.labelId;
                            defer.resolve(labelId);
                        }
                    })
                },
                error:function(err){
                    $.ajax({
                        url: "http://127.0.0.1:15050/api/postTipMessage",
                        type: "GET",
                        data: {"content":"分享失败"},
                        success: function () {
                            window.close()
                        }
                    });
                    defer.resolve(null);
                }
            })
        })

        return defer.promise();
    };

    var shareToClass = function(classes,file){
        var attachInfo = '[{"attachType":'+0+',"duration":0}]';
        getLabelId("课堂记录").done(function(labelId){
            var params = {
                ownerId:userInfo.id,
                classIds:classes.join(","),
                labelIds:labelId,
                fromApp:3,
                attachInfo:'[{"attachType":'+0+',"duration":0,"attachName":"1.jpg"}]'
            };
            jxFeedAdd(params,file);
        })
    };

    var dataURLtoBlob = function(dataurl) {
        var arr = dataurl.split(','), mime = arr[0].match(/:(.*?);/)[1],
        bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
        while(n--){
          u8arr[n] = bstr.charCodeAt(n);
        }
      return new Blob([u8arr], {type:mime});
    } 

    var jxFeedAdd = function(params,file){
        getInterfaceUrl().done(function (interfaceUrl) {
            var feedUrl = interfaceUrl + "method=jx.feed.add&version=1.0&format=json&";
            feedUrl = feedUrl + $.param(params);
            feedUrl = feedUrl.replace("cyservice.edcc.xinjiangtest.changyan.cn","127.0.0.1:15050/proxy");
            feedUrl = feedUrl.replace("cyservice.edcc.edu.xjcxedu.com","127.0.0.1:15050/proxy");

            var formData = new FormData();
            formData.append("attachments", dataURLtoBlob(file),"1.jpg");
            $.ajax({
                url: feedUrl,
                type: "POST",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                dataType: "jsonp",
                success: function (ret) {
                    console.log(ret);
                    $.ajax({
                        url: "http://127.0.0.1:15050/api/postTipMessage",
                        type: "GET",
                        data: {"content": "截图已分享至班级圈"},
                        success: function () {
                            window.close();
                        }
                    })
                },
                error: function (err) {
                    console.error(err);
                    $.ajax({
                        url: "http://127.0.0.1:15050/api/postTipMessage",
                        type: "GET",
                        data: {"content": "分享失败"},
                        success: function () {
                            window.close();
                        }
                    })
                }
            })
            //$("#classSelector").hide();
        })
    };

    var fixClassName = function(classInfo){
        var curDate = new Date();
        var curYear, curMonth, curDay;
        curYear = curDate.getFullYear();//当前年
        curMonth = curDate.getMonth() + 1;//当前月
        curDay = curDate.getDate();//当前天
        curPhase = classInfo.phase;//当前学段
        var startYear = classInfo.year;
        var attrGrade = "", attrClassName = "";
        if (curPhase == "" || curPhase == null || curPhase == undefined) {
            attrGrade = startYear + "级";
        } else {
            var gradeIdx = curYear - startYear;
            switch (curPhase) {//找到当前学段号对应的学段
                case '01':
                    phaseIndex = 0;
                    break;
                case '02':
                    phaseIndex = 1;
                    break;
                case '03':
                    phaseIndex = 2;
                    break;
                case '04':
                    phaseIndex = 3;
                    break;
                case '05':
                    phaseIndex = 4;
                    break;
            }

            if ((curMonth > 8 && curDay >= 15) || curMonth > 9) {
                if (gradeIdx >= 1) {
                    if (gradeIdx < phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx++;//超过九月中旬的了  加一年级

                    } else if (gradeIdx == phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = 1;
                        phaseIndex++;
                    } else {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                } else {
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                }
            } else {
                if (gradeIdx >= 1) {
                    if (gradeIdx > phaseToGrade[phaseIndex].grade.length) {
                        gradeIdx = gradeIdx - phaseToGrade[phaseIndex].grade.length;
                        phaseIndex++;
                    }
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx - 1].name;
                } else {
                    attrGrade = phaseToGrade[phaseIndex].grade[gradeIdx].name;
                }

            }

        }
        attrClassName = classInfo.className;
        className = attrGrade + attrClassName;
        return className;
    };
    
    var getBase64Image = function () {
        var canvas = document.createElement("canvas");
        var img = $("img")[0];
        canvas.width = img.width;
        canvas.height = img.height;

        var ctx = canvas.getContext("2d");
        ctx.drawImage(img, 0, 0, img.width, img.height);

        var dataURL = canvas.toDataURL("image/png");
        return dataURL;
    };

    $("#classSelector").on("click",".close,.btncancel",function(){
        window.close();
    });

    //确认发送
    $("#classSelector").on("click",".btnconfirm",function(){
        var classid = $("#classSelector").find("option:selected").attr("classid");
        var classes = [];
        if(classid == 0){
            for(var i = 0;i < userInfo.classInfo.length; i++){
                classes.push(userInfo.classInfo[i].classId);
            }
        }
        else{
            classes.push(classid);
        }

        shareToClass(classes, getBase64Image());
        console.log("确认");
    });

    //创建
    $("#classSelector").on("click",".btncreate",function(){
        $.ajax({
            url: "http://127.0.0.1:15050/api/createClasses",
            data: {"loginName": userInfo.loginName, "password": userInfo.password},
            success: function () {
                window.close();
            }
        })
    });

    var handleEvent = function(){

        //测试加载时间
        console.log(new Date(Date.now()));
        getUserInfo().done(function (data) {
            console.log(new Date(Date.now()));
            userInfo = data;

            if (userInfo.classInfo == null || userInfo.classInfo.length == 0){
                //没有创建班级
                $("#classSelector").html(templateNoClasses);
            } else {
                $("#classSelector").html(template);
                var img = $("#classSelector").find("img")[0];
                img.onload = function(){
                    $("#classSelector .jxpop-poety").css("background","url('')");
                    var imgWidth = img.width;
                    var imgHeight = img.height;
                    var imgRate = imgWidth / imgHeight;
                    var width = $("#classSelector .jxpop-poety").width();
                    var height = $("#classSelector .jxpop-poety").height();
                    var rate = width/height;
                    if(imgRate < rate){
                        $("#classSelector img").width(imgWidth * height / imgHeight);
                        $("#classSelector img").height(height);
                    }
                    else{
                        $("#classSelector img").width(width);
                        $("#classSelector img").height(imgHeight * width / imgWidth);
                    }
                    console.log(width,height);
                }
                img.src = picPath;

                $.each(userInfo.classInfo, function(i, n){
                    var el = "<option classid="+ n.classId +">"+fixClassName(n)+"</option>";
                    $("#classSelector").find(".classList").append(el);
                })
            }
        })
    };

    handleEvent();

})()
