local assets = {
	Asset("ANIM", "anim/robewand.zip"),
	Asset("ANIM", "anim/swap_robewand.zip"),   
	
	Asset("ATLAS", "images/inventoryimages/robewand.xml"),    
	Asset("IMAGE", "images/inventoryimages/robewand.tex"),
}
		
local prefabs = 
{
	"fire_projectile",
}

local function onattack_robewand(inst, owner, target)
	local inventory = owner.components.inventory
	if inventory and inventory:Has("petals", 1) then
		inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
		inventory:ConsumeByName("petals", 1)
		return
	elseif inventory and inventory:Has("berries", 1) then
		inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
		inventory:ConsumeByName("berries", 1)
		return
	elseif inventory and inventory:Has("berries_juicy", 1) then
		inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
		inventory:ConsumeByName("berries_juicy", 1)
		return
	else
		inst.components.weapon:SetDamage(TUNING.UNARMED_DAMAGE)
		if owner.components.hunger ~= nil then
			if owner.components.hunger.current > 0 then
				owner.components.hunger:DoDelta(-1.8)
			end
		end
	end
end



local function storeincontainer(inst, container)
    if container ~= nil and container.components.container ~= nil then
        inst:ListenForEvent("onputininventory", inst._oncontainerownerchanged, container)
        inst:ListenForEvent("ondropped", inst._oncontainerownerchanged, container)
        inst._container = container
    end
end

local function unstore(inst)
    if inst._container ~= nil then
        inst:RemoveEventCallback("onputininventory", inst._oncontainerownerchanged, inst._container)
        inst:RemoveEventCallback("ondropped", inst._oncontainerownerchanged, inst._container)
        inst._container = nil
    end
end

local function topocket(inst, owner)
    if inst._container ~= owner then
        unstore(inst)
        storeincontainer(inst, owner)
    end
end

local function toground(inst)
    unstore(inst)
end

local function OnEquip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_robewand", "swap_robewand")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function OnUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	anim:SetBank("robewand")
	anim:SetBuild("robewand")
	anim:PlayAnimation("idle")
	
	inst:AddTag("irreplaceable")
	
	inst:ListenForEvent("onputininventory", topocket)
    inst:ListenForEvent("ondropped", toground)
	
    inst._container = nil
	inst._damagemodifier = TUNING.UNARMED_DAMAGE
	
	inst._oncontainerownerchanged = function(container)
        topocket(inst, container)
    end

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "robewand"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/robewand.xml"
	inst:AddComponent("equippable")
	inst:AddComponent("inspectable")
	inst.components.equippable:SetOnEquip(OnEquip)
	inst.components.equippable:SetOnUnequip(OnUnequip)
	inst:AddComponent("chosenweapon")
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.UNARMED_DAMAGE)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetOnAttack(onattack_robewand)
	inst.components.weapon:SetProjectile("ice_projectile")

	return inst	
end

return Prefab("common/inventory/robewand", fn, assets, prefabs)