DEFUsage = {}

DEFUsage.ModName = g_currentModName
DEFUsage.ModDirectory = g_currentModDirectory
DEFUsage.Version = "1.0.0.0"
DEFUsage.debug = fileExists(DEFUsage.ModDirectory ..'debug')


DEFUsage.Multiplier = 1.5

DEFUsage.rightSpacing = 0.005
DEFUsage.overlayBgColor = 	{0, 0.028, 0.1875, 0.5}
DEFUsage.overlayFillColor = {0.0044, 0.15, 0.6376, 0.75}
DEFUsage.overlayTextColor = {0.270, 0.550, 0.880, 1}
DEFUsage.overlayTextColorWarning = {0.8469, 0.3419, 0.011, 1}
DEFUsage.overlayBorder = 0.001
DEFUsage.hudAtlasPath = "dataS2/menu/hud/hud_elements_1080p.png"

addModEventListener(DEFUsage)

function DEFUsage.prerequisitesPresent(specializations)
    return true;
end

function DEFUsage.registerEventListeners(vehicleType)
	local functionNames = {	"onPostLoad", "onDraw", "onDelete" }
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, DEFUsage)
	end
end

function DEFUsage:onPostLoad(savegame)
	DEFUsage.initDefUsage(DEFUsage)
	DEFUsage.updateDefUsageFactor(self)
	
	self.defBarBg, self.defBarFill = DEFUsage:createDefBar(0, 0, DEFUsage.textWidth, DEFUsage.textHeight)
	self.defIcon = DEFUsage:createDefIcon(0, 0)
end

function DEFUsage:onDraw()

	if self.spec_enterable.isEntered then
		local consumer = self.spec_motorized.consumersByFillType[FillType.DEF]
		if consumer ~= nil then
			local defFillLevelPercentage = self:getFillUnitFillLevelPercentage(consumer.fillUnitIndex)
			local warning = false
			if defFillLevelPercentage < 0.2 then
				warning = true
			end

			local fuelIcon = g_currentMission.inGameMenu.hud.speedMeter.fuelGaugeIconElement.overlay

			local posX = 1 - DEFUsage.rightSpacing
			local posY = fuelIcon.y + fuelIcon.height
	
			DEFUsage:setDefBarPosition(self.defBarBg, self.defBarFill, posX, posY)
			DEFUsage:setDefIconPosition(self.defIcon, posX, posY)
	
			local text = string.format('%s: %s %%', g_i18n.texts.fillType_def_short, tostring(math.floor(defFillLevelPercentage * 100)))		
			self.defBarFill:setScale(defFillLevelPercentage, 1)	

			DEFUsage:renderText(posX, (posY * 1.0075) , text, DEFUsage.textSize, warning)
			self.defBarBg:render()
			self.defBarFill:render()
			self.defIcon:render()
		end
	end
end

function DEFUsage:onDelete()
	self.defBarBg:delete()
	self.defBarFill:delete()
	self.defIcon:delete()
end

function DEFUsage.initDefUsage(self)
	self.textSize = g_currentMission.inGameMenu.hud.fillLevelsDisplay.fillLevelTextSize
	self.textWidth = getTextWidth(self.textSize, " DEF: 100% ")
	self.textHeight, _ = getTextHeight(self.textSize, " DEF: 100% ")
end

function DEFUsage.updateDefUsageFactor(self)
    local spec = self.spec_motorized
    local consumer = spec.consumersByFillType[FillType.DEF]
	if consumer ~= nil then
		consumer.usage = consumer.usage * DEFUsage.Multiplier
	end
end

function DEFUsage:renderText(posX, posY, text, textSize, warning)
	setTextBold(true)
	if warning then
		setTextColor(unpack(DEFUsage.overlayTextColorWarning))
	else
		setTextColor(unpack(DEFUsage.overlayTextColor))
	end
	setTextAlignment(RenderText.ALIGN_RIGHT)
	renderText(posX, posY, textSize, text)
	-- Back to defaults
	setTextBold(false)
	setTextColor(1,1,1,1)
	setTextAlignment(RenderText.ALIGN_LEFT)
end

function DEFUsage:createDefBar(posX, posY, width, height)
	-- Don't want to use StatusBar, as it's not possible to use an alignment there
	--return StatusBar:new(g_baseUIFilename, g_colorBgUVs, nil, self.overlayBgColor, self.overlayFillColor, nil, posX, posY, width, height)
	local defBarBg = Overlay:new(g_baseUIFilename, posX, posY, width + (self.overlayBorder * 2), height + (self.overlayBorder * 2))
	defBarBg:setUVs(g_colorBgUVs)
	defBarBg:setColor(unpack(self.overlayBgColor))
	defBarBg:setAlignment(Overlay.ALIGN_VERTICAL_BOTTOM, Overlay.ALIGN_HORIZONTAL_RIGHT)
	
	local defBarFill = Overlay:new(g_baseUIFilename, posX, posY, width, height)
	defBarFill:setUVs(g_colorBgUVs)
	defBarFill:setColor(unpack(self.overlayFillColor))
	defBarFill:setAlignment(Overlay.ALIGN_VERTICAL_BOTTOM, Overlay.ALIGN_HORIZONTAL_RIGHT)
	
	return defBarBg, defBarFill
end

function DEFUsage:setDefBarPosition(defBarBg, defBarFill, posX, posY)
	defBarBg:setPosition(posX + self.overlayBorder, posY - self.overlayBorder)
	defBarFill:setPosition(posX, posY)
end

function DEFUsage:createDefIcon(posX, posY)
    local width, height = getNormalizedScreenValues(unpack(SpeedMeterDisplay.SIZE.FUEL_LEVEL_ICON))
	width = width * 0.75
	height = height * 0.75

	local defIcon = g_fillTypeManager.nameToFillType['DEF'].hudOverlayFilenameSmall
    local iconOverlay = Overlay:new(defIcon, posX, posY, width, height)
	iconOverlay:setColor(unpack(self.overlayFillColor))
	return iconOverlay
end

function DEFUsage:setDefIconPosition(icon, posX, posY)
    local width, height = getNormalizedScreenValues(unpack(SpeedMeterDisplay.SIZE.FUEL_LEVEL_ICON))
	width = width * 0.75
	height = height * 0.75
	posX = posX - width
	posY = posY - height
	icon:setPosition(posX, posY)
end

function DEFUsage:getVehicleDefLevelAndCapacity(vehicle)
    local defFillType = vehicle:getConsumerFillUnitIndex(FillType.DEF)
    local level = vehicle:getFillUnitFillLevel(defFillType)
    local capacity = vehicle:getFillUnitCapacity(defFillType)
    return level, capacity
end

function DEFUsage:onFillUnitFillLevelChanged(self, superFunc, fillUnitIndex, fillLevelDelta, fillType, toolType, fillPositionData, appliedDelta)
    -- We don't want to refill def if diesel is refilled
end

Motorized.onFillUnitFillLevelChanged = Utils.overwrittenFunction(Motorized.onFillUnitFillLevelChanged, DEFUsage.onFillUnitFillLevelChanged)