<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2022 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\api\controller\v1\student;

use app\common\controller\RestUserBaseController;
use app\scratch\service\IndexWorksService;
use app\scratch\model\ScratchWorksModel;
use app\course\model\ScratchHomeworkModel;

use app\common\lib\Upload;


use think\Db;

class WorksController extends RestUserBaseController
{
    // 获取登录用户的作品列表信息
    public function getWorksList()
    {    

        $param = $this->request->param();

        $IndexWorksService = new IndexWorksService();

        $data = $IndexWorksService->getWorksList();

        $this->success('',$data);
    }


    // 获取登录用户的回收站里的作品列表信息
    public function getRecycleWorksList()
    {
        $param = $this->request->param();

        $IndexWorksService = new IndexWorksService();

        $data = $IndexWorksService->getRecycleWorksList();

        $this->success('',$data);
    }    

    public function getWorksById()
    {
        $param = $this->request->param();
        $id = decode($param['id']);

        $ScratchWorksModel = new ScratchWorksModel();

        $WorksFind = $ScratchWorksModel
            ->where(['id' => $id])
            ->find();

        if (!isset($WorksFind)) {
           $this->error('项目不存在!');
        }
        $this->success('ok',$WorksFind);
    }

    public function getWorksContentById()
    {
        $param = $this->request->param();
        $id = decode($param['id']);

        $ScratchWorksModel = new ScratchWorksModel();

        $project_find = $ScratchWorksModel
            ->where(['id' => $id])
            ->find();

        if (!isset($project_find)) {
           $this->error('项目不存在!');
        }
        $s = json_decode(file_get_contents('./upload/'.$project_find['works_path']));

        returnJson($s);
    }

    public function updateWorksThumbnail()
    {
        if ($this->request->isPost()) {
            $param = $this->request->param();
            $id = decode($param['id']);

            $uploader = new Upload();

            $result = $uploader->upload();


            if ($result === false) {
                $this->error($uploader->getError());
            } else {
                $ScratchWorksModel = new ScratchWorksModel();
                $ScratchHomeworkModel = new ScratchHomeworkModel();
                $r = $ScratchWorksModel
                        ->save([
                            'thumbnail'=>$result['filepath'],
                            'update_time'=>time()
                        ],
                        ['id' => $id,'create_user_id'=>getUserId()]
                    );
                $ScratchHomeworkModel
                        ->save([
                            'thumbnail'=>$result['filepath'],
                            'update_time'=>time()
                        ],
                        ['works_id' => $id,'create_user_id'=>getUserId()]
                    );

                $this->success("上传成功!", $result);
            }

        }
    }

    public function updateWorksName()
    {
        $param = $this->request->param();
        $id = decode($param['id']);

        $post_title = isset($param["title"])?$param["title"]:'';


        $ScratchWorksModel = new ScratchWorksModel();


        $post = $ScratchWorksModel
           ->where('id',$id)
           ->where('create_user_id',getUserId())
           ->find();
        if(empty($post)){
            $this->error('保存失败!');
        }

        $r = $ScratchWorksModel
            ->save([
                'works_name'=>$post_title
            ],['id' => $id]);

        $this->success('保存成功！');
    }


    // 删除登录用户的作业列表信息
    public function deleteWorks(){

        //以数组的形式接受参数
        $param = $this->request->param();

        $IndexWorksService = new IndexWorksService();

        $res = $IndexWorksService->deleteWorks($param);

        
        if ($res) {
            $this->success("删除成功");
        }else{
            $this->error("删除失败");
        }
        
    }
    // 置顶登录用户的作业列表信息
    public function topWorks(){
        //以数组的形式接受参数
        $param = $this->request->param();

        $IndexWorksService = new IndexWorksService();

        $res = $IndexWorksService->topWorks($param);

        if ($res) {
            $this->success("操作成功",$res);
        }else{
            $this->error("操作失败");
        }
    }    

    // 恢复登录用户的作品列表信息
    public function recoverWorks($id){
         //以数组的形式接受参数
        $param = $this->request->param();

        $IndexWorksService = new IndexWorksService();

        $res = $IndexWorksService->recoverWorks($param);

        if ($res) {
            $this->success("恢复成功");
        }else{
            $this->error("恢复成功");
        }
    }

    //修改作品信息
    public function updateWorks(){
        
        $param = $this->request->param();

        $IndexWorksService = new IndexWorksService();

        $res = $IndexWorksService->updateWorks($param);
        
        if ($res) {
            $this->success('保存成功！');
        } else {
            $this->error('保存失败！');
        }        
    }
}
