<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2022 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\index\controller;

use app\common\controller\HomeBaseController;
use think\Db;
use app\org\model\OrgModel;
use app\scratch\model\ScratchWorksModel;




class IndexController extends HomeBaseController
{

	// 首页输出
	public function index()
	{
		$siteInfo = getOption('site_info','overall');
		$siteInfo['logo'] = '/static/logo-2.png';
		
		$subDomain = $this->request->subDomain();
        if($subDomain != config("database.sub_domain")){
            
            
            $data['subDomain'] = $subDomain;

            $OrgModel = new OrgModel();
            $orgInfo = $OrgModel
                    ->where([
                        'org_domain'       => $subDomain,
                    ])
                    ->find();
            if(empty($orgInfo)){
	            $this->assign('siteInfo',$siteInfo);
	        	return $this->fetch(':index');
            }else{
            	if ($orgInfo['org_logo']) {
					$siteInfo['logo'] = $orgInfo['org_logo'];
            	}
            	$siteInfo['orgInfo'] = $orgInfo;
	            $this->assign('siteInfo',$siteInfo);
	            return $this->fetch(':school');
            }


        }else{
            $this->assign('siteInfo',$siteInfo);
        	return $this->fetch(':index');
        }

		
	}


    public function worksList()
    {
        $param = $this->request->param();
        $ScratchWorksModel = new ScratchWorksModel();

        $where = [];

        if (isset($param['search']) && $param['search']!='') {
            $where['works_name'] = $param['search'];
        }


        $list = $ScratchWorksModel
                ->where('published_status',1)
                ->where($where)
                ->paginate(8,false,[
                    'query'     => $param
                ]);
        $page = $list->render();


        $this->assign('list', $list);
        $this->assign('page', $page);

        $siteInfo = getOption('site_info','overall');
		$siteInfo['logo'] = '/static/logo-2.png';

		$subDomain = $this->request->subDomain();
        if($subDomain != config("database.sub_domain")){
            $www = explode(".",$subDomain);
            
            $subDomain = $www[0];
            
            $data['subDomain'] = $subDomain;

            $OrgModel = new OrgModel();
            $orgInfo = $OrgModel
                    ->where([
                        'org_domain'       => $subDomain,
                    ])
                    ->find();
            if(!empty($orgInfo)){
            	if ($orgInfo['org_logo']) {
					$siteInfo['logo'] = $orgInfo['org_logo'];
            	}
            	$siteInfo['orgInfo'] = $orgInfo;
            }

        }
        $this->assign('siteInfo',$siteInfo);

        return $this->fetch(':works_list');

    }

    public function worksContent()
    {
        $param  = $this->request->param();
        $id     = isset($param['id'])?decode($param['id']):0;



        $ScratchWorksModel = new ScratchWorksModel();


        $WorksFind = $ScratchWorksModel
                ->where('id',$id)
                ->find();

        $hotWorksList = $ScratchWorksModel
                ->where('published_status',1)
                ->limit(5)
                ->orderRaw('rand()')
                ->select();



        $this->assign('WorksData', $WorksFind);
        $this->assign('hotWorksList', $hotWorksList);
        
        $siteInfo = getOption('site_info','overall');
		$siteInfo['logo'] = '/static/logo-2.png';

		$subDomain = $this->request->subDomain();
        if($subDomain != config("database.sub_domain")){
            $www = explode(".",$subDomain);
            
            $subDomain = $www[0];
            
            $data['subDomain'] = $subDomain;

            $OrgModel = new OrgModel();
            $orgInfo = $OrgModel
                    ->where([
                        'org_domain'       => $subDomain,
                    ])
                    ->find();
            if(!empty($orgInfo)){
            	if ($orgInfo['org_logo']) {
					$siteInfo['logo'] = $orgInfo['org_logo'];
            	}
            	$siteInfo['orgInfo'] = $orgInfo;
            }

        }
        $this->assign('siteInfo',$siteInfo);

        return $this->fetch(':works_content');

    }



	
}
