<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2022 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\python\service;

use app\common\service\BaseService;

use app\python\model\PythonWorksModel;
use think\facade\Validate;

use think\db\Where;

class IndexWorksService extends BaseService
{


    /**
     * 查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    public function getWorksList($filter = array())
    {


        $where  = new Where;
  
        $pageNo = 1;
        $pageSize = 10;
  

        $where['create_user_id'] = getUserId();

        if (!empty($filter['works_name'])) {
            $d = trim($filter['works_name']);
            $where['works_name'] = ['like', '%'. $d .'%'];
        }

        if (!empty($filter['works_status']) && $filter['works_status'] != 0) {
            $where['works_status'] = $filter['works_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }


        $field = '*';


        $PythonWorksModel = new PythonWorksModel();


        // 查询列表
        $Select      = $PythonWorksModel
            ->where($where)
            ->field($field)
            ->order('id desc')
            ->paginate($pageSize)
            ->append(['status_text','works_status_text'])
            ->toArray();

        foreach ($Select['data'] as $key => $value) {
            $works['data'][$key]['id'] = encode($value['id']);
        }


        return $Select;

    }

    


    public function deleteWorks($filter = array())
    {

        $PythonWorksModel = new PythonWorksModel();
        $worksId = decode($filter['id']);

        $id      = isset($worksId)?$worksId:0;


        return $PythonWorksModel->destroy($id);

    }

    

}