<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2022 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\scratch\model;

use think\Model;
// 软删除
use think\model\concern\SoftDelete;

class ScratchWorksModel extends Model
{
	// 软删除
	use SoftDelete;
    protected $deleteTime = 'delete_time';
    protected $defaultSoftDelete = 0;

    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    // 自动完成
    protected $auto = [];
    protected $insert = ['create_user_id','status' => 1];  
    protected $update = []; 

    // 类型转换
    protected $type = [
        'status'        =>  'integer', // 数据状态
        'published_status'        =>  'integer', // 数据状态

    ];



    public function setCreateUserIdAttr($value)
    {
        return getUserId();
    }




    public function getThumbnailAttr($value)
    {
        return getAssetUrl($value);
    }




    // 获取器
    public function getStatusTextAttr($value,$data)
    {

        $status = [0=>'无效',1=>'有效',2=>'待审核'];



        return $status[$data['status']];
    }




    // 获取器
    public function getWorksStatusTextAttr($value,$data)
    {

        $status = [0=>'停用',1=>'开启'];



        return $status[$data['works_status']];
    }





}