<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2022 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\scratch\service;

use app\common\service\BaseService;

use app\scratch\model\ScratchWorksModel;
use think\facade\Validate;

use think\db\Where;

class IndexWorksService extends BaseService
{


    /**
     * 查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    public function getWorksList($filter = array())
    {


        $where  = new Where;
  
        $pageNo = 1;
        $pageSize = 10;
  

        $where['create_user_id'] = getUserId();

        if (!empty($filter['works_name'])) {
            $d = trim($filter['works_name']);
            $where['works_name'] = ['like', '%'. $d .'%'];
        }

        if (!empty($filter['works_status']) && $filter['works_status'] != 0) {
            $where['works_status'] = $filter['works_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }


        $field = '*';


        $ScratchWorksModel = new ScratchWorksModel();


        // 查询列表
        $Select      = $ScratchWorksModel
            ->where($where)
            ->field($field)
            ->order('id desc')
            ->paginate($pageSize)
            ->append(['status_text','works_status_text'])
            ->toArray();

        foreach ($Select['data'] as $key => $value) {
            $works['data'][$key]['id'] = encode($value['id']);
        }


        return $Select;

    }

        /**
     * 查询
     * @param      $filter
     * @return \think\Paginator
     * @throws \think\exception\DbException
     */
    public function getRecycleWorksList($filter = array())
    {


        $where  = new Where;
  
        $pageNo = 1;
        $pageSize = 20;
  

        $where['create_user_id'] = getUserId();

        if (!empty($filter['works_name'])) {
            $d = trim($filter['works_name']);
            $where['works_name'] = ['like', '%'. $d .'%'];
        }

        if (!empty($filter['works_status']) && $filter['works_status'] != 0) {
            $where['works_status'] = $filter['works_status'];
        }

        if (!empty($filter['pageNo']) && $filter['pageNo'] != 0 && is_int($filter['pageNo'])) {
            $pageNo = $filter['pageNo'];
        }

        if (!empty($filter['pageSize']) && $filter['pageSize'] != 0 && $filter['pageSize'] <= 100) {
            $pageSize = $filter['pageSize'];
        }


        $field = '*';


        $ScratchWorksModel = new ScratchWorksModel();


        // 查询列表
        $Select      = $ScratchWorksModel
            ->onlyTrashed()
            ->where($where)
            ->field($field)
            ->paginate($pageSize)
            ->append(['status_text','works_status_text'])
            ->toArray();

        foreach ($Select['data'] as $key => $value) {
            $works['data'][$key]['id'] = encode($value['id']);
        }


        return $Select;

    }



    public function deleteWorks($filter = array())
    {

        $ScratchWorksModel = new ScratchWorksModel();
        $worksId = decode($filter['id']);

        $id      = isset($worksId)?$worksId:0;


        return $ScratchWorksModel->destroy($id);

    }

    public function topWorks($filter = array())
    {
        $ScratchWorksModel = new ScratchWorksModel();

        $worksId = decode($filter['id']);

        $id      = isset($worksId)?$worksId:0;

        //查询当前作品的置顶状态
        $res = $ScratchWorksModel->where('id', $id)->field('list_top')->find();
        if(!$res['list_top']){
            $info = $ScratchWorksModel->save(['list_top' => 1],['id' => $id]);   //置顶
        }else{
            $info = $ScratchWorksModel->save(['list_top' => 0],['id' => $id]);   //取消置顶 
        }
        return $info;
    }

    public function recoverWorks($filter = array())
    {
        $ScratchWorksModel = new ScratchWorksModel();

        $worksId = decode($filter['id']);

        $id      = isset($worksId)?$worksId:0;

        $res = $ScratchWorksModel->restore(['id'=>$id]);

        return $res;

    }


    public function updateWorks($filter = array())
    {
        $ScratchWorksModel = new ScratchWorksModel();

        $id = decode(isset($filter['works_id']) ? $filter['works_id'] : '');

        if (isset($filter['works_name'])) {
           $editData['works_name']  = $filter['works_name'];
        }
        if (isset($filter['works_excerpt'])) {
            $editData['works_excerpt']  =  $filter['works_excerpt'];
        }

        return $ScratchWorksModel->save($editData,['id' => $id]);
    }

}