<?php

/***************************************************************\
|                                                               |
|   彩纸屋（彩纸屋编程系统）                                    |
|                                                               |
|   © 2019-2022 淮南市银泰软件科技有限公司 All rights reserved  |
|                                                               |
|   https://www.kidssteam.cn/                                   |
|                                                               |
|   QQ号：984784483                                             |
|                                                               |
\***************************************************************/

namespace app\user\model;

use think\Model;
// 软删除
use think\model\concern\SoftDelete;

class UserModel extends Model
{
	// 软删除
	use SoftDelete;
    protected $deleteTime = 'delete_time';
    protected $defaultSoftDelete = 0;

    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    // 自动完成
    protected $auto = [];
    protected $insert = ['create_user_id','status' => 1];  
    protected $update = []; 

    // 类型转换
    protected $type = [
        'status'        =>  'integer', // 数据状态
        'birthday'      =>  'timestamp',
    ];



    public function setCreateUserIdAttr($value)
    {
        return getUserId();
    }



    public function getBirthdayAttr($value)
    {
        return date('Y-m-d',$value);
    }

    public function getAvatarAttr($value)
    {
        return getAssetUrl($value);
    }







}