<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cdn\V20180606\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeUrlViolations请求参数结构体
 *
 * @method integer getOffset() 获取分页查询偏移量，默认为 0 （第一页）
 * @method void setOffset(integer $Offset) 设置分页查询偏移量，默认为 0 （第一页）
 * @method integer getLimit() 获取分页查询限制数目，默认为 100
 * @method void setLimit(integer $Limit) 设置分页查询限制数目，默认为 100
 * @method array getDomains() 获取指定的域名查询
 * @method void setDomains(array $Domains) 设置指定的域名查询
 */
class DescribeUrlViolationsRequest extends AbstractModel
{
    /**
     * @var integer 分页查询偏移量，默认为 0 （第一页）
     */
    public $Offset;

    /**
     * @var integer 分页查询限制数目，默认为 100
     */
    public $Limit;

    /**
     * @var array 指定的域名查询
     */
    public $Domains;

    /**
     * @param integer $Offset 分页查询偏移量，默认为 0 （第一页）
     * @param integer $Limit 分页查询限制数目，默认为 100
     * @param array $Domains 指定的域名查询
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Offset",$param) and $param["Offset"] !== null) {
            $this->Offset = $param["Offset"];
        }

        if (array_key_exists("Limit",$param) and $param["Limit"] !== null) {
            $this->Limit = $param["Limit"];
        }

        if (array_key_exists("Domains",$param) and $param["Domains"] !== null) {
            $this->Domains = $param["Domains"];
        }
    }
}
