<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Mps\V20190612\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ManageTask请求参数结构体
 *
 * @method string getOperationType() 获取操作类型，取值范围：
<li>Abort：终止任务。</li>
 * @method void setOperationType(string $OperationType) 设置操作类型，取值范围：
<li>Abort：终止任务。</li>
 * @method string getTaskId() 获取视频处理的任务 ID。
 * @method void setTaskId(string $TaskId) 设置视频处理的任务 ID。
 */
class ManageTaskRequest extends AbstractModel
{
    /**
     * @var string 操作类型，取值范围：
<li>Abort：终止任务。</li>
     */
    public $OperationType;

    /**
     * @var string 视频处理的任务 ID。
     */
    public $TaskId;

    /**
     * @param string $OperationType 操作类型，取值范围：
<li>Abort：终止任务。</li>
     * @param string $TaskId 视频处理的任务 ID。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("OperationType",$param) and $param["OperationType"] !== null) {
            $this->OperationType = $param["OperationType"];
        }

        if (array_key_exists("TaskId",$param) and $param["TaskId"] !== null) {
            $this->TaskId = $param["TaskId"];
        }
    }
}
