/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.legends.common;

import com.tihyo.legends.abilities.PotionExtraHealth;
import com.tihyo.legends.armors.RegisterArmors;
import com.tihyo.legends.biomes.BiomeRegistry;
import com.tihyo.legends.blocks.RegisterBlocks;
import com.tihyo.legends.common.CraftingManager;
import com.tihyo.legends.common.LegendsGameRules;
import com.tihyo.legends.common.LegendsVersionChecker;
import com.tihyo.legends.common.ServerProxy;
import com.tihyo.legends.handlers.GuiHandler;
import com.tihyo.legends.handlers.LegendsHealthEventHandler;
import com.tihyo.legends.handlers.LegendsUpdateEventHandler;
import com.tihyo.legends.items.RegisterItems;
import com.tihyo.legends.packets.PacketsHandler;
import com.tihyo.legends.worldgens.OresWorldRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.io.File;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="legends", name="Legends Mod", version="1.4")
public class Main {
    public static final String MODID = "legends";
    public static final String NAME = "Legends Mod";
    public static final String VERSION = "1.4";
    @SidedProxy(clientSide="com.tihyo.legends.client.ClientProxy", serverSide="com.tihyo.legends.common.ServerProxy")
    public static ServerProxy proxy;
    public static final SimpleNetworkWrapper NETWORK;
    @Mod.Metadata
    public static ModMetadata meta;
    @Mod.Instance(value="legends")
    public static Main modInstance;
    public static LegendsVersionChecker versionChecker;
    public static boolean haveWarnedVersionOutOfDate;
    public static Potion healthPotion;
    public static int healthPotionID;

    public void initConfiguration(FMLPreInitializationEvent preEvent) {
        Configuration config = new Configuration(new File("config/LegendsMod.cfg"));
        config.load();
        LegendsGameRules.conquestEnabled = config.getBoolean("Conquest", "Game Rules", false, "Is Conquest Mode Enabled (Removes damage-enhancing utilities)?");
        healthPotionID = config.getInt("Health ID", "Abilities", 108, 0, Integer.MAX_VALUE, "Health ID");
        config.save();
    }

    @Mod.EventHandler
    public void PreLoad(FMLPreInitializationEvent PreEvent) {
        this.initConfiguration(PreEvent);
        PacketsHandler.init();
        RegisterBlocks.mainRegistry();
        RegisterItems.mainRegistry();
        RegisterArmors.mainRegistry();
        CraftingManager.mainRegistry();
        OresWorldRegistry.mainRegistry();
        BiomeRegistry.mainRegistry();
        FMLCommonHandler.instance().bus().register((Object)new LegendsUpdateEventHandler());
        boolean modEntityID = false;
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[256];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                System.err.println("Severe error, please report this to the mod author:");
                System.err.println(e);
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)modInstance, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderThings();
        proxy.init();
        healthPotion = new PotionExtraHealth(healthPotionID, false, 0).func_76399_b(2, 2).func_76390_b("potion.extraHealth");
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void PostLoad(FMLPostInitializationEvent PostEvent) {
    }

    public static void initClientOnly() {
        MinecraftForge.EVENT_BUS.register((Object)new LegendsHealthEventHandler(Minecraft.func_71410_x()));
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        haveWarnedVersionOutOfDate = false;
    }
}

