local g=GLOBAL

local TimeEvent = g.TimeEvent
local FRAMES = g.FRAMES
local EQUIPSLOTS = g.EQUIPSLOTS
local EventHandler = g.EventHandler
local SpawnPrefab = g.SpawnPrefab
local State = g.State
local DEGREES = g.DEGREES
local Vector3 = g.Vector3
local STRINGS = g.STRINGS
local ACTIONS = g.ACTIONS
local FOODTYPE = g.FOODTYPE
local GetTime = g.GetTime

PrefabFiles = {
	"shinai",
	"sn_we",	--武器类
	"sn_proj",	--抛射物类
	"sn_box",	--盒子类
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/shinai.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/shinai.xml" ),

    Asset( "IMAGE", "bigportraits/shinai.tex" ),
    Asset( "ATLAS", "bigportraits/shinai.xml" ),
	
	Asset( "IMAGE", "images/map_icons/shinai.tex" ),
	Asset( "ATLAS", "images/map_icons/shinai.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_shinai.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_shinai.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_shinai.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_shinai.xml" ),
	
	Asset("ANIM","anim/zg_bow_attack.zip"),
	Asset("SOUNDPACKAGE", "sound/sn_sound.fev"),
	Asset("SOUND", "sound/sn_sound.fsb"),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.shinai = "朝田诗乃"
STRINGS.CHARACTER_NAMES.shinai = "shinai"
STRINGS.CHARACTER_DESCRIPTIONS.shinai = "*可以制作武器箱\n*可以在武器箱中随机开出多种强力武器\n*吃下九个精灵之心变成猫形态"
STRINGS.CHARACTER_QUOTES.shinai = "\"\""

-- Custom speech strings
STRINGS.CHARACTERS.SHINAI = require "speech_shinai"

-- The character's name as appears in-game 
STRINGS.NAMES.SHINAI = "shinai"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHINAI = 
{
	GENERIC = "It's shinai!",
	ATTACKER = "That shinai looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "shinai, friend of ghosts.",
	GHOST = "shinai could use a heart.",
}


AddMinimapAtlas("images/map_icons/shinai.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("shinai", "FEMALE")

---------------------------------------------------------------------------------
local shinai_builder = AddRecipeTab("shinai", -21, "images/shinai.xml", "shinai.tex", "shinai_builder")

--制作配方
AddRecipe("sn_ggo",
{g.Ingredient("gears", 3), g.Ingredient("transistor", 3)}, 
shinai_builder, g.TECH.NONE, 
nil, nil, nil, nil, "shinai_builder",
"images/sn_ggo.xml", "sn_ggo.tex")

AddRecipe("sn_alo",
{g.Ingredient("livinglog", 3), g.Ingredient("sn_heart", 3, "images/sn_heart.xml")}, 
shinai_builder, g.TECH.NONE, 
nil, nil, nil, nil, "shinai_builder",
"images/sn_alo.xml", "sn_alo.tex")

AddRecipe("sn_heart",
{g.Ingredient("papyrus", 3), g.Ingredient("coontail", 3)}, 
shinai_builder, g.TECH.NONE, 
nil, nil, nil, nil, "shinai_builder",
"images/sn_heart.xml","sn_heart.tex")

AddRecipe("catcoonden",
{g.Ingredient("twigs", 10), g.Ingredient("acorn", 10)}, 
shinai_builder, g.TECH.NONE, 
"catcoonden_placer", nil, nil, nil, "shinai_builder",
"minimap/minimap_data.xml","catcoonden.png")


---------------------------------------------------------------------------------
--攻击actionhandler
AddStategraphPostInit("wilson",function(sg)
	local action_attack_fn=sg.actionhandlers[ACTIONS.ATTACK].deststate
	sg.actionhandlers[ACTIONS.ATTACK].deststate=function(inst, action)
		if not inst.components.health:IsDead() and not inst.sg:HasStateTag("attack") then
			local weapon = inst.components.combat ~= nil and inst.components.combat:GetWeapon() or nil
			
			if weapon and weapon:HasTag("sn_gun") then
				return "sn_gun"
			elseif weapon and weapon:HasTag("sn_bow") then
				return "sn_bow"
			else
				return action_attack_fn(inst, action)
			end
			
		end
	end
end)
AddStategraphPostInit("wilson_client",function(sg)
	local action_attack_fn=sg.actionhandlers[ACTIONS.ATTACK].deststate
	sg.actionhandlers[ACTIONS.ATTACK].deststate=function(inst, action)
		if not (inst.replica.health:IsDead() or inst.sg:HasStateTag("attack")) then
			local weapon = inst.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
			
			if weapon and weapon:HasTag("sn_gun") then
				return "sn_gun"
			elseif weapon and weapon:HasTag("sn_bow") then
				return "sn_bow"
			else
				return action_attack_fn(inst, action)
			end
			
		end
	end
end)
--------------------------------------------------------------------------------------

--构造新的攻击状态模板v1.0 by 大猪猪
local function addplayer_atkstate(st)
	AddStategraphState("wilson", State{
		name=st.name,
		tags = { "attack", "notalking", "abouttoattack", "autopredict",  },
		onenter = function(inst)
			local buffaction = inst:GetBufferedAction()
			local target = buffaction ~= nil and buffaction.target or nil
			inst.components.combat:SetTarget(target)
			inst.components.combat:StartAttack()
			inst.components.locomotor:Stop()
			
			--动作
			inst.AnimState:PlayAnimation(st.anim)
			
			--超时
			inst[st.name.."_endf"]=st.endf
			if st.timeout then
				inst.sg:SetTimeout(st.timeout(inst)*FRAMES)
			end
			
		end,
		timeline =
		{		
			TimeEvent(st.inif*FRAMES, function(inst) 
				st.inifn(inst)	--开始时操作,一般是播放声音
			end),
			TimeEvent(st.dof*FRAMES, function(inst) 
				if st.failtest and st.failtest(inst) then
					st.failfn(inst) 	--失败时操作,一般是失败武器声音或玩家说话
				else
					--inst:PerformBufferedAction()
					st.dofn(inst)	--伴随攻击的操作
				end
				inst.sg:RemoveStateTag("abouttoattack") 
			end),  
			TimeEvent(st.endf*FRAMES, function(inst)
				inst.sg:RemoveStateTag("attack")
			end),				
		},
		ontimeout=function(inst)
			inst.sg:GoToState( st.outstate and st.outstate(inst) or "idle")
		end,
		events =
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState( st.outstate and st.outstate(inst) or "idle")
			end ),
		},
	})
	AddStategraphState("wilson_client", State{
		name = st.name,
		tags = { "attack", "notalking", "abouttoattack", "autopredict" },
		onenter = function(inst)
			local buffaction = inst:GetBufferedAction()
			if buffaction ~= nil then
				inst:PerformPreviewBufferedAction()
				if buffaction.target ~= nil and buffaction.target:IsValid() then
					inst:FacePoint(buffaction.target:GetPosition())
					inst.sg.statemem.attacktarget = buffaction.target
				end
			end
			if inst.replica.combat ~= nil then
				inst.replica.combat:StartAttack()
			end
			inst.components.locomotor:Stop()
			--动画
			inst.AnimState:PlayAnimation(st.anim)
		end,
		timeline=
		{	
			TimeEvent(st.endf*FRAMES, function(inst)
				inst.sg:RemoveStateTag("abouttoattack")
				inst.sg:RemoveStateTag("attack")
			end),   
		},
		events=
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("idle")
			end ),
		},			
	})
end

local sts={
	--枪
	{
		name="sn_gun",
		anim="fishing_idle",
		inif=2,
		inifn=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.SoundEmitter then weapon.SoundEmitter:PlaySound(weapon.zg_atksound or "") end
		end,
		failtest=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.components.finiteuses and weapon.components.finiteuses.current<=0 then
				return true
			else
				return false
			end
		end,
		failfn=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.SoundEmitter then weapon.SoundEmitter:PlaySound(weapon.zg_failsound or "") end
			if inst.components.talker then inst.components.talker:Say("没有弹药了") end
		end,
		dof=3,
		dofn=function(inst)
			inst:PerformBufferedAction()
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.components.finiteuses then weapon.components.finiteuses:Use(1) end
		end,
		endf=4,
		timeout=function(inst) return math.max(inst.components.combat.min_attack_period*30, inst["sn_gun_endf"]+2) end,
		
	},
	
	--弓箭
	{
		name="sn_bow",
		anim="bow_attack",
		inif=4,
		inifn=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.SoundEmitter then weapon.SoundEmitter:PlaySound(weapon.zg_atksound or "") end
		end,
		failtest=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.components.finiteuses and weapon.components.finiteuses.current<=0 then
				return true
			else
				return false
			end
		end,
		failfn=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.SoundEmitter then weapon.SoundEmitter:PlaySound(weapon.zg_failsound or "") end
			if inst.components.talker then inst.components.talker:Say("没有耐久了") end
		end,
		dof=11,
		dofn=function(inst)
			inst:PerformBufferedAction()
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.components.finiteuses then weapon.components.finiteuses:Use(1) end
		end,
		endf=12,
		timeout=function(inst) return math.max(inst.components.combat.min_attack_period*30, inst["sn_bow_endf"]+2) end,
		
	},
	
	--回旋刃
	{
		name="sn_boomerang",
		anim="throw",
		inif=4,
		inifn=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.SoundEmitter then weapon.SoundEmitter:PlaySound(weapon.atksound or "") end
		end,
		failtest=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.components.finiteuses and weapon.components.finiteuses.current<=0 then
				return true
			else
				return false
			end
		end,
		failfn=function(inst)
			local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			if weapon and weapon.SoundEmitter then weapon.SoundEmitter:PlaySound(weapon.failsound or "") end
			if inst.components.talker then inst.components.talker:Say("没有耐久了") end
		end,
		dof=7,
		dofn=function(inst)
			inst:PerformBufferedAction()
			--local weapon = inst.components.combat and inst.components.combat:GetWeapon()
			--if weapon and weapon.components.finiteuses then weapon.components.finiteuses:Use(1) end
		end,
		endf=8,
		timeout=function(inst) return math.max(inst.components.combat.min_attack_period*30, inst["sn_bow_endf"]+2) end,
		
	},
	
}

for k,v in ipairs(sts) do
	addplayer_atkstate(v)
end


local function setAutoCatch(inst)
	local oldhit = inst.components.projectile.Hit
	function inst.components.projectile:Hit(target)
		if target == self.owner and target.components.catcher then
			target:PushEvent("catch", {projectile = self.inst}) 
			self.inst:PushEvent("caught", {catcher = target})
			self:Catch(target)
			target.components.catcher:StopWatching(self.inst)
		else
			oldhit(self, target)
		end
	end
end
AddPrefabPostInit("sn_boomerang",setAutoCatch)

--UI(version 2)
--
local Zg_SkillButton2 = require("widgets/zg_skillbutton2")
local function AddSkillButton(self) 
	if self.owner and self.owner:HasTag("shinai_builder") then
	
		--self.skillbutton_z = self:AddChild( Zg_SkillButton2( self.owner, nil, nil, nil,35,37.5,0) )	
		self.skillbutton_z = self:AddChild( Zg_SkillButton2( self.owner, nil, nil, nil,95,37.5,0) )	
		--self.skillbutton_x = self:AddChild( Zg_SkillButton2( self.owner, "images/yohimetab2.xml", "yohimetab2.tex", "yohimetab2.tex",95,37.5,0) )
		--self.skillbutton_c = self:AddChild( Zg_SkillButton2( self.owner, "images/yohimetab2.xml", "yohimetab2.tex", "yohimetab2.tex",155,37.5,0) )	
		
		local OnUpdate_base = self.OnUpdate
		self.OnUpdate = function(self, dt)
			OnUpdate_base(self, dt)
			
			local thetab = {
				"z",--"x","c"
			}
			for k, v in pairs(thetab) do
				--if self.owner[v.."_skill"] ~= true then
				--	self["skillbutton_"..v]:Zg_SetTint(0.2,0.2,0.2,1)
				--	self["skillbutton_"..v]:Zg_SetColour(1,0,0,1)
				--	local cd = self.owner.components.timer:GetTimeLeft(v.."_skill") or self.owner[v.."_skill_cd"]
				--	cd = math.ceil(cd)
				--	self["skillbutton_"..v]:Zg_SetString(cd)
				--else
					self["skillbutton_"..v]:Zg_SetTint(1,1,1,1)
					self["skillbutton_"..v]:Zg_SetColour(0,1,0,1)
					self["skillbutton_"..v]:Zg_SetString( "Level: "..(self.owner.shinai_level_current and self.owner.shinai_level_current:value() or 0) )
				--end
			end
			
		end
		
	end
end

AddClassPostConstruct("widgets/controls", AddSkillButton)

--可交易
local function AddTradable(inst)
	if g.TheWorld.ismastersim then
		inst:AddComponent("tradable")
	end
end
AddPrefabPostInit("gears",AddTradable)
AddPrefabPostInit("sn_heart",AddTradable)


